/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * Provides a single, convenient location for creating and initializing sound
 * players. Loads patch resources when appropriate.
 */

class SoundPlayer;

class PlayerManager {
public:
	PlayerManager();
	SoundPlayer *CreateAndInit(HWND listener, int index);
	void SetResourcePath(const CString &path);
private:
	CString mResourcePath;
	void InitWithPatch(SoundPlayer *player, int patchNum);
};
