/* FUNCTION list 	---	---	---	---	---	---	---

*/

/* BASE headers	---	---	---	---	---	---	--- */
#include "types.h"

/* LIBRARY headers	---	---	---	---	---	---	--- */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

/* OTHER headers	---	---	---	---	---	---	--- */
//#include "view/crap.h"

/* PROTOTYPES	---	---	---	---	---	---	--- */
//void test_function(void);



/* VARIABLES	---	---	---	---	---	---	--- */


/* CODE	---	---	---	---	---	---	---	--- */

u32 file_buf_size;

void *file_to_buf(u8 *file_name)
{
	fpos_t file_size;
	FILE *file_stream;
	void *buf;
	
	file_stream=fopen(file_name, "rb");
	if (file_stream == 0)
		return 0;

	fseek(file_stream, 0, SEEK_END);
	fgetpos(file_stream, &file_size);
	fseek(file_stream, 0, SEEK_SET);
	file_buf_size = (u32)file_size;
	
	buf = malloc(file_size);
	if (buf == 0)
		return 0;
	
	if ( fread(buf, sizeof(u8), file_size, file_stream) != file_size)
	{
		free(buf);
		return 0;
	}
		
	fclose(file_stream);
	return buf;
}


u8 *strtok_r(u8 *newstring, u8 *delimiters, u8 **save_ptr)
{
	u8 *token_cur;
	u8 *token_cur_end;
	u8 *token_next;
	
	assert(save_ptr != 0);
	assert(delimiters != 0);
	
	if (newstring != 0)
		token_cur = newstring;
	else
		token_cur = *save_ptr;
	
	if (token_cur != 0)
	{
		token_cur_end = token_cur + strcspn(token_cur, delimiters);
		token_next = token_cur_end + strspn(token_cur_end, delimiters);
	
		if (*token_next == '\0')
			token_next = 0;
		
		*token_cur_end = '\0';
		*save_ptr = token_next;
	}
	
	return token_cur;
}