{
    ResourceWin1.pas - Resource window
    Copyright (C) 1997-1999 Peter Kelly <peter@area51.org.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
}

unit ResourceWin1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Defines, VolMan2, Menus, ExtCtrls, ComCtrls;

type
  TResourceWin = class(TForm)
    ResourceList: TListBox;
    ResTypeSelect: TComboBox;
    MainMenu1: TMainMenu;
    ResourceMenu: TMenuItem;
    ResourceAdd: TMenuItem;
    ResourceExtract: TMenuItem;
    ResourceDelete: TMenuItem;
    ResourceRenum: TMenuItem;
    N1: TMenuItem;
    ResourceRebuild: TMenuItem;
    Image1: TImage;
    StatusBar1: TStatusBar;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ResourceListClick(Sender: TObject);
    procedure ResTypeSelectChange(Sender: TObject);
    procedure ResourceListDblClick(Sender: TObject);
    procedure ResourceListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ResourceAddClick(Sender: TObject);
    procedure ResourceExtractClick(Sender: TObject);
    procedure ResourceDeleteClick(Sender: TObject);
    procedure ResourceRenumClick(Sender: TObject);
    procedure ResourceRebuildClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    DefaultClientWidth : integer;
    procedure DisplayResourceList;
    procedure SelectResource(ResType1,ResNum1:byte);
  end;

var
  ResourceWin: TResourceWin;

implementation

uses PreviewWin1, main1, ViewPreview1, PicPreview1, ViewEdit1, LogEdit1,
  GetResourceNum1;

{$R *.DFM}

{*************************************************************}
procedure TResourceWin.DisplayResourceList;
{*************************************************************}
var CurResNum : word;
    TempResourceList : TStringList;
begin
  TempResourceList := TStringList.Create;
  if NumResources[SelectedResourceType] > 0 then
  for CurResNum := 0 to NumResources[SelectedResourceType] - 1 do
    TempResourceList.Add(ResourceName(SelectedResourceType,ResourceNum[SelectedResourceType,CurResNum]));
  ResourceList.Items.Assign(TempResourceList);
  TempResourceList.Free;
end;


{*************************************************************}
procedure TResourceWin.SelectResource(ResType1,ResNum1:byte);
{*************************************************************}
var TempIndex : byte;
begin
  if SelectedResourceType <> ResType1 then
  begin
    SelectedResourceType := ResType1;
    ResTypeSelect.ItemIndex := ResType1;
    DisplayResourceList;
    if (SelectedResourceType <> View) and PreviewWin.ViewPreviewPanel.Visible then PreviewWin.ViewPreviewPanel.Visible := False;
    if (SelectedResourceType <> Picture) and PreviewWin.PicPreviewPanel.Visible then PreviewWin.PicPreviewPanel.Visible := False;
    if (SelectedResourceType <> Logic) and (SelectedResourceType <> Sound) then PreviewWin.ErrorMessageLabel.Visible := False;
  end;
  ResourceList.ItemIndex := ResourceIndex(ResType1,ResNum1);
  ResourceListClick(ResourceWin);
  ResourceWin.ResourceExtract.Enabled := True;
  ResourceWin.ResourceDelete.Enabled := True;
  ResourceWin.ResourceRenum.Enabled := True;
end;


{*************************************************************}
procedure TResourceWin.FormResize(Sender: TObject);
{*************************************************************}
begin
  ResTypeSelect.Width := ClientWidth;
  ResourceList.Width := ClientWidth;
  ResourceList.Height := ClientHeight - ResourceList.Top - StatusBar1.Height;
end;

{*************************************************************}
procedure TResourceWin.FormCreate(Sender: TObject);
{*************************************************************}
begin
  DefaultClientWidth := Resourcelist.Width;
  if Settings.Windows.ResourceWin.Top >= 0 then Top := Settings.Windows.ResourceWin.Top
  else Top := 0;
  if Settings.Windows.ResourceWin.Left >= 0 then Left := Settings.Windows.ResourceWin.Left
  else Left := 0;
  if Settings.Windows.ResourceWin.Width >= 0 then Width := Settings.Windows.ResourceWin.Width
  else ClientWidth := ResourceList.Width;
  ResTypeSelect.Items.Assign(ResTypeName2);
  ResTypeSelect.ItemIndex := SelectedResourceType;
end;

{*************************************************************}
procedure TResourceWin.ResourceListClick(Sender: TObject);
{*************************************************************}
var ThisResourceSize : integer;
begin
  ResourceWin.ResourceExtract.Enabled := True;
  ResourceWin.ResourceDelete.Enabled := True;
  ResourceWin.ResourceRenum.Enabled := True;
  if PreviewView.InUse then FreePreviewView;
  if PreviewPic.InUse then FreePreviewPic;
  ThisResourceSize := GetResourceSize(SelectedResourceType,ResourceNum[SelectedResourceType,ResourceList.ItemIndex]);
  if ThisResourceSize > 0 then
    StatusBar1.Panels[0].Text := IntToStr(ThisResourceSize)+' bytes'
  else StatusBar1.Panels[0].Text := '';
{VIEW}
  if SelectedResourceType = VIEW then
  begin
    if LoadPreviewView(ResourceNum[SelectedResourceType,ResourceList.ItemIndex]) then
      PreviewWin.ViewPreviewPanel.Visible := true
    else
    begin
      ShowMessage('Error: Could not load resource. The files may be open or the resource may be corrupt.');
      if PreviewView.InUse then FreePreviewView;
      PreviewWin.ViewPreviewPanel.Visible := False;
      PreviewWin.PicPreviewPanel.Visible := False;
      PreviewWin.ErrorMessageLabel.Visible := False;
    end;
  end
  else PreviewWin.ViewPreviewPanel.Visible := false;
{PICTURE}
  if SelectedResourceType = PICTURE then
  begin
    if LoadPreviewPic(ResourceNum[SelectedResourceType,ResourceList.ItemIndex]) then
      PreviewWin.PicPreviewPanel.Visible := True
    else
    begin
      ShowMessage('Error: Could not load resource. The files may be open or the resource may be corrupt.');
      if PreviewPic.InUse then FreePreviewPic;
      PreviewWin.ViewPreviewPanel.Visible := False;
      PreviewWin.PicPreviewPanel.Visible := False;
      PreviewWin.ErrorMessageLabel.Visible := False;
    end;
  end
  else PreviewWin.PicPreviewPanel.Visible := false;
{LOGIC}
  if (SelectedResourceType = LOGIC) or (SelectedResourceType = SOUND) then
  begin
    if SelectedResourceType = LOGIC then
      PreviewWin.ErrorMessageLabel.Caption := 'No preview available.'+chr(13)+'Double-click to edit.'
    else PreviewWin.ErrorMessageLabel.Caption := 'No preview available.';
    PreviewWin.ErrorMessageLabel.Left := (PreviewWin.ClientWidth div 2) - (PreviewWin.ErrorMessageLabel.Width div 2);
    PreviewWin.ErrorMessageLabel.Top := (PreviewWIn.ClientHeight div 2) - (PreviewWin.ErrorMessageLabel.Height div 2);
    PreviewWin.ErrorMessageLabel.Visible := True;
  end
  else PreviewWin.ErrorMessageLabel.Visible := False;
end;

{*************************************************************}
procedure TResourceWin.ResTypeSelectChange(Sender: TObject);
{*************************************************************}
begin
  if SelectedResourceType <> ResTypeSelect.ItemIndex then
  begin
    SelectedResourceType := ResTypeSelect.ItemIndex;
    DisplayResourceList;
    ResourceWin.ResourceExtract.Enabled := False;
    ResourceWin.ResourceDelete.Enabled := False;
    ResourceWin.ResourceRenum.Enabled := False;
    ResourceWin.StatusBar1.Panels[0].Text := '';
    if (SelectedResourceType <> View) and PreviewWin.ViewPreviewPanel.Visible then PreviewWin.ViewPreviewPanel.Visible := False;
    if (SelectedResourceType <> Picture) and PreviewWin.PicPreviewPanel.Visible then PreviewWin.PicPreviewPanel.Visible := False;
    if (SelectedResourceType <> Logic) and (SelectedResourceType <> Sound) then PreviewWin.ErrorMessageLabel.Visible := False;
    PreviewWin.Caption := 'Preview';
  end;
end;

{*************************************************************}
procedure TResourceWin.ResourceListDblClick(Sender: TObject);
{*************************************************************}
var ResourceData : TResource;
    CurWinNum : byte;
    ThisWinNum : byte;
    ResourceLoadSuccess : boolean;

begin
  if (ResourceList.ItemIndex>-1)  then
  begin
    if SelectedResourceType = VIEW then
    begin
      EditView(ResourceNum[SelectedResourceType,ResourceList.ItemIndex]);
    end;
    if SelectedResourceType = LOGIC then
    begin
      EditLogic(ResourceNum[SelectedResourceType,ResourceList.ItemIndex],False);
    end;
  end;
end;

{*************************************************************}
procedure TResourceWin.ResourceListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
{*************************************************************}
begin
  if (Key = 46) and ResourceWin.ResourceDelete.Enabled then ResourceWin.ResourceDelete.OnClick(ResourceWin);
  if (Key = 45) and ResourceWin.ResourceAdd.Enabled then ResourceWin.ResourceAdd.OnClick(ResourceWin);
  if (Key = ord('E')) and (Shift=[ssCtrl]) and ResourceWin.ResourceExtract.Enabled then ResourceWin.ResourceExtract.OnClick(ResourceWin);
  if (Key = ord('R')) and (Shift=[ssCtrl]) and ResourceWin.ResourceRenum.Enabled then ResourceWin.ResourceRenum.OnClick(ResourceWin);
end;

procedure TResourceWin.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  PreviewWin.OnKeyDown(Sender,Key,Shift);
end;

procedure TResourceWin.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Settings.Windows.ResourceWin.Top := Top;
  Settings.Windows.ResourceWin.Left := Left;
  Settings.Windows.ResourceWin.Width := Width;
  Settings.Windows.ResourceWin.Height := Height;
  if not GameIsOpen then Action := caFree;
end;

procedure TResourceWin.ResourceAddClick(Sender: TObject);
begin
  AddResourceAsk;
end;

procedure TResourceWin.ResourceExtractClick(Sender: TObject);
begin
  if ResourceWin.ResourceList.ItemIndex >= 0 then ExtractResource
  else ShowMessage('Error: No resource selected!');
end;

procedure TResourceWin.ResourceDeleteClick(Sender: TObject);
begin
  if ResourceWin.ResourceList.ItemIndex >= 0 then
  begin
    DeleteResource(SelectedResourceType,ResourceNum[SelectedResourceType,ResourceWin.ResourceList.ItemIndex],True);
  end;
end;

procedure TResourceWin.ResourceRenumClick(Sender: TObject);
begin
  GetResourceNum.WindowFunction := MainRenumberResource;
  GetResourceNum.ResType := SelectedResourceType;
  GetResourceNum.OldNum := ResourceNum[SelectedResourceType,ResourceWin.ResourceList.ItemIndex];
  GetResourceNum.NumberEdit.Text := IntToStr(ResourceNum[SelectedResourceType,ResourceWin.ResourceList.ItemIndex]);
  GetResourceNum.OKBut.Enabled := True;
  GetResourceNum.ShowModal;
end;

procedure TResourceWin.ResourceRebuildClick(Sender: TObject);
begin
  if AskYesNo('Rebuild VOL files','Are you sure?') then
    RebuildVolFiles;
end;

end.
