/*************************************************************************
** linklist.c
**
** The AGI PICTURE codes will be stored in a doubly linked list which
** will make the editing a lot more simple and quicker.
**
** (c) Lance Ewing 1997
*************************************************************************/

#include <alloc.h>
#include <stdio.h>
#include <conio.h>
#include "linklist.h"

struct picCodeNode picCodes;

struct picCodeNode *picPos=NULL;
struct picCodeNode *picStart=NULL;
struct picCodeNode *picLast=NULL;

int addMode = INS_MODE;
int bufPos=0;    /* This variables holds current offset into buffer */
int bufLen=0;

void showPos();

void dldelete()
{
   struct picCodeNode *temp;

   if (picPos == NULL) return;

   if (picPos == picStart) picStart = picPos->next;
   if (picPos == picLast) picLast = picPos->prior;

   if (picPos->prior != NULL) {
      picPos->prior->next = picPos->next;
   }
   if (picPos->next != NULL) {
      picPos->next->prior = picPos->prior;
   }

   temp = picPos->next;
   free(picPos);
   picPos = temp;

   bufLen--;
   /* bufPos should still be the same */
}

void removeAction()
{
   if (picPos != NULL) {
      dldelete();
      while ((picPos->node < 0xF0) && (picPos != NULL)) dldelete();
   }
}

void dlstore(struct picCodeNode *i)
{
   if ((picStart == NULL) && (picLast == NULL))   {
      picStart = picLast = i;
      i->next = NULL;
      i->prior = NULL;
      picPos = NULL;
   }
   else if (picPos == NULL) {   // End Node
      i->next = NULL;
      i->prior = picLast;
      picLast->next = i;
      picLast = i;
      picPos = NULL;
   }
   else {
      switch (addMode) {
	 case INS_MODE:
	    i->prior = picPos->prior;   // works for picStart as well
	    i->next = picPos;
	    if (picPos != picStart) picPos->prior->next = i;
	    if (picPos == picStart) picStart = i;
	    picPos->prior = i;
	    // picPos = i;
	    break;

	 case OVR_MODE:
	    i->prior = picPos->prior;    // link from i
	    i->next = picPos->next;
	    if (picPos != picStart) picPos->prior->next = i;
	    if (picPos == picStart) picStart = i;
	    if (picPos != picLast) picPos->next->prior = i;
	    if (picPos == picLast) picLast = i;
	    free(picPos);
	    picPos = i->next;
	    break;
      }
   }

   bufLen++;
   bufPos++;
}

void displayList()
{
   struct picCodeNode *temp;

   temp = picStart;
   printf("%02X ", temp->node);

   do {
      temp = temp->next;
      printf("%X ", temp->node);
   } while (temp->next != NULL);

   printf("\n");
}

void freeList()
{
   struct picCodeNode *temp, *store;

   if ((picStart != NULL) && (picLast != NULL)) {

      temp = picStart;
      store = temp->next;
      free(temp);

      do {
	 temp = store;
	 store = temp->next;
	 free(temp);
      } while (store != NULL);

      picStart = picLast = picPos = NULL;
   }

   bufPos = 0;
   bufLen = 0;
}

void moveBack()
{
   if (picPos == NULL) {
      picPos = picLast;
      if (bufPos > 0) bufPos--;
   }
   else {
      if (picPos->prior != NULL) {
	 picPos = picPos->prior;
	 bufPos--;
      }
   }
}

void moveForward()
{
   if (picPos !=NULL) {
      picPos = picPos->next;
      bufPos++;
   }
}

void moveToStart()
{
   picPos = picStart;

   bufPos = 0;
   showPos();
}

void moveToEnd()
{
   picPos = NULL;

   bufPos = bufLen;
   showPos();
}

void moveBackAction()
{
   do {
      moveBack();
      if (picPos == picStart) break;
   } while (picPos->node < 0xF0);

   showPos();
}

void moveForwardAction()
{
   do {
      moveForward();
      if (picPos == NULL) break;
   } while (picPos->node < 0xF0);

   showPos();
}


/* LIST TEST PROGRAM
void main()
{
   struct picCodeNode *trial, *trial2, *trial3, *temp;
   int i;

   trial = (struct picCodeNode *)malloc(sizeof(picCodes));
   trial2 = (struct picCodeNode *)malloc(sizeof(picCodes));
   trial3 = (struct picCodeNode *)malloc(sizeof(picCodes));

   trial->node = 0x64;
   trial2->node = 0x50;
   trial3->node = 0x40;
   dlstore(trial);
   dlstore(trial2);
   dlstore(trial3);

   for (i=0; i<10; i++) {
      temp = (struct picCodeNode *)malloc(sizeof(picCodes));
      temp->node = i;
      dlstore(temp);
   }

   clrscr();
   displayList();
   moveBack();
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x3F;
   dlstore(temp);
   displayList();

   moveBack();
   moveBack();
   moveBack();
   addMode = OVR_MODE;
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x4F;
   dlstore(temp);
   displayList();

   moveToStart();
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x8F;
   dlstore(temp);
   displayList();

   moveToStart();
   addMode = INS_MODE;
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x7F;
   dlstore(temp);
   displayList();

   moveForward();
   moveForward();
   moveForward();
   moveForward();
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x6F;
   dlstore(temp);
   displayList();

   moveToEnd();
   temp = (struct picCodeNode *)malloc(sizeof(picCodes));
   temp->node = 0x5F;
   dlstore(temp);
   displayList();

   freeList();
}
*/