
                                                       22 November 1993
------------
| OVERVIEW |
------------

This README describes an OS/2 device driver (SBCD2.ADD) for the following
CD-ROM drives:

   Creative Labs OmniCD
   IBM ISA CD-ROM Drive
   Panasonic CR-521,522,523,562,563




Supported Features
------------------
The OS/2 device driver (SBCD2.ADD) supports the following features:

  * Reads data from CD-ROM discs conforming to the High Sierra/ISO-9660
    file formats.

  * Plays audio from standard audio CDs or mixed mode CD-ROM discs
    containing both data and audio

  * Multisession photo CD  (for drives supporting this feature)

  * Reads data from Mode 2 Form 1 or Mode 2 Form 2 sector formats

  * MMPM/2 Software Motion Video

  * MMPM/2 CD Audio Player

  * Software lock, unlock and eject  (for drives supporting this feature)


THIS CD-ROM DEVICE DRIVER IS DESIGNED TO BE USED WITH THE OS/2 2.1 PRODUCT
AND IS GOVERNED BY THE TERMS AND CONDITIONS OF THE OS/2 PROGRAM LICENSE
AGREEMENT.





----------------
| INSTALLATION |
----------------

Before starting the installation procedure, you should unzip the
files included in the SBCD2.ZIP file and copy them to a diskette.
The diskette you created will be referred to as the "CD-ROM Device
Driver Diskette" in the following installation instructions.

The following files are included in the SBCD2.ZIP file:

     SBCD2.ADD  -  OS/2 device driver
         *.DDP  -  Installation profiles
    README.PAN  -  This README file.




Installation if OS/2 2.1 is already installed on your fixed disk
----------------------------------------------------------------

1. Run the Device Driver installation program

   a. Open the OS/2 System folder on the desktop.
   b. Open the System Setup folder.
   c. Open Device Driver Install.
   d. Insert the "CD-ROM Device Driver Diskette"
   e. Select Install
   f. Select the device driver to install from the list
   g. Select OK.

   (Note: You do not need to reboot OS/2 before starting step 2 below).

2. After the Device Driver Installation is complete, you must run
   Selective Install to install the files for the OS/2 CD-ROM Device
   Manager and OS/2 CD-ROM File System.

   a. Open the OS/2 System folder on the desktop.
   b. Open the System Setup folder.
   c. Open Selective Install
   d. Select the CD-ROM Device Support check box
   e. Select OK
   f. Scroll to the bottom of the CD-ROM device list table and
      select the choice OTHER
   g. Select OK
   h. Select the OK push button to proceed from the System Configuration
      screen to the OS/2 Setup and Installation window
   i. Select Install
   j. When prompted to do so, insert the numbered installation diskettes
      or installation CD-ROM from the OS/2 2.1 product.


3. If you have changed the base I/O port address on your CD-ROM
   host adapter card you must edit your CONFIG.SYS file and add
   modify the /P:nnn parameter on the BASEDEV=SBCD2.ADD statement in
   your CONFIG.SYS file.  Refer to the "Device Driver Parameters"
   section below.


4. Shut down and restart your system




Installation from the CD-ROM version of OS/2 2.1
------------------------------------------------

1.  Make a copy of the OS/2 2.1 diskette labeled "Diskette 1"

2.  Copy the file SBCD2.ADD from the "CD-ROM Device Driver
    Diskette" to the root directory on the copy of the OS/2 2.1 Diskette 1.

    (Note: If there is not enough room on the copy of OS/2 2.1
     Diskette 1, then delete the file IBM2SCSI.ADD.  If you delete
     IBM2SCSI.ADD, you must also edit the CONFIG.SYS file and delete
     the line BASEDEV=IBM2SCSI.ADD)

3.  Edit the CONFIG.SYS file located on the copy of Diskette 1.
    At the end of the file, add the following statement.

       BASEDEV=SBCD2.ADD  /P:nnn

          where "/P:nnn" is the base I/O port address selected on the
          CD-ROM host interface card.  The default base I/O port address
          for the Sound Blaster adapter is is 220h, so the statement
          would appear as follows if the card is set to address 220h:


       BASEDEV=SBCD2.ADD  /P:220



4.  Begin the installation by inserting the Installation Diskette
    into drive A and restarting the system.  When prompted to insert
    Diskette 1, insert the copy that you modifed.

5.  When the System Configuration screen is displayed during installation,
    the CD-ROM Device Support field will display "None".  Do not modify
    the choice and continue with the installation.

6.  After installation is complete, and you have rebooted your system,
    you will not be able to access your CD-ROM drive.  This is due
    to a defect in the OS/2 2.1 install program.  To access your
    CD-ROM drive, perform the following steps:

    a. Copy the following files from the OS/2 2.1 Diskette 1
       to the drive which OS/2 was installed.
       (Note: the example assume C:, change if different)

       COPY A:OS2CDROM.DMD C:\OS2
       COPY A:CDFS.IFS     C:\OS2

    b. Edit the CONFIG.SYS file on drive which OS/2 was installed
       and add the following statements to the end of the file:
       (Note: the example assume C:, change if different)

       DEVICE=C:\OS2\OS2CDROM.DMD /Q
       IFS=C:\OS2\CDFS.IFS /Q

    c. Shut down and reboot the system


7.  You will need to run Selective Install to copy over some remaining
    system files.

    a. Open the OS/2 System folder on the desktop.
    b. Open the System Setup folder.
    c. Open Selective Install
    d. Select the CD-ROM Device Support check box
    e. Select OK
    f. Scroll to the bottom of the CD-ROM device list table and
       select the choice OTHER
    g. Select OK
    h. Select the OK push button to proceed from the System Configuration
       screen to the OS/2 Setup and Installation window
    i. Select Install
    j. When prompted to do so, insert the installation CD-ROM
       from the OS/2 2.1 product.



Installation from the diskette version of OS/2 2.1
--------------------------------------------------

1. Install the OS/2 2.1 product from the diskettes

2. Go to the section above titled "Installation if OS/2 2.1 is already
   installed on your fixed disk".




--------------------------------------
| SBCD2.ADD Device Driver Parameters |
--------------------------------------

This section lists the parameters which are supported for the
SBCD2.ADD device driver.  The parameters can be changed by modifying
the BASEDEV=SBCD2.ADD line in config.sys.


For the SBCD2.ADD device driver, the syntax for the line in config.sys
is as follows:

   BASEDEV=SBCD2.ADD  [/P:nnn]  [T:n] [/V]


   [/P:nnn]

     Specifies the base I/O port address of the interface card.
     The value must be the same number as the port address selected
     by the jumper on the host interface card.


   [/T:nn]

      Sets the adapter type connected to the CD-ROM drive.

      Supported value is:
         2 = Creative Labs CD-ROM interface card (not Sound Blaster)



Parameter Examples
------------------

1.  Panasonic, Creative Labs OmniCD or IBM ISA CD-ROM drive attached
    to standard Panasonic or IBM ISA CD-ROM host adapter:

    The standard Panasonic or IBM ISA host adapter supports base I/O
    port addresses of 300h, 310h, 320h or 330h.  For example, if the
    adapter is set to a base I/O port address of 300, the line in
    config.sys should be:

        BASEDEV=SBCD2.ADD /P:300


2.  Panasonic, Creative Labs OmniCD or IBM ISA CD-ROM drive attached
    to Creative Labs Sound Blaster Pro, Sound Blaster 16, or Sound
    Blaster 16 MultiCD.

    For example, if the Sound Blaster card is set for a base I/O
    address of 220h, the line in config.sys should be:

        BASEDEV=SBCD2.ADD /P:220


3.  Creative Labs OmniCD attached to standard Creative Labs
    CD-ROM host adapter (not Sound Blaster) :

    The standard Creative Labs host adapter supports base I/O port
    addresses of 250h or 260h.  For example, if the adapter is set
    to a base I/O port address of 250, the line in config.sys should be:

        BASEDEV=SBCD2.ADD /P:250 /T:2


--------------------
| Trouble shooting |
--------------------

1. If you are not able to access the CD-ROM drive:


   a.  Make sure the Base I/O Port Address specified by the /P parameter
       in the config.sys file matches the Base Port Address selected
       on the interface card.


   b.  Make sure all the required files to operate the CD-ROM drive have
       been installed.  You should have the appropriate BASEDEV=
       statement in CONFIG.SYS for your CD-ROM device driver.  You
       should also have the following statements for the CD-ROM system
       files in your config.sys:


          DEVICE=C:\OS2\OS2CDROM.DMD /Q
          IFS=C:\OS2\CDFS.IFS /Q
          DEVICE=C:\OS2\MDOS\VCDROM.SYS
          BASEDEV=SBCD2.ADD  /P:220


       If you do not have the above statements in your config.sys, you
       must use the OS/2 2.1 Selective Install to install the CD-ROM
       support files.




2.  If the drive letter assigned to the CD-ROM drive under OS/2 is
    different than the drive letter assigned under DOS.

    The CD-ROM drive is assigned the next available drive
    letter after drive letters have been assigned for the
    floppy drives and fixed disk drives.

    The drive letter is also assigned after any installable block
    device drivers which are located in config.sys before the
    DEVICE=C:\OS2\OS2CDROM.DMD statement (i.e. DEVICE=C:\OS2\VDISK.SYS).

    There is currently no mechanism in OS/2 for assigning a specific
    drive letter for the CD-ROM drive.  The drive letter assignment
    under DOS can be controlled by using the /L switch on MSCDEX.EXE
    command line.


----------------------
| Reporting Problems |
----------------------

Defect reports should include the following information:

  CD-ROM Product ID:            i.e. Panasonic 563
  Host adapter:                 i.e. Sound Blaster Pro
  Host CPU type and speed:      i.e. 25MZ 486




-------------------------------
| TradeMarks and Copyrights   |
-------------------------------

IBM(TM) and OS/2(TM) are registered trademarks of International Business
Machines Corporation.

Sound Blaster(C) is a copyright of Creative Labs, Inc.


