//	tseng.h
//
//	contains class definitions for Tseng ET6000 chipset
//
//   v0.93a added ET-6000
//   v0.93b added destructor to ET-6000 chipset.  The hope is that the
//		  modified constructor will set some control lines (MEEN/IOEN)
//		  which will let MCLK write to the PCI_CFG space.  V0.93a did
//		  not work with all ET-6000 adapters.   Many users observed
//		  "floating" PLL values as reported by MCLK.
//		  In 0.93b, _et6000::_et6000 sets the MEEN/IOEN controls,
//		   and the destructor restores them to their original state(s).
//

//	The following line denies outside code access to certain
//	member functions of class vga.
#ifndef __et6000_h
	#define __et6000_h
#include"vga.h"
#include"pci.h"
class _w32p : public vga	{	//	Class w32p RevA
public:
	_w32p( vga_info info );	//	Constructor
	void _fxn1( int cmd );	//	PCI Burst enable
	void _fxn2( int cmd );	//	Enable memory-interleaving
	void _fxn3( int cmd );	//	FIFO threshold control
};

class _w32pb : public _w32p {	// class w32p RevB and up
public:
	_w32pb( vga_info info ) : _w32p( info ) //	Constructor
		{;};
	void _fxn4( int cmd );	//	fast read/write control
	void _fxn5( int cmd );	//	zero wait-state read/write control
};

class _et6000 : public vga {	//	Class Tseng Labs ET6000
protected:
	uchar pci_bus;	// TRUE if ET6000PCI, FALSE if ET6000VL
	pci_bios_type *pci_bios;		//  Needed for PCI autodetect routine
	pci_device_handle_type pci_vga;	// Needed for PCI autodetect
     uchar pci_cfg04;	// Placeholder for PCI config register $04, v0.93b

     uchar read_cbyte( const uchar index );
     	// Read PCI-configuration register, index 0-255
     uchar write_cbyte( const uchar index, const uchar value );
     	// Write value -> PCI-config(index)
     void mclk_help( void );	// Display help for ET6000 MCLK
	void read_clock1( uchar *byte1, uchar *byte0);
		//	Read clock1 PLL registers, 2-bytes
public:
	message _info( void );		//	Return silicon Revision#
	_et6000( vga_info info );//	Constructor, sets IOEN/MEEN
	~_et6000();			//	Destructor to restore IOEN/MEEN
     void _mclk( int cmd );	//	MCLK programming function
	void _fxn1( int cmd );	//	RAS/CAS configuration for DRAM/MDRAM
};
#endif