;	****************** List Program Parameters *******************
%list
	The "LIST" keyword provides a display of the currently enabled options
as well as various program parameters.
/
;	***************** Short Command Summary ******************
%commands

	COMMANDS displays a short summary of the available commands.
/
;	****************** Error Summary *******************
%es
%ses
	During the execution of the various tests and commands, all
errors are noted and counted individually. At any time you may get a
detailed error summary by using the "es" keyword.

	A separate summary is provided for use with the SRA commands.  The
statistical error summary is displayed when the "ses" keyword is entered.
/
;	****************** Read the Task File *******************
%rtf
	The "rtf" command reads all of the WD1010 task file registers
and displays their contents.
/
;	****************** Drive Selection *******************
%d
%drive
	Most hard disk controllers support more than one physical drive.
To select a drive you must set the desired drive number with the "DRIVE"
parameter keyword. The drive is not physically selected until a  command
is issued to the controller. A typical sequence is as follows:

		d:1		;select drive 1
		read		;read from drive 1
		d:0		;select drive 0
		read		;read from drive 0

/
;	    ****************** Read Command **********************
%r
%read
%rl
%read.long
	The read command  initiates a disk read  command  sequence. One or more
sectors  may be  read with one read command.  Use the BLOCKS keyword to set the
number of sectors to read or write.  To specify where on disk you would like to
read, you must specify a disk address.  A physical disk address is specified
in terms of  cylinder, sector and head.  To read,  you would have to specify
the disk  address in  physical terms using the C, S and H keywords followed
by the read ( ie  c:5,s:0,h:1,read ). A typical read sequence would look as
follows:

	b:1
	c:100,s:5,h:3,r
/
;	****************** Write Command **********************
%w
%write
%wl
%write.long
	The Write command initiates a disk write command sequence.  One or 
more sectors  may be written with one write command.  Use the BLOCKS keyword
to set the number of sectors to write.  To select a location on disk for the 
write operation, you must pre-specify a disk address, in terms of cylinder, 
sector, and head.  In other words, to write, you first specify the disk
address in  physical terms using the C, S and H keywords, then select the 
desired write command (i.e.  c:5,s:0,h:1,write).  A typical write sequence 
would look as follows:

	b:1
	c:100,s:5,h:3,w
/
;	******************** Seek Command ********************
%sk
%seek
	The seek command allows the user to seek to a specified cylinder.  The
cylinder would be specified as a physical cylinder number.  The command syntax 
for this command is as follows:

		sk
		     or
	      seek

/
;	**************** Disk Address Specification ******************
%c
%s
%h
	Whenever you read or write to a disk drive you must specify to the
controller the exact place to begin.  This place is known as a disk address.
A disk address is comprised of a cylinder number, a head number and a sector
number.  To specify these parameters use the "C", "H" and "S" keywords.

	Physical Disk Address Specificaiton Keywords

		c:cylinder-number
		h:head-number
		s:sector-number

/
;	    *************** Controller Diagnostics *****************
%diag
	This command instructs the controller to perform various levels of
self-test.  At the end of this command, the error register will be set to 
indicate whether or not any errors were detected.  A value of "1" indicates 
no errors have been detected.
/
;	************ Repeat the Last Command Line Entered ***************
%rep
%repeat
	The "REPEAT" keyword allows you to repeat the previously entered and
executed  line of commands. The accompanying numeric parameter is the repeat
count.	 If you  wanted  to read  sector  zero 1000 times you would use  the
following sequence of commands.

		read
		repeat:1000

		NOTE that this is not at all the same as:

		read,repeat:1000

	Remember that the repeat keyword repeats the previously executed line,
not the current one!!!!!!!
/
;	************** Production Test Procedure ****************
%ta
	The "TA" keyword initiates the production test procedure. It is best
if you are in the  "LOGERR" logging mode  to reduce the amount of extraneous
output.   This test procedure takes approximately  two minutes	to  complete.
The individual tests and commands that are executed are:

	1)	Recalibrate Drive
	2)	Format last "N" Cylinders( FD )
	3)	Write/Read/Compare Test
	4)	Error Correction Test
/
;	***************** Read/Write All Test ********************
%ra
%wa
	The "RA"  and "WA" commands start  a continuous  read or  write test.
"RA" will read every sector of the disk unless it is interrupted  by pressing
the enter key. While doing this it will monitor the I/O timing ( see RETCNT )
and indicate on  the screen whenever it  thinks  the controller has performed
a retry  on a sector read.   A normal read will  appear  as a period ( . ) on
the screen.   A retry on  a read  will appear as  an exclamation  point ( ! )
on the	screen.   Every  retry will be counted and a cumulative total will be
maintained. Note that the retry evaluation only works correctly if the block 
size is set to one (i.e., B:1).  The "RA" test does not verify the data	read
into memory.  It is only looking for timing and controller errors.

	The "WA" command will continuously write the currently selected data
pattern ( see PATTERN ) onto every sector of the disk unless interrupted by
pressing the ENTER key.

	The starting disk address is specified by using the C, S, and H 
commands prior to execution.
/
;	*************** Read/Write/Compare Data Test *****************
%rt
	This test is included in the production test procedure.  It can be 
executed directly by using the "RT" keyword.  The test procedure performs the 
following command sequence:

	1)	Write current data pattern to current sector
	2)	Read sector to establish timing position
	3)	Read sector and time operation( retry evaluation )
	4)	Compare "should be" and "was" data.

	Any errors will be reported.  As with the "RA" and "WA" tests, this 
test can be terminated by pressing the ENTER key.  The starting disk address 
is specified using the C, S, and H commands.
/
;	****************** Seek Exercisor ********************
%st
	The "ST" keyword intiates a series of seek commands to the controller
The disk  will seek  between the  extremes  ( inner cyl to outer cyl )	in  a
butterfly or crescendo pattern. No data reads or writes take place.
/
;	************** Error Correction Test ****************
%tecc
	The error correction test is started by the "TECC" keyword.  This test
forces correctable and uncorrectable data errors on the disk.  It makes sure
that the controller can correct these errors, and monitors the expected error
status indications.  Any correctable errors that were not noticed will be
flagged as controller errors.  Improper error responses in general are flagged
as controller errors.
/
;	   ***************  Bad Track Handling	 ****************
%bad.track
%bt
%btlist
%bton
%btoff
	The BT command allows the specification of a bad track list. This list
of undesirable tracks will be skipped in the RA, WA, RT, LTT, DRA and FD
commands.  A bad track specification consists of two numbers per line separated
by a comma. Each number must be in decimal format. The first number of the pair
is the cylinder number. The second number is the head. Up to 50 bad tracks may
be specified. The bad track list can come from a normal ascii disk file or
directly from the keyboard.  A typical file might look like this....

	100,1
	200,0
	201,3

	The BTLIST command displays the current bad track list. It will be
displayed onto the crt screen as well as a log file if logging is enabled.

	The BTOFF command is a mode command. It disables bad track skipping.
Its counter part is BTON which enables bad track skipping.
/
;	******* IDC - Initialize Drive Characteristics *******
%idc
	The IDC command is used to  inform the	controller  about the physical
structure  of the  particular disk that  is being used.  Prior	to using  this
command, you should have set the drive parameters to the proper values. These
parameters are set using the following keyword commands:

	cyl:		max number of cylinders
	heads:		number of read/write heads
	sectors:	sectors/track
	precomp:	cylinder where write precompensation starts
	reduce: 	cylinder where reduce write current starts

Note:	THE IDC COMMAND MUST BE ISSUED PRIOR TO THE FIRST DISK ACCESS
	UNLESS THE DEFAULT PARAMETERS AT POWER UP ARE SUITABLE FOR
	YOUR PARTICULAR DISK  !!!!!!
/
;	   ******* CYL - Set Maximum Cylinders per Drive *******
%cyl
	The "CYL"  keyword is  used  for  setting  the	maximum cylinder drive
parameter. This parameter and some others are given to the controller whenever
the IDC command is issued.   A typical	use of	this  parameter  keyword is as
follows:

	cyl:306,idc	;sets max cylinders, send to controller

The cylinder parameter is different for each style of hard disk and must be set
prior to any disk activity.  See IDC command.
/
;	    ****************** Sectors per Track ********************
%sectors
	The "sectors" command establishes the number of sectors on each
track.	The sectors per track informs the controller how to perform
multi-sector reads and writes and also how to interpret the interleave table
at format time.  Command syntax is as follows:

	sectors:n
/
;	     ******* HEADS - Set Number of heads per Drive *******
%heads
	The "HEADS" keyword is used for  setting the number of heads per drive
parameter. This parameter and some others are given to the controller whenever
the IDC command is issued.  A typical  use of  this  parameter	keyword  is as
follows:

	cyl:306,heads:4,idc ;sets max cylinders, send to controller

The heads parameter is different for each style of hard disk and must be set
prior to any disk activity.  See IDC command.
/
;		  ******* Write Precompensation *******
%precomp
	The Precomp keyword is used to set the cylinder number at which write
precompensation will be enabled.  This keyword is used in conjuntion with the
IDC command.

		    precomp:128,cyl:306,heads:4,idc


The precomp parameter is different for each style of hard disk and must be set
prior to any disk activity.  See IDC command.
/
;		  ******* Reduced Write Current *******
%reduce
	The REDUCE keyword is used to set the cylinder number at which reduced
write current is enabled.   This  parameter keyword is	used  prior to the IDC
command. A typical use of this parameter keyword is as follows:

		reduce:64,precomp:128,cyl:306,heads:4,idc

The REDUCE parameter is different for each style of hard disk and must be set
prior to any disk activity.  See IDC command.
/
;		    ******* Step Rate Options *******
%step
	The stepping rate can be specified with the STEP keyword. The tandon
controller requires that the  IDC  command be issued after setting the	STEP
option. All other controllers do not require that the IDC command be  issued
after setting a new step option.

			Step Rate Table

	STEP

	 0
	 1
	 2
	 3
	 4
	 5
	 6
	 7
	 8


		 Step Rate Table ( continued )

	STEP

	 9
	10
	11
	12
	13
	14
	15

/
;	     ******* Format Drive - Initializes Headers *******
%fd
%format.drive
	The format drive command is responsible for formatting the entire drive
starting  from the specified cylinder or  logical disk	address in the case of
SHD.   All or a portion of the disk can be formatted using this command.   For
example, if you set c:100 and issued a "fd" command all cylinders from	100 to
the end  of the disk would be formatted.   Before  this command is issued, the
drive parameters should have been set and the IDC command issued if necessary.
The interleave	factor must also  have been specified with the	"i"  parameter
keyword. To format the entire drive you would normally do the following command
sequence.

				recal,fd

See "idc" and "i".
/
;	    ************** Format Track Commands ********************
%ft
%format.track
	The format track commands are responsible for formating one track.
Note that the "fd" command is really many "ft" commands.  Prior to formatting
each track, the sector buffer is filled with an interleave table indicating 
to the controller the correct order for the individual sectors.

		ft
		format.track

/
;		******* Specify Sector Interleave Factor *******
%i
%interleave
	The interleave	parameter keyword  specifies what interleave factor is
to be used when formating the disk. This  parameter must be set to the desired
value prior to issuing a "fd" or "ft" command. Typical useage of this keyword
is as follows:

				 i:3,recal,fd

	A value of 9 to 17 will create a table with an interleave table of
1 to 8 starting with track 0.
/
;	**************** Controller Retries *******************
%enable.retries
%er
%disable.retries
%dr
	Retries of two types can be enabled or disabled simultaneously.  Upon 
execution of this command the WD1010 automatic retries are en/disabled as 
requested, as well as retries on ECC errors.


		er
		enable.retries

		dr
		disable.retries
/
;	***************** Logging Option Keywords *********************
%lognorm
%logerr
%logall
%logoff
	The logging options keywords allow you to specify the level of detail
of controller protocol	that is displayed and optionally saved in a log file.
The nominal or default	logging mode is the "normal" mode.   This mode can be
entered  by using  the	"LOGNORM"  keyword.  This mode produces an abreviated
protocol display.

	At the other extreme is the most detailed logging mode which is enabled
by using  the  "LOGALL"  keyword.   This  mode produces  the most  detailed and
therefore  most voluminous output.  You  normally  use this mode when debugging
controllers that are somewhat ill.

	Another useful mode is the errors only logging mode.  This particular
mode of logging only produces some output to the screen or logfile when there
is an error situation. This mode is used mostly during production testing,
and for long term testing where you want to minimize the amount of output.
This mode is entered by using the "LOGERR" keyword.

	All logging modes  can be  directed to a  disk file or a printer. This
allows you save  testing  results  for review at a later time.	 To direct the
output of the HDT program to a log file or printer use the following syntax:

		lognorm:filename or lognorm:lpt1

	The same syntax applies to all logging keywords. To terminate a logfile
session use the "LOGOFF" keyword.   This keyword just terminates logfile output
without changing the logging mode.
/
;	**************** Sectors to Read or Write ******************
%blocks
%b
	All of	the controllers  that are  supported  by  HDT are  capable  of
multisector reads and writes.  By using the "BLOCKS" keyword, you can tell the
controller how many disk blocks (sectors)  to transfer	for each read or write
operation. The syntax for this key word is as follows:

			blocks:sectors-to-transfer

			b:sectors-to-transfer

	The maximum of physical buffers allocated by this program is 36.
Any value greater than this will result in repeated use of the first 512 byte
buffer.
/
;	*************** Decimal to Hex Conversion ******************
%cvt
	The "CVT"  keyword allows  you to  convert  hex  numbers to decimal and
decimal numbers to hex. This is a calculator type of feature and is intended as
a convenience.

	cvt:100 	will display the hex equivalent of decimal 100

	cvt:100h	will display the decimal equivalent of hex 100

This particular keyword serves no other function.
/
;	  **************** Getting Help ********************
%help
%commands
	HDT supports a help feature.  There are two keywords that allow access
to support information.  These keywords are "COMMANDS" and "HELP".  The
"COMMANDS" keyword allows you to browse through a brief command glossary.
This level of help is intended as a memory jogger in case you forget the name
of a command.  The glossary is alphabetically sorted and includes a brief 
command description.

The "HELP" keyword provides a detailed description of most keywords supported
by the HDT program.  If you want to know something about the "IDC" command,
you would merely enter the following command.

				help:idc

	The "IDC" command will be looked up in the command help file and the
appropriate text will be displayed on the crt screen.  If you merely enter
the "HELP" keyword with no parameter, a short narative on how to get more help
is displayed.
/
;	************* Clear All of the Error Counters **************
%zero
	The "ZERO" keyword clears all of the various error and retry counters
that are  used internally  within the program.	These counters are cumulative.
/
;	     **************** Buffer Manipulation ******************
%buf
%o
%offset
%data
%v
%dump
%du
%pattern
%pat
%cmp
%compare
%fill
	This version of HDT has a new buffer scheme.  There are two data
buffers, one dedicated to reads and related operations, and the other dedicated
to writes and related operations.  They are called the "Read" and "Write"
buffers.  The read buffer contains the data most recently read from the disk. 
The write buffer contains the data most recently written to the disk.

The following keyword commands allow you to manipulate these sector buffers:

	1)	DUR - Displays the contents of the READ Buffer (DUmp Read)
	2)	DUW - Displays the contents of the WRITE Buffer (DUmp Write)
	3)	BUF - toggles between buffers for the "DU" command only
	4)	DUMP, DU - allows you to view the most recently used buffer
	5)	OFFSET, O - manual buffer modification offset (Write Buffer)
	6)	DATA, V - 8 bit value to be stored at current Write Buf. offset
	7)	PATTERN, PAT - data pattern generation in Write Buffer
	8)	COMPARE, CMP - compare both data buffers for equality
	9)	FILL - Specify Write Buffer fill pattern (8 or 16 bits)


	The "BUF" command allows you to change between displays of the Read or
Write Buffer when the "DU" command is used.  This command was left in HDT for
compatibility with previous versions.

	To display the contents of the most recently used buffer you simply
enter:  "DU:length"  where  length is  the optional number of bytes you
wish to see. If length is not specified, the valid data in the buffer will be
displayed. The amount of data in  the  buffer varies from command to command.
The DU command will also tell you which buffer you are viewing.

	To fill the Write buffer with a desired data pattern prior to executing
a write command, the "PATTERN" keyword may be used.  There are currently 11
data patterns available.  They are numbered from 0 to 10.  Pattern 0 (zero)
disables pattern generation ( i.e., pat:0 ).  It is important to note that when
automatic data pattern generation takes place, the contents of the write buffer
are over-written (lost).  By using the DUW or DU commands you can see the data
pattern in the buffer.  The available data patterns are as follows:

	0)	pat:0		disable pattern generation
	1)	pat:1		all zeros in buffer
	2)	pat:2		all ones in buffer
	3)	pat:3		count 0 thru FFh in buffer
	4)	pat:4		fill with 6DB6h
	5)	pat:5		fill with A5's
	6)	pat:6		fill with 55's
	7)	pat:7		random data fill
	8)	pat:8		interleave table
	9)	pat:9		fill with 18C63h
       10)	pat:10		User-selected fill pattern (from FILL command)

	To write a sector with manually created data, requires the use of the
"OFFSET" and "DATA" keywords.  These keywords modify the contents of the write
data buffer.  Then the appropriate write command is issued.  It is important to
note that when you manually modify the write data buffer using the "OFFSET" and
"DATA" keywords, the automatic pattern generation is disabled.  If this were
not the case, your manually modified buffer would be over-written right before
the write command takes place.  The following gives a typical sequence for
manually creating a sector buffer and writing it to disk.


		pat:1		; fill the write buffer with zeros
		o:0		; specify offset = 0 ( i.e., first byte )
		v:1		; put a 01h into first byte
		v:2		; 02h to second byte ( o is incremented by v )
		write		; write to disk

	You should have noticed in the above example that the buffer offset
is incremented every time a value is stored  by  the "DATA" or "V" keywords.
This allows you to more easily build a custom pattern in the write buffer.

	If you wish to compare two data buffers  you must use the "COMPARE"
keyword. This command causes a data compare operation to take place and the
differences between the contents of the two data buffers to be displayed.
This is useful for write/read/compare sequences.

/
;	***************** Execute a Command File *******************
%exec
%execute
	HDT can execute command sequences that have been previously prepared
and saved in a disk file.  In this mode, disk file input substitutes for
keyboard input.  Execution of these command files can be started in two
different ways.

	The first  way	is to specify  the names of the files on the command
line when you first load the HDT program.   One or more command files can be
specified on the command line. The general syntax is as follows:

	HDT   file1  file1 file3 .....

	The second way to execute command files presumes that you are already
running HDT from the keyboard. In this case you can use the "EXECUTE" keyword
to perform the same thing as demonstrated above.   For example to execute the
the command file "file1" you would enter in the following command:

			     exec:file1

	Once that file has been processed, keyboard input will resume, at which
time you may execute another file if you choose to do so.  Command files can
have "execute" commands  within them.  They can be nested, but this practice is
recommended.
/

;	******************* Error Stop Control ********************
%stop
%go
	The keywords "stop" and "go" control the action of the program whenever
an error occurs.  STOP changes the mode to stop and wait for keyboard response
on each error.  GO terminates the stop mode.  GO is the default mode.
/
;	************** Long Term Test ( multiple pass RT ) ****************
%ltt
	This test is simply a re-occuring read/write/compare test. Multiple
passes over the entire disk take place. This test is interruptable and may be
resumed by merely re-issuing the ltt keyword again. You might stop it briefly
to do an error summary command, for example.
/
;	***************** Recalibrate the Drive ********************
%t0
%recal
%recalibrate
	This command forces the drive back to track 0. The controller will
issue 1024 step pulses backwards until track zero is sensed.
/
;	******************* Reset the Controller ********************
%reset
	The "reset" command issues a reset pulse to the controller and
monitors the results of the controller self diagnostics. See the "diag" 
command for details.
/
;	********************** Retry Evaluation ***********************
%retcnt
	The "ra" and "rt" commands are designed to figure out if the controller
had to retry on a read operation. The determination of whether or not a retry 
has occurred is based solely upon timing.  A sector is read.  The same sector
is read again, and the time to the first DRQ is measured using the "retcnt"
value as a reference.  If the time to the first DRQ exceeds "retcnt" then a
retry is assumed to have occurred.  The "retcnt" value can be set either 
manually or automatically.  The proper value must be determined empirically.

	Manual Method:	  retcnt:value

	Automatic Method:	retcnt:0,retcnt


	Note that the automatic mode writes a sector and reads it 50 times.
The minimum timer value is assumed to be 1 rotation time. A retry is flagged
if 1.5 rotations have occurred.  The timer value for "retcnt" is displayed
after it has been deduced automatically.  Note that the Block size must be set
to 1 (one) for these commands to work properly.
/
;	********** Random Number Generator Initialization ************
%seed
	The "seed" parameter keyword allows the user to initialize the starting
reference point of the random number generator used for writing random data.
The "pattern:7" generates random data into each sector.  To insure repeatable
test sequences requires setting the random number seed to the same value.

		seed:n
/
;	****************** Status Register Read ******************
%sr
	The "sr" command causes the WD1010 register to be read and its contents
to be displayed onto the crt screen. If the error bit is on, the error register
will also be read.

		Command:	sr
/
;	***************** Statistical Read All *******************
%sra
	The "SRA" test is designed to allow large amounts of data to be
read in the shortest amount of time.  This test is usually used to characterize
data separators.  If an error occurs, the test allows for multiple re-reads of
the error sector. The errors occurring during the re-reads are accumulated and
displayed.  In this way it is hoped that the error can be attributed to actual
media related problems or data separator problems.  See "sret" for multiple
re-reads.   A typical sequence of commands to use the "sra" test is as follows:


		b:17
		sret:100
		recal,sra

	It should be noted that sra does not do retry evaluation as does the
"ra" test, and furthermore the data field is not checked for validity against
a pattern.  This test does read the entire disk, however.
/
;	****************** Re-Reads for SRA Test ********************
%sret
	The "sret" parameter keyword allows the user to specify how many
re-reads of each error sector will be performed during the SRA test. The
command syntax follows:


		sret:n
/
;	*********** Cylinders to Test During Production Test ************
%test
	The "test" parameter keyword allows the number of cylinders that are
to be tested by the production test "ta" to be set.  Only the innermost
cylinders of the disk are tested since they are the ones most likely to cause
problems.  To test the last 100 cylinders on the disk, merely enter test:100.
The command syntax is as follows:

		test:n
/
;	****************** Error Summary Titles *******************
%title
	The "title" command allows you to specify a title that will be
displayed at the top of each "list" or error summary. The command syntax
is as follows:


		title:text


	Note that the text field cannot have embedded blanks.
/
;	**************** Clear Error Counters ******************
%zero
	The "zero" command clears out all error counters. Command syntax is
as follows:

		zero
/
;	****************** Read Verify All ********************
%rva
	The "rva" command performs a read-verify disk operation on all sectors
of the disk under test.  This operation begins at the currently specified 
cylinder location, and continues until the maximum cylinder number is reached.
At this point the test stops.  When each cylinder is completed, a "+" mark is
displayed on the screen, thus a "rva" will seem to go more slowly than a read-
all operation (ra) which displays the "." mark for each sector.  However, the
rva is actually about a factor of three faster than a standard read.

	Be sure to set the desired cylinder location prior to starting the
"rva" command.  Also, enable or disable retries as desired.  The command
syntax for the "rva" command is:

	rva
/
;	****************** Format Bad Track ********************
%fbt
	The "fbt" command is used to generate a bad track in a known location. 
The currently set cylinder location will be modified by this command to
generate an error each time that location is read or written.  The "fbt"
command can be reversed by performing a "format track" ("ft") on the same
cylinder.

	Be sure to set the desired cylinder location prior to starting the
"fbt" command.  The command syntax for the "fbt" command is:

	fbt
/
;	****************** Dump Read Buffer ********************
%dur
	The "dur" command causes a display of the contents of the Read Buffer.
 At any time, this buffer will contain the data from the most recent read
operation.  The command syntax for the "dur" command is:

	dur
/
;	****************** Dump Write Buffer ********************
%duw
	The "duw" command causes a display of the contents of the Write
Buffer.  At any time, this buffer will contain the data from the most recent
write, offset, value, or format operation.  The command syntax for the "duw"
command is:

	duw
/
;	************** Copy Read Buffer to Write Buffer *********
%copy
	The "copy" command copies the read buffer in its entirity to the
write buffer. This is usefull to create ECC errors. Do a Read long, copy, 
then modify the write buffer with the "offsets" and "value" commands, then
do a write long. This will cause the wrong ECC bytes to be written to the
disk.
/
;	************** Write the ID Field in the Write Buffer *********
%idon
	The "idon" command causes the cylinder, head, and sector values to
be written in the 1st 4 bytes of the write buffer. This is only valid when
blocks are set to 1. This command is useful to validate logical to physical
translation schemes.

/
;	*******Disable Writing the ID Field in the Write Buffer *********
%idoff
	The "idoff" command cancels the "idon" command.

/
