assume  cs:_TEXT

public	_iscyrix

_TEXT	segment byte public 'CODE'

;**************************************************************************	
;       Function:	int iscyrix ()
;
;       Purpose:        Determine if Cyrix CPU is present
;       Technique:      Cyrix CPUs do not change flags where flags change
;                        in an undefined manner on other CPUs
;       Inputs:         none
;       Output:         ax == 1 Cyrix present, 0 if not
;**************************************************************************
_iscyrix   proc	near
           .486
           xor   ax, ax         ; clear ax
           sahf                 ; clear flags, bit 1 is always 1 in flags
           mov   ax, 5          
           mov   bx, 2
           div   bl             ; do an operation that does not change flags
           lahf                 ; get flags
           cmp   ah, 2          ; check for change in flags
           jne   not_cyrix      ; flags changed not Cyrix        
           mov   ax, 1          ; TRUE Cyrix CPU 
           jmp   done

not_cyrix:
           mov  ax, 0           ; FALSE NON-Cyrix CPU
done:
           ret
_iscyrix   endp

_TEXT	ends
	end

