
/* NT IBM SDLC Adapter Device Driver: 8273 chip-specific objects */

#define ARxR_A1OK     0xe0       /* Adapter Receive Result byte: A1 OK        */
#define ARxR_A2OK     0xe1

#define ARxR_ErrGeneral        0x00
#define ARxR_ErrSelective      0x01
#define ARxR_ErrCRC            0x03
#define ARxR_ErrAbort          0x04
#define ARxR_ErrIdle           0x05
#define ARxR_ErrShort          0x07
#define ARxR_ErrDMAOverrun     0x08
#define ARxR_ErrBufO           0x09
#define ARxR_ErrRLSD           0x0a
#define ARxR_ErrRxIntOverrun   0x0b

#define ATxR_EarlyEOT          0x0c
#define ATxR_TxCompleteOK      0x0d
#define ATxR_ErrTxUnderrun     0x0e
#define ATxR_ErrTxCTSDrop      0x0f
#define ATxR_ErrTxFrameAborted 0x10

/*****************************************************************************/
/* AS_ : Values for Adapter Status register                                  */
/*****************************************************************************/

#define AS_TXIRA  0x01   /* bit 1: TxINT Result Available                    */
#define AS_RXIRA  0x02   /* bit 1: RxINT Result Available                    */
#define AS_TXINT  0x04   /* bit 2: Tx Interrupt                              */
#define AS_RXINT  0x08   /* bit 3: Rx Interrupt                              */
#define AS_CRBFF  0x10   /* bit 4: Command result buffer full                */
#define AS_CPBFF  0x20   /* bit 5: Command parameter buffer full             */
#define AS_CMBFF  0x40   /* bit 6: Command buffer full                       */
#define AS_CMBSY  0x80   /* bit 7: Command busy                              */

/*****************************************************************************/
/* AP_ : Values for Adapter Parameters to various commands                   */
/*****************************************************************************/

#define AP_OMX25  0x20   /* Operating mode bit 5 - use HDLC abort characters */
#define AP_OMETX  0x08   /* Operating mode bit 3 - use early End Tx ints     */
#define AP_OMBFR  0x04   /* Operating mode bit 2 - use buffered A+C          */
#define AP_OMFLG  0x01   /* Operating mode bit 0 - flag stream               */
#define AP_IODLP  0x04   /* Serial IO mode bit 2 - data loopback             */
#define AP_IOCLP  0x02   /* Serial IO mode bit 1 - Tx -> Rx clock loop       */
#define AP_IONZI  0x01   /* Serial IO mode bit 0 - NRZI                      */
#define AP_DTINT  0x01   /* Data transfer mode = interrupts                  */
#define AP_PBDTR  0x04   /* Port B mask to set DTR                           */
#define AP_PBRTS  0x01   /* Port B mask to set RTS                           */

/*****************************************************************************/
/* APR_ : Values for Adapter Parameters to do Reset on the object            */
/*****************************************************************************/

#define APR_OM    0xC0   /* Reset Operating Mode clear all bits              */
#define APR_IO    0xF8   /* Reset Serial IO Mode clear all bits              */
#define APR_DT    0xFE   /* Reset Data transfer mode clear all bits          */
#define APR_PB    0xC0   /* Port B mask to clear all bits                    */

/*****************************************************************************/
/* MCA POS register gadgets                                                  */
/*****************************************************************************/

#define POS_IDMPAA1 0x11
#define POS_IDMPAA2 0x13

#define COPY8273CMD(pDX,CmdName) { pDX->CmdName[0] = Proto##CmdName[0];  \
                                   pDX->CmdName[1] = Proto##CmdName[1];  \
                                 }

