
/* semfispr.h */

/* Prototypes for Device Driver for IBM SDLC adapter.                        */

/*****************************************************************************/

BOOLean AdapterExistenceCheck (
                              PCONFIGDATA pConfigData
                              );

VOID AdapterReset            (PDX pDX);

BOOLean AllocateDMAMemory (
                      ULONG        BufferSize,
                      PVOID      *pBufferPtr,
                      PMDL      *ppMdl,
                      PHYSICAL_ADDRESS * pPhysAddr,
                      ULONG       *ErrorCode
                     );
VOID Close8273Sequence (PDX pDX);

VOID CompleteIoRequest (PIRP Irp);

BOOLean DeviceInit (
                    PDRIVER_OBJECT  pDriverObject,
                    CHAR *           DeviceName,
                    PCONFIGDATA     pConfigData
                   );

VOID  DPCRoutine(
                 IN PKDPC          pDpc,
                 IN PDEVICE_OBJECT pDeviceObject,
                 IN PIRP           pIrp,
                 IN PVOID          DeferredContext
                );

NTSTATUS DriverEntry (IN PDRIVER_OBJECT DriverObject,
                      IN PUNICODE_STRING RegistryPath
                     );

NTSTATUS EntryPointClose (
                          PDEVICE_OBJECT pDeviceObject,
                          PIRP           pIrp
                         );

NTSTATUS EntryPointDevIoctl (
                             PDEVICE_OBJECT pDeviceObject,
                             PIRP           pIrp
                            );

BOOLEAN EntryPointISR (
                       PKINTERRUPT pInterrupt,
                       PVOID       Context
                      );

NTSTATUS EntryPointOpen (
                         PDEVICE_OBJECT pDeviceObject,
                         PIRP           pIrp
                        );

BOOLEAN  EntryPointRogueInterrupt (
                                  PKINTERRUPT pInterrupt,
                                  PVOID       Context
                                 );


VOID     EntryPointUnload (IN PDRIVER_OBJECT pDriverObject);

BOOLean  GetInterfaceType (IN PDRIVER_OBJECT pDriverObject);

BOOLean  GetDriverSpec (CHAR *DriverName,
                        PCONFIGDATA *pConfigData
                       );

VOID     GetV24Input (PDX pDX);

BOOLean  InitialiseAdapter (PDX pDX);

VOID     IoctlAbortReceiver (PDX pDX);

VOID     IoctlAbortTransmitter (PDX pDX);

VOID    IoctlSetInterfaceRecord (PDX pDX);

BOOLean IoctlSetLinkConfig (PDX pDX);

BOOLean IoctlRxFrame (PDX pDX);

BOOLean IoctlSetV24Output (PDX pDX);

BOOLean IoctlTxFrame (PDX pDX);

VOID RxFSMActionInvalid (PDX pDX);

VOID RxFSMActionRestart (PDX pDX);

VOID RxFSMActionStart (PDX pDX);

VOID RxFSMActionStop (PDX pDX);

VOID RxFSMActionRcvError (PDX pDX);

VOID RxFSMActionRcvOK (PDX pDX);

VOID RxFSMEvent (PDX pDX, int Input);

VOID FSMNullAction (PDX pDX);

BOOLean SetLinkConfig (PDX pDX);

BOOLean SetV24Output (PDX pDX);

VOID StartDMA(PDX              pDX,
              PHYSICAL_ADDRESS PhysicalAddress,
              USHORT           BufferLength,
              UCHAR            OpCode);

VOID StopDMA (PDX pDX);

BOOLEAN SynchEntryPointOpen (PVOID Context);

BOOLEAN SynchReset8273 (PVOID Context);

BOOLEAN SynchTerminateAdapter (PVOID Context);

VOID TerminateAdapter (PDX pDX);

VOID TxFSMActionAbort (PDX pDX);

VOID TxFSMActionEndError (PDX pDX);

VOID TxFSMActionEndOK (PDX pDX);

VOID TxFSMActionInvalid (PDX pDX);

VOID TxFSMActionStart (PDX pDX);

VOID TxFSMActionStop (PDX pDX);

VOID TxFSMActionXmitNext (PDX pDX);

VOID TxFSMEvent (PDX pDX, int Input);

UCHAR Write8273Cmd (PDX pDX, UCHAR *Cmd);

VOID LogDriverError (
                     PDEVICE_OBJECT pDeviceObject,
                     NTSTATUS       FinalStatus,
                     ULONG          UniqueErrorValue,
                     UCHAR          MajorFunctionCode,
                     ULONG          IoControlCode
                    );

