
/* Map a drive letter to the next free drive, & set and env variable
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NWCALLS.H>

int	i;
int	iVerbose=0;
#ifdef DEBUG
int	iDebug=0;
#endif
int	iIgnore=0;
int	iSearch=0;

NWCONN_HANDLE	ConnectionHandle;
NWDIR_HANDLE	DirectoryHandle;
char				SetName[128];
char				SetVal[256];
char				UserPath[256];
char				DirPathName[256];
char				ServerName[48];
char			VectorBuffer[16];

int ccode;
int	iFirstDrive,iDriveLetter;
int	status;

static	char *PATH="PATH";
int GetEnvironmentVariable(char *,char *);
int PutEnvironmentVariable(char *,char *);


void Usage(void)
{
#ifdef DEBUG
	fprintf(stderr,"Usage:\n\tmapnext [-d] [-v] [-s] <variable-name> <Path>\n");
	fprintf(stderr,"\t\t-d : Debug program\n");
#else
	fprintf(stderr,"Usage:\n\tmapnext [-v] [-s] <variable-name> <Path>\n");
#endif
	fprintf(stderr,"\t\t-v : verbose output\n");
	fprintf(stderr,"\t\t-s : create a search mapping\n");
	exit(4);
};

void main(int argc,char *argv[])
{
int	i;
int	iVerbose=0;
#ifdef DEBUG
int	iDebug=0;
#endif
int	iIgnore=0;
int	iSearch=0;

NWCONN_HANDLE	ConnectionHandle;
NWDIR_HANDLE	DirectoryHandle;
char				SetName[128];
char				SetVal[256];
char				UserPath[256];
char				DirPathName[256];

char			VectorBuffer[16];

int ccode;
int	iFirstDrive,iDriveLetter;
int	status;

printf("[MAPNEXT Version 1.23 Copyright (C) 1994 University of Salford]\n");
ccode=NWCallsInit(NULL,NULL);
if (ccode) {
	fprintf(stderr,"NWCALLS Initialisation failed (0x%04x)\n",ccode);
	exit(1);
	};

for (i=1;i<argc;i++) 
#ifdef DEBUG
	if (stricmp(argv[i],"-d")==0)	iDebug++;
		else
#endif
	 if (stricmp(argv[i],"-v")==0)	iVerbose++;
		else if (stricmp(argv[i],"-s")==0)	iSearch++;
			else if (*argv[i]=='-') Usage();
				else break;

if (argc-i!=2) Usage();

#ifdef DEBUG
/* print out the argmants left after command-line parseing */
if (iDebug) {
	int k=i;
	while (k<argc) 
		printf("argv[%d] = %s\n",k,argv[k++]) ;
	};
#endif

strcpy(UserPath,argv[argc-1]);
strupr(UserPath);

strcpy(SetName,argv[argc-2]);
strupr(SetName);

/* validate path passed to us by the user */
ccode=NWParseNetWarePath(UserPath,&ConnectionHandle,&DirectoryHandle,DirPathName);

NWParsePath(UserPath,ServerName,NULL,NULL,NULL);

/* cope with the errors */
if (ccode) {
#ifdef DEBUG
	if (iDebug) 
		fprintf(stderr,"error (0x%04x) returned by NWParseNetWarePath()\n",ccode);
#endif

	switch (ccode) {
		case 0x880F : fprintf(stderr,"You are not logged into %s\n",ServerName);
				break;

		case 0x883C : 	fprintf(stderr,"You cannot use this utility on local drives\n");
				break;
		
		default : fprintf(stderr,"Unexpected error (0x%04x) returned by NWParseNetWarePath()\n",ccode);
				break;
		};
	exit(3);
	};

#ifdef DEBUG
if (iDebug) {
	fprintf(stderr,"ConnectionHandle= %d\n",ConnectionHandle);
	fprintf(stderr,"DirectoryHandle= %d\n",DirectoryHandle);
	fprintf(stderr,"DirPathName= %s\n",DirPathName);
	};
#endif


ccode=NWGetFirstDrive(&iFirstDrive);
if (ccode) {
	if (iVerbose) fprintf(stderr,"Could not locate any free drive letters\n");
	exit(2);
	};

#ifdef DEBUG
if (iDebug) 	printf("first drive letter: %d\n",iFirstDrive);
#endif

for (iDriveLetter=26;iDriveLetter>=iFirstDrive;iDriveLetter--) {
	ccode=NWGetDriveStatus(iDriveLetter,NW_FORMAT_UNC,&status,NULL,NULL,NULL,NULL);
	if (ccode) {
		if (iVerbose)
			fprintf(stderr,"Could not locate any free drive letters\n");
		exit(2);
		};
	if (status==NW_FREE_DRIVE) break;
	};

if (status != NW_FREE_DRIVE)  {
		if (iVerbose)	fprintf(stderr,"Could not locate any free drive letters\n");
		exit(2);
		};

if (iVerbose) printf("map root %c:=%s/%s\n",iDriveLetter+'@',ServerName,strupr(DirPathName));

/* set environment variable */
SetVal[0]=iDriveLetter+'@';
SetVal[1]=':';
SetVal[2]=0;

ccode=PutEnvironmentVariable(SetName,SetVal);
if (ccode) {
	if (iVerbose) printf("Out of environment space\n");
	exit(1);
	};

GetEnvironmentVariable(SetName,SetVal);

ccode=NWSetDriveBase(iDriveLetter,ConnectionHandle,0,DirPathName,0);
if (ccode) {
	fprintf(stderr,"error (0x%04x) returned by NWSetDriveBase()\n",ccode);
	exit(3);
	};

if (!iSearch) exit(0);

ccode=NWGetSearchDriveVector( VectorBuffer);
if (ccode) {
	fprintf(stderr,"Unexpected error from NWGetSearchDriveVector (0x%04x)\n",ccode);
	exit(3);
	};

for (i=0;i<16;i++) {
#ifdef DEBUG
	if (iDebug) 
		printf("Vector[%d] : %d [%c]\n",i,VectorBuffer[i],VectorBuffer[i]+'A');
#endif
	if (VectorBuffer[i]==-1) break;	
};

if (VectorBuffer[i]!=-1) {
	fprintf(stderr,"Could not create a search drive mapping\n");
	exit(3);
	};

/* create space at the start of the list */
while (i>0) {
	VectorBuffer[i]=VectorBuffer[i-1];
	i--;
	};

/* insert new drive letter */	
VectorBuffer[0]=iDriveLetter-1;

for (i=0;i<16;i++) {
#ifdef DEBUG
	if (iDebug) 
		printf("Vector[%d] : %d [%c]\n",i,VectorBuffer[i],VectorBuffer[i]+'A');
#endif
};


ccode=NWSetSearchDriveVector(VectorBuffer);
if (ccode) {
	fprintf(stderr,"Unexpected error from NWSetSearchDriveVector (0x%04x)\n",ccode);
	exit(2);
	};

strcat(SetVal,".;");

ccode=GetEnvironmentVariable(PATH,&SetVal[strlen(SetVal)]);
if (ccode) {
	fprintf(stderr,"Failed to read environment");
	exit(1);
	};

ccode=PutEnvironmentVariable(PATH,SetVal);
if (ccode) {
	fprintf(stderr,"Failed to write environment");
	exit(1);
	};

exit(0);
};
