int API_E3(void *Request, void *Reply)
{
	_SI=(unsigned)Request;
	_DI=(unsigned)Reply;
	_ES=_DS;
	_AH=0xE3;
	geninterrupt(0x21);
	return(_AL);
}

void perror(int ern)
{
	if (printdebug==1)
	switch (ern)
	{
		case 0x00: printf("Success\n");                  break;
		case 0x96: printf("Server Out Of Memory\n");     break;
		case 0x9C: printf("Invalid Path\n");             break;
		case 0xD0: printf("Q Error\n");                  break;
		case 0xD1: printf("No Queue\n");                 break;
		case 0xD2: printf("No Q Server\n");              break;
		case 0xD3: printf("No Q Rights\n");              break;
		case 0xD5: printf("No Q Job\n");                 break;
		case 0xEC: printf("No Such Segment\n");          break;
		case 0xEF: printf("Invalid name\n");             break;
		case 0xF0: printf("Wildcard Not Allowed\n");     break;
		case 0xF1: printf("Invalid Bindary Security\n"); break;
		case 0xFB: printf("No Such Property\n");         break;
		case 0xFC: printf("No Such Object\n");           break;
		case 0xFE: printf("Server Bindary Locked\n");    break;
		case 0xFF: printf("Bindary Failure\n");          break;

		default:   printf("Unknown error #%2x#2\n",ern); break;
	}
	else
	switch (ern)
	{
		case 0x00:
		case 0x96:
		case 0x9C:
		case 0xD0:
		case 0xD1:
		case 0xD2:
		case 0xD3:
		case 0xD5:
		case 0xEC:
		case 0xEF:
		case 0xF0:
		case 0xF1:
		case 0xFB:
		case 0xFC:
		case 0xFE:
		case 0xFF: break;

		default:   printf("Unknown error #%2x#2\n",ern); break;
	}
}

int ScanBinderyObject (char *searchObjectName, WORD searchObjectType,
	long *objectID, char *objectName, WORD *objectType,
	char *objectHasProperties, char *objectFlag,
	char *objectSecurity)
{
	static long Last_ObjectID=0xFFFFFFFF;

	struct scanBindReq Request;
	struct scanBindRep Reply;

	int result;

//	memset ( & Request, NULL, sizeof(Request));
//	memset ( & Reply,   NULL, sizeof(Reply  ));
	zap(Request);
	zap(Reply);

	Request.Length=          sizeof(Request)-2;
	Request.Function=        0x37;
	Request.LastObjectID=    Last_ObjectID;
	Request.ObjectType=      searchObjectType;
	Request.ObjectNameLength=strlen(searchObjectName);
	strcpy(Request.ObjectName,searchObjectName);

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	*objectID           =Reply.ObjectID;
	strcpy(objectName,Reply.ObjectName);
	*objectType		    =Reply.ObjectType;
	*objectHasProperties=Reply.ObjectHasProperties;
	*objectFlag         =Reply.ObjectFlag;
	*objectSecurity     =Reply.ObjectSecurity;

	Last_ObjectID=*objectID;

	return (result);
}

void GetPrintServerName(long qsid,char *sname)
{
	struct getBindObjNameReq Request;
	struct getBindObjNameRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=  sizeof(Request)-2;
	Request.Function=0x36;
	Request.ObjectID=qsid;

	Reply.Length=    sizeof(Reply  )-2;

	result=API_E3(&Request,&Reply);

	if (result>0) {
		perror(result);
		strcpy(sname,"");
	}
	else {
		strcpy(sname,Reply.ObjectName);
	}

	return;
}

void GetPrintServer (long qid,char *sname)
{
	struct readQueueStatReq Request;
	struct readQueueStatRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=sizeof(Request)-2;
	Request.Function=0x66;
	Request.ObjectID=qid;

	Reply.Length=  sizeof(Reply  )-2;

	result=API_E3(&Request,&Reply);

	if (result!=0) perror(result);

	if (Reply.NumberOfServers>0) {
		GetPrintServerName(Reply.ServerID[0],sname);
	}
	else {
		strcpy(sname,"");
	}

	return;
}

void GetQueueLocation(LONG qid,char *qloc)
{
	struct readPropValueReq Request;
	struct readPropValueRep Reply;

	int result;
	char sname[100];

	zap(Request);
	zap(Reply);
	zap(sname);

	GetPrintServer(qid,sname);

	Request.Length=sizeof(Request)-2;
	Request.Function=0x3D;
	Request.ObjectType=0x0700; // 0x0700 = Queue (Byte swapped)
	Request.ObjectNameLength=sizeof(Request.ObjectName);
	strcpy(Request.ObjectName,sname);
	Request.SegmentNumber=1;
	Request.PropertyNameLength=14;
	strcpy(Request.PropertyName,"IDENTIFICATION");

	Reply.Length=sizeof(Reply)-2;

	if (sname[0]=='\0')
	{
		result=0;
	}
	else
	{
		result=API_E3(&Request,&Reply);
	}

	if (result!=0) {
		perror(result);
		strcpy(qloc,"");
	}
	else strcpy(qloc,Reply.PropertyValue);
	return;
}

void GetServerLocation(LONG qsid, char *qloc)
{
	struct readPropValueReq Request;
	struct readPropValueRep Reply;

	int result;
	char stmp[100];

	zap(Request);
	zap(Reply);
	zap(stmp);

	GetPrintServerName(qsid,stmp);

	Request.Length=sizeof(Request)-2;
	Request.Function=0x3D;
	Request.ObjectType=0x0700; // 0x0700 = Queue (Byte swapped)
	Request.ObjectNameLength=sizeof(Request.ObjectName);
	strcpy(Request.ObjectName,stmp);
	Request.SegmentNumber=1;
	Request.PropertyNameLength=14;
	strcpy(Request.PropertyName,"IDENTIFICATION");

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	if (result!=0)
	{
		perror(result);
		strcpy(qloc,"");
	}
	else strcpy(qloc,Reply.PropertyValue);
	return;
}

void GetQueueDefaultLocation(char *qname, char *qloc)
{
	struct readPropValueReq Request;
	struct readPropValueRep Reply;

	int result;

	union
	{
		char s[4];
		LONG l;
	} PServer;

	zap(Request);
	zap(Reply);

	Request.Length=sizeof(Request)-2;
	Request.Function=0x3D;
	Request.ObjectType=0x0300; // 0x0300 = Print Queue (Byte swapped)
	Request.ObjectNameLength=sizeof(Request.ObjectName);
	strcpy(Request.ObjectName,qname);
	Request.SegmentNumber=1;
	Request.PropertyNameLength=9;
	strcpy(Request.PropertyName,"Q_SERVERS");

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	if (result!=0) {
		if (result!=0xFC) perror(result);
		strcpy(qloc,"");
	}
	else
	{
		PServer.s[0]=Reply.PropertyValue[0];
		PServer.s[1]=Reply.PropertyValue[1];
		PServer.s[2]=Reply.PropertyValue[2];
		PServer.s[3]=Reply.PropertyValue[3];
		GetServerLocation(PServer.l,qloc);
	}
	return;
}

int QueueServerReady (long qid)
{
	struct readQueueStatReq Request;
	struct readQueueStatRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=sizeof(Request)-2;
	Request.Function=0x66;
	Request.ObjectID=qid;

	Reply.Length=  sizeof(Reply  )-2;

	result=API_E3(&Request,&Reply);

	if (result!=0) perror(result);

	result=0;
	if (Reply.NumberOfServers>0) result=1;

	return (result);
}

