
/* truncate a spase file
 * This program truncates a file at the point where it becomes sparse
 * CAUTION:
 *    MANY DATABASE FILES ARE SPARSE BY DESIGN
 *    USE ONLY ON THOSE FILES YOU **KNOW** SHOULD NOT BE SPARSE
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>

#include <NWCALLS.H>


#define OS_FILE_HANDLE	0
#define NW_FILE_HANDLE	1

#define	FALSE	0
#define	TRUE	1

#define	BYTE_BUFFER_SIZE	512
#define	BIT_BUFFER_SIZE	BYTE_BUFFER_SIZE*8

typedef int flag;

int	iVerbose=0;
int	iDebug=0;
int	iIgnore=0;
int	iTruncate=0;

NWCONN_HANDLE	ConnectionHandle;
NWDIR_HANDLE	DirectoryHandle;
char				PathName[256];
char				DirPathName[256];
char				strFileName[20];

int			fhIn,fhOut;
NWINT16		fileFlag=OS_FILE_HANDLE;
DWORD			dwOffset;
NWNUM			HowMuchToCopy;
DWORD			BlockSize;
BYTE			BitMap[512];

NWNUM	BytesCopied;
NWNUM	NWFAR	*pBytesCopied=&BytesCopied;

flag	fCopying;
int	ccode, i , iLB;
long	lFileSize;
long	lNumBits;

static unsigned int	BitMask[] = { 1,2,4,8,16,32,64,128 };

void DoFileArgs(char *UserPathName);
void TruncateSparseFile(void);
flag	IsFileSparse(void);


void Usage(void)
{

	fprintf(stderr,"Usage:\n\ttsparse [-d] [-v] [-i] {file-list}\n");
	fprintf(stderr,"\t\t-d : Debug program\n");
	fprintf(stderr,"\t\t-v : verbose output\n");
	fprintf(stderr,"\t\t-t : truncate sparse files\n");
	fprintf(stderr,"\t\t-i : ignore errors in user input\n\n");

	fprintf(stderr,"You MUST read the TSPARSE.TXT file that came with this program\n");
	fprintf(stderr,"before using the '-t' option.\n");

	exit(2);
};

void main(int argc,char *argv[])
{
int	i;

printf("[TSPARSE Version 1.10 Copyright (C) 1994 University of Salford]\n");
ccode=NWCallsInit(NULL,NULL);
if (ccode) {
	fprintf(stderr,"NWCALLS Initialisation failed (0x%04x)\n",ccode);
	exit(1);
	};

for (i=1;i<argc;i++) 
	if (stricmp(argv[i],"-d")==0)	iDebug++;
		else if (stricmp(argv[i],"-v")==0)	iVerbose++;
			else if (stricmp(argv[i],"-i")==0)	iIgnore++;
				else if (stricmp(argv[i],"-t")==0)	iTruncate++;
					else if (*argv[i]=='-') Usage();
						else break;

if (i==argc) Usage();

/* print out the argmants left after command-line parseing */
if (iDebug) {
	int k=i;
	while (k<argc) 
		printf("argv[%d] = %s\n",k,argv[k++]) ;
	};

while (i<argc) 
		DoFileArgs(argv[i++]) ;

exit(0);

};

/* *********************************************************************** */
/* take a user-specified pathname, and try to get a list of files from it! */
/* Arguments : one pathname, possibly with wildcards
/* Returns   : Nothing
/*             abort program on fatal errors
/*             abort program on non-fatal errors unless -i option selected
/* *********************************************************************** */
void DoFileArgs(char *UserPathName)
{
char ServerName[48];
char strFileName[20];
int ccode;
char	NWFAR	*cpSearch;
NWSEQUENCE lSequence;
NWENTRY_INFO	EntryInfo;

/* validate path passed to us by the user */
ccode=NWParseNetWarePath(UserPathName,&ConnectionHandle,&DirectoryHandle,
									DirPathName);

if (iDebug) 
	if (ccode) 
		fprintf(stderr,"error (0x%04x) returned by NWParseNetWarePath()\n",ccode);

/* cope with the errors */
switch (ccode) {
	case 0 : break;

	case 0x880F : NWParsePath(UserPathName,ServerName,NULL,NULL,NULL);
			fprintf(stderr,"You are not logged into server %s\n",ServerName);
			if (iIgnore) return;
			exit(1);

	case 0x883C : 	fprintf(stderr,"You cannot use this utility on local drives\n");
			if (iIgnore) return;
			exit(1);
	
	default : fprintf(stderr,"Unexpected error (0x%04x) returned by NWParseNetWarePath()\n",ccode);
			  exit(1);
	};

if (iDebug) {
	fprintf(stderr,"ConnectionHandle= %d\n",ConnectionHandle);
	fprintf(stderr,"DirectoryHandle= %d\n",DirectoryHandle);
	fprintf(stderr,"DirPathName= %s\n",DirPathName);
	};

if (cpSearch=strrchr(DirPathName,'\\')) *cpSearch++='\0';
	else if (cpSearch=strrchr(DirPathName,':')) *cpSearch++='\0';
		else {
			fprintf(stderr,"Invalid Path %s\n",DirPathName);
			exit(1);
			};

strupr(cpSearch);
if (iDebug) fprintf(stderr,"cpSearch= %s\n",cpSearch);

/* Scan for files */
if (iVerbose) fprintf(stderr,"Scanning %s:",DirPathName);

ccode=NWAllocTemporaryDirectoryHandle(ConnectionHandle,0,DirPathName,&DirectoryHandle,NULL);
switch (ccode) {
	case 0 : break;

	case 0x8801 : 
	case 0x8998 :
	case 0x899B :
			fprintf(stderr,"Internal Error : (0x%04x) returned by NWAllocTemporaryDirectoryHandle\n",ccode);
			exit(1);

	case 0x899C : 	fprintf(stderr,"Invalid Path\n");
			if (iIgnore) return;
			exit(1);
	
	case 0x89FF : 	fprintf(stderr,"Invalid Drive\n");
			if (iIgnore) return;
			exit(1);

	default :	fprintf(stderr,"Unexpected Error : (0x%04x) returned by NWAllocTemporaryDirectoryHandle\n",ccode);
				  exit(1);
	};

if (DirectoryHandle==0) {
	fprintf(stderr,"Out or directory handles\n");
	exit(1);
	};

lSequence=0xffffffff;
while (1) {
	ccode=NWScanDirEntryInfo(ConnectionHandle,DirectoryHandle,
		FA_NORMAL | FA_HIDDEN | FA_SHAREABLE | FA_READ_ONLY | FA_NEEDS_ARCHIVED,
		&lSequence,cpSearch,&EntryInfo);

	if (ccode==0x89ff) {
		NWDeallocateDirectoryHandle(ConnectionHandle,DirectoryHandle);
		if (iVerbose) fprintf(stderr,"\n");
		return;
		};

	if (ccode!=0) {
		if (ccode==0x8801) fprintf(stderr,"Invalid connection (NWScanDirEntryInfo)\n");
		if (ccode==0x8998) fprintf(stderr,"Volume does not exist (NWScanDirEntryInfo)\n");
		if (ccode==0x899B) fprintf(stderr,"Bad directory handle (NWScanDirEntryInfo)\n");
		if (ccode==0x899C) fprintf(stderr,"Invalid path (NWScanDirEntryInfo)\n");
		NWDeallocateDirectoryHandle(ConnectionHandle,DirectoryHandle);
		if (iIgnore) return;
		exit(1);
		};

	strncpy(strFileName,EntryInfo.name,EntryInfo.nameLength);
	strFileName[EntryInfo.nameLength]='\0';
	if (iVerbose)	fprintf(stderr,"\n\t%s\t: ",strFileName);

	strcpy(PathName,DirPathName);
	strcat(PathName,"\\");
	strcat(PathName,strFileName);
	if (IsFileSparse()) {
			if (iVerbose) fprintf(stderr,"SPARSE FILE");
				else {
					printf("\n%s\t: SPARSE FILE",PathName); 
					fflush(stdout);
					};
			if (iTruncate) TruncateSparseFile();
			}	
		else if (iVerbose) fprintf(stderr,"normal file");
	if (iDebug) fprintf(stderr,"Copy %ld blocks\n",HowMuchToCopy);

	};

};

/* should not get ANY errors reported from this routine! */
flag IsFileSparse(void)
{
fCopying=TRUE;

dwOffset=0l;
HowMuchToCopy=0l;

if (iDebug) fprintf(stderr,"Opening %s\n",PathName);

if ((fhIn=_open(PathName,O_RDONLY | O_BINARY))==-1) {
	perror(PathName);
	exit(1);
	};

/* determine size of input file */
lFileSize=_lseek(fhIn,0l,SEEK_END);
if (lFileSize==-1) {
	perror("lseek");
	exit(1);
	};

if (iDebug) fprintf(stderr,"\n\t\tInput filesize = %ld bytes",lFileSize);

while (fCopying) {
	ccode=NWGetSparseFileBitMap(
			ConnectionHandle,
			fhIn,
			OS_FILE_HANDLE,
			dwOffset,
			&BlockSize,
			BitMap);

	if (ccode) {
		fprintf(stderr," error (0x%04x) returned by NWGetSparseFileBitMap\n",ccode);
		exit(1);
		};
	
/* how many blocks in this bitmap are valid ? */
	lNumBits=(lFileSize-dwOffset)/BlockSize;
	if ((lFileSize-dwOffset)%BlockSize) lNumBits++;
	if (lNumBits < BIT_BUFFER_SIZE) fCopying=FALSE;
	if (lNumBits > BIT_BUFFER_SIZE) lNumBits = BIT_BUFFER_SIZE;
	if (iDebug) fprintf(stderr,"check %ld bits\n",lNumBits);

	for(i=0;i<lNumBits;i++)
		if (BitMap[i/8] & BitMask[i%8]) 
			HowMuchToCopy+=BlockSize;
		else	{
			_close(fhIn);
			return TRUE;
		};

	dwOffset+=(512*8*BlockSize);
	};

_close(fhIn);
return FALSE;
};

/* should not get ANY errors reported from this routine! */
void TruncateSparseFile(void)
{
printf(".."); fflush(stdout);

if ((fhIn=_open(PathName,O_RDWR| O_BINARY))==-1) {
	perror(PathName);
	exit(1);
	};

if (_chsize(fhIn,HowMuchToCopy)) {
	perror("truncate");
	exit(1);
	};

_close(fhIn);
printf("truncated"); fflush(stdout);
return;
};
