/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import sun.misc.Sort;
import sun.net.www.MessageHeader;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sun.net.www.URLConnection;
import sun.net.www.protocol.file.StringCompare;

public class FileURLConnection
extends URLConnection {
    InputStream is;
    int length;

    FileURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        String string = this.url.getFile();
        MessageHeader messageHeader = new MessageHeader();
        int n = Integer.getInteger("hotjava.file.iconheight", 32);
        int n2 = Integer.getInteger("hotjava.file.iconwidth", 32);
        MimeTable mimeTable = MimeTable.getDefaultTable();
        MimeEntry mimeEntry = mimeTable.findByFileName(string);
        if (mimeEntry != null) {
            messageHeader.add("content-type", mimeEntry.getType());
        }
        this.url.getHost();
        this.setProperties(messageHeader);
        File file = new File(string);
        if (file.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = file.list();
            if (objectArray == null) {
                throw new FileNotFoundException(string);
            }
            StringCompare stringCompare = new StringCompare();
            Sort.quicksort(objectArray, stringCompare);
            messageHeader.add("content-type", "text/html");
            stringBuffer.append("<title>");
            stringBuffer.append(System.getProperty("file.dir.title", "Directory Listing"));
            stringBuffer.append("</title>\n");
            stringBuffer.append("<base href=\"file://localhost/");
            stringBuffer.append(string.substring(string.charAt(0) == '/' ? 1 : 0));
            if (string.endsWith("/")) {
                stringBuffer.append("\">");
            } else {
                stringBuffer.append("/\">");
            }
            stringBuffer.append("<h1>");
            stringBuffer.append(string);
            stringBuffer.append("</h1>\n");
            stringBuffer.append("<hr>\n");
            boolean bl = Boolean.getBoolean("file.hidedotfiles");
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (!bl || ((String)objectArray[n3]).indexOf(46) != 0) {
                    stringBuffer.append("<img align=middle src=\"");
                    if (new File(String.valueOf(string) + "/" + (String)objectArray[n3]).isDirectory()) {
                        stringBuffer.append("doc:/lib/images/ftp/directory.gif\" width=" + n2 + " height=" + n + ">\n");
                    } else {
                        String string2;
                        String string3 = "doc:/lib/images/ftp/file.gif";
                        mimeEntry = mimeTable.findByFileName((String)objectArray[n3]);
                        if (mimeEntry != null && (string2 = mimeEntry.getImageFileName()) != null) {
                            string3 = string2;
                        }
                        stringBuffer.append(string3);
                        stringBuffer.append("\" width=" + n2 + " height=" + n + ">\n");
                    }
                    stringBuffer.append("<a href=\"");
                    stringBuffer.append((String)objectArray[n3]);
                    stringBuffer.append("\">");
                    stringBuffer.append((String)objectArray[n3]);
                    stringBuffer.append("</a><br>");
                }
                ++n3;
            }
            this.is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        } else {
            if (file.exists()) {
                messageHeader.add("Content-length", String.valueOf(file.length()));
            }
            this.is = new BufferedInputStream(new FileInputStream(string.replace('/', File.separatorChar)));
        }
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }
}

