/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.util.Vector;

class AdapPanel
extends ICPanel {
    AdapDlg adapDlg = new AdapDlg(this);
    Vector adapList;
    int adapSortField = 0;
    boolean adapSortOrder = true;
    int selectID = -1;

    AdapPanel(ICFrame iCFrame) {
        super(iCFrame);
    }

    public void init() {
        this.adapDlg.CreateControls();
        this.adapDlg.AdapList.setBackground(Color.white);
        this.adapDlg.AddrList.setBackground(Color.white);
        this.adapDlg.TxAAL0Cells.setBackground(Color.white);
        this.adapDlg.RxAAL0Cells.setBackground(Color.white);
        this.adapDlg.DroppedAAL0Cells.setBackground(Color.white);
        this.adapDlg.TotalAAL0Cells.setBackground(Color.white);
        this.adapDlg.TxAAL3Cells.setBackground(Color.white);
        this.adapDlg.RxAAL3Cells.setBackground(Color.white);
        this.adapDlg.DroppedAAL3Cells.setBackground(Color.white);
        this.adapDlg.TotalAAL3Cells.setBackground(Color.white);
        this.adapDlg.TxAAL3PDUs.setBackground(Color.white);
        this.adapDlg.RxAAL3PDUs.setBackground(Color.white);
        this.adapDlg.DroppedAAL3PDUs.setBackground(Color.white);
        this.adapDlg.TotalAAL3PDUs.setBackground(Color.white);
        this.adapDlg.TxAAL5Cells.setBackground(Color.white);
        this.adapDlg.RxAAL5Cells.setBackground(Color.white);
        this.adapDlg.DroppedAAL5Cells.setBackground(Color.white);
        this.adapDlg.TotalAAL5Cells.setBackground(Color.white);
        this.adapDlg.TxAAL5PDUs.setBackground(Color.white);
        this.adapDlg.RxAAL5PDUs.setBackground(Color.white);
        this.adapDlg.DroppedAAL5PDUs.setBackground(Color.white);
        this.adapDlg.TotalAAL5PDUs.setBackground(Color.white);
        this.adapDlg.TxRate.setBackground(Color.white);
        this.adapDlg.RxRate.setBackground(Color.white);
        this.adapDlg.DroppedRate.setBackground(Color.white);
        this.adapDlg.TotalRate.setBackground(Color.white);
        ((Component)this).setFont(this.frame.fixFont);
        this.adapDlg.setControlFont(this.frame.baseFont);
        this.adapDlg.AdapList.setFont(this.frame.fixFont);
        ((Component)this.adapDlg.AdapInfoGroup).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.AdapConnectGroup).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.AdapStatGroup).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.AAL4Group).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.CellGroup).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.OC3Group).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.AAL5Group).setFont(this.frame.boldFont);
        ((Component)this.adapDlg.RxGroup).setFont(this.frame.boldFont);
        this.adapDlg.AdapListLabel.setFont(this.frame.boldFont);
        this.adapDlg.Unit.setFont(this.frame.boldFont);
        this.adapDlg.Group.setFont(this.frame.boldFont);
        this.adapDlg.IFName.setFont(this.frame.boldFont);
    }

    public void Update() {
        if (this.firstTime) {
            this.firstTime = false;
            this.updateList();
            this.adapDlg.AdapList.select(0);
        } else {
            this.updateList();
        }
        this.updateStats(true);
    }

    public void updateStats(boolean bl) {
        int n = this.adapDlg.AdapList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.selectID = Integer.parseInt(((AdaptersPSB)this.adapList.elementAt(n)).getField(3).trim());
        String[] stringArray = new String[60];
        int n2 = this.frame.topLayer.get_adap_info(this.selectID, stringArray);
        String[] stringArray2 = new String[60];
        int n3 = this.frame.topLayer.get_statistics(this.selectID, stringArray2, bl);
        if (ICTop.cellUnits) {
            this.adapDlg.rateUnits.setText("Rate (cells/sec)");
        } else {
            this.adapDlg.rateUnits.setText("Rate (Kbits/sec)");
        }
        if (n2 == 0) {
            this.adapDlg.SerialNumber.setText(stringArray[0]);
            this.adapDlg.HWVersion.setText(stringArray[1]);
            this.adapDlg.DriverVersion.setText(stringArray[2]);
            this.adapDlg.MediaType.setText(stringArray[3]);
            this.adapDlg.XmitBufCount.setText(stringArray[4]);
            this.adapDlg.XmitQueueSize.setText(stringArray[5]);
            this.adapDlg.FragmentSize.setText(stringArray[6]);
            this.adapDlg.ESIAddr.setText(stringArray[7]);
            this.adapDlg.BusType.setText(stringArray[8]);
            this.adapDlg.OC3Options.setText(stringArray[9]);
            this.adapDlg.FWVersion.setText(stringArray[10]);
            this.adapDlg.RcvBufCount.setText(stringArray[11]);
            this.adapDlg.RcvQueueSize.setText(stringArray[12]);
            this.adapDlg.IntVector.setText(stringArray[13]);
            this.adapDlg.Carrier.setText(stringArray[14]);
            this.adapDlg.ILMI.setText(stringArray[15]);
            this.adapDlg.SPANS.setText(stringArray[16]);
            this.adapDlg.UNIState.setText(stringArray[18]);
            this.adapDlg.UNICfg.setText(stringArray[19]);
            this.adapDlg.UNIMode.setText(stringArray[20]);
            boolean bl2 = this.adapDlg.AddrList.getSelectedIndex() != -1;
            this.adapDlg.AddrList.enableUpdate(false);
            this.adapDlg.AddrList.clear();
            this.adapDlg.AddrList.addItem(stringArray[22]);
            if (bl2) {
                this.adapDlg.AddrList.select(0);
            }
            this.adapDlg.AddrList.enableUpdate(true);
        } else {
            this.adapDlg.SerialNumber.setText("Unknown");
            this.adapDlg.HWVersion.setText("Unknown");
            this.adapDlg.DriverVersion.setText("Unknown");
            this.adapDlg.MediaType.setText("Unknown");
            this.adapDlg.XmitBufCount.setText("Unknown");
            this.adapDlg.XmitQueueSize.setText("Unknown");
            this.adapDlg.FragmentSize.setText("Unknown");
            this.adapDlg.ESIAddr.setText("Unknown");
            this.adapDlg.BusType.setText("Unknown");
            this.adapDlg.OC3Options.setText("Unknown");
            this.adapDlg.FWVersion.setText("Unknown");
            this.adapDlg.RcvBufCount.setText("Unknown");
            this.adapDlg.RcvQueueSize.setText("Unknown");
            this.adapDlg.IntVector.setText("Unknown");
            this.adapDlg.Carrier.setText("Unknown");
            this.adapDlg.ILMI.setText("Unknown");
            this.adapDlg.SPANS.setText("Unknown");
            this.adapDlg.UNIState.setText("Unknown");
            this.adapDlg.UNICfg.setText("Unknown");
            this.adapDlg.UNIMode.setText("Unknown");
            this.adapDlg.AddrList.clear();
            String string = "Adapter Error: " + ICTop.GetErrorString(n2);
            this.adapDlg.AddrList.addItem(string);
        }
        if (n3 == 0) {
            AdapStats adapStats = new AdapStats();
            adapStats.fromStrings(stringArray2);
            AdapStats.show(this.adapDlg, adapStats);
            return;
        }
        AdapStats.show(this.adapDlg, null);
        String string = "Error (" + n3 + ")";
        this.adapDlg.TotalErrors.setText(string);
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target == this.adapDlg.Unit || event.target == this.adapDlg.Group || event.target == this.adapDlg.IFName) {
                int n = 0;
                if (event.target == this.adapDlg.Group) {
                    n = 1;
                }
                if (event.target == this.adapDlg.IFName) {
                    n = 2;
                }
                if (this.adapSortField != n) {
                    this.adapSortOrder = true;
                    this.adapSortField = n;
                } else {
                    this.adapSortOrder = !this.adapSortOrder;
                }
                this.notifySort(this.adapDlg.AdapList);
                return true;
            }
            if (event.target == this.adapDlg.zeroStats) {
                int n = this.frame.topLayer.reset_adap_stats(this.selectID);
                if (n != 0) {
                    this.frame.topLayer.ShowError(n);
                    return true;
                }
                AdapStats adapStats = new AdapStats();
                AdapStats.show(this.adapDlg, adapStats);
            }
            return true;
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public boolean handleEvent(Event event) {
        try {
            switch (event.id) {
                case 701: {
                    this.notifySelection((ColorListBox)event.target);
                    return true;
                }
            }
            return super.handleEvent(event);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public void notifySelection(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        if (colorListBox == this.adapDlg.AdapList) {
            this.updateStats(false);
        }
        ICLock.unlock(this.frame.globalLock, l);
    }

    public void notifySort(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        if (colorListBox == this.adapDlg.AdapList) {
            this.updateList();
        }
        ICLock.unlock(this.frame.globalLock, l);
    }

    public void updateList() {
        Vector<AdaptersPSB> vector = new Vector<AdaptersPSB>();
        String[] stringArray = new String[96];
        Vector<Color> vector2 = new Vector<Color>();
        int n = this.frame.topLayer.get_adap_list(32, stringArray);
        if (n < 0) {
            this.frame.topLayer.ShowError(n);
            return;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            AdaptersPSB adaptersPSB = new AdaptersPSB();
            adaptersPSB.setField(3, String.valueOf(n4));
            adaptersPSB.setField(2, stringArray[n3++]);
            adaptersPSB.setField(0, stringArray[n3++]);
            vector.addElement(adaptersPSB);
            String string = stringArray[n3].startsWith("DOWN") ? "DOWN" : (stringArray[n3].startsWith("UP") ? "UP" : (stringArray[n3].startsWith("REG") ? "REG" : "UNK"));
            ++n3;
            Color color = AdapPanel.getColor(string);
            vector2.addElement(color);
            ++n4;
        }
        ParsedStringBuffer.sort(vector, this.adapSortField, this.adapSortOrder, vector2);
        this.adapList = vector;
        AdaptersPSB.updateList(this.adapList, this.adapDlg.AdapList, vector2);
    }

    public static Color getColor(String string) {
        if (string.equals("DOWN")) {
            return Color.red;
        }
        if (string.equals("UP")) {
            return Color.yellow.darker();
        }
        if (string.equals("REG")) {
            return Color.green.darker();
        }
        return Color.black;
    }
}

