/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.Window;

class AddClipDialog
extends ICDialog {
    AddClipDlg dlg;
    String errMsg = "Unknown Error";
    String host;
    String vlan;
    String macAddr;
    int vpi;
    int vci;
    int cell_rate;
    boolean routed;

    AddClipDialog(ICFrame iCFrame) {
        super(iCFrame, "Add Classical IP PVC", true);
        Object object;
        this.frame = iCFrame;
        this.dlg = new AddClipDlg(this);
        this.dlg.CreateControls();
        ((Component)this).setFont(this.frame.fixFont);
        this.dlg.setControlFont(this.frame.baseFont);
        this.dlg.vlanChoice.setBackground(Color.white);
        int n = 0;
        while (n < this.frame.vlanPanel.vlanList.size()) {
            VlanPSB vlanPSB = (VlanPSB)this.frame.vlanPanel.vlanList.elementAt(n);
            if (vlanPSB.getField(2).equals("Classical IP")) {
                this.dlg.vlanChoice.addItem(vlanPSB.getField(0));
            }
            ++n;
        }
        if (this.dlg.vlanChoice.countItems() > 0) {
            object = this.dlg.vlanChoice.getItem(0);
            this.dlg.vlanChoice.select((String)object);
        }
        if (ICTop.cellUnits) {
            this.dlg.txUnits.setText("cells/sec");
        } else {
            this.dlg.txUnits.setText("Kbits/sec");
        }
        this.dlg.Routed.setState(true);
        this.dlg.MACAddress.disable();
        ((Component)this.dlg.MACAddress).setBackground(Color.gray);
        if (!this.frame.pvcBridged) {
            this.dlg.Bridged.hide();
            this.dlg.Routed.hide();
            this.dlg.encapsulationGroup.hide();
            this.dlg.MACAddress.hide();
            this.dlg.MACAddrLabel.hide();
        }
        this.dlg.VPI.disable();
        ((Component)this.dlg.VPI).setBackground(Color.gray);
        ((TextComponent)this.dlg.VPI).setText("0");
        this.dlg.VCI.requestFocus();
        object = this.frame.location();
        this.move(((Point)object).x + 100, ((Point)object).y + 100);
        this.setResizable(false);
        this.show();
    }

    public boolean addConnection() {
        this.vlan = this.dlg.vlanChoice.getSelectedItem();
        int n = 0;
        while (n < this.frame.vlanPanel.vlanList.size()) {
            VlanPSB vlanPSB = (VlanPSB)this.frame.vlanPanel.vlanList.elementAt(n);
            if (this.vlan.equals(vlanPSB.getField(0))) {
                this.vlan = vlanPSB.getField(1);
                break;
            }
            ++n;
        }
        if (n >= this.frame.vlanPanel.vlanList.size()) {
            this.errMsg = "Unrecognized VLAN selected";
            return false;
        }
        this.routed = this.dlg.Routed.getState();
        try {
            String string = this.dlg.VPI.getText();
            this.errMsg = "VPI missing or invalid";
            this.vpi = Integer.parseInt(string);
            string = this.dlg.VCI.getText();
            this.errMsg = "VCI missing or invalid";
            this.vci = Integer.parseInt(string);
            this.errMsg = "VCI must be between 32 and 1023";
            if (this.vci < 32 || this.vci > 1023) {
                return false;
            }
            string = this.dlg.PeakCellRate.getText();
            if (string.equals("")) {
                this.cell_rate = 0;
            } else {
                if (ICTop.cellUnits) {
                    this.errMsg = "Max Tx Rate must be from 1 to 100000";
                    this.cell_rate = Integer.parseInt(string);
                } else {
                    this.errMsg = "Max Tx Rate must be between " + ICTop.Cells2Kbits(1) + " and " + ICTop.Cells2Kbits(100000);
                    double d = Double.valueOf(string);
                    this.cell_rate = ICTop.Kbits2Cells(d);
                }
                if (this.cell_rate < 1 || this.cell_rate > 100000) {
                    return false;
                }
            }
            if (!this.routed) {
                string = this.dlg.MACAddress.getText();
                this.errMsg = "MAC Address missing or invalid. Must be 12 Hex digits long";
                if (string.length() != 12) {
                    return false;
                }
                int n2 = 0;
                while (n2 < 12) {
                    if (Character.digit(string.charAt(n2), 16) == -1) {
                        return false;
                    }
                    ++n2;
                }
                this.macAddr = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (this.vci < 1) {
            this.errMsg = "VCI field is invalid";
            return false;
        }
        n = 0;
        while (n < this.frame.connPanel.connList.size()) {
            ConnectionPSB connectionPSB = (ConnectionPSB)this.frame.connPanel.connList.elementAt(n);
            if (connectionPSB.getField(4).equals(String.valueOf(this.vpi)) && connectionPSB.getField(5).equals(String.valueOf(this.vci)) && connectionPSB.getField(11).equals(this.vlan.trim())) {
                this.errMsg = "Requested VC already exists on selected VLAN";
                return false;
            }
            ++n;
        }
        this.host = this.dlg.Hostname.getText().trim();
        if (this.host.length() > 0) {
            String[] stringArray = new String[1];
            if (!this.frame.topLayer.get_IP_addr(this, this.host, stringArray)) {
                this.errMsg = "Unknown IP Hostname, or Invalid IP Address.";
                return false;
            }
            this.errMsg = "Wildcards not permitted in IP Address.";
            n = 0;
            while (n < stringArray[0].length()) {
                char c = stringArray[0].charAt(n);
                if (c == '*') {
                    return false;
                }
                ++n;
            }
            this.host = stringArray[0];
        } else {
            this.host = "0.0.0.0";
        }
        this.errMsg = "";
        return this.frame.connPanel.addClipPVC(this);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.dlg.Bridged) {
            this.dlg.MACAddress.enable();
            ((Component)this.dlg.MACAddress).setBackground(Color.white);
        } else if (event.target == this.dlg.Routed) {
            this.dlg.MACAddress.disable();
            ((Component)this.dlg.MACAddress).setBackground(Color.gray);
        } else {
            if (event.target == this.dlg.IDOK) {
                if (!this.addConnection()) {
                    if (!this.errMsg.equals("")) {
                        new MessageBox(this.frame, (Window)this, this.errMsg, 1);
                    }
                    return true;
                }
                this.dispose();
                return true;
            }
            if (event.target == this.dlg.IDCANCEL) {
                this.dispose();
                return true;
            }
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                this.dispose();
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

