/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Event;
import java.awt.MenuItem;
import java.awt.Window;

abstract class ICTop
extends Applet {
    ICFrame frame = new ICFrame("InFOREmation Center", this);
    static boolean initDetails;
    static boolean cellUnits;
    public static final int ERR_NO_ERROR = 0;
    public static final int ERR_GENERIC = -1;
    public static final int ERR_NOT_INIT = -2;
    public static final int ERR_NOT_FOUND = -3;
    public static final int ERR_DRIVER_FAIL = -4;
    public static final int ERR_NO_SUPPORT = -5;
    public static final int ERR_INCOMPLETE = -6;
    public static final int ERR_BAD_REQUEST = -7;
    public static final int ERR_NO_MEM = -8;
    public static final int ERR_DISABLED = -9;
    public static final int ERR_MUST_REBOOT = -10;
    static final String title = "InFOREmation Center";

    abstract boolean initialize(String[] var1);

    abstract void set_frame_icon(String var1);

    abstract void set_clipboard(String var1);

    abstract void terminate();

    abstract int get_status_summary(int var1, String[] var2, int var3, String[] var4);

    abstract int rejoin_elan(String var1, String var2);

    abstract int get_vlan_list(int var1, String[] var2);

    abstract int get_vlan_info(String var1, String[] var2);

    abstract int get_vlan_status(String var1, String[] var2, int var3, String[] var4, String[] var5);

    abstract int get_flow_specs(String var1, int var2, String[] var3);

    abstract int set_flow_specs(String var1, int var2, String[] var3);

    abstract int del_arp_entry(String var1, String[] var2);

    abstract int get_adap_list(int var1, String[] var2);

    abstract int get_adap_info(int var1, String[] var2);

    abstract int get_statistics(int var1, String[] var2, boolean var3);

    abstract int reset_adap_stats(int var1);

    abstract int get_connect_list(int var1, String[] var2);

    abstract int add_pvc(String var1, String[] var2);

    abstract int del_pvc(String var1, String[] var2);

    abstract boolean get_IP_addr(Window var1, String var2, String[] var3);

    abstract void show_help(String var1);

    public ICTop() {
        Object object;
        String[] stringArray = new String[10];
        try {
            if (!this.initialize(stringArray)) {
                System.exit(0);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            object = "ERROR: InfoCenter could not access its shared library.";
            new MessageBox(this.frame, (String)object, 1);
        }
        this.frame.Notices = stringArray[0];
        this.frame.init();
        if (stringArray[1].equals("NO")) {
            object = new Event(new MenuItem("none"), 1001, "About");
            this.frame.action((Event)object, ((Event)object).arg);
        }
        boolean bl = true;
        boolean bl2 = true;
        int n = 2;
        while (n < 10) {
            if (stringArray[n] == null) break;
            if (stringArray[n].equals("NO_CLIP")) {
                this.frame.connPanel.connDlg.AddClipPVC.hide();
                bl = false;
            } else if (stringArray[n].equals("NO_FORE_IP")) {
                this.frame.connPanel.connDlg.AddForePVC.hide();
                bl2 = false;
            } else if (stringArray[n].equals("NO_BRIDGED_PVC")) {
                this.frame.pvcBridged = false;
            }
            if (!bl2 && !bl) {
                this.frame.connPanel.connDlg.DeleteEntry.hide();
                this.frame.connPanel.connDlg.DeleteAll.hide();
                this.frame.vlanPanel.vlanDlg.deletePVC.hide();
            }
            ++n;
        }
        this.frame.setResizable(false);
        this.frame.show();
        this.set_frame_icon(title);
    }

    public void ShowError(int n) {
        String string = ICTop.GetErrorString(n);
        this.frame.ShowMessage(string);
    }

    public static String GetErrorString(int n) {
        switch (n) {
            case 0: {
                return new String("No Error");
            }
            case -1: {
                return new String("General Error");
            }
            case -2: {
                return new String("Driver Interface Not Initialized");
            }
            case -3: {
                return new String("Specified Adapter Or VLAN Not Found");
            }
            case -4: {
                return new String("Driver Error");
            }
            case -5: {
                return new String("Operation Not Supported");
            }
            case -6: {
                return new String("Incomplete Information Returned");
            }
            case -7: {
                return new String("Missing Or Invalid Parameter");
            }
            case -8: {
                return new String("Insufficient Memory");
            }
            case -9: {
                return new String("Selected Driver Is Disabled");
            }
            case -10: {
                return new String("You must reboot to complete the operation");
            }
        }
        String string = "Unknown Error (" + n + ")";
        return string;
    }

    public static double Cells2Kbits(int n) {
        double d = 0.5 + (double)n * 41.40625;
        int n2 = (int)d;
        d = (double)n2 / 100.0;
        return d;
    }

    public static double Cells2Kbits(long l) {
        double d = 0.5 + (double)l * 41.40625;
        int n = (int)d;
        d = (double)n / 100.0;
        return d;
    }

    public static int Kbits2Cells(double d) {
        int n = (int)(0.5 + d * 2.415094339623);
        return n;
    }
}

