/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import com.freescale.cdt.debug.cw.core.ui.publicintf.ISettingsListener;
import com.freescale.cdt.debug.cw.core.ui.settings.PrefException;
import com.swtdesigner.SWTResourceManager;
import net.sourceforge.usbdm.connections.usbdm.DoubleTextAdapter;
import net.sourceforge.usbdm.connections.usbdm.HexTextAdapter;
import net.sourceforge.usbdm.connections.usbdm.UsbdmConnectionPanel;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UsbdmHCS08ConnectionPanel
extends UsbdmConnectionPanel {
    private Button btnAutomaticallyReconnect;
    private Button btnDriveReset;
    private Button btnMaskInterruptsWhenStepping;
    private Button btnBDMClockDefault;
    private Button btnBDMClockBus;
    private Button btnBDMClockAlt;
    private Label lblTargetId;

    public UsbdmHCS08ConnectionPanel(Composite parent, int style) {
        super(parent, style);
        System.err.println("createComposite()");
        this.init();
        this.defaultBdmOptions = new UsbdmConnectionPanel.DefaultBdmOptions();
    }

    public UsbdmHCS08ConnectionPanel(ISettingsListener listener, Composite parent, int swtstyle, String protocolPlugin, String connectionTypeId) {
        super(listener, parent, swtstyle, protocolPlugin, connectionTypeId);
        this.init();
    }

    private void init() {
        this.deviceNameId = "com.freescale.cdt.debug.cw.CW_SHADOWED_PREF.HC08 Debugger.processor";
        this.gdiDllName = "usbdm-hcs08-gdi";
        this.gdiDebugDllName = "usbdm-hcs08-gdi-debug";
    }

    @Override
    public void create() {
        this.createContents((Composite)this);
        this.addSettingsChangedListeners();
    }

    @Override
    protected void restoreDefaultSettings() {
        super.restoreDefaultSettings();
        try {
            this.btnMaskInterruptsWhenStepping.setSelection(this.defaultBdmOptions.maskinterrupts != 0);
            this.btnAutomaticallyReconnect.setSelection(this.defaultBdmOptions.autoReconnect != 0);
            this.btnDriveReset.setSelection(this.defaultBdmOptions.useResetSignal != 0);
            int bdmClockSelect = this.defaultBdmOptions.useAltBDMClock;
            this.btnBDMClockDefault.setSelection(bdmClockSelect == 255);
            this.btnBDMClockBus.setSelection(bdmClockSelect == 1);
            this.btnBDMClockAlt.setSelection(bdmClockSelect == 0);
            int clockTrimFrequency = this.defaultBdmOptions.clockTrimFrequency;
            this.txtTrimFrequencyAdapter.setDoubleValue((double)clockTrimFrequency / 1000.0);
            this.txtNVTRIMAddressAdapter.setHexValue(this.defaultBdmOptions.clockTrimNVAddress);
            this.enableTrim(this.defaultBdmOptions.doClockTrim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadSettings(ILaunchConfiguration iLaunchConfiguration) {
        this.launchConfiguration = iLaunchConfiguration;
        super.loadSettings(iLaunchConfiguration);
        try {
            this.btnMaskInterruptsWhenStepping.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("maskInterrupts"), this.defaultBdmOptions.maskinterrupts) != 0);
            this.btnAutomaticallyReconnect.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("automaticReconnect"), this.defaultBdmOptions.autoReconnect) != 0);
            this.btnDriveReset.setSelection(this.getIntAttribute(iLaunchConfiguration, this.attrib("useResetSignal"), this.defaultBdmOptions.useResetSignal) != 0);
            int bdmClockSelect = this.getIntAttribute(iLaunchConfiguration, this.attrib("useAltBDMClock"), this.defaultBdmOptions.useAltBDMClock);
            this.btnBDMClockDefault.setSelection(bdmClockSelect == 255);
            this.btnBDMClockBus.setSelection(bdmClockSelect == 1);
            this.btnBDMClockAlt.setSelection(bdmClockSelect == 0);
            int clockTrimFrequency = this.getIntAttribute(iLaunchConfiguration, this.attrib("clockTrimFrequency"), this.defaultBdmOptions.clockTrimFrequency);
            this.txtTrimFrequencyAdapter.setDoubleValue((double)clockTrimFrequency / 1000.0);
            int clockTrimNVAddress = this.getIntAttribute(iLaunchConfiguration, this.attrib("clockTrimNVAddress"), this.defaultBdmOptions.clockTrimNVAddress);
            this.txtNVTRIMAddressAdapter.setHexValue(clockTrimNVAddress);
            this.enableTrim(this.getIntAttribute(iLaunchConfiguration, this.attrib("trimTargetClock"), this.defaultBdmOptions.clockTrimFrequency != 0 ? 1 : 0) != 0);
            this.btnUseDebugBuild.setSelection(iLaunchConfiguration.getAttribute(this.attrib("useDebugBuild"), "false").equalsIgnoreCase("true"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblTargetId.setText(this.GetGdiLibrary());
    }

    @Override
    public void saveSettings(ILaunchConfigurationWorkingCopy paramILaunchConfigurationWorkingCopy) throws PrefException {
        super.saveSettings(paramILaunchConfigurationWorkingCopy);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("maskInterrupts"), this.btnMaskInterruptsWhenStepping.getSelection() ? "1" : "0");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("automaticReconnect"), this.btnAutomaticallyReconnect.getSelection() ? "1" : "0");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useResetSignal"), this.btnDriveReset.getSelection() ? "1" : "0");
        int bdmClock = 255;
        if (this.btnBDMClockBus.getSelection()) {
            bdmClock = 1;
        } else if (this.btnBDMClockAlt.getSelection()) {
            bdmClock = 0;
        }
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useAltBDMClock"), String.format("%d", bdmClock));
        if (this.btnTrimTargetClock.getSelection()) {
            String nvAddress = "0";
            String trimfreq = "0";
            try {
                trimfreq = String.format("%d", (int)(this.txtTrimFrequencyAdapter.getDoubleValue() * 1000.0));
                nvAddress = String.format("%d", this.txtNVTRIMAddressAdapter.getHexValue());
            }
            catch (Exception exception) {}
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("trimTargetClock"), "1");
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("clockTrimFrequency"), trimfreq);
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("clockTrimNVAddress"), nvAddress);
        } else {
            paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("trimTargetClock"), "0");
            paramILaunchConfigurationWorkingCopy.removeAttribute(this.attrib("clockTrimFrequency"));
            paramILaunchConfigurationWorkingCopy.removeAttribute(this.attrib("clockTrimNVAddress"));
        }
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("useDebugBuild"), this.btnUseDebugBuild.getSelection() ? "true" : "false");
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("usePSTSignals"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("guessSpeedIfNoSYNC"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("targetClockFrequency"), null);
        paramILaunchConfigurationWorkingCopy.setAttribute(this.attrib("guessSpeedIfNoSYNC"), null);
    }

    @Override
    protected void addSettingsChangedListeners() {
        super.addSettingsChangedListeners();
        if (this.fListener != null) {
            this.btnAutomaticallyReconnect.addSelectionListener(this.fListener.getSelectionListener());
            this.btnBDMClockAlt.addSelectionListener(this.fListener.getSelectionListener());
            this.btnBDMClockBus.addSelectionListener(this.fListener.getSelectionListener());
            this.btnBDMClockDefault.addSelectionListener(this.fListener.getSelectionListener());
            this.btnDriveReset.addSelectionListener(this.fListener.getSelectionListener());
            this.btnMaskInterruptsWhenStepping.addSelectionListener(this.fListener.getSelectionListener());
            this.btnTrimTargetClock.addSelectionListener(this.fListener.getSelectionListener());
            this.txtNVTRIMAddress.addModifyListener(this.fListener.getModifyListener());
            this.txtTrimFrequency.addModifyListener(this.fListener.getModifyListener());
            this.btnUseDebugBuild.addSelectionListener(this.fListener.getSelectionListener());
        }
    }

    @Override
    protected void createContents(Composite comp) {
        super.createContents(comp);
        Group grpConnectionControl = new Group((Composite)this, 0);
        RowLayout rl_grpConnectionControl = new RowLayout(512);
        rl_grpConnectionControl.marginHeight = 3;
        grpConnectionControl.setLayout((Layout)rl_grpConnectionControl);
        grpConnectionControl.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpConnectionControl.setText("Connection Control");
        this.toolkit.adapt((Composite)grpConnectionControl);
        this.toolkit.paintBordersFor((Composite)grpConnectionControl);
        this.btnAutomaticallyReconnect = new Button((Composite)grpConnectionControl, 32);
        this.btnAutomaticallyReconnect.setToolTipText("Automatically re-sync with the target whenever target state is polled.");
        this.toolkit.adapt((Control)this.btnAutomaticallyReconnect, true, true);
        this.btnAutomaticallyReconnect.setText("Automatically re-connect");
        this.btnDriveReset = new Button((Composite)grpConnectionControl, 32);
        this.btnDriveReset.setToolTipText("Drive target reset pin when resetting the target.");
        this.btnDriveReset.setText("Drive RESET pin");
        this.btnDriveReset.setBounds(0, 0, 140, 16);
        this.toolkit.adapt((Control)this.btnDriveReset, true, true);
        this.grpClockTrim = new Group((Composite)this, 0);
        this.grpClockTrim.setText("Internal Clock Trim");
        this.grpClockTrim.setLayout((Layout)new GridLayout(2, false));
        this.grpClockTrim.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        this.toolkit.adapt((Composite)this.grpClockTrim);
        this.toolkit.paintBordersFor((Composite)this.grpClockTrim);
        this.btnTrimTargetClock = new Button((Composite)this.grpClockTrim, 32);
        this.btnTrimTargetClock.setText("Enable Clock Trim");
        this.btnTrimTargetClock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmHCS08ConnectionPanel.this.enableTrim(((Button)e.getSource()).getSelection());
            }
        });
        new Label((Composite)this.grpClockTrim, 0);
        this.lblTrimFrequency = new Label((Composite)this.grpClockTrim, 0);
        this.toolkit.adapt((Control)this.lblTrimFrequency, true, true);
        this.lblTrimFrequency.setText("Trim Frequency");
        new Label((Composite)this.grpClockTrim, 0);
        this.btnTrimTargetClock.setToolTipText("Enable trimming of target internal clock source.");
        this.toolkit.adapt((Control)this.btnTrimTargetClock, true, true);
        this.txtTrimFrequency = new Text((Composite)this.grpClockTrim, 2048);
        this.txtTrimFrequencyAdapter = new DoubleTextAdapter(this.txtTrimFrequency);
        this.txtTrimFrequency.setTextLimit(7);
        this.txtTrimFrequencyAdapter.setDoubleValue(0.0);
        this.txtTrimFrequency.setToolTipText("");
        this.txtTrimFrequency.setBackground(SWTResourceManager.getColor(255, 255, 255));
        GridData gd_txtTrimFrequency = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtTrimFrequency.widthHint = 65;
        gd_txtTrimFrequency.minimumWidth = 65;
        this.txtTrimFrequency.setLayoutData((Object)gd_txtTrimFrequency);
        this.toolkit.adapt((Control)this.txtTrimFrequency, true, true);
        this.lblKhz = new Label((Composite)this.grpClockTrim, 0);
        this.lblKhz.setToolTipText("The frequency to trim the internal clock source to.\r\nNote this is NOT the bus clock frequency.\r\nZero indicates use chip default value");
        this.toolkit.adapt((Control)this.lblKhz, true, true);
        this.lblKhz.setText("kHz");
        this.lblNvtrimAddress = new Label((Composite)this.grpClockTrim, 0);
        this.toolkit.adapt((Control)this.lblNvtrimAddress, true, true);
        this.lblNvtrimAddress.setText("NVTRIM Address");
        new Label((Composite)this.grpClockTrim, 0);
        this.txtNVTRIMAddress = new Text((Composite)this.grpClockTrim, 2048);
        this.txtNVTRIMAddressAdapter = new HexTextAdapter(this.txtNVTRIMAddress);
        this.txtNVTRIMAddressAdapter.setHexValue(0);
        GridData gd_txtNVTRIMAddress = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtNVTRIMAddress.widthHint = 65;
        gd_txtNVTRIMAddress.minimumWidth = 65;
        this.txtNVTRIMAddress.setLayoutData((Object)gd_txtNVTRIMAddress);
        this.toolkit.adapt((Control)this.txtNVTRIMAddress, true, true);
        this.lblHex = new Label((Composite)this.grpClockTrim, 0);
        this.lblHex.setToolTipText("Address of non-volatile memory location to write the trim value to.\r\nZero indicates use chip default value");
        this.toolkit.adapt((Control)this.lblHex, true, true);
        this.lblHex.setText("hex");
        Group grpBdmClockSelect = new Group((Composite)this, 0);
        grpBdmClockSelect.setText("BDM Clock Select");
        RowLayout rl_grpBdmClockSelect = new RowLayout(256);
        rl_grpBdmClockSelect.marginHeight = 3;
        rl_grpBdmClockSelect.marginBottom = 0;
        grpBdmClockSelect.setLayout((Layout)rl_grpBdmClockSelect);
        grpBdmClockSelect.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt((Composite)grpBdmClockSelect);
        this.toolkit.paintBordersFor((Composite)grpBdmClockSelect);
        this.btnBDMClockDefault = new Button((Composite)grpBdmClockSelect, 16);
        this.btnBDMClockDefault.setToolTipText("Use default BDM clock.");
        this.toolkit.adapt((Control)this.btnBDMClockDefault, true, true);
        this.btnBDMClockDefault.setText("Default");
        this.btnBDMClockBus = new Button((Composite)grpBdmClockSelect, 16);
        this.btnBDMClockBus.setToolTipText("Force use of target Bus Clock as BDM clock.");
        this.toolkit.adapt((Control)this.btnBDMClockBus, true, true);
        this.btnBDMClockBus.setText("Bus Clock/2");
        this.btnBDMClockAlt = new Button((Composite)grpBdmClockSelect, 16);
        this.btnBDMClockAlt.setToolTipText("Force use of alternative  BDM clock (derivative specific source).");
        this.toolkit.adapt((Control)this.btnBDMClockAlt, true, true);
        this.btnBDMClockAlt.setText("Alt");
        Group grpMiscellaneous = new Group((Composite)this, 0);
        grpMiscellaneous.setText("Miscellaneous");
        RowLayout rl_grpMiscellaneous = new RowLayout(256);
        rl_grpMiscellaneous.marginHeight = 3;
        grpMiscellaneous.setLayout((Layout)rl_grpMiscellaneous);
        grpMiscellaneous.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt((Composite)grpMiscellaneous);
        this.toolkit.paintBordersFor((Composite)grpMiscellaneous);
        this.btnMaskInterruptsWhenStepping = new Button((Composite)grpMiscellaneous, 32);
        this.btnMaskInterruptsWhenStepping.setToolTipText("The I bit in the CCR will be dynamically modified to mask interrupts when single-stepping.\nIn most cases interrupts will be ignored.");
        this.btnMaskInterruptsWhenStepping.setText("Mask Interrupts when stepping");
        this.toolkit.adapt((Control)this.btnMaskInterruptsWhenStepping, true, true);
        Group grpDebuggingOptions = new Group((Composite)this, 0);
        grpDebuggingOptions.setText("Debugging Options");
        grpDebuggingOptions.setLayout((Layout)new RowLayout(256));
        grpDebuggingOptions.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt((Composite)grpDebuggingOptions);
        this.toolkit.paintBordersFor((Composite)grpDebuggingOptions);
        this.btnUseDebugBuild = new Button((Composite)grpDebuggingOptions, 32);
        this.btnUseDebugBuild.setToolTipText("Used for debugging USBDM drivers - don't enable");
        this.toolkit.adapt((Control)this.btnUseDebugBuild, true, true);
        this.btnUseDebugBuild.setText("Use debug build");
        this.btnUseDebugBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsbdmHCS08ConnectionPanel.this.lblTargetId.setText(UsbdmHCS08ConnectionPanel.this.GetGdiLibrary());
            }
        });
        Composite composite_2 = new Composite((Composite)this, 0);
        composite_2.setLayout((Layout)new FillLayout(512));
        GridData gd_composite_2 = new GridData(4, 128, false, false, 1, 1);
        gd_composite_2.horizontalIndent = 5;
        gd_composite_2.verticalIndent = 5;
        composite_2.setLayoutData((Object)gd_composite_2);
        this.toolkit.adapt(composite_2);
        this.toolkit.paintBordersFor(composite_2);
        this.lblTargetId = new Label(composite_2, 131072);
        this.toolkit.adapt((Control)this.lblTargetId, true, true);
        this.lblTargetId.setText("Target ID");
        super.appendContents((Composite)this);
    }
}

