' CapaPlay II for Quick Basic
' credits for this .BAS to Liket / Goto10

'****************************** GUS Settings **********************************

Declare Function CP_GetIRQ CDECL () as byte
Declare Sub CP_SetIRQ CDECL (BYVAL NewIRQ as byte)
Declare Function CP_GetDMA CDECL () as byte
Declare Sub CP_SetDMA CDECL (BYVAL NewDMA as byte)
Declare Function CP_GetBasePort CDECL () as word
Declare Sub CP_SetBasePort CDECL (BYVAL NewBasePort as word)
Declare Sub CP_SetLineIn CDECL (BYVAL LineInState as byte)
Declare Sub CP_SetMicIn CDECL (BYVAL MicInState as byte)

'******************************* Load/Unload **********************************

Declare Function CP_LoadModule CDECL (ModName as string*256,BYVAL StartOffset as long,BYVAL TransferMode as byte) as byte
Declare Function CP_LoadOnlyPatterns CDECL (ModName as string*256,BYVAL StartOffset as long,BYVAL TransferMode as byte) as byte
Declare Sub CP_FreeModule CDECL ()

'***************************** Start/Stop/Pause *******************************

Declare Sub CP_StartModule CDECL (BYVAL Amplification as byte,BYVAL DefaultPanning as byte,BYVAL TimerMode as byte)
Declare Sub CP_StopModule CDECL ()
Declare Function CP_PauseModule CDECL () as byte

'********************** Set General Module Information ************************

Declare Sub CP_SetSpeedZeroMode CDECL (BYVAL SpeedZeroMode as byte)
Declare Sub CP_SetPanEffectMode CDECL (BYVAL PanEffectMode as byte)
Declare Sub CP_SetVBlankMode CDECL (BYVAL VBlankMode as byte)
Declare Sub CP_SetAmigaLimitsMode CDECL (BYVAL AmigaLimitsMode as byte)

'********************** Get General Module Information ************************

Declare Function CP_GetModuleName CDECL () as string
Declare Function CP_GetModuleType CDECL () as byte
Declare Function CP_GetModuleLength CDECL () as byte
Declare Function CP_GetNumOfPatterns CDECL () as word
Declare Function CP_GetNumOfInstruments CDECL () as byte
Declare Function CP_GetNumOfChannels CDECL () as byte
Declare Function CP_GetNumOfUsedChannels CDECL () as byte
Declare Function CP_GetRestartPosition CDECL () as byte
Declare Function CP_GetUsedPatternMemory CDECL () as long
Declare Function CP_GetUsedInstrumentInfoMemory CDECL () as long
Declare Function CP_GetUsedGUSMemory CDECL () as long
Declare Function CP_GetFileSize CDECL () as long

'********************** Set General Playing Information ***********************

Declare Sub CP_SetPosition CDECL (BYVAL NewPosition as word)
Declare Sub CP_SetGlobalVolume CDECL (BYVAL NewVolume as word)
Declare Sub CP_SetMainVolume CDECL (BYVAL NewVolume as word)
Declare Sub CP_RestoreInitialVolume CDECL ()
Declare Sub CP_SetSpeed CDECL (BYVAL NewSpeed as word)
Declare Sub CP_SetTempo CDECL (BYVAL NewTempo as word)
Declare Sub CP_RestoreSpeedAndTempo CDECL ()
Declare Sub CP_SetDefaultPanning CDECL (BYVAL DefaultPanning as byte)

'********************** Get General Playing Information ***********************

Declare Function CP_GetRow CDECL () as byte
Declare Function CP_GetNumOfRows CDECL (BYVAL PositionNum as word) as word
Declare Function CP_GetPosition CDECL () as byte
Declare Function CP_GetPattern CDECL () as byte
Declare Function CP_GetGlobalVolume CDECL () as byte
Declare Function CP_GetMainVolume CDECL () as byte
Declare Function CP_GetSpeed CDECL () as byte
Declare Function CP_GetTempo CDECL () as byte
Declare Function CP_GetPlayingTime CDECL () as word
Declare Function CP_GetTimer CDECL () as long
Declare Function CP_GetLoopCounter CDECL () as byte

'************************* Set Channel Information ****************************

Declare Function CP_SetChannelMute CDECL (BYVAL ChannelNum as word,BYVAL MuteState as byte) as byte
Declare Sub CP_SetChannelPanning CDECL (BYVAL ChannelNum as word,BYVAL NewPanning as byte)
Declare Sub CP_PlaySample CDECL (BYVAL ChannelNum as word,BYVAL InstrumentNum as word,BYVAL SampleNum as word,BYVAL Note as byte,BYVAL Octave as byte)
Declare Sub CP_StopSample CDECL (BYVAL ChannelNum as word)

'************************* Get Channel Information ****************************

Declare Function CP_GetChannelNote CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelOctave CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelVolume CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelEffect CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelEffectParams CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelInstrument CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelSample CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelBar CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelNoteTrigger CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelPanning CDECL (BYVAL ChannelNum as word) as byte
Declare Function CP_GetChannelMute CDECL (BYVAL ChannelNum as word) as byte

'******************** Set Instrument/Sample Information ***********************

Declare Function CP_SetSampleMute CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word,BYVAL MuteState as byte) as byte

'******************** Get Instrument/Sample Information ***********************

Declare Function CP_GetInstrumentName CDECL (BYVAL InstrumentNum as word) as string
Declare Function CP_GetNumOfSamples CDECL (BYVAL InstrumentNum as word) as byte
Declare Function CP_GetSampleName CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as string
Declare Function CP_GetSampleSize CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as long
Declare Function CP_GetSampleC4Spd CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as word
Declare Function CP_GetSampleVolume CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as byte
Declare Function CP_GetSamplePanning CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as byte
Declare Function CP_GetSampleLoopType CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as byte
Declare Function CP_GetSampleLoopBegin CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as long
Declare Function CP_GetSampleLength CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as long
Declare Function CP_GetSample16Bit CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as byte
Declare Function CP_GetSampleMute CDECL (BYVAL InstrumentNum as word,BYVAL SampleNum as word) as byte

