unit txt3d;
interface
{$s-}
const
  scr_seg : word = $a000;

type
t_matrix = array[0..8] of longint;

var
matrix : t_matrix;

procedure matriisi(var mat : t_matrix;kx2,ky2,kz2 : integer);
procedure rotatep;
procedure line3(x1,y1,x2,y2 : integer;color : byte);
procedure mix;
procedure show;
procedure hide;
procedure setfont;
procedure l3d_cube;
procedure l3d_pyramid;
procedure l3d_adnmod;
procedure init3d;

implementation
const
  fontti_POINTS=$08;
  fontti : ARRAY [1..$0800] OF CHAR = (
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$00, 
    #$7E, #$81, #$A5, #$81, #$BD, #$99, #$81, #$7E, 
    #$7E, #$FF, #$DB, #$FF, #$C3, #$E7, #$FF, #$7E, 
    #$6C, #$FE, #$FE, #$FE, #$7C, #$38, #$10, #$00, 
    #$10, #$38, #$7C, #$FE, #$7C, #$38, #$10, #$00, 
    #$38, #$7C, #$38, #$FE, #$FE, #$7C, #$38, #$7C, 
    #$10, #$10, #$38, #$7C, #$FE, #$7C, #$38, #$7C, 
    #$00, #$00, #$18, #$3C, #$3C, #$18, #$00, #$00, 
    #$FF, #$FF, #$E7, #$C3, #$C3, #$E7, #$FF, #$FF, 
    #$00, #$3C, #$66, #$42, #$42, #$66, #$3C, #$00, 
    #$FF, #$C3, #$99, #$BD, #$BD, #$99, #$C3, #$FF, 
    #$0F, #$07, #$0F, #$7D, #$CC, #$CC, #$CC, #$78, 
    #$3C, #$66, #$66, #$66, #$3C, #$18, #$7E, #$18, 
    #$3F, #$33, #$3F, #$30, #$30, #$70, #$F0, #$E0, 
    #$7F, #$63, #$7F, #$63, #$63, #$67, #$E6, #$C0, 
    #$99, #$5A, #$3C, #$E7, #$E7, #$3C, #$5A, #$99, 
    #$80, #$E0, #$F8, #$FE, #$F8, #$E0, #$80, #$00, 
    #$02, #$0E, #$3E, #$FE, #$3E, #$0E, #$02, #$00, 
    #$18, #$3C, #$7E, #$18, #$18, #$7E, #$3C, #$18, 
    #$66, #$66, #$66, #$66, #$66, #$00, #$66, #$00, 
    #$7F, #$DB, #$DB, #$7B, #$1B, #$1B, #$1B, #$00, 
    #$3E, #$63, #$38, #$6C, #$6C, #$38, #$CC, #$78, 
    #$00, #$00, #$00, #$00, #$7E, #$7E, #$7E, #$00, 
    #$18, #$3C, #$7E, #$18, #$7E, #$3C, #$18, #$FF, 
    #$18, #$3C, #$7E, #$18, #$18, #$18, #$18, #$00, 
    #$18, #$18, #$18, #$18, #$7E, #$3C, #$18, #$00, 
    #$00, #$18, #$0C, #$FE, #$0C, #$18, #$00, #$00, 
    #$00, #$30, #$60, #$FE, #$60, #$30, #$00, #$00, 
    #$00, #$00, #$C0, #$C0, #$C0, #$FE, #$00, #$00, 
    #$00, #$24, #$66, #$FF, #$66, #$24, #$00, #$00, 
    #$00, #$18, #$3C, #$7E, #$FF, #$FF, #$00, #$00, 
    #$00, #$FF, #$FF, #$7E, #$3C, #$18, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$00, 
    #$30, #$78, #$78, #$78, #$30, #$00, #$30, #$00, 
    #$6C, #$6C, #$6C, #$00, #$00, #$00, #$00, #$00, 
    #$6C, #$6C, #$FE, #$6C, #$FE, #$6C, #$6C, #$00, 
    #$30, #$7C, #$C0, #$78, #$0C, #$F8, #$30, #$00, 
    #$00, #$C6, #$CC, #$18, #$30, #$66, #$C6, #$00, 
    #$38, #$6C, #$38, #$76, #$DC, #$CC, #$76, #$00, 
    #$60, #$60, #$C0, #$00, #$00, #$00, #$00, #$00, 
    #$18, #$30, #$60, #$60, #$60, #$30, #$18, #$00, 
    #$60, #$30, #$18, #$18, #$18, #$30, #$60, #$00, 
    #$00, #$66, #$3C, #$FF, #$3C, #$66, #$00, #$00, 
    #$00, #$30, #$30, #$FC, #$30, #$30, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$30, #$30, #$60, 
    #$00, #$00, #$00, #$FC, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$30, #$30, #$00, 
    #$06, #$0C, #$18, #$30, #$60, #$C0, #$80, #$00, 
    #$7C, #$C6, #$CE, #$DE, #$F6, #$E6, #$7C, #$00, 
    #$30, #$70, #$30, #$30, #$30, #$30, #$FC, #$00, 
    #$78, #$CC, #$0C, #$38, #$60, #$CC, #$FC, #$00, 
    #$78, #$CC, #$0C, #$38, #$0C, #$CC, #$78, #$00, 
    #$1C, #$3C, #$6C, #$CC, #$FE, #$0C, #$1E, #$00, 
    #$FC, #$C0, #$F8, #$0C, #$0C, #$CC, #$78, #$00, 
    #$38, #$60, #$C0, #$F8, #$CC, #$CC, #$78, #$00, 
    #$FC, #$CC, #$0C, #$18, #$30, #$30, #$30, #$00, 
    #$78, #$CC, #$CC, #$78, #$CC, #$CC, #$78, #$00, 
    #$78, #$CC, #$CC, #$7C, #$0C, #$18, #$70, #$00, 
    #$00, #$30, #$30, #$00, #$00, #$30, #$30, #$00, 
    #$00, #$30, #$30, #$00, #$00, #$30, #$30, #$60, 
    #$18, #$30, #$60, #$C0, #$60, #$30, #$18, #$00, 
    #$00, #$00, #$FC, #$00, #$00, #$FC, #$00, #$00, 
    #$60, #$30, #$18, #$0C, #$18, #$30, #$60, #$00, 
    #$78, #$CC, #$0C, #$18, #$30, #$00, #$30, #$00, 
    #$7C, #$C6, #$DE, #$DE, #$DE, #$C0, #$78, #$00, 
    #$30, #$78, #$CC, #$CC, #$FC, #$CC, #$CC, #$00, 
    #$FC, #$66, #$66, #$7C, #$66, #$66, #$FC, #$00, 
    #$3C, #$66, #$C0, #$C0, #$C0, #$66, #$3C, #$00, 
    #$F8, #$6C, #$66, #$66, #$66, #$6C, #$F8, #$00, 
    #$7E, #$60, #$60, #$78, #$60, #$60, #$7E, #$00, 
    #$7E, #$60, #$60, #$78, #$60, #$60, #$60, #$00, 
    #$3C, #$66, #$C0, #$C0, #$CE, #$66, #$3E, #$00, 
    #$CC, #$CC, #$CC, #$FC, #$CC, #$CC, #$CC, #$00, 
    #$78, #$30, #$30, #$30, #$30, #$30, #$78, #$00, 
    #$1E, #$0C, #$0C, #$0C, #$CC, #$CC, #$78, #$00, 
    #$E6, #$66, #$6C, #$78, #$6C, #$66, #$E6, #$00, 
    #$60, #$60, #$60, #$60, #$60, #$60, #$7E, #$00, 
    #$C6, #$EE, #$FE, #$FE, #$D6, #$C6, #$C6, #$00, 
    #$C6, #$E6, #$F6, #$DE, #$CE, #$C6, #$C6, #$00, 
    #$38, #$6C, #$C6, #$C6, #$C6, #$6C, #$38, #$00, 
    #$FC, #$66, #$66, #$7C, #$60, #$60, #$F0, #$00, 
    #$78, #$CC, #$CC, #$CC, #$DC, #$78, #$1C, #$00, 
    #$FC, #$66, #$66, #$7C, #$6C, #$66, #$E6, #$00, 
    #$78, #$CC, #$E0, #$70, #$1C, #$CC, #$78, #$00, 
    #$FC, #$30, #$30, #$30, #$30, #$30, #$30, #$00, 
    #$CC, #$CC, #$CC, #$CC, #$CC, #$CC, #$FC, #$00, 
    #$CC, #$CC, #$CC, #$CC, #$CC, #$78, #$30, #$00, 
    #$C6, #$C6, #$C6, #$D6, #$FE, #$EE, #$C6, #$00, 
    #$C6, #$C6, #$6C, #$38, #$38, #$6C, #$C6, #$00, 
    #$CC, #$CC, #$CC, #$78, #$30, #$30, #$78, #$00, 
    #$FE, #$06, #$0C, #$18, #$30, #$60, #$FE, #$00, 
    #$78, #$60, #$60, #$60, #$60, #$60, #$78, #$00, 
    #$C0, #$60, #$30, #$18, #$0C, #$06, #$02, #$00, 
    #$78, #$18, #$18, #$18, #$18, #$18, #$78, #$00, 
    #$10, #$38, #$6C, #$C6, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$FF, 
    #$30, #$30, #$18, #$00, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$78, #$0C, #$7C, #$CC, #$76, #$00, 
    #$E0, #$60, #$60, #$7C, #$66, #$66, #$DC, #$00, 
    #$00, #$00, #$78, #$CC, #$C0, #$CC, #$78, #$00, 
    #$1C, #$0C, #$0C, #$7C, #$CC, #$CC, #$76, #$00, 
    #$00, #$00, #$78, #$CC, #$FC, #$C0, #$78, #$00, 
    #$38, #$6C, #$60, #$F0, #$60, #$60, #$F0, #$00, 
    #$00, #$00, #$76, #$CC, #$CC, #$7C, #$0C, #$F8, 
    #$E0, #$60, #$6C, #$76, #$66, #$66, #$E6, #$00, 
    #$30, #$00, #$70, #$30, #$30, #$30, #$78, #$00, 
    #$0C, #$00, #$0C, #$0C, #$0C, #$CC, #$CC, #$78, 
    #$E0, #$60, #$66, #$6C, #$78, #$6C, #$E6, #$00, 
    #$70, #$30, #$30, #$30, #$30, #$30, #$78, #$00, 
    #$00, #$00, #$CC, #$FE, #$FE, #$D6, #$C6, #$00, 
    #$00, #$00, #$F8, #$CC, #$CC, #$CC, #$CC, #$00, 
    #$00, #$00, #$78, #$CC, #$CC, #$CC, #$78, #$00, 
    #$00, #$00, #$DC, #$66, #$66, #$7C, #$60, #$F0, 
    #$00, #$00, #$76, #$CC, #$CC, #$7C, #$0C, #$1E, 
    #$00, #$00, #$DC, #$76, #$66, #$60, #$F0, #$00, 
    #$00, #$00, #$7C, #$C0, #$78, #$0C, #$F8, #$00, 
    #$10, #$30, #$7C, #$30, #$30, #$34, #$18, #$00, 
    #$00, #$00, #$CC, #$CC, #$CC, #$CC, #$76, #$00, 
    #$00, #$00, #$CC, #$CC, #$CC, #$78, #$30, #$00, 
    #$00, #$00, #$C6, #$D6, #$FE, #$FE, #$6C, #$00, 
    #$00, #$00, #$C6, #$6C, #$38, #$6C, #$C6, #$00, 
    #$00, #$00, #$CC, #$CC, #$CC, #$7C, #$0C, #$F8, 
    #$00, #$00, #$FC, #$98, #$30, #$64, #$FC, #$00, 
    #$1C, #$30, #$30, #$E0, #$30, #$30, #$1C, #$00, 
    #$18, #$18, #$18, #$00, #$18, #$18, #$18, #$00, 
    #$E0, #$30, #$30, #$1C, #$30, #$30, #$E0, #$00, 
    #$76, #$DC, #$00, #$00, #$00, #$00, #$00, #$00, 
    #$00, #$10, #$38, #$6C, #$C6, #$C6, #$FE, #$00, 
    #$78, #$CC, #$C0, #$CC, #$78, #$18, #$0C, #$78, 
    #$00, #$CC, #$00, #$CC, #$CC, #$CC, #$7E, #$00, 
    #$1C, #$00, #$78, #$CC, #$FC, #$C0, #$78, #$00, 
    #$7E, #$C3, #$3C, #$06, #$3E, #$66, #$3F, #$00, 
    #$CC, #$00, #$78, #$0C, #$7C, #$CC, #$7E, #$00, 
    #$E0, #$00, #$78, #$0C, #$7C, #$CC, #$7E, #$00, 
    #$30, #$30, #$78, #$0C, #$7C, #$CC, #$7E, #$00, 
    #$00, #$00, #$78, #$C0, #$C0, #$78, #$0C, #$38, 
    #$7E, #$C3, #$3C, #$66, #$7E, #$60, #$3C, #$00, 
    #$CC, #$00, #$78, #$CC, #$FC, #$C0, #$78, #$00, 
    #$E0, #$00, #$78, #$CC, #$FC, #$C0, #$78, #$00, 
    #$CC, #$00, #$70, #$30, #$30, #$30, #$78, #$00, 
    #$7C, #$C6, #$38, #$18, #$18, #$18, #$3C, #$00, 
    #$E0, #$00, #$70, #$30, #$30, #$30, #$78, #$00, 
    #$C6, #$38, #$6C, #$C6, #$FE, #$C6, #$C6, #$00, 
    #$30, #$30, #$00, #$78, #$CC, #$FC, #$CC, #$00, 
    #$1C, #$00, #$FC, #$60, #$78, #$60, #$FC, #$00, 
    #$00, #$00, #$7F, #$0C, #$7F, #$CC, #$7F, #$00, 
    #$3E, #$6C, #$CC, #$FE, #$CC, #$CC, #$CE, #$00, 
    #$78, #$CC, #$00, #$78, #$CC, #$CC, #$78, #$00, 
    #$00, #$CC, #$00, #$78, #$CC, #$CC, #$78, #$00, 
    #$00, #$E0, #$00, #$78, #$CC, #$CC, #$78, #$00, 
    #$78, #$CC, #$00, #$CC, #$CC, #$CC, #$7E, #$00, 
    #$00, #$E0, #$00, #$CC, #$CC, #$CC, #$7E, #$00, 
    #$00, #$CC, #$00, #$CC, #$CC, #$7C, #$0C, #$F8, 
    #$C3, #$18, #$3C, #$66, #$66, #$3C, #$18, #$00, 
    #$CC, #$00, #$CC, #$CC, #$CC, #$CC, #$78, #$00, 
    #$18, #$18, #$7E, #$C0, #$C0, #$7E, #$18, #$18, 
    #$38, #$6C, #$64, #$F0, #$60, #$E6, #$FC, #$00, 
    #$CC, #$CC, #$78, #$FC, #$30, #$FC, #$30, #$30, 
    #$F8, #$CC, #$CC, #$FA, #$C6, #$CF, #$C6, #$C7, 
    #$0E, #$1B, #$18, #$3C, #$18, #$18, #$D8, #$70, 
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$00, 
    #$F0, #$F0, #$F0, #$F0, #$00, #$00, #$00, #$00, 
    #$0F, #$0F, #$0F, #$0F, #$00, #$00, #$00, #$00, 
    #$FF, #$FF, #$FF, #$FF, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$F0, #$F0, #$F0, #$F0, 
    #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, 
    #$0F, #$0F, #$0F, #$0F, #$F0, #$F0, #$F0, #$F0, 
    #$FF, #$FF, #$FF, #$FF, #$F0, #$F0, #$F0, #$F0, 
    #$00, #$00, #$00, #$00, #$0F, #$0F, #$0F, #$0F, 
    #$F0, #$F0, #$F0, #$F0, #$0F, #$0F, #$0F, #$0F, 
    #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, 
    #$FF, #$FF, #$FF, #$FF, #$0F, #$0F, #$0F, #$0F, 
    #$00, #$00, #$00, #$00, #$FF, #$FF, #$FF, #$FF, 
    #$F0, #$F0, #$F0, #$F0, #$FF, #$FF, #$FF, #$FF, 
    #$0F, #$0F, #$0F, #$0F, #$FF, #$FF, #$FF, #$FF, 
    #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, 
    #$22, #$88, #$22, #$88, #$22, #$88, #$22, #$88, 
    #$55, #$AA, #$55, #$AA, #$55, #$AA, #$55, #$AA, 
    #$DB, #$77, #$DB, #$EE, #$DB, #$77, #$DB, #$EE, 
    #$18, #$18, #$18, #$18, #$18, #$18, #$18, #$18, 
    #$18, #$18, #$18, #$18, #$F8, #$18, #$18, #$18, 
    #$18, #$18, #$F8, #$18, #$F8, #$18, #$18, #$18, 
    #$36, #$36, #$36, #$36, #$F6, #$36, #$36, #$36, 
    #$00, #$00, #$00, #$00, #$FE, #$36, #$36, #$36, 
    #$00, #$00, #$F8, #$18, #$F8, #$18, #$18, #$18, 
    #$36, #$36, #$F6, #$06, #$F6, #$36, #$36, #$36, 
    #$36, #$36, #$36, #$36, #$36, #$36, #$36, #$36, 
    #$00, #$00, #$FE, #$06, #$F6, #$36, #$36, #$36, 
    #$36, #$36, #$F6, #$06, #$FE, #$00, #$00, #$00, 
    #$36, #$36, #$36, #$36, #$FE, #$00, #$00, #$00, 
    #$18, #$18, #$F8, #$18, #$F8, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$F8, #$18, #$18, #$18, 
    #$18, #$18, #$18, #$18, #$1F, #$00, #$00, #$00, 
    #$18, #$18, #$18, #$18, #$FF, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$FF, #$18, #$18, #$18, 
    #$18, #$18, #$18, #$18, #$1F, #$18, #$18, #$18, 
    #$00, #$00, #$00, #$00, #$FF, #$00, #$00, #$00, 
    #$18, #$18, #$18, #$18, #$FF, #$18, #$18, #$18, 
    #$18, #$18, #$1F, #$18, #$1F, #$18, #$18, #$18, 
    #$36, #$36, #$36, #$36, #$37, #$36, #$36, #$36, 
    #$36, #$36, #$37, #$30, #$3F, #$00, #$00, #$00, 
    #$00, #$00, #$3F, #$30, #$37, #$36, #$36, #$36, 
    #$36, #$36, #$F7, #$00, #$FF, #$00, #$00, #$00, 
    #$00, #$00, #$FF, #$00, #$F7, #$36, #$36, #$36, 
    #$36, #$36, #$37, #$30, #$37, #$36, #$36, #$36, 
    #$00, #$00, #$FF, #$00, #$FF, #$00, #$00, #$00, 
    #$36, #$36, #$F7, #$00, #$F7, #$36, #$36, #$36, 
    #$18, #$18, #$FF, #$00, #$FF, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$00, 
    #$F0, #$F0, #$F0, #$F0, #$00, #$00, #$00, #$00, 
    #$0F, #$0F, #$0F, #$0F, #$00, #$00, #$00, #$00, 
    #$FF, #$FF, #$FF, #$FF, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$F0, #$F0, #$F0, #$F0, 
    #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, #$F0, 
    #$0F, #$0F, #$0F, #$0F, #$F0, #$F0, #$F0, #$F0, 
    #$FF, #$FF, #$FF, #$FF, #$F0, #$F0, #$F0, #$F0, 
    #$00, #$00, #$00, #$00, #$0F, #$0F, #$0F, #$0F, 
    #$F0, #$F0, #$F0, #$F0, #$0F, #$0F, #$0F, #$0F, 
    #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, #$0F, 
    #$FF, #$FF, #$FF, #$FF, #$0F, #$0F, #$0F, #$0F, 
    #$00, #$00, #$00, #$00, #$FF, #$FF, #$FF, #$FF, 
    #$F0, #$F0, #$F0, #$F0, #$FF, #$FF, #$FF, #$FF, 
    #$0F, #$0F, #$0F, #$0F, #$FF, #$FF, #$FF, #$FF, 
    #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, #$FF, 
    #$00, #$00, #$76, #$DC, #$C8, #$DC, #$76, #$00, 
    #$00, #$78, #$CC, #$F8, #$CC, #$F8, #$C0, #$C0, 
    #$00, #$FC, #$CC, #$C0, #$C0, #$C0, #$C0, #$00, 
    #$00, #$FE, #$6C, #$6C, #$6C, #$6C, #$6C, #$00, 
    #$FC, #$CC, #$60, #$30, #$60, #$CC, #$FC, #$00, 
    #$00, #$00, #$7E, #$D8, #$D8, #$D8, #$70, #$00, 
    #$00, #$66, #$66, #$66, #$66, #$7C, #$60, #$C0, 
    #$00, #$76, #$DC, #$18, #$18, #$18, #$18, #$00, 
    #$FC, #$30, #$78, #$CC, #$CC, #$78, #$30, #$FC, 
    #$38, #$6C, #$C6, #$FE, #$C6, #$6C, #$38, #$00, 
    #$38, #$6C, #$C6, #$C6, #$6C, #$6C, #$EE, #$00, 
    #$1C, #$30, #$18, #$7C, #$CC, #$CC, #$78, #$00, 
    #$00, #$00, #$7E, #$DB, #$DB, #$7E, #$00, #$00, 
    #$06, #$0C, #$7E, #$DB, #$DB, #$7E, #$60, #$C0, 
    #$38, #$60, #$C0, #$F8, #$C0, #$60, #$38, #$00, 
    #$78, #$CC, #$CC, #$CC, #$CC, #$CC, #$CC, #$00, 
    #$00, #$FC, #$00, #$FC, #$00, #$FC, #$00, #$00, 
    #$30, #$30, #$FC, #$30, #$30, #$00, #$FC, #$00, 
    #$60, #$30, #$18, #$30, #$60, #$00, #$FC, #$00, 
    #$18, #$30, #$60, #$30, #$18, #$00, #$FC, #$00, 
    #$0E, #$1B, #$1B, #$18, #$18, #$18, #$18, #$18, 
    #$18, #$18, #$18, #$18, #$18, #$D8, #$D8, #$70, 
    #$30, #$30, #$00, #$FC, #$00, #$30, #$30, #$00, 
    #$00, #$76, #$DC, #$00, #$76, #$DC, #$00, #$00, 
    #$38, #$6C, #$6C, #$38, #$00, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$18, #$18, #$00, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$18, #$00, #$00, #$00, 
    #$0F, #$0C, #$0C, #$0C, #$EC, #$6C, #$3C, #$1C, 
    #$78, #$6C, #$6C, #$6C, #$6C, #$00, #$00, #$00, 
    #$70, #$18, #$30, #$60, #$78, #$00, #$00, #$00, 
    #$00, #$00, #$3C, #$3C, #$3C, #$3C, #$00, #$00, 
    #$00, #$00, #$00, #$00, #$00, #$00, #$00, #$00);

  _mul = 1024;
  _mul2 = 512;
  maxpoints = 50;


obj_x = 0;
obj_y = 0;
obj_z : integer = 250;
{$i 3d.inc}


var
yofs : array[0..200] of word;
sini : array[0..249] of real;
cosini : array[0..1000] of real;
lines : array[0..maxpoints,0..1] of integer;
points,rpoints : array[0..maxpoints,0..3] of integer;

procedure matriisi(var mat : t_matrix;kx2,ky2,kz2 : integer);
var
xa1,xa2,xa3,
ya1,ya2,ya3,
za1,za2,za3 : real;
sinkz : real;
begin
  kx2 := kx2 mod 1000;
  ky2 := ky2 mod 1000;
  kz2 := kz2 mod 1000;
  if kx2 < 0 then inc(kx2,1000);
  if ky2 < 0 then inc(ky2,1000);
  if kz2 < 0 then inc(kz2,1000);
  sinkz := sini[kz2];
  xa1 := cosini[KZ2]*cosini[KY2];
  xa2 := -sinkz*cosini[KX2]-cosini[KZ2]*sini[KY2]*sini[KX2];
  xa3 := sinkz*sini[KX2]-cosini[KZ2]*sini[KY2]*cosini[KX2];
  ya1 := sinkz*cosini[KY2];
  ya2 := cosini[KZ2]*cosini[KX2]-sinkz*sini[KY2]*sini[KX2];
  ya3 := -sinkz*sini[KY2]*cosini[KX2]-cosini[KZ2]*sini[KX2];
  za1 := sini[KY2];
  za2 := cosini[KY2]*sini[KX2];
  za3 := cosini[KY2]*cosini[KX2];
  mat[0] := round(xa1*_mul);
  mat[1] := round(xa2*_mul);
  mat[2] := round(xa3*_mul);
  mat[3] := round(ya1*_mul);
  mat[4] := round(ya2*_mul);
  mat[5] := round(ya3*_mul);
  mat[6] := round(za1*_mul);
  mat[7] := round(za2*_mul);
  mat[8] := round(za3*_mul);
end;

procedure rotatep;
var
ax_,ay,az : longint;
x,y,z : longint;
rx,ry : integer;
n,col : integer;
maxp : integer;
begin
  maxp := points[0,0];
  for n := 1 to maxp do begin
    x := points[n,0];
    y := points[n,1];
    z := points[n,2];
    asm
      mov  ax,word ptr x
      imul word ptr matrix[0]
      mov  cx,dx
      mov  bx,ax
      xor  dx,dx
      mov  ax,word ptr y
      imul word ptr matrix[4]
      add  bx,ax
      adc  cx,dx
      mov  ax,word ptr z
      imul word ptr matrix[8]
      add  ax,bx
      adc  dx,cx
      shl  dx,6
      shr  ax,10
      add  ax,dx

      add  ax,obj_x
      cwd
      mov  word ptr ax_,ax
      mov  word ptr ax_+2,dx

      mov  ax,word ptr x
      imul word ptr matrix[12]
      mov  cx,dx
      mov  bx,ax
      xor  dx,dx
      mov  ax,word ptr y
      imul word ptr matrix[16]
      add  bx,ax
      adc  cx,dx
      mov  ax,word ptr z
      imul word ptr matrix[20]
      add  ax,bx
      adc  dx,cx
      shl  dx,6
      shr  ax,10
      add  ax,dx

      add  ax,obj_y
      cwd
      mov  word ptr ay,ax
      mov  word ptr ay+2,dx

      mov  ax,word ptr x
      imul word ptr matrix[24]
      mov  cx,dx
      mov  bx,ax
      xor  dx,dx
      mov  ax,word ptr y
      imul word ptr matrix[28]
      add  bx,ax
      adc  cx,dx
      mov  ax,word ptr z
      imul word ptr matrix[32]
      add  ax,bx
      adc  dx,cx
      shl  dx,6
      shr  ax,10
      add  ax,dx

      add  ax,obj_z
      cwd
      mov  word ptr az,ax
      mov  word ptr az+2,dx
    end;
    {ax_:= (x*matrix[0] +
           y*matrix[1] +
           z*matrix[2]) div _mul;
    ay:= (x*matrix[3]+
               y*matrix[4]+
               z*matrix[5]) div _mul;
    az:= obj_z+(x*matrix[6]+
               y*matrix[7]+
               z*matrix[8]) div _mul;
    rpoints[n,0] := 160+200*longint(ax_) div longint(az);
    rpoints[n,1] := 100+166*longint(ay) div longint(az);
    rpoints[n,2] := az;}
    asm
      mov  bx,n
      shl  bx,3
      mov  cx,word ptr az
      mov  ax,120
      imul word ptr ax_
      idiv cx
      add  ax,80
      mov  word ptr rx,ax
      mov  ax,100
      imul word ptr ay
      idiv cx
      add  ax,50
      mov  word ptr ry,ax
      mov  [bx+offset rpoints+2],ax
      mov  ax,word ptr rx
      mov  [bx+offset rpoints],ax
    end;
  end;
end;

procedure init3d;
var
n : integer;
begin
  for n := 0 to 249 do sini[n] := sin(n*pi/500);
  for n := 0 to 1000 do begin
    cosini[n] := cos(n*pi/500);
  end;
  fillchar(points,sizeof(points),0);
  fillchar(rpoints,sizeof(rpoints),0);
  for n := 0 to 100 do yofs[n] := n*160;
end;

procedure xline3(d,_dx,incr1,incr2,yinc,address:word;color:byte); assembler;
{ draw line with X as the independent variable

  d        decision variable
  _dx       number of pixels in x-dimension of line
  incr1    increment #1 value for decision variable
  incr2    increment #2 value for decision variable
  yinc     amount to add to y variable / point
  address  starting offset address into display memory
  color    desired color}
asm
  push ds
  mov  ds,scr_seg

{ load the working registers with the variables}
  mov  di,address
  mov  cx,_dx  {number of points -> cx}
  mov  bx,d   {decision variable -> bx}
  mov  al,color

{operational loop}
@@runloop:
                   {send the first point}
  mov  [di],al  {write to display memory}

  inc  di          {increment x variable}

  cmp  bx,0        {d = 0 ?}
  jl   @@noinc     {jump if d < 0}

                   {adjust d += incr2 + increment y += inc}
  add  bx,incr2    {d = d+incr2}

  add  di,yinc     {y (address) += offset}
  {jmp  @@check}
                   {adjust d += incr1}
@@noinc:
  add  bx,incr1    {d = d+incr1}

@@check:
  dec  cx
  jnz  @@runloop
  pop  ds
end;

procedure yline3(d,dy,incr1,incr2,xinc,address,ofset:word;color:byte);
assembler;
{draw a line with Y as the independent variable

d       decision variable
dy      # of pixels in y-dimension of line
incr1   increment #1 value for decision variable
incr2   increment #2 value for decision variable
xinc    amount to add to x variable / point
address starting offset adress of display memory
ofset  display offset}

asm
  push ds
  mov  ds,scr_seg
                     {load working registers with the variables}
  mov  di,address    {load display offset address}
  mov  cx,dy         {# of points -> cx}
  mov  bx,d          {decision variable -> bx}
  mov  ah,color

@@runloop:
  mov  [di],ah    {write to display memory}

  add  di,160     {y (address) += offset (always positive)}

  cmp  bx,0          {d = 0 ?}
  jl   @@noinc       {jump if d < 0}

  add  bx,incr2      {d = d+incr2}

  add  di,xinc       {inc x variable}
  {jmp  @@check}

@@noinc:
  add  bx,incr1      {d = d+incr1}

@@check:
  dec  cx
  jnz  @@runloop
  pop  ds
end;

procedure hline3(x1,x2,y,offset : word;color : byte);
var
  x,dx,address : integer;

procedure hsub3(address,_dx : word;color:byte); assembler;
asm
  cld
  mov  es,scr_seg
  mov  di,address
  mov  cx,_dx
  mov  al,color
  rep  stosb
end;

begin
  if (y < 0) or (y > 99) then exit;
  if x1 > x2 then begin
    x := x1; x1 := x2; x2:= x;  {reverse x-coordinates}
  end;
  if (x1 > 159) or (x2 < 0) then exit;
  if x1 < 0 then x1 := 0;
  if x2 > 159 then x2 := 159;
  {dx := (x2-x1)+1;
  address := (y*offset)+x1;
  hsub3(address,dx,color);}
  asm
    mov  cx,x2
    sub  cx,x1
    inc  cx
    mov  di,y
    add  di,di
    mov  di,[di+offset yofs]
    add  di,x1
    mov  es,scr_seg
    mov  al,color
    rep  stosb
  end;
end;

procedure vline3(x,y1,y2,ofset : integer;color : byte);
var
  t,dy,address : integer;

procedure vsub3(address,dy,ofset : word;color : byte); assembler;
asm
  mov  es,scr_seg
  mov  di,address
  mov  cx,dy
  mov  al,color
@@runloop:
  mov  es:[di],al
  add  di,ofset
  dec  cx
  jnz  @@runloop
end;

begin
  if (x < 0) or (x > 159) then exit;
  if y1 > y2 then begin
    t := y2; y2 := y1; y1 := t;
  end;
  if (y1 > 99) or (y2 < 0) then exit;
  if y1 < 0 then y1 := 0;
  if y2 > 99 then y2 := 99;
  {dy := y2-y1+1;}
  asm
    mov  es,scr_seg
    mov  cx,y2
    sub  cx,y1
    inc  cx
    mov  bx,y1
    add  bx,bx
    mov  di,[bx+offset yofs]
    add  di,x
    mov  al,color
@@runloop:
    mov  es:[di],al
    add  di,160
    dec  cx
    jnz  @@runloop
  end;
  {vsub3(address,dy,offset,color);}
end;

procedure line3(x1,y1,x2,y2 : integer;color : byte);
const
  offset : integer = 160;
var
  dx,dy,d,d2,xinc,yinc,incr1,incr2,x,y,address : integer;
begin
  if y1 > y2 then begin
    d := x1;
    x1 := x2;
    x2 := d;
    d := y1;
    y1 := y2;
    y2 := d;
  end;
  dx := abs(x2-x1);  {x-length}
  if dx = 0 then vline3(x1,y1,y2,offset,color)
  else begin
    dy := abs(y2-y1);
    if dy = 0 then hline3(x1,x2,y1,offset,color)
    else begin    {neither horz or vert then do bresenhams}
                 {is the slope between 0 and 1 ie. dy > dx}
      if dx >= dy then begin     {slope < 1 quadrants 0,1,2 or 3}
        if x1 > x2 then begin    {quadrant 0 or 1}
          x := x2; y := y2;
          if y2 > y1 then yinc := -offset  {quadrant 0}
          else yinc := offset;             {quadrant 1}
        end
        else begin
          x := x1; y := y1;
          if y2 > y1 then yinc := offset   {quadrant 2}
          else yinc := -offset;            {quadrant 3}
        end;
        address := y*offset+x;      {starting address}
        d2 := dy shl 1;             {y distance times 2}
        d := d2-dx;     {init the decision variable to 2*dy-dx}
        incr1 := d2;        {incr. for decision var. if d < 0}
        incr2 := (dy-dx) shl 1-incr1;  {incr. for decision var if d >= 0}
        xline3(d,dx+1,incr1,incr2,yinc,address,color);
      end
      else begin     {slope > 1 quadrant 4, 5, 6 or 7}
        if y1 > y2 then begin   {quadrant 4 or 5}
          x := x2; y := y2;
          if x > x1 then xinc := -1  {quadrant 4}
          else xinc := 1;            {quadrant 5}
        end
        else begin
          x := x1; y := y1;   {quadrant 6 or 7}
          if x2 > x1 then xinc := 1    {quadrant 6}
          else xinc := -1;             {quadrant 7}
        end;
        address := y*offset+x;
        d2 := dx shl 1;         {x distance times 2}
        d := d2-dy;             {decision var. = 2*dx-dy}
        incr1 := d2;            {incr. for decision var, d' if d <0}
        incr2 := (dx-dy) shl 1-incr1; {incr. for decision var if d >= 0}
        yline3(d,dy+1,incr1,incr2,xinc,address,offset,color);
      end;         {end of quadrants 0,1,2,3 or 4,5,6,7}
    end;
  end;
end;

procedure mix; assembler;
asm
  push ds
  mov  ds,scr_seg
  mov  si,0
  mov  ax,0b800h
  mov  es,ax
  mov  di,0
  mov  dx,49
@@y:
  mov  cx,80
@@x:
  mov  ah,[si+1]
  add  ah,ah
  add  ah,[si]
  mov  al,[si+160]
  shl  al,2
  add  ah,al
  mov  al,[si+161]
  shl  al,3
  add  ah,al
  add  ah,208
  mov  es:[di],ah
  add  si,2
  add  di,2
  dec  cx
  jnz  @@x
  add  si,160
  dec  dx
  jnz  @@y
  pop  ds
end;

procedure show;
var
n : integer;
p1,p2 : integer;
begin
  for n := 1 to lines[0,0] do begin
    p1 := lines[n,0];
    p2 := lines[n,1];
    line3(rpoints[p1,0],rpoints[p1,1],
          rpoints[p2,0],rpoints[p2,1],1);
  end;
end;

procedure hide; assembler;
asm
  cld
  xor  ax,ax
  mov  cx,160*100/2
  mov  es,scr_seg
  mov  di,0
  rep  stosw
end;

procedure setfont; assembler;
asm
  push bp
  mov  ax,seg fontti
  mov  es,ax
  mov  bp,offset fontti
  mov  bx,$800
  mov  dx,0
  mov  cx,256
  mov  ax,$1110
  int  10h
  pop  bp
end;

procedure l3d_cube;
begin
  move(cubep,points,sizeof(cubep));
  move(cubel,lines,sizeof(cubel));
  obj_z := points[0,1];
end;

procedure l3d_pyramid;
begin
  move(pyramidp,points,sizeof(cubep));
  move(pyramidl,lines,sizeof(cubel));
  obj_z := points[0,1];
end;

procedure l3d_adnmod;
begin
  move(adnmodp,points,sizeof(adnmodp));
  move(adnmodl,lines,sizeof(adnmodl));
  obj_z := points[0,1];
end;

end.
