-------------------------------------------------------------------------------
DOCUMENT                     : MANUEL D'UTILISATION DE X1
LANGAGE                      : FRANCAIS
TEXT TYPE                    : ASCII NON FORMATTE
JEU DE CARACTERES            : ISO LATIN
VERSION DU PROGRAMME         : X1 v0.94g (beta)
DERNIERE MISE A JOUR         : 960828
NOTE DE DERNIERE MISE A JOUR : TEXTE PRELIMINAIRE - CHANGEMENTS POSSIBLES
TAPE PAR                     : S.V./Sebastian Guilbaud
AUTRES DOCUMENTS             : X1 "DISCLAIMER",
                               HISTORIQUE DES CHANGEMENTS DE X1,
-------------------------------------------------------------------------------

       IMPORTANT: N'utilisez pas ce programme avant d'avoir lu, compris et
                      accept les termes du ""disclaimer""

                         ==================
                         = X1 USER MANUAL =
                         =     APERCU     =
                         ==================

   1.  matriel requis (minimum)
   2.  "Qu'est-ce ??" (rsum)
   3.  "Comment l'utiliser" (format de la ligne de commande et liste des commandes et options)
   4.  Variables d'environnement  (module de langage)
   5.  Formats et mthodes de compression (aperu et exemples)
   6.  Noms des fichiers temporaires
   7.  Codes de retour 



1. Matriel requis
==================
CPU  : 386sx ou mieux
RAM  : un minimum de 4Mb de mmoire est fortement recommand
OS   : DOS/Win95 (DOS 3.3 ou plus rcent - (possibilit de supporter les noms longs de Win95)
       OS/2 (32-bit)
       NT/Win95

Rcuperez bien la version du programme correspondant au systme
d'exploitation que vous utilisez

Sachez que la mmoire reporte par l'archiveur est la mmoire indirectement
reporte par le DPMI - la mmoire effectivement "visible". Suivant le
gestionnaire de mmoire (DOS..OS/2), de la mmoire virtuelle (sur disque)
peut tre utilise, ce qui peut rendre la quantit de mmoire reporte
suprieure  la quantit de mmoire physique installe. Mais il importe peu
au programme la faon dont la mmoire est gre ; il est plus important de
savoir combien de mmoire le gestionnaire autorise l'utilisation.


2. "Qu'est-ce ?"
==================
C'est un archiveur. Il compresse plusieurs fichiers en un seul.
Il est entirement contrl en ligne de commande. Compression et uncompression
sont combines en ce seul xcutable.


Cet archiveur utilise pleinement les resources de la plate-forme sur laquelle
il est utilisi, pour arriver n taux de compression ilevi.

Ses principales caractristiques sont :

* Introduction des archives au format .x
* compatibilit avec ARJ,(PK)ZIP,LHA(RC),ZOO,HA
* Interface multilingue
* Contient des mthodes "exprimentales" suite  l'exploration d'algorithmes
  hautes-performances. "exprimentales" ne signifie pas instabilit, mais
  plutt que la mthode peut ne pas tre supporte dans des versions futures
  du programme.

L'interface en ligne de commande est semblable  celles de ZOO et HA. Mais
les caractres d'options sont plus ressemblants  ceux de ARJ et LHA. 
L'interface a peu en commun avec PKZIP. Avec une connaissance minimale des
archiveurs les plus communs, il est possible de passer certaines parties de
cette documentation.


3. "Comment l'utiliser" (format de la ligne de commande  et revue de dtail des commandes et options)
=====================================================================================================
   Il s'agit de la spcification du programme. Si le programme se comporte
de faon diffrents, il s'agit soit d'une erreur, soit d'un chec 
implmenter correctement la function en accord avec la spcification.
   Utiliser la dnomination d'"archiveur" pour un programme introduit un
certain nombre d'esprances - bases sur les possibilits des autres archiveurs. 
En consquence, il devient important de considrer non seulement ce qui A
ETE mais galement ce qui n'a PAS encore t implment.
   Si des choses mentionnes dans le texte ne sont pas encore implmentes,
un message "**non implment**" prcedera la section. Un travail futur devra
permettre la rduction du nombre de tels messages.

Format de la ligne de commande 
------------------------------

 X1 commande[<options>..] <archives> [<masque de fichier>..]

 Dfinition:
 commande[<options>..] une seule commande autorise (le tout premier caractre)
                       suivi d'une liste d'options - sans espaces
                       entre la commande et les options - ou parmi les options
 <archive>             nom de l'archive, avec comme extension par dfaut .ZIP
 <masque de fichier>   fichiers  archiver, par dfaut tous les fichiers si
                       rien de spcifi. Les wildcards *, ? peuvent tre utiliss.
                       Les noms de fichiers sont spcifis comme extension
                       normale du chemin.


Rgles syntaxiques de la ligne de commande
------------------------------------------
Les commandes et option(s) peuvent tre spcifies en majuscules ou en
minuscules.

Faites attention au fait que "x1" a deux options d'exclusion de chemin au
lieu d'habituellement une seule. C'est une consquence directe des rgles #1
et #2

     Rgle #1 (chemin inclus):
     ------------------------
        Par dfaut, tous les chemins mentionns en ligne de commande sont
     ajouts  l'archive -  moins que l'options d'exclusion "X" soit active

     Rgle #2 (chemin inclus):
     ------------------------
        Par dfaut, tous les chemins rencontrs au cours d'une recherche
     rcursive (option "R" active) sont ajouts  l'archive - a moins que
     l'option d'exclusion "E" soit active. Ceci est quelque peu diffrent
     de la plupart des autres archiveurs

     Rgle #3 (plusieurs masques de fichiers relatifs au mme rpertoire):
     ---------------------------------------------------------------------
        Un masque de fichier sans prcision de chemin suppose le chemin du 
     masque de fichier prcdent.
        Explication plus en  detail:
     Supposons "x1 a test <arg[1]> .. <arg[i]> <arg[i+1]>..". Si <arg[i+1]> ne
     contient pas  "\" ("/") ou ":" alors il est suppos travailler sous le mme
     chemin que <arg_i> (qui lui-mme peut travailler sous le mme chemin que  
     <arg[i-1]>...  etc.). Qu'est-ce que cela signifie ? Cela signifie que : 
     "x1 a test \dir1\dir2\*.c *.h"  produit en fait le mme resultat que
     "x1 a test \dir1\dir2\*.c \dir1\dir2\*.h". Qu'est ce que cela ne
     signifie pas ? Eh bien, "x1 a test dir1\*.c dir2\*.h" ne travaille pas !
     comme "x1 a test dir1\*.c dir1\dir2\*.h" parce que "dir2\*.h" contient "\".
     x1 a test dir1 *.c" ne travaille pas non plus comme "x1 a test dir1\*.* dir1\*.c", 
     qui serait en fait dpourvu de toute signification.
        La justification de cette convention ? : moins de caractres  taper.
     (notez comme vous n'aviez pas besoin de rpter "\dir1\dir2\" sur la
     ligne de commande du premier exemple)
        Effets de bord / Inconvnients ?? Si vous voulez des fichiers du
     rpertoire courant, vous devez les spcifier tous avant de spcifier
     des rpertoires. Cependant, il s'agit juste d'une convention, et ne
     doit pas restreindre l'utilisateur de quelque faon que ce soit.

     Rgle #4 (rpertoire enregistr dans l'archive):
     ------------------------------------------------
        Spcifier un nom de rpertoire en ligne de commande implique la
     compression de tous les fichier de ce rpertoire. Notez que "x1 a test \dir1\dir2"
     produit le mme rsultat que "x1 a test \dir1\dir2\" ou "x1 a test \dir1\dir2\*.*".
     Et si l'option rcursive est active, alors tous les fichiers plus haut
     dans "\dir1\dir2\.." sont aussi traits.
        Mais faites attention ! Si les noms des fichiers sont identiques aux
    noms des chemins, il peut ne pas tre vident de voir ce que le rsultat
    final sera.

                                  =============
                                  = COMMANDES =
                                  =============

? commande (affiche l'aide)
-----------------------------------
     Cette commande est seulement utilise dans le contexte "x1 ?".
     Ceci affichera un bref rsum des commandes et options.
     La page affiche n'est PAS la mme que la page affiche lorque l'on
     lance le programme sans arguments. Si aucun paramtre n'est spcifi,
     alors seules les commandes sont listes. (parmi elles, "?")

     Si les informations sont affiches trop vire, il est recommand de
     les rediriger dans un fichier ("x1 ? >archive.lst"), qui peut tre
     consult par la suite par votre fouineur prfr 
     ou dans votre diteur favori.

     De nombreux langages sont supports. Nanmoins, certain langages sont
     plus difficiles  comprendre que d'autres. Il ne peut donc pas tre
     garanti que la signification des messages soit claire comme de l'eau de
     roche. Dans le doute, les pages anglaises, danoises, franaises,
     allemandes et espagnoles devraient tre consultes (dans cette ordre de
     priorit)

     (Sur PC) Si vos rglages de code de pages sont faux, le rsultat sera
     des caractres manquants. Donc, prenez s'il vous plat un peu de temps
     afin d'obtenir le bon rglage de code de pages.


A commande (ajouter des fichiers  l'archive)
---------------------------------------------
     Options valides: $,A,C,E,F,I,K,L,M,N,O,R,S,T,U,V,X,Y,Z

     Cette commande a deux fonctionnements:
         *  crer une archive et y ajouter des fichiers...
         *  mettre  jour (re-ouvrir) une archive et y ajouter des fichiers...
     Mais  la base, cette commande compresse et ajoute les fichiers
     spcifis  une archive. Si l'archive nomme n'existe pas, alors il en
     est cre une avec le nom spcifi. Si l'archive exoste, alors elle est
     mise  jour. Cela signifie, que des nouveaux fichiers avec les mmes
     chemins que d'anciens fichiers dans l'archive craseront ces anciennes
     entres. Quelques exceptions existent (quand on compresse en modules
     solides) - mais ceci dpasse notre porte pour l'instant.

     Si le rpertoire de base est omis, le rpertoire par dfaut est suppos
     tre le rpertoire courant.

     S'il n'y a pas de fichiers spcifis en the ligne de commande, alors
     tous les fichiers (dans le rpertoire par dfaut) sont ajouts. 
     Ceci signifie que "x1 a test.x" compresse tous les fichiers du
     rpertoire courant.

     En aucun cas, il n'est possible de compresser une archive en train
     d'tre mise  jour dans l'archive elle-mme.

     Si l'extension de l'archive cible n'est pas spcifie, alors
     l'extension par dfaut ZIP est slectionne. Si vous souhaitez compressser 
     sous un autre format, alors il est ncessaire de spcifier l'archive
     cible avec l'extension du format correspondant (ARJ,LZH,..). 
     Il n'est pas possible de compresser des archives avec des extensions
     arbitraires.

     Des fichiers peuvent tre exclus de l'archivage en utilisant l'option "Z".

     Exemple (compression format standard) : x1 a archive.x   mon_fichier.doc
     Exemple (compression format ZIP)      : x1 a archive.zip mon_fichier.doc

C commande (ajout de commentaires  l'archive)
--------------------------
     **non implment**
     Options valides: I,C

     Cette commande ajoute des commentaires  une archive. Les commentaires
     sont possibles dans les archives ARJ,ZIP,ZOO,X mais pas dans les
     archives LHA et HA, pour des raisons de diffrences dans les
     structures d'en-ttes.


D commande (dtruit des fichiers dans une archive)
---------------------------------------
     Options valides: I,S,Z

     Pour tre dtruit, l'entre de chemin dans l'archive doit correspondre
      un argument de la ligne de commande (pas de diffrence
     majuscules-minuscules).

     Si un masque de fichier ne contient pas de chemin, alors il agira sur
     toutes les entre de l'archive, quel que soit leur chemin d'accs.
     Ceci signifie que "x1 d test.x *.pas" dtruira galement les entres
     "dir1/dir2/*.pas" dans l'archive (si disponibles). Toutefois,
     "x1 d test.x /dir1/dir2/*.pas" ne dtruira que les fichiers
     effectivement indiques - et non pas "*.pas" dans toute l'archive quel
     soit le chemin d'accs.

     Si l'on demande  dtruire tous les fichiers, alors toute l'archive est
     supprime.

     Les fichiers peuvent tre exclus de la suppression en utilisant
     l'option "Z".

     Exemple (suppression d'entres multiples)   : x1 d archive.x *.pas *.doc
     Exemple (suppression de l'archive complte) : x1 d archive *.*


E commande (extraction des fichiers sans chemin)
-------------------------------------------
     Options valides: $,A,F,I,N,O,T,W,Y,Z

     Cette commande est identique  la commande "X" avec l'option "E".
     Elle est fournie pour adhrer au consensus gnral parmi les autres 
     archiveurs qui la supportent.

     Au cours de l'extraction, les date et heure des fichies originaux sont 
     restaurs en mme temps que le contenu des fichiers. Un test de crc est effectu
     en vue de vrifier que l'opration s'est droule avec succs. Toutefois, le
     fichier est vrifi avant de l'crire sur disque, plutt que de faire un test
     de lecture du fichier.     
     
     Les fichiers peuvent tre extraits dans un rpertoire et sur une unit
     spcifis par l'utilisateur - mais par dfaut, les fichiers sont
     extraits dans le rpertoire courant. Toutes les extractions sont faites 
     sans chemin (tout dans le mme rpertoire)

     Lors de l'extraction dans un rpertoire prcis, le nom du rpertoire
     doit se terminer par "/" ou "\" comme dans l'exemple "x1 e test.x c:\dir\". 
     Ne pas terminer le nom du rpertoire par un tel caractre comme dans
     l'exemple "x1 e test.x c:\dir" obligera le programme  supposer que
     l'on essaie d'extraire un fichier de l'archive.

     Lors de l'extraction dans un rpertoire non existant (spcifi en ligne
     de commande), l'utilisateur sera averti et consult avant toute action.
     Le prompt d'avertissement prsente plusieurs solutions - de "(y)es" 
     (crer le rpertoire seulement cette fois-ci)  "n(e)ver" (ne jamais
     crer de rpertoire). L'utilisateur rpond en tapant la lettre entre
     parenthses. Les mots et lettres peuvent changer suivant le module de
     langage. Il est possible de forcer une rponse par dfaut en activant
     l'une des deux options "Y" ou "N".
     
     Lors de l'extraction sur une unit spcifie, il est autoris que le
     dernier caractre de la spcification de l'unit soit ":", comme dans 
     l'exemple "x1 e test.x a:". Ceci, parce que aucun nom de fichier valide 
     ne se termine par ce caractre.
     Si plusieurs units/rpertoires de destination sont spcifis 
     ("x1 e test.x a: b: c:") alors le dernier spcifi sera effectivement
     utilis pour l'extraction ("c:").

     S'il y a tentative d'extraire un fichier avec le mme nom qu'un
     rpertoire existant, le fichier sera saut (sauf si l'crasement
     intelligent est choisi avec l'option "W").

     S'il y a tentative d'extraire un fichier sur un nom de fichier dj
     existant, l'utilisateur sera prvenu et consult avant toute action.
     Seule exception : les fichiers de taille 0. Ils ne sont pas considrs
     contenir la moindre information valable et sont crass sans
     avertissement.
     Le prompt d'avertissement permet plusieurs rponses diffrentes - de "(y)es" 
     (craser cette fois-ci seulement)  "n(e)ver" (ne jamais craser).
     L'utilisateur rpond en tapant la lettre entre parenthses. Les mots et 
     lettres peuvent changer suivant le module de langage.

     Exemple (extraction d'un fichier): x1 e archive.x file_id.diz

     
F commande (rafrachir les fichiers dj dans l'archive)
--------------------------------------------------------
     **non implment**
     Options valides: E,F,I,X

     Cette commande remplace les entres dans l'archive avec les fichiers
     plus rcents, quand c'est possible. Ceci signifie que les noms et
     le nombre total de fichiers dans l'archive resteront constants. 
     Seul le contenu des fichiers archivs peut changer.

     Seules les dates et heures des fichiers sont vrifies au cours de la
     recherche de fichiers plus rcents. Si les fichiers sont plus vieux - ou 
     si ils ont des dates et heures identiques (et peut-tre des tailes
     diffrentes), alors les fichiers sont sauts.

     Des conflits potentiels peuvent subvenir dans le cas o l'archive
     contient des entres avec des chemins. Est-il ncessaire de spcifier
     ces entres compltement ? La rponse choisie dans ce cas est : non !
     Il est plutt ncessaire de les exclure avec l'option "E" - si pour une
     raison quelconque elles ne doivent pas tre rafrachies avec les autres
     fichiers.

     De faon similaire  la commande "A", si aucun fichier n'est specifi
     en ligne de commande, alors tous les fichiers de l'archive sont
     candidats  un rafrachissment. Ceci signifie que "x1 f test.x" 
     tente de rafrachir tous les fichiers de l'archive "test.x" - tandis
     que "x1 f test.x *.pas" tente seulement de rafrachir les fichiers "*.pas" 
     (ce qui inclut peut-tre les fichies "dir1/dir2/*.pas"). Seule la
     commande "x1 fz test.x *.pas dir1/dir2/*.pas" s'assure que les derniers
     fichiers sont exclus du rafrachissement.

     Exemple (rafrachissement de tous les fichiers): "x1 f test.x"

L commande (liste le contenu de l'archive)
------------------------------------------
     Options valides: E,I,O,Z

     Cette commande liste les informations standard concernant les entres 
     de fichiers dans l'archive. Ceci comprend:
      * chemin complet
      * taille du fichier compress et dcompress
      * taux de compression (% compress/dcompress)
      * date (au format anne-mois-jour)
      * heure (au format heure-minute-secondes)
      * CRC (16/32 bit)
      * Attributs DOS des fichiers
      * mthode de compression (identifie par un nombre plutt que par un nom)

     Le caractre "*" ajout  la fin du nom du fichier indique que le
     fichier est encrypt et ne peut donc pas tre extrait.

     Un ajustage dynamique des noms de chemins est tent. S'il y a assez de
     place pour des noms longs, ils sont lists sur la mme ligne que le
     reste des informations. Dans le cas contraire, le nom du fichier est
     affich seul sur une lignes - et les informations complmentaires sont
     dplaces sur la ligne suivante.

     Il est possible de lister toute les archives d'un format spcifi
     ("x1 l *.lzh") ou toutes les archives reconnues par l'archiveur ("x1 l *") 
     - qui ne fait en fait que vrifier les fichiers avec une extension
     connue (".arj",".zip",..).
     Il est possible de ne vrifier que des fichiers spcifis ("x1 l *.zip file_id.diz")
     ou de multiples fichiers ("x1 l *.zip *.nfo *.diz").

     Si les informations dfilent trop vite, il est recommand de les
     rediriger dans un fichier ("x1 l *.zip >archive.lst"), qui peut tre
     consult par votre fouineur favori (Norton-Commander-F3) ou par votre
     diteur prfr

     Exemple (lister tous *.ARJ,*.ZIP,...): "x1 l *"

T commande (test l'intgrit du contenu de l'archive)
-----------------------------------------------------
     Options valides: E,F,I,O,Z

     Cette commande a deux utilisations :
       * vrifier que l'archiveur n'a pas fait d'erreurs durant la compression
       * dtecter des erreurs induites dans l'archive lors de la transmission 
         (medium de stockage ou erreurs de transmission matrielles)
     La premire erreur est de loin la plus inquitante. C'est pourquoi
     c'est galement le genre de test effectu habituellement. En
     consquence, l'archiveur doit dcompresser les donnes (en mmoire).

     Pour s'assurer du succs d'une possible extraction, une fonction de
     validation est fournie sous la forme d'un test de CRC (code de redondance
     cyclique). Mme si le procd n'est pas sr  100%, il est
     habituellement suffisant dans la plupart des cas.

     Il est possible de tester la totalit du contenu de plusieurs archives
     ("x1 t *.zip"), les occurences de fichiers dans un groupe d'archives
     ("x1 t *.zip *.doc") ou d'un fichier dans une archive 
     ("x1 t archive.x readme.doc").

     Si l'archiveur peut tre suppos avoir accompli son travail
     correctement, alors un test de CRC plus simple et plus rapide peut tre
     fait . Ce test est activ en utilisant l'option "F". Comment savoir si
     l'archiveur a fait son travail correctement ? Et bien, essayez un test
     de CRC traditionnel une fois (juste aprs la compression). Si le
     rsultat est OK, alors seules des erreurs de CRC lies  la
     transmission peuvent arriver.

     L'utilisateur est inform de toute diffrence entre le CRC enregistr
     dans l'archive et le CRC effectivement calcul. Dans le cas d'erreurs,
     il est peu probable que les donnes puissent tre rcupres - sauf si
     une forme d'ECC (code de correction d'erreur) a t utilise. Mettre 
     jour des archives prsentant des erreurs de CRC est souvent possible,
     mais non recommand.

     Dans le cas d'archives solides, les tests de CRC peuvent prendre plus
     de temps. Ceci est caus par le fait que l'extraction peut prsupposer 
     l'extraction d'un autre fichier. En mode solide, les donnes sont
     compresses ensemble sous la forme d'un long flot, ce qui rduit les
     possibilits d'accs direct.

     Exemple (test de tous les fichiers): "x1 t test.x"

P commande (protge l'archive contre les erreurs)
-------------------------------------------------
     Options valides: I,L

     Cette commande ajoute des codes de correction d'erreurs (ECC)  l'archive   
     qui sont censs protger l'archive (dans certaines limites) d'erreurs
     de medium ou de transmission.

     On ne peut pas ajouter l'ECC plus d'une fois  l'archive. Plutt que
     d'utiliser des mthodes simples plusieurs fois, il est recommend
     d'utiliser une mthode plus sophistique mais plus coteuse.

     Exactement comme il existe des diffrences de performace entre les
     mthodes de compression, les mthodes de correction d'erreurs doivent
     tre optimises pour des types d'erreurs prcis. Si ce n'est pas fait,
     le rsultat sera juste une charge supplmentaire sans beaucoup
     d'utilit. En consquence plus de mthodes seront disponibles par
     la suite.

     La mthode de protection par dfault est "ECC Niveau 1".

     ECC Niveau 1:
       Ce type de code ECC est a destination de l'utilisateur normal, qui veut 
       wants une (basse) securit avec un minimum de surcharge sur les donnes.
       La mthode est spcialise pour compenser des erreurs de surface de disque.
       Elle peut compenser pour un (!) seul secteur perdu. La taille du secteur
       est configurable. Par dfaut, c'est 512 octets. Pour compenser les erreurs 
       sur plus d'un secteur, des niveaux suprieurs de protection ECC doivent tre
       utiliss.
       La protection d'un secteur de (N) octets de long, implique une surchage de
       donnes de (N+48) octets. Les 48 octets couvrent un en-tte incluant un crc pour
       l'en-tte, un crc pour le fichier en totalit et des vecteurs de test utiliss
       pour localiser des erreurs plus rapidement. Les donnes ECC se trouvent 
       dans un bloc contigu en debut de fichier.

     ECC Niveau 2:
       en attente d'implmentation.

     *ATTENTION* Les mthodes de correction d'erreurs ne corrigent qu'un nombre limit
     d'erreurs. Une mthode ne corrigera des erreurs que suivant sa specification.
     Donc: lisez les spcifications - et n'esprez pas de correction d'erreurs au-del
     de ces spcifications !!! La correction d'erreurs ne donne qu'une scurit limite.
     Il est donc important de ne pas vouer une confiance aveugle dans ces mthodes.

     Exemple:
       Pour protger contre la perte d'un seul secteur de 512 octets (disquette), la
       commande utilise est "x1 p test.zip" ou "x1 pm1 test.zip".
       Pour ajouter une protection ECC1 de 1024 octets/secteur (=2 secteurs de 512 octets,
       donc "m2"), la commande suivante est utilise "x1 pm2 test.zip".


R commande (rparer de possibles erreurs dans l'archive)
--------------------------------------------------------
     Options valides: I

     Cette commande a deux utilits:
       * Effectivement rparer des erreurs dans l'archive.
       * Vrifier que l'archive ne prsente aucune erreur.
         Un test de crc ne vrifie que les entres de fichiers compresss dans l'archive
         - et non pas un possible code de correction d'erreur (ECC) corrompu . Evidemment, le
         "test tendu" ne peut (devrait) tre effectu que si il y a des codes ECC  vrifier.

     Reparation d'une archive avec une protection ECC:
     Cette command retire les erreurs - soit dans les donnes ECC
     elles-mmes - soit dans les donnes que l'ECC doit protger. Si les
     erreurs sont irrcuprables, l'utilisateur en est averti, et plus rien
     n'est entrepris. Si les erreurs sont rcuprables, alors elles seront
     corriges, et un message dira que le traitement s'est achev avec
     succs.

     Reparation d'archive sans protection ECC :
     Ceci n'a jamais t le but de cette commande. Dans X1, il n'y a pas
     de fonction gnrale de rparation des archives endommages.
     L'utilisateur doit plutt tenter l'extraction de l'archive, puis doit
     archiver de nouveau les donnes.
     Les problmes que l'on rencontre avec les fonction gnrales de
     reparation sont bien connus, comme avec le programme "PKZipFix" fourni
     avec l'archiver "PKZIP". Le programme de rparation met simplement 
     jour la structure d'en-tte de l'archive - sans vrifier l'intgrit 
     des fichiers archivs. D'autres fichiers peuvent tre ajouts 
     l'archive. Toutefois, sans un test d'intgrit, il n'y a aucun moyen de
     savoir si l'archive contient d'autres erreurs. Ne pas tester cette
     possibilit peut produire un fausse apparence de scurit. Il apparat 
     beaucoup mieux de n'autoriser que l'extraction de l'archive - ceci
     permettant  l'utilisateur de vrifier directement le nombre d'erreurs.
     Si des archives sont stockes dans une autre archive, il est
     dangereusement possible de commettre des erreurs. Dans de tels cas, 
     il est mieux que l'utilisateur essaie d'valuer la situation. 
     Si jamais des gens taient intrsss (et prts  payer !), alors un
     programme de correction d'erreurs avanc pourrait tre mis au point
     pour quelques uns/tous les formats diffrents. Ceci ne changerait en
     aucun cas le fait que la plupart des erreurs sont normalement
     irrcuprables.

     Exemple: "x1 r test.x"

U commande (dprotection de l'archive - suppression des codes de correction d'erreur)
-------------------------------------------------------------------------------------
     Options valides: I

     Cette commande suit le mme chemin que celui emrpunt par la commande "P". 
     La suppression sera tente sur tout code ECC disponible. Un chec dans la
     localisation de code ECC peut avoir deux causes : soit aucun code ECC
     n'a t cr dans l'archive avec, soit des erreurs dans l'en-tte
     empchent la dtection du code ECC. Dans le dernier cas, il est
     recommand de tenter une rparation des erreurs.

     Il est recommend de vrifier si l'archive ne prsente pas d'erreurs
     avant de supprimer le code ECC. Mme si le traitement a des chances de
     localiser le code ECC, l'archive peut encore contenir des erreurs 
     d'autres endroits du fichier. Aucun test d'existence d'erreurs lors de
     la suppression des codes ECC n'est fait (en vue d'acclerer le traitement).

X commande (extraction des fichiers avec chemins complets)
----------------------------------------------------------
     Options valides: $,A,E,F,I,N,O,T,W,Y,Z

     La principalde diffrence avec la commande "E" est que les fichiers
     sont extraits avec leurs chemins d'accs (comme stocks dans l'archive). 
     Les noms de chemin peuvent tre visualiss avant extraction avec la
     commande "L".

     Les fichiers peuvent tre extraits dans n'importe quel rpertoire ou
     unit spcifi par l'utilisateur - mais par dfaut, les fichiers sont
     extraits dans le rpertoire courant. Certain chemins ne peuvent pas
     tre utiliss comme extension du rpertoire courant. C'est le cas de
     chemins contenant des noms d'units ou faisant rfrence  la racine. 
     De tels chemins seront restaurs sur disque suivant leur spcification
     dans l'archive.

     Lors de l'extraction dans une rpertoire/unit spcifi, les chemins
     seront construits depuis la position spcifie. Par exemple "x1 x test.x a:"
     essaiera d'extraire tous les fichiers sur "a:" (en construisant les
     chemins depuis le rpertoire courant).

     Quand l'extraction de fichiers implique un rpertoire non existant sur
     disque, la situation est la mme que lors de l'extraction dans un
     rpertoire spcifi en ligne de commande. L'utilisateur est averti et
     consult avant d'entreprendre quoi que ce soit.

                                  ===========
                                  = OPTIONS =
                                  ===========

$ option (ajouter/extraire le label de l'unit)
-----------------------------------------------
     **non implment**
     Compression:
     Ajoute le label de l'unit du premier fichier spcifi l'archive.
     
     Dans l'exemple "x1 a text.x *.* a:*.* b:*.* c:*.*" le label de l'unit
     courante est ajout  l'archive - parce que l'unit par dfaut est
     utilise dans la premire spcification de fichier. 
     "x1 a text.x a:*.* b:*.* c:*.*" provoque l'enregistrement du label "a:".

     Extraction:
     Restaure le label de l'unit (si prsent)  partir de l'archive, la o
     les fichiers sont extraits. Du fait qu'un seul label d'unit peut tre
     stock dans l'archive, aucune confusion n'est possible.

A option (stockage/restauration des attributs)
----------------------------------------------
     **non implment**
     Note: cette option n'est utilise que pour les "attributs spciaux"
     comme les attributs tendus d'OS/2. Les attibuts simples comme ceux
     sous DOS sont toujours restaurs.

     Compression:
     Cette option permet la sauvegarde de tous les attributs (peut-tre
     tendus) dans l'archive.
     
     Extraction:
     Cette option permet la restauration des attributs (peut-tre tendus).
     Les attributs dpendants d'un systme d'exploitation ne peuvent tre
     restaurs que sous ce mme systme d'exploitation. 
     En cas de conflit de systme d'exploitation, les attributs sont soit non
     restaurs - soit restaurs en faisant correspondre des attributs
     similaires dans les deux systmes.

C option (lit le commentaire depuis un fichier)
----------------------------------------------------
    **non implment**
    Utlise uniquement avec la commande "C".
    Il y a deux faons d'ajouter des commentaires  une archive:
     * les entrer au claver
     * les lire depuis un fichier
    Si les commentaires sont taps au clavier, l'option "C" n'est pas disponible. 
    Si les commentaires sont lus depuis un fichier, cette option doit tre
    utilise.

E option (exclut le chemin d'accs des noms de fichiers)
--------------------------------------------------------
     Compression:
     Cette fonction sert  exclure les chemins d'accs trouvs pendant une
     recherche rcursive. Si elle n'est pas utilise, tous les chemins d'accs 
     sont stocks dans l'archive.

     Extraction:
     Cette fonction sert  s'assurer que tous les fichiers seront extraits
     dans le mme rpertoire - quels que soient leurs chemins d'accs stocks
     dans l'archive.

     Mise  jour de fichiers:
     Cette fonction sert  viter d'avoir  rafrachir les fichiers avec
     des chemins d'accs. Dans le cas contraire, tous les fichiers sont
     rafrachis quel que soit leur chemin d'accs.

F option (force le dplacement des fichiers en-dehors/dedans de l'archive)
--------------------------------------------------------------------------
     **non implment**
     Compression:
     Cette fonction sert  supprimer les files du disque ds qu'ils ont t
     compresss et que l'opration semble s'tre droule correctement.
     Ceci, afin d'assurer une scurit supplmentaire dans le cas o le
     traitement est stopp prmaturment, afin qu'il n'y ait aucune perte de
     donnes.

     Extraction:
     Cette fonction diminue la taille de l'archive en supprimant les
     fichiers compresse de l'archive au fur et  mesure de leur extraction.

I option (mode silencieux)
--------------------------
     **non implment**
     Cette option limine toute sortie  l'cran. Ceci inclut l'en-tte
     standard et l'indicateur d'avancement en %. Ceci devrait permettre 
     d'autres logiciels d'appeler l'archiveur sans pour autant voir leur
     affichage perturb par les messages de l'archiveur.

K option (crase une archive dj existante)
--------------------------------------------
     **non implment**
     Compression:
     Cette option force l'crasement d'une archive dj existante. Si cette
     option n'est pas utilise, l'archive est mise  jour - des nouvelles
     entres sont ajoutes aux entres existantes.

L<nombre> option (niveau de compression)
----------------------------------------
     Compression:
     Cette option dclenche un niveau de compression plus pouss. Ceci peut
     signifier un plus grand besoin en mmoire ou un taux de compression
     dgrad/plus rapide, tout ceci dpendant de la mthode de compression.

     .x mthode 4    : les niveaux valides sont 0,1,2,3. Chaque niveau 
                       dtermine un modle de mmoire diffrent.
     autres mthodes : aucun effet

M<mthode> option (mthode de compression)
------------------------------------------
     Compression:
     Spcifie la mthode de compression  utiliser. Le mthode est indique
     par un nombre compris entre 0 et 256 au sens large. Si le nombre ne
     correspond pas  une mthode de compression, un message d'erreur est
     affich.

N option ("NO" en rponse  toutes les questions)
-------------------------------------------------
     Extraction:
     L'option "N" est complmentaire de l'option "Y". L'option "N" provoque
     une rponse ngative  toutes les questions poses  l'utilisateur.
     Ceci empche toute pause dans le programme et toute intervention de
     l'utilisateur. (concerne les crasements de fichiers, la cration of
     rpertoires etc.)

O option (trie les fichiers suivant nom,taille,date,etc.)
---------------------------------------------------------
     Il doit toujours y avoir deux 'O' dans la chane d'options sur la ligne
     de commande. Entre les deux "O...O" sont mises les sous-options - qui 
     dfinissent les cls de tri - et leurs priorits. 
     Toutefois, si aucune option ne suit l'option "O", le dernier "O" peut
     tre omis.
     Les sous-options de tri sont :
       A: croissant (dcroissant par dfaut)
       D: date
       E: extension
       N: nom
       P: chemin
       S: taille
       T: date

       B: meilleure compression
     Par exemple, "OSNO" signifie : trier d'abord sur la taille et si deux
     fichiers ont la mme taille, trier sur le nom.

     Compression:
     Lors de la cration d'une archive, les fichiers sont stocks dans
     l'archive dans l'ordre spcifi par les cls de tri. Lors de la mise 
     jour d'une archive, les entres existantes seront mises  jour dans
     l'ordre actuel de l'archive, mais les nouvelles entres seront tries
     suivant les options de tri.

     Extraction:
     **non implment**
     Les fichiers sont extraits dans l'ordre spcifi par les options de tri.

     Exemple:
       Tri des fichiers compresss suivant (1) la date (2) la taille 
       et (3) le name: "x1 aodsno test.x *.*"

R option (archivage rcursif)
-----------------------------
     Compression:
     Sans cette option, seuls les fichiers dans les rpertoires 
     spcifis en ligne de commande seront traits. Quand aucun rpertoire
     n'est spcifi explicitement, le rpertoire courant est trait. 
     Utliser l'option 'R' rsultera dans le traitement des tous les fichiers
     dans tous les sous-rpertoires de l'arborescence des rpertoires
     spcifis. Les sous-rpertoires sont visits  rcursivement dans
     l'ordre dans lequel ils apparaissent sur le disque. Les noms de chemins
     stocks dans l'archive sont tendus des sous-rpertoires visits, sauf
     si l'option "E" est  active. Les fichiers sont consults deux fois :
     une premire fois durant un premier parcours d'exploration, puis une
     seconde fois lorsqu'ils sont effectivement compresss dans l'archive.
     Le parcours initial est fait afin de pouvoir disposer d'un indicateur
     d'avancement global, et de pouvoir effectuer une estimation de taille
     pour les en-ttes solides (avec plusieurs entres de fichiers).

S option (change la date/heure de l'archive  celle de la plus rcente entre de l'archive)
-------------------------------------------------------------------------------------------
     **non implment**
     Compression:
     Trois situations peuvent apparatre quand on tente de mettre la date de
     l'archive  celle de l'entre la plus rcente :
       * choisir la date/heure la plus rcente parmi les entres ajoutes 
         une archive en cours de rafrachissement
       * slectionner la date/heure la plus rcente parmi les entres dj 
         prsentes dans l'archive - avant de commencer  la mettre  jour
       * slectionner la date/heure la plus rcente parmi tous les fichiers
         de l'archive aprs avoir mis celle-ci  jour.
     Dans l'implmentation actuelle, seule la dernire approche  t
     ralise.

     Un moyen simple de mettre  jour la date/heure de l'archive, sans
     y ajouter de fichiers est  "x1 lis test.x", qui provoque (1) le listage
     (sans affichage) du contenu (2) la mise  jour de la date.
  
T option (chage la date/heure des fichiers  l'heure courante)
--------------------------------------------------------------
     **non implment**
     Compression:
     Cette  option met la date/heure des fichiers ajouts  l'archive  la
     date/heure courante. La date/heure prcdente des fichiers est ignore.

     Extraction:
     Extraits des fichiers en mettant leur date/heure aux valeurs actuelles -
     plutt que celles enregistres dans l'archive.

     Note: lors d'un traitement, tous les fichiers recevront la mme
     date/heurse. Mme si les fichiers sont traits avec quelques secondes
     de diffrence, ils recevront l'heure du dbut du traitement.
     
U option (mode d'archivage solide)
----------------------------------
     Compression:
     Si l'archive ne contient qu'un seul fichier, cette option n'aura aucun
     effet. Mais si plusieurs fichiers sont compresss, il le sont en mode
     "solide". Ceci signifie que les fichiers sont compresss en un seul
     flot de donnes, comme s'ils avaient t concatns, ce qui, pour des
     fichiers similaires se traduit par un taux de compression accru.

     Pour assurer une compression optimale, les fichiers devraient tre
     groups intelligemment, de telle faon que les fichiers similaires
     soient proches. Ceci n'est pas automatiquement fait dans
     l'implmentation courante.

V<taille> option (archivage multi-volumes)
------------------------------------------
     **non implment**
     Compression:
     Si <taille> n'est pas spcifie, la compression sera effectue
     dans une archive (multi-volumes) limite en taille par l'espace disque
     libre actuel. Aprs chaque volume, un promt apparat (sauf si l'option 'Y' 
     est active), ce qui dans le cas d'une unit amovible autorise
     l'insertion d'un nouveau disque. Quand ceci est autoris, la
     compression continuera avec un autre morceau d'archive.
     Si <taille> est spcifie, la compression se fait dans une archive 
     (multi-volumes) limite en taille par la valeur spcifie
     Dans tous les cas, le rsultat final doit tre une suite d'archives de
     noms identiques et d'extensions diffrentes .x00, .x01, .. (le fichier
     d'extension x00 est le premier de la suite).
     Il n'est pas possible de rafrachir une archive multi-volumes archive 
     en mode multi-volume. Mais il est possible de rafrachir une archive
     multi-volumes avec des entres additionnelles normales, ou de
     rafrachir une archive normale (non multi-volumes) avec des
     entres multi-volumes.

     Extraction:
     Ici, <taille> n'a aucune utilit.
     L'extraction ne doit tre tente que sur une squence complte
     d'archives multi-volume. Tenter de n'extraire que depuis un morceau
     d'une archive multi-volumes est possible mais ne russira que si les
     fichiers extraits se situent entirement dans le mme morceau d'archive.
     Un prompt est affich  chaque changement d'archive, sauf si l'option
     'Y' est active.

W option (crase intelligemment lors de l'extraction)
-----------------------------------------------------
     **non implment**
     Extraction:
     Cette option tente de rsoudre intelligemment les situations o des
     fichiers extraits risquent d'craser des fichiers existants.
     Traditionnellement, ces situations sont rsolues en demandant 
     l'utilisateur si l'crasement est autoris ou non. Une troisime
     possibilit est d'extraire les fichiers en changeant lgrement les
     noms. Les  extensions  00X,01X,.. (pour ne pas les confondre avec des
     archives .x) sont utilises pour de tels fichiers.

X option (exclut les noms de chemins des fichiers en ligne de commande)
-----------------------------------------------------------------------
     Compression:
     Par dfaut, tous les chemins spcifis en ligne de commande sont inclus
     dans les noms de chemin des fichiers de l'archive. Si un rpertoire est
     spcifi avec "x1 a test.x dir\*.*" alors les chemins "dir\file1", "dir\file2",...
     sont enregistrs dans l'archive. L'option "X" vite l'enregistrement
     par dfaut des chemins spcifis en ligne de commande. "x1 ax test.x dir\*.*" 
     enregistrera les entres prcdentes comme "file1", "file2",... 
     Notez cependant que cette option n'affecte pas les chemins rencontrs
     lors d'une recherche rcursive (option "R"). Pour liminer ces chemins,
     l'option "E" est obligatoire.

     Extraction:
     Cette option n'a aucun effet dans ce cas - seule l'option "E" doit tre
     utilise pour exclure les chemins des fichiers extraits

Y option ("YES" assumed at all enquiries)
-----------------------------------------
     Extraction:
     L'option "Y" est complmentaire de l'option "N". L'option "Y" provoque
     une rponse affirmative  toutes les questions poses  l'utilisateur.
     Ceci empche toute pause dans le programme et toute intervention de
     l'utilisateur. (concerne les crasements de fichiers, la cration of
     rpertoires etc.)

Z<nombre> option (exclut des fichiers de l'archivage)
-----------------------------------------------------
     Compression:
     Quand cette option n'est pas utilise, toutes les expressions
     rgulires en ligne de commande spcifient des fichiers  inclure dans
     l'archive. Quand cette option est utilise, mais non suivie d'un
     nombre, la valeur par dfaut est 1. Ce nombre spcifie le nombre
     d'expressions rgulires (comptes  partir de la fin de la ligne de
     commande) qui correspondent  des fichiers  exclure de l'opration
     d'archivage. Cette convention ne permet pas le mlange des masques
     d'inclusion et d'exclusion. Tous les masques d'exclusion doivent tre
     spcifis ensemble, en fin de ligne de commande. Dans l'exemple
     "x1 az3 test.x test1.* test2.* *.bak *.swp *.tmp" le nombre "3" suivant
     l'option "Z" signifie que les trois derniers masques "*.bak *.swp *.tmp" 
     dsignent les fichiers qui ne doivent pas tre archivs. 
     Le comptage se fait depuis la fin de la ligne de commande et n'est donc
     pas affect par le nombre de masques d'inclusion.

     Au cas o le nombre suivant 'Z' est suprieur ou gal au nombre total
     de masques de la ligne de commande, alors les fichiers "*.*" sont
     supposs tre inclus par dfaut - et tous les autres fichiers spcifis
     exclus.

4. Variables d'environnement
============================
     Pour l'instant, une seule variable d'environnement est supporte. C'est
     "COUNTRY", qui est utilise pour le choix d'une langue et d'un jeu de
     caractres. 

     Sous DOS, la variable d'environnement COUNTRY peut tre utilise pour
     spcifier le pays et le jeu de caractres. Les caractres spciaux
     dpendants de la langue sont supports par le biais du jeu de
     caractres  ASCII "suprieur" (codes de 128  255) et est suscpetible
     de changer suivant la configuration. Suivant le jeu de caractres,
     les caractres dependants de la langue peuvent apparatre  diffrents
     endroits dans la table ASCII tendue (si disponibles). Pour utiliser de
     tels caractres, il est important d'identifier tout d'abord le jeu de
     caractres en question.

     Par exemple, la configuration pour un clavier amricain peut tre :
                          COUNTRY=001,437
     Le "001" spcifie la langue amricaine, et le "437" spcifie la page de
     codes 437 (jeu de caractres amricain). Consultez vos manuels du DOS 
     pour une liste dtaille des pages de codes disponibles.

     Si pour une raison quelconque la variable d'environnement COUNTRY 
     ne peut pas tre utilise, une autre variable nomme LANGUAGE 
     peut tre utilise  la place (mme syntaxe).

     Si une phrase n'est pas supporte dans la langue choisie, elle sera
     remplace par son quivalent anglais.

     D'autres variables d'environnement ne sont pas supportes pour
     l'instant.

5. Formats et mthodes de compression (au niveau de l'utilisateur)
==================================================================

First an overview of the header formats and methods supported.

"x1" archiver as of version 0.94a ("+" indicates support and "-" indicates
lack of support):
------------------------------------------------------------------------------
   Nom de     listage
 l'archiveur   |   dcompression
               |   |   compression
               |   |   |   mthodes de compression supportes
               |   |   |   |      mthodes de decompression supportes
               |   |   |   |      |          commentaires
               |   |   |   |      |          |
    arj        +   +   +   0,1    0,1,2,3,4  1,..,4 sont identiques (~)
    zip        +   +   +   0,1,8  0,1,7,8    1:shrink,7:implode,8:deflate
    lzh/lha    +   +   +   0,5    0,1,5      pas de support pour l'Amiga-LHA (no Amiga!)
    zoo        +   +   +   0,2    0,2
    ha         +   +   +   0,1,2  0,1,2
    tar        +   -   -   -      -
    tgz        +   +   +   8      8         
    hap        +   +   +   0,1    0,1
    rar        +   -  (+)  0      0
    arc        +   -   -   -      -
    pak        +   -   -   -      -
    sqz        +   -  (+)  0      0
    arx        +   -  (+)  0      0,1 (5)    algorithmes de LHA1.13
    put        +   +   +   0,5    0,5        algorithmes de LHA2.x
    x          +   +   +   0,1,.. 0,1,..
------------------------------------------------------------------------------
(+) signifie que seulement compresser n'est pas trs drle ... :-)

A propos du module ARJ :
-------------------------
     Exemple de compression au format ARJ :
                           "x1 a test.arj *.*"
     Ceci compresse tous les fichiers du rpertoire courant dans l'archive
     "test.arj" (avec la mthode 1 par dfaut).
     Pour stocker des fichiers sans compression :     "x1 am0 test.arj *.*"
     Les archives multi-volumes au format ARJ ne sont pas (encore) supportes.

A propos du module ZIP :
-------------------------
     Exemple de compression au format ZIP :
                           "x1 a test.zip *.*"
     Ceci compresse tous les fichiers du rpertoire courant - par dfaut
     avec la mthode ZIP connue sous le nom de "deflate" (versions 2.x). Si
     la compatibilit descendante est un problme, il est possible de
     compresser avec une mthode plus ancienne :
                           "x1 am1 test.zip *.*"
     Ceci applique la mthode "shrink" des versions 0.9 and 1.1 de ZIP. 
     Cette ancienne mthode n'est pas prvue pour une utilisation "srieuse". 
     Elle remonte  mes premires et humbles expriences avec le format ZIP
     en 1991...
     Le test d'intgrit de l'archive (aprs compression) se fait avec :
                    "x1 t test.x"   ou   "x1 t test.x *.*"

A propos du module LHA :
------------------------
     Exemple de compression au format LHA :
            "x1 a test.lha *.*"   ou   "x1 a test.lzh *.*"
     Les extensions ".lha" and ".lzh" sont supports de manire gale (les
     deux sont prises en compte par exemple pour :  "x1 l *"). La mthode 5
     est la mthode par dfaut.

A propos du module ZOO :
------------------------
     Exemple de compression au format ZOO :
                           "x1 a test.zoo *.*"
     ATTENTION: le format zoo spcifie deux types d'en-ttes et
     actuellement, seul l'un d'entre eux est support par x1 (le type 2,
     largement dominant). Ceci peut causer des problmes, si x1 doit mettre
      jour des anciennes archives zoo (format type 1?).
     Envoyez-moi des exemples d'archives au vieux format !!!

A propos du module HA :
-----------------------
     Exemple de compression au format HA :
                           "x1 a test.ha *.*"
     Ceci compresse tous les fichiers du rpertoire courant (par dfaut avec
     la mthode 1..ASC). En cas de besoin d'une compression plus pousse par
     une mthode PPM du 4me ordre, il faut mieux utiliser (HSC) : 
                           "x1 am2 test.ha *.*"
     Pour laisser l'ordinateur tenter les deux mthode et choisir la
     meilleure :
                           "x1 am# test.ha *.*"

A propos du module TGZ :
------------------------
     Exemple de compression au format TAR+GZIP :
                           "x1 a test.tgz *.*"
     Ceci met dans tous les fichiers souhaits dans une archive TAR
     compresse par le suite au format GZIP. Sur les platformes supportant
     les noms de fichiers longs, l'extension approprie serait ".tar.gz".
     Lors du listage d'un tel fichier, une dcompression complte (en
     mmoire) est ncessaire - il faut donc tre un peu plus patient.
                           "x1 l test.x"
     Actuellement, il n'est pas possible d'extraire le contenu d'un fichier
     GZIP en un seul fichier.                           

A propos du module X :
----------------------
     Une chose qui n'a rien  voir directement avec la mthode de
     compression mais qui diffrencie le format X de la plupart des autres
     archiveurs est le double enregistrement de CRC (possibilit de test de
     CRC rapide). Un CRC est calcul pour les donnes non compresses aussi pour 
     les compresses. Pour juste dtecter des erreurs de transmission, une
     vrification de ce dernier CRC (donnes compresses) est suffisante.

     Comme la taille des donnes compresses est habituellement infrieure
      leur taille originale (non compresse), le calcul  faire pour le
     test de CRC est ngligeable : il ne ralentit pas le traitement de
     manire significative.

     De plus, il faut noter que des archives .x peuvent contenir plusieurs entres
     avec des noms rigoureusement identiques (chemin+nom du fichier). Ceci
     ne peut pas tre vit dans le cas d'archives solides. Si une telle l'entre
     d'une archive solide est dtruite, alors les autres entres de mme nom
     sont galement supprimes - ce qui se provoque une perte de donnes. 
     Ce problme peut tre vit en "prtendant" qu'un fichier en double
     n'est pas l (en ne le montrant pas, comme le font UC2 et HPACK).
     Il semblait pourtant raisonnable, que si le fichier tait prsent,
     l'utilisateur devrait le voir ... par convention !

     Mthode n      Nom  Exemple de compression Commentaires
     --------------  ---- ---------------------- ------------
           1         XLZ  "x1 am1 test.x *.*"     fentre LZ77 de 64k
          (2)         -
          (3)         -
           4         XXC  "x1 am4 test.x *.*"     possibilit de mmoire variable
          (5)        LZP  "x1 am5 test.x *.*"
     meilleure mth.  -   "x1 am# test.x *.*"
     --------------- ---- --------------------
     NOTE: "meilleure mthode" essaiera d'abord la mthode 4, puis la 1. 
     La mthode finalement retenue sera celle qui offre le rsultat le plus
     petit en taille.

     ATTENTION: les mthodes >4 seront certainement modifies... N'esprez
     aucune compatibilit ascendante/descendante ici !!!

     Le format X supporte le format solide. Exemple : "x1 aum1 test.x *.*"
     Une archive peut contenir plusieurs entres solides indpendantes, et
     des entres solides peuvent tre mlanges librement avec des entres
     normales. Une fois cre, une entre solide ne peut pas tre mise  jour.

     Pour vrifier une archive en testant par dcompression :
                           "x1 t test.x *.*"
     Pour vrifier une archive pour des erreurs de transmission :
                           "x1 tf test.x *.*"
     Ceci donne  l'option "F" (forcer les fichiers) une autre signification
     (test de CRC plus rapide), lors de la vrification d'une archive. 
     Ceci ne restreint pas l'utilisation de l'option dans sa signification
     originale, parce que forcer des fichiers hors de l'archive pendant un
     test n'a aucun sens.

     Tenter une test de CRC rapide sur d'autres format qui ne supportent pas
     le double CRC rsulte en un test de CRC normal.
     
     En bref sur la mthode 4:
     Elle fonctionne avec l'option "niveau de compression" "l" dans le sens :
                           "x1 am4l2 test.x *.*"
     ... signifie compression niveau 2 (<4Mb de mmoire).
                Niveau  Mmoire  Commentaire
                  0      640kb    le gestionnaire de mmoire peut demander 1Mb
                  1        3Mb    -
                  2        7Mb    -  
                  3       16Mb    non test - pas encore 16Mb dans ma machine

6. Noms des fichiers temporaires
================================
En compressant, le programme choisit un fichier temporaire  "X???????.SWP"
(o ??..?? est choisi au hasard). Il contient la nouvelle archive en cours
de cration. Si le traitement semble russi, le fichier est renomm avec le
nom spcifi.

Lors de la dcompression, une entre de l'archive peut craser l'archive
elle-mme. Dans ce cas, l'archive originale est temporairement renomme
avec un nom neutre (X???????.SWP) - et dtruite, une fois que toutes les
entres ont t  extraitres.

A aucun moment il ne peut y avoir plus de 3 fichiers ouverts (lors de la
mise  jour d'une archive).
Une fois lanc, le programme utilise au maximum un fichier temporaire, et un
seul nom pour ce fichier (X???????.SWP).

L'extension peut paratre un peu trompeuse. Le fichier temporaire n'est pas
un fichier de mmoire virtuelle. Le fichier est renomm  la fin - le
contenu n'est pas copi ailleurs.
L'extension doit rappeler celles utilises par d'autres programmes
(compilateurs de chez Borland), ce qui vite quelques hsitations, lorsque
l'utilisateur se demande s'il doit effacer ce fichier.

Comme les fichiers de mmoire virtuelle ne sont pas vraiment ncessaires, il
n'est pas utilis de rpertoire de travail. Pour une vitesse optimale, la compression 
devrait avoir lieu sur un ramdisk, et les fichiers rsultants copis sur un
support non volatil.



7. Codes de retour
==================

Rfrence interne  Valeur  Commentaire
------------------ ------ -----------------------------
 EXIT_OK             0     Pas d'erreur
 EXIT_INT_ERR        1     Erreur interne(?)
 EXIT_NO_MEM         2     A court de mmoire
 EXIT_NO_DISK        3     A court d'espace disque
 EXIT_NO_OPEN        4     Ne peut pas ouvrir l'archive
 EXIT_NO_TMP         5     Ne peut pas ouvrir le fichier temporaire
 EXIT_NO_FOUND       6     Ne peut pas trouver l'archive(s) correspondante(s)
 EXIT_NO_PATH        7     Ne peut pas trouver le chemin
 EXIT_NO_BASE        8     Ne peut pas accder au rpertoire de base
 EXIT_NO_MKDIR       9     Ne peut pas crer le rpertoire
 EXIT_BREAK          10    Interruption par l'utilisateur
 EXIT_FILE_ERR       11    Erreur de fichier inconnue - ne peut pas lire le fichier
 EXIT_BAD_HDR        12    Rpertoire de l'archive (partiellement) corrompu
 EXIT_BAD_EXT        13    Le contenu de l'archive ne correspond pas  l'extension
 EXIT_BAD_ARC        14    Est-ce vraiment une archive?
 EXIT_LONG_NO        15    Long argument non support - ou trop d'arguments
 EXIT_LONG_PATH      16    Chemin trop long
 EXIT_NO_OVERRIDE    17    Ne peut pas craser le chemin de base
 EXIT_NEST           18    Arborescence trop profonde
 EXIT_SCRIPT_ERR     19    Erreur(s) dans le fichier de script
 EXIT_NOTHING        20    Rien  faire 
 EXIT_UNSP           21    Methode non supporte dans cette version..
 EXIT_COM            22    Commande inconnue
 EXIT_OPT            23    Option inconnue
 EXIT_OPT_DIR        24    Option inconnue
 EXIT_OPT_WR         25    Option inconnue
 EXIT_OPT_VIEW       26    Option inconnue
 EXIT_WC_FORM        27    Usage inappropri des expressions rgulires
 EXIT_WC_NAME        28    Usage inappropri des expressions rgulires
 EXIT_WC_COMPL       29    Usage inappropri des expressions rgulires
 EXIT_CHG_WRPROT     30    Mauvaise tentative de changement d'une archive protge en criture
 EXIT_CHG_DEL        31    Mauvaise tentative de changement d'une archive supprime
 EXIT_CHG_UNI        32    Mauvaise tentative de changement d'une archive solide
 EXIT_CHG_MULTI      33    Mauvaise tentative de changement d'une archive multi-volumes
 EXIT_CHG_CR         34    Mauvaise tentative de changement d'une archive encrypte
 EXIT_CHG_UNCR       35    Mauvaise tentative de changement d'une archive non encrypte
 EXIT_BAD_KEYFILE    36    fichier de cl incorrect (cryptage)
 EXIT_PASS_NO        37    Nom d'utilisateur incorrect (cryptage)
 EXIT_PASS_DIFF      38    Echec de la vrification du mot de passe (cryptage)
 EXIT_SECURITY       39    Erreur gnrale de scurit-encryptage (cryptage)
 EXIT_NOCRYPT        40    Ne peut pas grer l'archive encrypte (cryptage)

------------------------------------------------------------------------------

Stig Valentini, x1develop@internet.dk (jusqu'en Mars 1997)

------------------------------------------------------------------------------

