{$M 8192, 0, 16384}
program
	ht;
uses
	crt,
	nya,
	dos,
	spx_ini;
type
	OutProc     = procedure(s: string);
	str12       = string[12];
const
	hexchars    : array[0..$f] of char = '0123456789abcdef';
	version     : string[64] = '$VER: ht 2.52a (27.5.96) Copyright (C)1993-96 Fredrik Wangel';
	inikeys     : array[0..5] of string = ('DefCmdLine', 'Extensions', 'Specials', 'Externals', 'MoreExt', 'MoreXtrns');
	inidefs     : array[0..5] of string = ('/E', '&h,COM,EXE,SYS', '&a,CONFIG.SYS',
														'ZIP:PKZIP_-vb_%s_|more,ARJ:ARJ_v_%s_|more', '', '');
	filterstr	: string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789' +
								  '+-*/\ $&?!#%@,;:_"''<>[](){}';
	deftabsize  : byte = 3;

var
	Out,
	OutLn       : OutProc;
	padchar		: char;
	buf         : array[1..16384] of char;
	fob         : file;
	inivals     : array[0..5] of string;
	runpar,                                { externals parameter }
	extpar,                                { extensions parameters }
	prgpar,                                { program parameters }
	spcpar,                                { special parameters }
	filer,                                 { files to be viewed }
	filterstra,
	filnamn     : string;
	evenb,
	infol,
	paged,
	hexed,
	ffsens,
	filter,
	strict,
	attrchgd,
	fopen,
	skip,
	stop        : boolean;
	tabsize     : integer;
	procent     : longint;
	di          : searchrec;
	pp          : pathstr;
	dp          : dirstr;
	fp          : namestr;
	ep          : extstr;
	pcs         : string[2];
	pc          : char;
	maxcolumn,
	ini_return,
	antalfiler,
	i,
	j           : integer;
	OldExit,
	Int1B       : pointer;
	OldTA,
	tasav,
	fattr,
	key         : word;
	xMax,
	yMax        : byte;
	startHere,
	fs,
	fpos        : longint;

procedure __write(s : string);
begin
	write(s);
end;

procedure __writeln(s : string);
begin
	writeln(s);
end;

function SetDeviceRaw(var T: Text) : boolean; assembler;
{ Checks whether or not the Text file is a device.
  If so, it is forced to "raw" mode }
asm
	LES   DI,T
	MOV   BX,WORD PTR ES:[DI]
	MOV   AX,4400H
	INT   21H
	MOV   AL, 0                { assume false }
	TEST  DX,0080H
	JZ    @@1
	OR    DL,20H
	MOV   DH,DH
	MOV   AX,4401H
	INT   21H
	MOV   AL, 1                { it was forced to raw }
@@1:
end;

procedure CursOff; assembler;
	asm
		mov   ah, 1
		mov   cx, 0ffffh
		int   10h
	end;

procedure CursOn; assembler;
	asm
		mov   ah, 1
		mov   cx, windmax
		shr   cx, 8
		cmp   cx, 25
		jge   @a
		mov   cx, 100eh
		jmp   @b
@a:   mov   cx, 0806h
@b:   int   10h
	end;

{$F+}
procedure BreakHandler; interrupt;
begin
	OutLn('^C');
	halt(1);
end;

procedure error(es : string);
begin
	OutLn('HT error: ' + es);
end;

function bytetohex(bth: Byte) : string;
	begin
		bytetohex := hexchars[lo(bth) shr 4] + hexchars[lo(bth) and $F];
	end;

function wordtohex(wth: word) : string;
	begin
		wordtohex := hexchars[hi(wth) shr 4] + hexchars[hi(wth) and $F] +
						 hexchars[lo(wth) shr 4] + hexchars[lo(wth) and $F];
	end;

function LongToHex(lth : Longint) : string;
	begin
		LongToHex := WordToHex(lth shr 16) + WordToHex(Word(lth));
	end;

function handleIni(value : integer) : integer;
begin
	case value of
		2     :  value := 1;
		3..5  :  value := 2;
	end;
	handleIni := value;
end;

function itos(i : integer) : string;
var
	s  :  string;
begin
	str(i, s);
	itos := s;
end;

FUNCTION Lz(lzw : LONGINT; lzn : BYTE) : STR12;
VAR
	lzs      :  STR12;
BEGIN
	Str(lzw:0, lzs);
	WHILE Length(lzs) < lzn DO
		lzs := '0' + lzs;
	Lz := lzs;
END;

{$F+}
procedure NewExitProc;
begin
	ExitProc := OldExit;
	SetVector($1B, Int1B);
	TextAttr := OldTA;

	if(ExitCode <> 0) and (ErrorAddr <> NIL) then
	begin
		error('Run-time error ' + itos(ExitCode) + '. Please report to tde95waf@te.hik.se');
		ErrorAddr := NIL;
		ExitCode := 10;
	end;
	if fopen then
	begin
		{$I-}
		close(fob);
		{$I+}
		if IOResult <> 0 then
			error('could not close file');
	end;
	if attrchgd then begin
		attrchgd := false;
		setfattr(fob, fattr);
	end;
	Quiet;
	Out(' '#13);
	FlushKbd;
	while keyhit do;
	FlushKbd;
	curson;
end;

function getExternal(filnamn : string) : string;
var
	tmp,
	slagg : string;
	ext   : extstr;
	dir   : dirstr;
	name  : namestr;
	i,
	j     : byte;
begin
	slagg := '';
	fsplit(filnamn, dir, name, ext);
	if ext <> '' then begin
		delete(ext, 1, 1);
		slagg := UCaseStr(inivals[3]);
		j := pos(ext + ':', slagg);

		if (slagg[j - 1] = '=') or (slagg[j - 1] = ',') then begin

			slagg := '';
			if j <> 0 then
				slagg := copy(inivals[3],
								  1 + instr(':', inivals[3], j),
								  instr(',', inivals[3], j + 1));
			repeat
				j := pos('_', slagg);
				if j <> 0 then begin
					i := instr('_', slagg, j);
					while i <> 0 do begin
						slagg[i] := ' ';
						inc(j);
						i := instr('_', slagg, j);
					end;
				end;
			until j = 0;
			j := pos(',', slagg);
			if j <> 0 then
				delete(slagg, j, length(slagg) - j + 1);
			tmp := UCaseStr(slagg);
			j := pos('%S', tmp);
			if j <> 0 then begin
				slagg := copy(slagg, 1, j - 1) + filnamn +
							copy(slagg, j + 2, length(slagg) - j - 1);
			end;

		end
		else
			slagg := '';

	end;
	getExternal := slagg;
end;

function getExtParams(filnamn : string) : string;
var
	slagg : string;
	ext : extstr;
	dir : dirstr;
	name : namestr;
	i,
	j     : byte;
begin
	slagg := '';
	fsplit(filnamn, dir, name, ext);
	delete(ext, 1, 1);
	j := pos(ext, inivals[1]);
	if j <> 0 then begin
		slagg := copy(inivals[1], 1, j);
	end;
	repeat
		j := pos('&', slagg);
		if j <> 0 then begin
			slagg[j] := '/';
			i := instr(',', slagg, j);
			if i <> 0 then begin
				j := pos('&', slagg);
				if j <> 0 then begin
					delete(slagg, i, j - i);
				end;
			end;
		end;
	until j = 0;
	j := pos(',', slagg);
	if j <> 0 then
		delete(slagg, j, length(slagg) - j + 1);
	getExtParams := slagg;
end;

function getSpecParams(filnamn : string) : string;
var
	i,
	j     : byte;
	slagg : string;
begin
	slagg := '';
	j := pos(filnamn, inivals[2]);
	if j <> 0 then begin
		slagg := copy(inivals[2], 1, j);
	end;
	repeat
		j := pos('&', slagg);
		if j <> 0 then begin
			slagg[j] := '/';
			i := instr(',', slagg, j);
			if i <> 0 then begin
				j := pos('&', slagg);
				if j <> 0 then begin
					delete(slagg, i, j - i);
				end;
			end;
		end;
	until j = 0;
	j := pos(',', slagg);
	if j <> 0 then
		delete(slagg, j, length(slagg) - j + 1);
	getSpecParams := slagg;
end;

function getFileName(s : string; i : byte) : string;
	var
		j,
		k,
		l     :  byte;
		s2    :  string;
	begin
		j := 0;
		k := 1;
		l := 0;
		repeat
			j := instr(',', s, k);
			if j <> 0 then
				inc(l)
			else
				inc(l);
			if l = i then
				s2 := copy(s, k, j - k);
			k := j + 1;
		until (l >= i);
		if l > i then
			s2 := '';
		getFileName := s2;
	end;

procedure moreinfo;
begin
	OutLn(version);
	outln('-----------------------------------------------------------');
	outln('This program uses the SPX_INI.TPU from The SPX Library v2.0');
	outln('which is copyright (c)1993 Scott D. Ramsay. Apart from that');
	outln('everything is  copyright (c)1996  Fredrik Wangel.  Read the');
	outln('included HT.DOC file for more information.        Thank you');
	outln('-----------------------------------------------------------');
	halt(0);
end;

procedure usage;
begin
	OutLn(version);
	OutLn('');
	OutLn('usage: HT files [options]');
	OutLn('');
	OutLn('options are one or more of these with a leading slash or hyphen:');
	OutLn('H  : Outputs all files in hexadecimal mode.');
	OutLn('E  : Hexadecimal output will be either 8 or 16 bytes per line.');
	OutLn('A  : Outputs all files in standard ASCII mode.');
	OutLn('P  : Page mode. Programs halts output at every full page.');
	OutLn('F  : FormFeed Sensitive. In ascii mode, formfeed characters (#12)');
	OutLn('     will generate an empty page (do not use for printer output).');
	OutLn('I  : Put an information banner at top of screen.');
	OutLn('N  : No Even. Hex output uses full screen width.');
	OutLn('Z  : FormFeed Zap. Turns off FormFeed Sensitive (use with printers).');
	OutLn('U  : Filter ASCII. In ascii mode, only certain characters are shown.');
	OutLn('     Usefull when a text file turns out to contain binary data, or');
	OutLn('     when you wish to see the text strings in an exe file.');
	OutLn('Y  : Used with U to indicate Strict filter (only letters A..Z and a..z shown)');
	OutLn('W  : Removes strict filter.');
	OutLn('S  : No Pause. Prevents pauses every full page.');
	OutLn('O  : Output using stdout.');
	if (@Out = @__write) and (yMax = 24) and (xMax = 80) then
	begin
		Out('--- more ---');
		flushkbd;
		waitkey;
		Out(#13);
	end;
	OutLn('Rx : Begins at line x in ASCII mode, percent x in HEX mode.');
	OutLn('     In HEX max is 99, in ASCII max is no. lines in textfile.');
	OutLn('     In HEX mode you could enter a hexadecimal number denoting');
	OutLn('     the exact fileposition. Start with a $ character.');
	OutLn('Tx : Sets tabsize to x, where x is in [0..16]. Default is 8.');
	OutLn('Cx : Sets max columns to x, where x is in [1..255]. Default is screen width.');
	OutLn('     When a line exeeds max column, it is considered to be a new line.');
	OutLn('!  : Displays some information about HT.');
	OutLn('?  : Shows this text.');
	OutLn('');
	OutLn('Example: HT *.exe *.cpp /E /T3 R$100');
	halt(0);
end;

procedure chkparam(par : string);
var
	code,
	i,
	j        : integer;
	slagg,
	params   : string;
begin
	hexed   := false;
	infol   := false;
	paged   := false;
	evenb   := false;
	ffsens  := false;
	filter  := false;
	tabsize := deftabsize;
	maxcolumn := xMax;
	procent := 0;
	fpos    := 0;
	params  := par + '/';
	repeat
		j := pos('/', params);
		if j <> 0 then begin
			if j + 1 > length(params) then
				params := params + ' ';
			case params[j + 1] of
				'?'   :  usage;
				'!'   :  moreinfo;
				'H'   :  hexed  := true;
				'E'   :  evenb  := true;
				'A'   :  hexed  := false;
				'P'   :  paged  := true;
				'F'   :  ffsens := true;
				'I'   :  infol  := true;
				'N'   :  evenb  := false;
				'Z'   :  ffsens := false;
				'Y'	:	strict := true;
				'W'	:	strict := false;
				'U'   :  filter := true;
				'B'   :  filter := false;
				'S'   :  paged  := false;
				'O'   :  begin
								Out   := PrintStr;
								OutLn := PrintStrLn;
							end;
				'R'   :  begin
								i := instr('/', params, j + 1);
								if i = 0 then
									i := length(params);
								slagg := copy(params, j + 2, i - j - 2);
								val(slagg, procent, code);
								if hexed then begin
									if pos('$', slagg) <> 0 then begin
										if (code <> 0) then begin
											error('/Rx parameter is bad');
											halt(2);
										end
										else
											fpos := procent;
									end
									else begin
										if (code <> 0) or (not (procent in [0..100])) then begin
											error('/Rx parameter is out of range [0..100]');
											halt(2);
										end;
									end;
								end
								else
									if (code <> 0) or ((procent < 0) and (procent > 32767)) then
										procent := 0;
								delete(params, j + 1, length(slagg));
							end;
				'T'   :  begin
								i := instr('/', params, j + 1);
								if i = 0 then
									i := length(params);
								slagg := copy(params, j + 2, i - j - 2);
								val(slagg, tabsize, code);
								if (code <> 0) or (not (tabsize in [1..16])) then
									tabsize := deftabsize;
								delete(params, j + 1, length(slagg));
							end;
				'C'   :  begin
								i := instr('/', params, j + 1);
								if i = 0 then
									i := length(params);
								slagg := copy(params, j + 2, i - j - 2);
								val(slagg, maxcolumn, code);
								if (code <> 0) or (not (maxcolumn in [1..255])) then
									maxcolumn := xMax;
								delete(params, j + 1, length(slagg));
							end;

			else
				insert(' ', params, j + 1);
			end;
			delete(params, j, 2);
		end;
	until j = 0;
end;

function short(t : string; ml : byte) : string;
	var
		t2    :  string;
		ps,
		l     :  integer;
	begin
		l := length(t);
		if l > ml then begin
			t[3] := #1;
			t2 := Copy(t, 4, Pos('\', t) - 3);
			repeat
				ps := Pos('\', t);
				Delete(t, 4, ps - 3);
			until (length(t) + 4 + length(t2)) <= ml;
			t[3] := '\';
			insert(t2 + '...\', t, 4);
		end;
		short := t;
	end;

procedure goExternal(cmd : string);
	var
		path  :  pathstr;
		aa,
		bb:string;
	begin
		{$I-}

		aa := copy(cmd, 1, pos(' ', cmd) - 1);
		bb := copy(cmd, pos(' ', cmd) + 1, length(cmd));

		swapvectors;
		exec(getenv('COMSPEC'), '/C ' + aa + ' ' + bb);
		swapvectors;
		if doserror <> 0 then
			error('could not execute external command')
		else
			if dosexitcode = 1 then
				error('external command was interrupted');
	end;

procedure pause;
begin
	tasav := textattr;
	textattr := yellow + red * $10;     { Yellow on Red }
	Out(#13);
	ClrEol;
	Out('press a key to continue...'#13);
	textattr := tasav;
	FlushKbd;
	repeat
	until GetKey(key);
	ClrEol;
end;

procedure readfile(fn : string);
var
	br,
	maxrow,
	i        : longint;
	maxcol,
	col,
	row,
	orow,
	nr       : word;
	ypos     : integer;
	linx,
	line     : string;
	x,
	y        : byte;
	np       : boolean;

	function GetMaxLines : longint;
	{
		returns number of lines in a textfile.
		if percent is set to a positive number
		startHere is is set to the byte position
		in the file where that line begins.
		if percent is out of range function
		returns -maxrows.
	}
	var
		i,
		nolf     : longint;
		nr       : word;
	begin
		reset (fob, 1);
		fopen := true;
		nolf := 1;
		startHere := 0;
		repeat
			BlockRead(fob, buf, sizeof(buf), nr);
			if nr > 0 then
				for i := 1 to nr do
					if buf[i] = #10 then begin
						inc(nolf);
						if nolf = procent then
							startHere := FilePos(fob) - nr + i - 1;
					end;
		until (nr = 0);
		if (startHere = 0) and (procent <> 0) then
			nolf := -nolf;
		reset (fob, 1);
		getmaxlines := nolf;
	end;

	procedure Info;
	begin
		x := wherex;
		y := wherey;
		tasav := textattr;
		window(1, 1, lo(windmax) + 1, hi(windmax) + 1);
		textattr := yellow + red * $10;     { Yellow on Red }
		gotoxy(1, 1);
		ClrEol;
		if hexed then
			Out('file: ' + short(fn, 32) + '  Read: ' + lz(br, 0) + ' of ' + lz(fs, 0) + ' bytes (' + lz(row, 3) + '%)')
		else
			Out('file: ' + short(fn, 32) + '  Line: ' + lz(row + 1, 0) + '/' + lz(maxrow, 0));
		textattr := tasav;
		window(1, 2, lo(windmax) + 1, hi(windmax) + 1);
		gotoxy(x, y);
	end;

begin
	yMax := Hi(WindMax);
	textattr := lightgray;
	if hexed then begin
		assign(fob, fn);
		getfattr(fob, fattr);
		setfattr(fob, Archive);
		attrchgd := true;
		{$I-}
		reset (fob, 1);
		{$I+}
		if IOResult = 0 then
			fopen := true
		else
		begin
			error('could not open file');
			exit;
		end;
		if fpos <> 0 then
			startHere := fpos
		else if procent > 0 then
			startHere := Round(filesize(fob) * (procent / 100))
		else
			startHere := 0;
		seek(fob, startHere);
		fs     := filesize(fob);
		if fs = 0 then begin
			error('unknown error opening file');
			fs := 1;
		end;
		row    := round(startHere / fs * 100);
		orow   := row;
		np     := false;
		br     := 0;
		col    := 0;
		ypos   := -1;
		line   := '';
		linx   := '';
		maxcol := 8;
		if evenb then begin
			if lo(windmax) > 39 then
				maxcol := 16;
		end
		else
			if lo(windmax) > 39 then
				maxcol := 17;
		if (fs > $ffff) and (lo(windmax) < 40) then
			if evenb then
				dec(maxcol, 4)
			else
				dec(maxcol, 2);
		if @Out <> @__write then
			infol := false;
		if infol then begin
			dec(yMax);
			x := wherex;
			y := wherey;
			window(1, 2, lo(windmax) + 1, hi(windmax) + 1);
			gotoxy(x, y - 1);
			Info;
		end;
		repeat
			fpos := filepos(fob);
			br := fpos - 1;
			BlockRead(fob, buf, sizeof(buf), nr);
			if nr > 0 then
				for i := 1 to nr do begin
					inc(br);
					if col = 0 then begin
						np := true;
						if fs > $FFFF then
							out('$' + LongToHex(fpos + i - 1) + ': ')
						else
							out('$' + WordToHex(word(fpos + i - 1)) + ': ');
						if infol then
							Info;
					end;
					if not (byte(buf[i]) in [32..254]) then
						line := line + '.'
					else
						line := line + buf[i];
					linx := linx + bytetohex(byte(buf[i])) + ' ';
					inc(col);
					if col = maxcol then begin
						col := 0;
						if @Out <> @__write then
							outln(linx + line)
						else begin
							textattr := cyan;
							out(linx);
							textattr := green;
							outln(line);
							textattr := lightgray;
							np := false;
						end;
						inc(ypos);
						row := round((fpos + i - 1) / fs * 100);
						if infol and (row <> orow) then begin
							orow := row;
							Info;
						end;
						linx := '';
						line := '';
					end;
					getkey(key);
					{ Space key }
					if ((not np) and (hi(key) = $39))
					or ((ypos >= yMax - 1) and (paged) and (not np)) then begin
						ypos := 0;
						if @Out = @__write then
							pause;
					end;
					if (hi(key) = $1f) then begin    { the S key for Skip }
						ypos := 0;
						skip := true;
						break;
					end;
					if (hi(key) = $31) then begin    { the N key for No Pause }
						paged := false;
					end;
					if (hi(key) = $19) then begin    { the P key for Page Mode }
						paged := true;
					end;
					if (hi(key) = $01) then begin    { Esc }
						stop := true;
						break;
					end;
					if (hi(key) = $10) then begin    { Q }
						stop := true;
						break;
					end;
				end;
		until (nr = 0) or (stop) or (skip);
		if col <> 0 then begin
			while (length(line) < maxcol) do begin
				line := line + ' ';
				linx := linx + '   ';
			end;
			if @Out <> @__write then
				outln(linx + line)
			else begin
				textattr := cyan;
				out(linx);
				textattr := green;
				out(line);
				textattr := lightgray;
				outln('');
			end;
		end;
	end
	else begin
		assign(fob, fn);
		getfattr(fob, fattr);
		setfattr(fob, Archive);
		attrchgd := true;
		{$I-}
		reset(fob, 1);
		{$I+}
		if IOResult = 0 then
		begin
			fopen := true;
			close(fob);
		end
		else
		begin
			error('could not open file');
			exit;
		end;
		maxrow := getmaxlines;
		if maxrow < 0 then begin
			error('/Rx parameter is out of range [0..' + itos(abs(maxrow)) + ']');
			exit;
		end;
		seek  (fob, startHere);
		line := '';
		stop := false;
		skip := false;
		row  := procent;
		col  := 0;
		ypos := -1;
		if @Out <> @__write then
			infol := false;
		if infol then begin
			dec(yMax);
			x := wherex;
			y := wherey;
			window(1, 2, lo(windmax) + 1, hi(windmax) + 1);
			gotoxy(x, y - 1);
			Info;
		end;

		if (strict) then
			filterstra := copy(filterstr, 1, 52) + ' '
		else
			filterstra := filterstr;

		repeat
			BlockRead(fob, buf, sizeof(buf), nr);
			if nr > 0 then
				for i := 1 to nr do begin
					if buf[i] = #13 then
						continue
					else
						if (buf[i] = #10) and (not filter) then begin
							inc(row);
							OutLn(line);
							inc(ypos);
							if length(line) > lo(windmax) then
								inc(ypos);
							col := 0;
							line := '';
							if infol then
								Info;
						end
						else if (buf[i] = #12) and (ffsens) then begin
							inc(row);
							OutLn(line);
							inc(ypos, hi(windmax) - 1);
							for col := 1 to hi(windmax) - 1 do
								OutLn('');
							col := 0;
							line := '';
							if infol then
								Info;
						end
						else
							if (buf[i] = #9) and (not filter) then begin
								repeat
									line := line + ' ';
									inc (col);
								until ((col - 1) mod tabsize) = (tabsize - 1);
							end
							else begin
								if (filter) then begin
									if (pos(buf[i], filterstra) > 0) and ((pos(buf[i + 1], filterstra) > 0)
										or ((i > 0) and (pos(buf[i - 1], filterstra) > 0))) then
										line := line + buf[i]
									else
										line := line + '.';
								end
								else if buf[i] in [#0..#8, #11, #14..#31] then
									line := line + ' '
								else
									line := line + buf[i];
								inc (col);
								if col >= maxcolumn then begin
									if col >= xMax then
										Out(line)
									else
										OutLn(line);
									col := 0;
									line := '';
									inc(ypos);
								end;
							end;
					getkey(key);
					{ Space key }
					if (hi(key) = $39) or ((ypos >= yMax - 1) and (paged)) then begin
						ypos := 0;
						if @Out = @__write then
							pause;
					end;
					if (hi(key) = $1f) then begin    { the S key for Skip }
						ypos := 0;
						skip := true;
						break;
					end;
					if (hi(key) = $31) then begin    { the N key for No Pause }
						paged := false;
					end;
					if (hi(key) = $19) then begin    { the P key for Page Mode }
						paged := true;
					end;
					if (hi(key) = $01) then begin    { Esc }
						stop := true;
						break;
					end;
					if (hi(key) = $10) then begin    { Q }
						stop := true;
						break;
					end;
				end;
		until (nr = 0) or (stop) or (skip);
		if line <> '' then
			Out(line);
	end;
	close(fob);
	fopen := false;
	if attrchgd then begin
		attrchgd := false;
		setfattr(fob, fattr);
	end;
	if infol then
		Info;
	if (paged) and (ypos <> 0) and (@Out = @__write) and (wherey >= ymax) then
		pause;
	if infol then begin
		x := wherex;
		y := wherey;
		window(1, 1, lo(windmax) + 1, hi(windmax) + 1);
		clreol;
		gotoxy(x, y + 1);
	end;
end;

begin
	OldTA := TextAttr;
	OldExit := ExitProc;
	ExitProc := @NewExitProc;
	GetVector($1B, Int1B);
	SetVector($1B, Addr(BreakHandler));
	cursoff;
	yMax := Hi(WindMax);
	xMax := Lo(WindMax) + 1;
	padchar := #1;

	if SetDeviceRaw(output) then begin
		Out   := __write;
		OutLn := __writeln;
	end
	else begin
		Out   := PrintStr;
		OutLn := PrintStrLn;
	end;

	for i := 0 to 5 do begin
		ini_return := getIniString('HT', inikeys[i], inidefs[i], inivals[i]);
		if handleIni(ini_return) = 2 then begin
			OutLn('Fatal error during .INI file handling, aborting');
			halt(10);
		end;
		if (i <> 3) then
			inivals[i] := UCaseStr(inivals[i]);
	end;

	if inivals[4] <> '' then
		inivals[1] := inivals[1] + ',' + inivals[4];
	inivals[4] := '';
	if inivals[5] <> '' then
		inivals[3] := inivals[3] + ',' + inivals[5];
	inivals[5] := '';
	inivals[3] := '=' + inivals[3] + ',';

	prgpar := '';
	filer  := '';
	antalfiler := 0;
	for i := 1 to paramcount do begin
		pcs := copy(paramstr(i), 1, 1);
		pc := pcs[1];
		if not (pc in ['-', '/']) then begin
			filer := filer + paramstr(i) + ',';
			inc(antalfiler);
		end
		else
			prgpar := prgpar + '/' + copy(paramstr(i), 2, length(paramstr(i)) - 1);
	end;
	prgpar  := UCaseStr(prgpar);
	filer   := UCaseStr(filer);

	if filer  = '' then
		if pos('/!', prgpar) = 0 then
			prgpar := '/?';

	chkparam(prgpar);

	for i := 1 to antalfiler do begin
		filnamn := getFileName(filer, i);
		fsplit(filnamn, dp, fp, ep);
		filnamn := fp + ep;
		findfirst(dp + filnamn, Archive + ReadOnly + Hidden + SysFile, di);
		if doserror = 18 then
			doserror := 2;
		while doserror = 0 do begin
			runpar := getExternal(dp + di.name);
			if runpar = '' then begin
				extpar  := getExtParams(di.name);
				spcpar  := getSpecParams(di.name);
				if (prgpar = '') and (extpar = '') and (spcpar = '') then
					prgpar := inivals[0];
				chkparam(extpar + spcpar + prgpar);
				readfile(dp + di.name);
			end
			else begin
				goExternal(runpar);
			end;
			if stop = true then begin
				if @Out = @__write then
					textattr := lightred;
				out('***Aborted');
				textattr := lightgray;
				outln(' ');
				doserror := 0;
				exit;
			end;
			findnext(di);
			if doserror <> 18 then
				outln('');
		end;
		case doserror of
			2, 3  :  error('file not found');
			5     :  error('access denied');
			0, 18 :  out('');
		else
			error('unknown error opening file');
		end;
	end;
end.
