
//      Vivid logo with Mandelbrot set and spun-chrome sphere

#include color.vc

studio {
	from -60 -100 35
	at 10 0 5
	up 0 0 1
	angle 16
	res 640 480
	aspect 4/3
	antialias adaptive
	threshold 2
	bkg sky_blue
}

light {
	type point
	falloff 0
	position 0 -20 40
	color .6 .6 .6
}
light {
	type point
	falloff 0
	position 35 -10 30
	color .6 .6 .6
}
light {
	type point
	falloff 0
	position 20 10 50
	color .6 .6 .6
}
light {
	type point
	falloff 0
	position -100 -100 10
	color .3 .3 .3
}

//      base surface

//      Note:   The mandelbrot pattern was put into Vivid almost as a joke.
//              Currently the format for specifying it is terrible.  The
//              first two parameters of the scale value determine the
//              x y scaling of the set while the 3rd parameter determines
//              the maximum number of iterations.  The result of the
//              iteration calculation is then scaled by the max number of
//              iterations to determine the relative percentages of the
//              surface parameters for that point.  Once I figure out a
//              resonable way of doing this Mandelbrot and Julia sets
//              will become a real part of Vivid.

surface {
	texture {
		pattern mandelbrot
		scale .05 .05 64
		offset -1 0 0
		surf { diff white amb .3 .3 .3 }
		surf { diff black }
	}
}
ring {
	location 20 0 -0.5
	normal 0 0 1
	radius 4000
}


//      spun chrome ball

surface {
	bump {
		turbulence {
			scale  25 25 .025    // Note the asymmetric scaling
			amp .25
			terms 1
		}
	}
	diff steel_blue
	spec .4 .4 .5
	shine 30
}

sphere { center 10 20 10 radius 9 }

//      glass sphere

surface {
	trans white
	ior 1.3
	shine 100 .7 .7 .7
}
sphere {
	center 15 -20 4.5
	radius 5
}

//      cluster of reflecting spheres, somewhat of a gold-tone

surf { diff .5 .3 .1 spec .5 .5 .5 shine 400 }
sphere { center 20 16 10 radius 4 }
sphere { center 28 20 12 radius 4 }
sphere { center 32 14  8 radius 4 }
sphere { center 30 10  4 radius 4 }

//      surface for Vivid logo

surface {
	diff white
}

#include vlogo.vo

