/**********************************************************************\
 *
 *	SYSTEM.H
 *
 * System dependencies and configurations for dgrep.
 *
 * Conditional compilation:
 *	ECTYPE  - Includes extended ctype instead of original.
 *	UNIX    - Uses '\n' as end of line character, otherwise uses
 *		  '\r\n'-pair.
 *	BSD     - Defines from SysV library to Bsd, defines also UNIX.
 *	TEST    - Includes routines to display some internal structures
 *		  and defines debug flag 'debug' which controls debug
 *		  displaying. Debug can be set to TRUE with -d option.
 *	MANYREG	- Uses more than two register variables. Defined
 *		  automatically with UNIX and BSD.
 *	TOUCH	- Touches all files that contain matches. Only for Turbo C
 *		  and systems, that contain time(3) and utime(3). Utime(3)
 *		  is supposed to be in every UNIX-system.
 *	FAST	- Makes faster dfa but uses more memory. This doesn't really
 *		  affect to the state machine but to the way how the
 *		  transitions are stored internally.
 *
 * Author: Jarmo Ruuth 17-Mar-1988
 *
 * Copyright (C) 1988-90 by Jarmo Ruuth
 * May be freely copied for any non-commercial usage.
\**********************************************************************/

#include <stdio.h>

#define assert(exp)	if (!(exp)) assertion_failure(__FILE__,__LINE__)

#ifdef ECTYPE

#include <ectype.h>
#define	CHCASE(c)	_diffcase[(unsigned char)(c)]

#else

#include <ctype.h>
#define	CHCASE(c)	(isalpha(c) ? ((c) ^ ('a' ^ 'A')) : (c))

#endif	/* ECTYPE */

#ifdef BSD

#define UNIX 
#define memcpy(dest,src,len)	bcopy(src,dest,len)
#define memcmp(s1,s2,len)	bcmp(s1,s2,len)
extern void* memset(void* b, char ch, unsigned n);
extern void* memchr(void* b, char ch, unsigned n);
extern char* ultoa(unsigned long n, char* s, int radix);
#include <strings.h>

#else

#include <string.h>
#include <process.h>
#include <io.h>
#include <stdlib.h>

#endif	/* BSD */

#ifdef __TURBOC__

#define TOUCH
#include <alloc.h>

#endif	/* TURBOC */

#ifdef M_I86	/* MSC */

#define TOUCH
#include <malloc.h>
#include <sys\types.h>
#include <sys\utime.h>
#include <time.h>
typedef struct utimbuf	utime_t;

#endif	/* MSC */

#if defined(__TURBOC__) || (defined(M_I86) && defined(MSDOS))
#define fputs(s,f)	putstr(s)
#endif

#ifndef max
#define max(x,y)	((x) > (y) ? (x) : (y))
#endif

#ifndef min
#define min(x,y)	((x) < (y) ? (x) : (y))
#endif

#define ERROR		-1

#define CHARBITS	8		/* hardware character bits */
#define NCHARS		(1 << CHARBITS)
#define MAXCHAR		(NCHARS-1)

#define MAXBUF		(1024*24)
#define MAXREGMUST	MAXCHAR

#define REG1	register
#define REG2	register

#ifdef	UNIX

#define O_BINARY        0
#define EOL1		'\n'
#define EOL2		'\n'
#define NEOL(_P)	1
#define ALIGN		4096
#define MANYREG
#define TOUCH

#include <sys/types.h>
#include <time.h>

/* define utime() parameter in MSC style */
typedef struct {
    time_t actime;      /* access time */
    time_t modtime;     /* modification time */
} utime_t;

#else

#define EOL1		'\r'
#define EOL2		'\n'
#define NEOL(_P)	((_P)[1] == EOL2 ? 2 : 1)
#define ALIGN		2048

#endif

#ifdef MANYREG

#define REG3	register
#define REG4	register
#define REG5	register
#define REG6	register

#else

#define REG3
#define REG4
#define REG5
#define REG6

#endif

/* common typedefs */
typedef unsigned char	uchar;
typedef unsigned int	uint;
typedef unsigned long	ulong;
typedef enum {
	FALSE,
	TRUE
} bool;

extern void* malloc(unsigned nbytes);
extern void* calloc(unsigned nelem, unsigned elsize);
extern void* realloc(void* p, unsigned newsize);
extern void  free(void* p);
extern void  d_free(void* ptr);
extern void  error(char* errmsg, int exit_value);
extern void  alloc_buffer(void);
extern bool  set_file_time(char* fname, int h);
extern void  putstr(uchar* str);
extern void  assertion_failure(char* file, int line);

extern uchar*	buffer;
extern unsigned	maxbuf;
