/***
*disked.h - DISKED The DISK EDitor MS(tm)-DOS.
*
*Copyright (c) 1991-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Definitions and declarations.
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

#ifndef GENERAL_H
#include "general.h"
#endif
#ifndef KEYWORDS_H
#include "init.h"
#endif

#define PAUSE   TRUE
#define NOPAUSE FALSE
#define XLATE   TRUE
#define NOXLATE FALSE
#define MAXSTR  63
#define SEARCH  63
#define MAX_DRIVE 26

struct Msg {                  /* generic number input messages */
    char *msg;                /* prompt */
    int len;                  /* length of input (e.g. 3 = 999 max) */
};

/* in SETUP.C */

extern const char * const Version;

/* in DATA.C */

extern char *command_text1[];
extern char *command_text2[];
extern char *signon_text[];
extern char *com_line_text[];
extern char *help_text[];
extern char *dir_help[];

/* in DISKED.C */

extern char curdir[];                  /* current directory each drive */
extern char comspec[];                 /* for shell command */
extern char inifile[];                 /* initialization file name */
extern char savfile[];                 /* save place file name */
extern char promptvar[];               /* DOS prompt variable */
extern int Save,Restore;               /* more switches */
extern int files_indexed;              /* files-indexed flag */
extern int write_to;                   /* double protection on write */
extern unsigned long tagged[10];       /* "tagged" sectors */
extern unsigned int byte_cnt;          /* buffer byte count */
extern unsigned int max_bytes;         /* maximum buffer size */
extern unsigned char *data_buf;        /* pointer to area for data buffer */
extern unsigned char *save_sec;        /* duplicate sector buffer */
extern unsigned char *spare_sec;       /* spare sector buffer */
extern unsigned int dir_cluster;       /* startup directory cluster SETUP.C */
extern long set_sector;                /* startup sector number */
extern int BigScreen;                  /* if 50 line display */

/* in DISKLIB.C */

extern char tmpfstr[];                 /* find string, entry */
extern char findstr[];                 /* find string, actual */
extern unsigned int findlen;           /* find string, length */

/* in SETUP.C */

extern const char *harderr_list[];

/* Function Prototypes */

extern int _access(const char *, int);
#define exist(f)  (_access(f,00)==0)

/* in DISKLIB.C */

extern void ext_commands(void);
extern void commands(void);
extern void signon_msg(void);
extern void dkey(struct Keys *str);
extern void ckey(char *s,struct Keys *str);
extern void psw(char c, struct Keys *str);
extern void header(void);
extern void dumpsector(void);
extern void dumpfilesec(void);
extern int get(struct Msg *str,int *one, int *two);
extern int getl(struct Msg *str,long *one, int *two);
extern int set(struct Msg *str,int *one,int *two,int *three);
extern int view(unsigned char *buffer,unsigned int bfptr,unsigned int bufend,int pause,int base);
extern int find(int val, int get,int kase);
extern void range(int val);
extern void dparams(char *drivedir);
extern void dumpboot(unsigned char *);
extern void help(void);

/* in FILEIO.C */

extern int putfile(char *filename, int xlate, int m, int s, int c);
extern int getfile(char *file,int xlate, int m, int s, int c);
extern int append(int s,int m,int c,unsigned char *buffer,unsigned int nbytes);
extern int putsectors(char *, long, int);
extern int prompt(int n, int base);
extern long filesize(const char *file);

/* in SETUP.C */

extern int setup(char **argv, int drives[], unsigned int *dsk);
extern void startup(char *ccurdir, unsigned int cdisk);
extern void logerror(int i);
extern int newdisk(int tempd);

/* in DEBUG.C */

extern void debug(void);
extern void heapdump(int);

/* in FILETRCK.C */

extern int ft_track;
extern int filetrack(const char *file, const int fnum);
extern void filetell(void);
extern int fileoffset(unsigned int cluster);
extern long filebytes(void);
extern int trackfile(unsigned int *c);
