/*
 * dirent.h:  definitions for SVR3 directory access routines
 */

#ifndef _DIRENT_H
#define _DIRENT_H

#include <sys/types.h>
#include <limits.h>
#include <sys/dirent.h>
#include <sys/proto.h>
#include <sys/null.h>

#ifndef _SIZE_T_DEFINED		/* Need size_t definition		*/
typedef unsigned int	size_t;
#define _SIZE_T_DEFINED
#endif

#define	DIRBUF	8192		/* buffer size for fs-indep. dirs	*/
				/* must in general be larger than the	*/
				/* filesystem buffer size		*/

#ifndef MSDOS
typedef struct
{
    int		dd_fd;		/* file descriptor			*/
    int		dd_loc;		/* offset in block			*/
    int		dd_size;	/* amount of valid data			*/
    char	*dd_buf;	/* -> directory block			*/
} DIR;				/* stream data from opendir()		*/

#else

/* MSDOS versions */

struct _dircontents {
    char		*_d_entry;
    struct _dircontents	*_d_next;
};

typedef struct _dirdesc {
    int			dd_id;	/* uniquely identify each open directory */
    long		dd_loc;	/* where we are in directory entry is this */
    struct _dircontents	*dd_contents;	/* pointer to contents of dir	*/
    struct _dircontents	*dd_cp;		/* pointer to current position	*/
} DIR;
#endif

/* Functions */

extern DIR _FAR_ * _FAR_ _CDECL	opendir	_PROTO ((const char _FAR_ *));
extern struct dirent _FAR_ * _FAR_ _CDECL readdir _PROTO ((DIR _FAR_ *));
extern void _FAR_ _CDECL	rewinddir _PROTO ((DIR _FAR_ *));
#ifndef MSDOS
extern int _FAR_ _CDECL		getdents _PROTO ((int, char _FAR_ *,
						  unsigned int));
#endif
extern int _FAR_ _CDECL		closedir _PROTO ((DIR _FAR_ *));
extern void _FAR_ _CDECL	seekdir	_PROTO ((DIR _FAR_ *, off_t));
extern off_t _FAR_ _CDECL	telldir	_PROTO ((DIR _FAR_ *));

extern int _FAR_ _CDECL		chdir _PROTO ((const char _FAR_ *));
extern char _FAR_ * _FAR_ _CDECL getcwd _PROTO ((char _FAR_ *, int));
extern int _FAR_ _CDECL		mkdir _PROTO ((const char _FAR_ *, mode_t));
extern int _FAR_ _CDECL		rmdir _PROTO ((const char _FAR_ *));
extern int _FAR_ _CDECL		scandir _PROTO ((char _FAR_ *,
						 struct dirent ***,
						 int (_FAR_ _CDECL *)(const void _FAR_ *, const void _FAR_ *),
						 int (_FAR_ _CDECL *)(const void _FAR_ *, const void _FAR_ *)));

#ifdef MSDOS
extern int _FAR_ _CDECL		_chdrive _PROTO ((int));
extern int _FAR_ _CDECL		_getdrive _PROTO ((void));
extern char _FAR_ * _FAR_ _CDECL _getdcwd _PROTO ((int, char _FAR_ *, int));
#ifdef OS2
extern bool			IsHPFSFileSystem _PROTO ((char _FAR_ *));
#endif
#endif
#endif
