**********************************************************************
* Name:		CTIM
* Stack:	( "opcode" --> cycles )
* Desc:		Measure opcode cycle count
* Calls:	TIM, Jazz/ASS
**********************************************************************

DEFINE xASS ROMPTR 3E0 0

ASSEMBLE
	CON(1)	8
RPL
xNAME CTIM
::
  CK1&Dispatch
  str
  ::

    '
    ::
ASSEMBLE
	CON(5)	=DOCSTR
	REL(5)	+
	NIBASC	'CODE\n'			* CODE
	NIBASC	' LC(2) 0\n'			*	Aligner, size=odd
	NIBASC	' GOSBVL #679B\n'		*	GOSBVL	=SAVPTR
	NIBASC	' LC(5) 500\n'			*	500 loops
	NIBASC	' D=C A\n'			*	D[A] = loops
	NIBASC	' D0=(5) #11B\n'		*	D0=(5)	(=IRAM@)-4
	NIBASC	' C=DAT0 A\n'			*
	NIBASC	' LC(4) #100\n'			*
	NIBASC	' D0=C\n'			*	D0 = ->#80100
	NIBASC	' D1=C\n'			*
	NIBASC	' D1=D1+ 1\n'			*	D1 = ->#80101	CC
	NIBASC	'lp'				* lp
+
RPL
      SWAP NEWLINE$&$ "\t" !insert$

      SIX ZERO_DO (DO)				( 64*input )
         DUP !append$
      LOOP
      !append$					( append to header )

ASSEMBLE
	CON(5)	=DOCSTR
	REL(5)	+
	NIBASC	' SETHEX\n'			*	SETHEX
	NIBASC	' D=D-1 A\n'			*	D=D-1	A
	NIBASC	' GOC done\n'			*	GOC	done
	NIBASC	' GOLONG lp\n'			*	GOTO	lp
	NIBASC	'done P= 0\n'			* done	P=	0
	NIBASC	' GOVLNG #5143\n'		*	GOVLNG	=GETPTRLOOP
	NIBASC	'ENDCODE'			* ENDCODE
+
RPL
     !append$					( append trailer )

     RESOROMP xASS EvalNoCK			( prog1 )
     DUP TOTEMPOB				( prog1 prog2 )

     RESOROMP xTIM EvalNoCK			( prog1 tim2 )
     'EvalNoCK: xOBJ> palparse DROPSWAPDROP	( prog1 ticks2 )
     
     SWAP					( ticks2 prog1 )
     CODE
		C=DAT1	A
		?CBIT=1	0
		GOYES	+
+		GOVLNG	=PushT/FLoop
     ENDCODE
     UNROT					( flag ticks2 prog1 )

     RESOROMP xTIM EvalNoCK			( flag ticks2 tim1 )
     'EvalNoCK: xOBJ> palparse DROPSWAPDROP	( flag ticks2 ticks1 )

     ROT ?SWAP					( tickseven ticksodd )
   ;

   1LAMBIND					( $ )

   "CODE\n " OVER !append$ "\nENDCODE" !append$
   RESOROMP xASS EvalNoCK LENHXS		( $ #nibbles )
   UNCOERCE DUPUNROT				( %nibbles $ %nibbles )
   %2 %MOD %0= ITE
   :: "NOP4" NULL$ ;
   :: "\n NOP5" !append$			( *Pad to even nibbles* )
      "NOP4\n\tNOP4"				( *Reference* )
      "NOP4"					( *Null code* )
   ;

   1GETLAM EVAL %+			( $ $ref n1+n2 )
   SWAP 1GETLAM EVAL %+			( $ n1+n2 r1+r2 )
   OVER %-				( $ n1+n2 r1+r2-n1-n2 )
   ROT 1GETABND EVAL			( n1+n2 r1+r2-n1-n2 t1 t2 )
   DUP %+				( n1+n2 r1+r2-n1-n2 t1 2*t2 )
   4PICK %-				( n1+n2 r1+r2-n1-n2 t1 2*t2-n1-n2 )
   3PICK %/				( n1+n2 r1+r2-n1-n2 t1 s2 )
   GX? ITE % 40 % 56 %* %0 RNDXY %4 %/	( n1+n2 r1+r2-n1-n2 t1 c2 )
   4UNROLLDUP %+			( c2 n1+n2 r1+r2-n1-n2 2*t1 )
   ROT %-				( c2 r1+r2-n1-n2 2*t1-n1-n2 )
   SWAP %/				( c2 s1 )
   GX? ITE % 40 % 56 %* %0 RNDXY %4 %/	( c2 c1 )
   SWAP					( c1 c2 )
  ;
;
**********************************************************************




