{$I COMPDIR.PAS}

UNIT UCrc;
INTERFACE

FUNCTION UpdCRC ( c : BYTE ; crc : WORD ) : WORD;
FUNCTION UpdCRCfast ( c : BYTE ; crc : WORD ) : WORD;

IMPLEMENTATION

FUNCTION UpdCRC ( c : BYTE ; crc : WORD ) : WORD;
VAR i : BYTE ;
BEGIN crc := crc XOR ( WORD(c) SHL 8 );
      FOR i := 0 TO 7 DO
       BEGIN
          IF (crc AND $8000) <> 0
          THEN crc := ( crc SHL 1 ) XOR $1021
          ELSE crc := crc SHL 1;
       END;
      UpdCRC := crc AND $FFFF ;
END;

VAR TableCRC16: ARRAY[0..255] OF WORD;

PROCEDURE InitTableCRC16;
VAR i : WORD;
BEGIN FOR i := 0 TO 255 DO TableCRC16[ i ] := UpdCRC( i , 0);
END;


{ Table driven version, after Jerry LeVan (Byte 11/87) }
FUNCTION UpdCRCfast ( c : BYTE ; crc : WORD ) : WORD;
BEGIN UpdCRCfast := TableCRC16[ ((crc SHR 8) XOR c ) AND 255 ] XOR (crc SHL 8);
END;


BEGIN InitTableCRC16;
END.