/* This program converts pictures, drawn with the DRAW48 program, to   */
/* HP48 GROB files. This PX2GROB program works only with those DRAW48  */
/* files that consist of PIXON statements: it will not handle LINE,    */
/* ARC, REPL, SUB commands, *yet*.  As it is, it's a fast GROB compiler.*/

#include <stdio.h>
#include <string.h>
#include <dos.h>
FILE *gr_fl, *drw_fl;                   /* Pointers to the  grob file  */
                                        /* and Draw file structs       */

main(int argc, char **argv)
{
     char table[]="084C2A6E195D3B7F";   /* The screwy GROB table       */
     int grobara[64][136];              /* an array of switches        */
	 char hexstr[2177];                 /* Eventually, use pointers    */
	 char gr_str[2200];                 /* for grobs of any size       */
     char instr[81];
     char ch;
     int r,c,i,p,j;
     
     if(argc != 3)                      /* Check if input and output   */
     {                                  /* filenames are on the command*/
                                        /* line.                       */
          printf("Usage: PX2GROB DRAWfilename GROBfilename"); exit(1);
     }
          
     if((drw_fl=fopen(argv[1],"r"))==NULL)
     {
          printf("Can't open DRAW file %s ", argv[1]); exit(1);
     }
     else  fgets(instr,41,drw_fl);      /* Read first line of Draw-file */
                                        /* which starts the Draw program*/
     if((gr_fl=fopen(argv[2],"w"))==NULL)
     {
          printf("Trouble opening GROB file %s", argv[2]);exit(1);
     }
     else                       /* put the first line in the GROB file. */
     {
          fputs("%%HP: T(3)A(D)F(.);", gr_fl);
          fputs("\n",gr_fl);
          strcpy(gr_str,"GROB 131 64 ");/* start building the grob string*/
     }

     clrscr();      printf("Now processing: one moment...");
     for (r=0;r<64;r++) for(c=0;c<136;c++) grobara[r][c]= 0; /*init array*/

     while (fgets(instr,41,drw_fl) != NULL)/*LOOP to get all lines of the*/
     {                                   /*Draw file.                    */
                                /* check for PIXON;otherwise send errmsg */
                                        /*PIXON statements are the only  */
                                        /*ones able to be processed by   */
                                        /*this here program.             */
          if(strstr(instr,"PIXON")==NULL)
		  {
			   instr[strlen(instr)-1]='\0';  /* Strip off "\n\r"         */
			   printf("\n\" %s \"\n", instr);
               printf("Not able to process the above string.");
          }
          else
          {
                                        /* extract the digits after each */
                                        /* # sign in the PIXON statement.*/
                                        /* These are the column and row  */
                                        /* in the grobara to be set to 1.*/
               sscanf(instr,"%c %c%d %c%d", &ch,&ch,&c,&ch,&r);
               grobara[r][c]=1;
          }
     }
                                        /* Once the array is filled,     */
                                        /* build the "hexstr". Note that */
                                        /* this is really a left-reading */
     i=0;                               /* hex string.                   */

	 for (r=0;r<64;r++)                 /* Loop on rows                  */
     { 
		  for (c=0;c<136;c+=4)          /* inner loop on columns, step 4.*/
               {
					j=0;
					for (p=0;p<4;p++)
                    {
						 j<<=1;         /* Double-dabble method to go    */
						 j+=grobara[r][c+p];  /*from binary to decimal.  */
					}
			   hexstr[i++]=table[j];    /* Look up the character in the  */
			   }                        /* ack-bassward GROB table.      */
	 }
     hexstr[i]='\0';                    /* Convert the array to a string.*/
     strcat(gr_str,hexstr);             /* Add this string to the Grob   */
     fputs(gr_str,gr_fl);               /* string and write this to the  */
     fputs("\n",gr_fl);                 /* grob_file.                    */
     fclose(drw_fl);
     fclose(gr_fl);
	 printf("\n\nFinished processing: your GROB file %s is ready.\n",argv[2]);
}
