
/* util.c */
void correct_underflow(void);
char *get_ext_data(void);
char *get_extra_bit_info(void);


/* video.c */
void init_stats(void);
void PrintAllStats(void);
double ReadSysClock(void);
void PrintTimeInfo(void);
VidStream *NewVidStream(int bufLength);
void DestroyVidStream(VidStream *astream);
PictImage *NewPictImage(unsigned int width, unsigned int height);
void DestroyPictImage(PictImage *apictimage);
void mpegInitVidRsrc(void);
int mpegVidRsrc(TimeStamp time_stamp , VidStream *vid_stream);
void ToggleBFlag(void);
void TogglePFlag(void);

/* parseblock.c */
void ParseReconBlock(int n);
void ParseAwayBlock(int n);

/* motionvector.c */
void ComputeForwVector(int *recon_right_for_ptr, int *recon_down_for_ptr);
void ComputeBackVector(int *recon_right_back_ptr, int *recon_down_back_ptr);

/* decoders.c */
void init_tables(void);

/* main.c */
int get_more_data(unsigned int *buf_start , int max_length , int *length_ptr , unsigned int **buf_ptr);
void int_handler(int);
void main(int argc, char **argv);
void usage(char *s);
void NoDitherImage(unsigned char *l , unsigned char *Cr , unsigned char *Cb , unsigned char *disp , int h , int w);
extern void (*DoDitherImage)(unsigned char *l, unsigned char *Cr, unsigned char *Cb, unsigned char *disp, int h, int w);

/* sjrevdct.s */
// void init_pre_idct(void);
// void j_rev_dct_sparse(DCTBLOCK data, int pos);
void j_rev_dct(DCTBLOCK data);

/* s24bit.s */
void InitColorDither(void);
void ColorDitherImage(unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int rows , int cols);
void ColorDitherImage_lores(unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int rows , int cols);
void ColorDitherImage_12bit(unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int rows , int cols);

/* gray.c */
void GrayDitherImage(unsigned char *lum , unsigned char *cr , unsigned char *cb , unsigned char *out , int h , int w);


/* sutils.s  svideo.s */
int next_start_code(void);

void new_matrix(unsigned short *qscale_1_table);
void recon_non2intra(int zigindex, unsigned short *iqmp, short *reconptr);
void __asm recon_nonintra(register __d0 int qscale, register __d1 int zigindex, register __a1 short *reconptr);
void recon_intra(unsigned short *iqmp, short *reconptr);
int s_get_bits_huff(int numbits, int *intra, short *table);
int sn_get_bits_huff(int numbits, int *intra, short *table);
int s_DecodeCBP(void);
int sn_DecodeCBP(void);
int s_get_byte_huff(int numbits, short *table);
int sn_get_byte_huff(int numbits, short *table);
int __asm s_DecodeDCTCoeff(register __a2 unsigned short *dct_coeff_tbl, register __a0 int *level);
int s_DecodeDCTDCSizeLum(void);
int s_DecodeDCTDCSizeChrom(void);
void s_flush_bits32(void);
void sn_flush_bits32(void);
void s_flush_bits(int num);
void sn_flush_bits(int num);
int s_show_bits32(void);
int sn_show_bits32(void);
int s_show_bitsX(int num);
int sn_show_bitsX(int num);
int s_get_bits1(void);
int sn_get_bits1(void);
int s_get_bitsX(int num);
int sn_get_bitsX(int num);


void clear64words(void *adr);
void __asm PMB2_reconstruct(register __a0 char *dest, register __a1 char *dest1, 
			    register __a2 char *source, register __a3  char *source1,
			    register __d0 int row_incr);
void __asm PMB1_reconstruct(register __a0 char *dest, register __a1 char *source,
			    register __d0 int row_incr);
/*
void __asm IM_reconstruct(register __a0 char *to, register __a1 short *from,
			  register __d0 int row_size);
void __asm BIMcm_reconstruct(register __a0 char *index, register __a1 char *rindex1,
			     register __a2 char *bindex1, register __a3 short *blockvals,
			     register __d0 int row_size);
void __asm BIM_reconstruct(register __a0 char *index, register __a1 char *rindex1,
			   register __a2 char *bindex1, register __d0 int row_size);
void __asm BMcm_reconstruct(register __a0 char *index, register __a1 char *rindex1,
			    register __a2 short *blockvals, register __d0 int row_size);
void __asm BM_reconstruct(register __a0 char *index, register __a1 char *rindex1,
			  register __d0 int row_size);
*/
void __asm RSB4_reconstruct(register __a0 char *dest, register __a1 char *source1,
			    register __a2 char *source2, register __d0 int row_size);
void __asm RSB3_reconstruct(register __a0 char *dest, register __a1 char *source,
			    register __d0 int row_size);
void __asm RSB2_reconstruct(register __a0 char *dest, register __a1 char *source1,
			    register __a2  char *source2, register __d0 int row_size);
void __asm RSB1_reconstruct(register __a0 char *dest, register __a1 char *source,
			    register __d0 int row_size);
void __asm PSB1_reconstruct(register __a0 char *dest, register __a1 char *source,
			    register __d0 int row_incr);
void __asm PSB2_reconstruct(register __a0 char *dest, register __a1 char *dest1, 
			    register __a2 char *source, register __a3  char *source1,
			    register __d0 int row_incr);
void __asm PSB3_reconstruct(register __a0 char *dest, register __a1 char *source1,
			    register __a2  char *source2, register __d0 int row_size);
void __asm PSB4_reconstruct(register __a0 char *dest, register __a1 char *dest1, 
			    register __a2 char *source1, register __a3  char *source2,
			    register __a5 char *source1a, register __a6  char *source2a,
			    register __d0 int row_size);

/* ham8.c */

void HAM8_draw_hires(void *, int, int);
void HAM8_draw_lores(void *, int, int);
void HAM6_draw_lores(void *, int, int);
extern void (*HAM8_draw)(void *, int, int);

void InitColorDisplay(char *name);
void ResizeDisplay(int w, int h);

void InitGrayDisplay(char *name);


/* svid2.s */

void ReconIMBlock(VidStream *vid_stream, int bnum);
void ReconPMBlock(VidStream *vid_stream, int bnum, int recon_right_for, int recon_down_for, int zflag);
void ReconBMBlock(VidStream *vid_stream, int bnum, int recon_right_back, int recon_down_back, int zflag);
void ReconBiMBlock(VidStream *vid_stream, int bnum, int forw_col_start, int forw_row_start, int back_col_start, int back_row_start, int zflag);
