; masm 5.10a
;
; masm tame21;
; link /tiny tame21;
;
; p.fitzsimmons 93/7/24

CSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:CSEG
        ORG 100H

begin:  jmp start
        OLD_2F  dd      ?       ; this is in the code seg!
isr0x2f proc near
        pushf
        cmp ax, 1680h
        je  Mine
        popf
        jmp cs:[old_2f]         ; not for us.  Chain to next 2f handler.
Mine:   popf
        sti
        xor     dx,dx
        mov     ax,1            ; Number of milliseconds in DX:AX, a
                                ; value of 0 means that the current
                                ; timeslice is released.
        hlt                     ; Call OS/2.
        db      35h,0CAh        ; Signature to differentiate between a
                                ; normal HLT-instruction and the call to
                                ; DosSleep().
        iret
isr0x2f endp

start proc near

        mov ax,352fh  ;get int2f adr; returns in es:bx
        int 21h
        mov word ptr cs:OLD_2F+0, bx
        mov word ptr cs:OLD_2F+2, es

        mov  dx, offset isr0x2f
        mov  ax,252fh  ;set int2f adr to ds:dx
        int  21h

        ; t&sr
        mov dx, offset start
        int 27h

start endp

CSEG    ENDS
end     begin
