


KSH(1)                    User commands                    KSH(1)


NNAAMMEE
       ksh - Public domain Korn shell

SSYYNNOOPPSSIISS
       kksshh [++--aabbCCeeffhhiikkmmnnpprrssuuvvxxXX] [++--oo _o_p_t_i_o_n] [ [ --cc _c_o_m_m_a_n_d_-
       _s_t_r_i_n_g [_c_o_m_m_a_n_d_-_n_a_m_e] | --ss | _f_i_l_e ] [_a_r_g_u_m_e_n_t ...] ]

DDEESSCCRRIIPPTTIIOONN
       kksshh is a command interpreter that  is  intended  for  both
       interactive and shell script use.  Its command language is
       a superset of the _s_h(1) shell language.

   SShheellll SSttaarrttuupp
       The following options can be specified only on the command
       line:

       --cc _c_o_m_m_a_n_d_-_s_t_r_i_n_g
              the shell executes the command(s) contained in _c_o_m_-
              _m_a_n_d_-_s_t_r_i_n_g

       --ii     interactive mode -- see below

       --ss     the shell reads commands from standard  input;  all
              non-option arguments are positional parameters

       --rr     restricted mode -- see below

       In addition to the above, the options described in the sseett
       builtin command can also be used on the command line.

       If neither the --cc nor the --ss options  are  specified,  the
       first non-option argument specifies the name of a file the
       shell reads commands from;  if  there  are  no  non-option
       arguments,  the  shell reads commands from standard input.
       The name of the shell  (i.e.,  the  contents  of  the  $$00)
       parameter  is  determined  as follows: if the --cc option is
       used and there is a non-option argument, it is used as the
       name;  if commands are being read from a file, the file is
       used as the name; otherwise the name the shell was  called
       with (i.e., argv[0]) is used.

       A shell is _i_n_t_e_r_a_c_t_i_v_e if the --ii option is used or if both
       standard input and standard error are attached to  a  tty.
       An  interactive  shell  has job control enabled (if avail-
       able), ignores the INT, QUIT and TERM signals, and  prints
       prompts before reading input (see PPSS11 and PPSS22 parameters).
       For non-interactive shells, the ttrraacckkaallll option is  on  by
       default (see sseett command below).

       A  shell  is  rreessttrriicctteedd  if  the  --rr option is used or if
       either the basename of the name the shell is invoked  with
       or the SSHHEELLLL parameter match the pattern *r*sh (e.g., rsh,
       rksh, rpdksh, etc.).  The following restrictions come into
       effect  after  the  shell  processes  any profile and $$EENNVV



                        November 28, 1994                       1





KSH(1)                    User commands                    KSH(1)


       files:
         +o    the ccdd command is disabled
         +o    the SSHHEELLLL, EENNVV and PPAATTHH parameters can't be changed
         +o    command  names  can't be specified with absolute or
              relative paths
         +o    the --pp option of the ccoommmmaanndd builtin can't be used
         +o    redirections that create files can't be used (i.e.,
              >>, >>||, >>>>, <<>>)

       A  shell  is pprriivviilleeggeedd if the --pp option is used or if the
       real user-id or group-id  does  not  match  the  effective
       user-id  or group-id (see _g_e_t_u_i_d(2), _g_e_t_g_i_d(2)).  A privi-
       leged shell does not process $HOME/.profile  nor  the  EENNVV
       parameter  (see below), instead the file /etc/suid_profile
       is processed.  Clearing the privileged option  causes  the
       shell  to set its effective user-id (group-id) to its real
       user-id (group-id).

       If the basename of the  name  the  shell  is  called  with
       (i.e.,  argv[0]) starts with --, the shell is assumed to be
       a login shell and the shell reads and  executes  the  con-
       tents of //eettcc//pprrooffiillee and $$HHOOMMEE//..pprrooffiillee if they exist and
       are readable.

       If the EENNVV parameter is set when the shell starts (or,  in
       the  case  of  login  shells,  after any profiles are pro-
       cessed), its value is subjected to parameter, command  and
       arithmetic substitution and the resulting file (if any) is
       read and executed.

       The exit status of the shell is 127 if  the  command  file
       specified on the command line could not be opened, or non-
       zero if a fatal syntax error occurred during the execution
       of  a  script.   In  the absence of fatal errors, the exit
       status is that of the last command executed, or  zero,  if
       no command is executed.

   CCoommmmaanndd SSyynnttaaxx
       The  shell  begins  parsing  its input by breaking it into
       _w_o_r_ds.  Words, which  are  sequences  of  characters,  are
       delimited  by  unquoted _w_h_i_t_e_-_s_p_a_c_e characters (space, tab
       and newline) or _m_e_t_a_-_c_h_a_r_a_c_t_e_r_s (<<, >>, ||, ;;, &&, (( and  ))).
       Aside  from delimiting words, spaces and tabs are ignored,
       while  newlines  usually  delimit  commands.   The   meta-
       characters  are  used in building the following tokens: <<,
       <<&&, <<<<, >>, >>&&, >>>>, etc. used to specify redirections  (see
       Input/Output   Redirection   below);   ||  used  to  create
       pipelines;  ||&&  used  to  create  co-processes  (see   Co-
       Processes  below);  ;; used to separate commands; && used to
       create asynchronous pipelines; &&&& and |||| used  to  specify
       conditional  execution; ;;;; used in ccaassee statements; (( .. ))
       used to start subshells; and lastly, (((( ..  ))))  which  are
       used in arithmetic expressions;




                        November 28, 1994                       2





KSH(1)                    User commands                    KSH(1)


       White-space and meta-characters can be quoted individually
       using backslash (\\), or in groups using double ("") or sin-
       gle  ('')  quotes.   Note that the following characters are
       also treated specially by the shell and must be quoted  if
       they  are to represent themselves: \\, "", '', ##, $$, ``, ~~, {{,
       }}, **, ?? and [[.  The first three of  these  are  the  above
       mentioned  quoting  characters  (see Quoting below); ##, if
       used at the beginning of a word, introduces a  comment  --
       everything  after  the  ##  up  to  the  nearest newline is
       ignored; $$ is used to  introduce  parameter,  command  and
       arithmetic   substitutions  (see  Substitution  below);  ``
       introduces an old-style command substitution (see  Substi-
       tution  below);  ~~ begins a directory expansion (see Tilde
       Expansion below); {{ and }} delimit  _c_s_h(1)  style  alterna-
       tions  (see Brace Expansion below); and, finally, **, ?? and
       [[ are used in file name generation (see File Name Patterns
       below).

       As words and tokens are parsed, the shell builds commands,
       of which there are two basic types: _s_i_m_p_l_e_-_c_o_m_m_a_n_d_s, typi-
       cally  programs  that are executed, and _c_o_m_p_o_u_n_d_-_c_o_m_m_a_n_d_s,
       such as ffoorr and iiff  statements,  grouping  constructs  and
       function definitions.

       A simple-command consists of some combination of parameter
       assignments (see Parameters below), input/output  redirec-
       tions  (see  Input/Output Redirections below), and command
       words; the only restriction is that parameter  assignments
       come before any command words.  The command words, if any,
       define the command that is to be executed  and  its  argu-
       ments.   The  command  may  be a shell built-in command, a
       function or an _e_x_t_e_r_n_a_l _c_o_m_m_a_n_d,  i.e.,  a  separate  exe-
       cutable file that is located using the PPAATTHH parameter (see
       Command Execution below).   Note  that  all  command  con-
       structs  have  an _e_x_i_t _s_t_a_t_u_s: for external commands, this
       is related to the status returned  by  _w_a_i_t(2);  the  exit
       status  of  other  command  constructs (built-in commands,
       functions, compound-commands, pipelines, lists, etc.)  are
       all  well defined and are described where the construct is
       described.  The exit status of a command  consisting  only
       of  parameter assignments is that of the last command sub-
       stitution performed during  the  parameter  assignment  or
       zero if there were no command substitutions.

       Commands can be chained together using the || token to form
       _p_i_p_e_l_i_n_e_s, in which the standard output  of  each  command
       but  the last is piped (see _p_i_p_e(2)) to the standard input
       of the following command.  The exit status of  a  pipeline
       is  that  of its last command.  A pipeline may be prefixed
       by the !! reserved word which causes the exit status of the
       pipeline  to  be  logically  complemented: if the original
       status was 0 the complemented status will be 1, and if the
       original  status  was  not 0, then the complemented status
       will be 0.



                        November 28, 1994                       3





KSH(1)                    User commands                    KSH(1)


       _L_i_s_t_s of commands can be created by  separating  pipelines
       by  any of the following tokens: &&&&, ||||, &&, ||&& and ;;.  The
       first two are for conditional execution: _c_m_d_1 &&&& _c_m_d_2 exe-
       cutes  _c_m_d_2 only if the exit status of _c_m_d_1 is zero; |||| is
       the opposite -- _c_m_d_2 is executed only if the  exit  status
       of  _c_m_d_1  is  non-zero.   &&&&  and |||| have equal precedence
       which is higher than that of &&, ||&& and ;;, which also  have
       equal  precedence.   The && token causes the preceding com-
       mand to be executed asynchronously,  that  is,  the  shell
       starts  the  command, but does not wait for it to complete
       (the shell does keep track of the status  of  asynchronous
       commands  -- see Job Control below).  When an asynchronous
       command is started when job control is disabled (i.e.,  in
       most scripts), the command is started with signals INT and
       QUIT ignored and  with  input  redirected  from  /dev/null
       (however,  redirections specified in the asynchronous com-
       mand have precedence).   The  ||&&  operator  starts  a  _c_o_-
       _p_r_o_c_e_s_s which is special kind of asynchronous process (see
       Co-Processes below).  Note that a command must follow  the
       &&&& and |||| operators, while a command need not follow &&, ||&&
       and ;;.  The exit status of a list is that of the last com-
       mand  executed,  with the exception of asynchronous lists,
       for which the exit status is 0.

       Compound commands are created used the following  reserved
       words  --  these  words  are  only  recognized if they are
       unquoted and if they are used as the first word of a  com-
       mand  (i.e.,  they  can't be preceded by parameter assign-
       ments or redirections):
                  ccaassee   eellssee   ffuunnccttiioonn   tthheenn    !!
                  ddoo     eessaacc   iiff         ttiimmee    [[[[
                  ddoonnee   ffii     iinn         uunnttiill   {{
                  eelliiff   ffoorr    sseelleecctt     wwhhiillee   }}
       NNoottee:: Some shells (but not ksh) execute control  structure
       commands  in  a  subshell  when  one or more of their file
       descriptors are redirected,  so  any  environment  changes
       inside  them may fail.  To be portable, the eexxeecc statement
       should be used instead to redirect file descriptors before
       the control structure.

       (( _l_i_s_t ))
              Execute  _l_i_s_t  in a subshell.  There is no implicit
              way to pass environment  changes  from  a  subshell
              back to its parent.

       {{ _l_i_s_t }}
              Compound  construct; _l_i_s_t is executed, but not in a
              subshell.   Note  that  {{  and  }}  are  not   meta-
              characters and thus must be distinct words.

       ccaassee _w_o_r_d iinn [ [((] _p_a_t_t_e_r_n [|| _p_a_t_t_e_r_n] ... )) _l_i_s_t ;;;; ] ...
              eessaacc
              The ccaassee statement attempts to match  _w_o_r_d  against
              the  specified  _p_a_t_t_e_r_ns;  the _l_i_s_t associated with



                        November 28, 1994                       4





KSH(1)                    User commands                    KSH(1)


              the first successfully matched pattern is executed.
              Patterns  used  in  ccaassee statements are the same as
              those used for file name patterns except  that  the
              restrictions  regarding  .. and // are dropped.  Note
              that any unquoted space before and after a  pattern
              is  stripped;  any  space  with  a  pattern must be
              quoted.  Both the word and the patterns are subject
              to  parameter, command, and arithmetic substitution
              as well as tilde substitution.  The exit status  of
              a  ccaassee  statement is that of the executed _l_i_s_t; if
              no _l_i_s_t is executed, the exit status is zero.

       ffoorr _n_a_m_e [ iinn _w_o_r_d ... _t_e_r_m ] ddoo _l_i_s_t ddoonnee
              where _t_e_r_m is either a newline or a  ;;.   For  each
              _w_o_r_d in the specified word list, the parameter _n_a_m_e
              is set to the word and _l_i_s_t is executed.  If iinn  is
              not  used  to  specify  a word list, the positional
              parameters ($$11, $$22, etc.) are  used  instead.   The
              exit  status  of  a  ffoorr statement is the last exit
              status of _l_i_s_t; if _l_i_s_t is never executed, the exit
              status is zero.

       iiff _l_i_s_t tthheenn _l_i_s_t [eelliiff _l_i_s_t tthheenn _l_i_s_t] ... [eellssee _l_i_s_t] ffii
              If the exit status of the first _l_i_s_t is  zero,  the
              second _l_i_s_t is executed; otherwise the _l_i_s_t follow-
              ing the eelliiff, if any, is executed with similar con-
              sequences.   If  all the lists following the iiff and
              eelliiffs fail (i.e., exit with non-zero  status),  the
              _l_i_s_t following the eellssee is executed.  The exit sta-
              tus of an iiff statement is that  of  non-conditional
              _l_i_s_t  that  is executed; if no non-conditional _l_i_s_t
              is executed, the exit status is zero.

       sseelleecctt _n_a_m_e [ iinn _w_o_r_d ... _t_e_r_m ] ddoo _l_i_s_t ddoonnee
              where _t_e_r_m is either a newline or a ;;.  The  sseelleecctt
              statement  provides an automatic method of present-
              ing the user with a menu and selecting from it.  An
              enumerated  list of the specified _w_o_r_d_s are printed
              on standard error, followed by a prompt (PPSS33,  nor-
              mally `##?? ').  A number corresponding to one of the
              enumerated words is then read from standard  input,
              _n_a_m_e  is  set  to the selected word (or is unset if
              the selection is not valid), RREEPPLLYY is set  to  what
              was  read,  and  _l_i_s_t is executed.  This process is
              repeated until an end-of-file is read, an interrupt
              is received or a break statement is executed inside
              the loop.  If iinn _w_o_r_d ......  is  omitted,  the  posi-
              tional  parameters  are  used (i.e., $$@@).  The exit
              status of a sseelleecctt statement is  zero  if  a  break
              statement is used to exit the loop, non-zero other-
              wise.

       uunnttiill _l_i_s_t ddoo _l_i_s_t ddoonnee
              This works like wwhhiillee,  except  that  the  body  is



                        November 28, 1994                       5





KSH(1)                    User commands                    KSH(1)


              executed  only  while  the exit status of the first
              _l_i_s_t is non-zero.

       wwhhiillee _l_i_s_t ddoo _l_i_s_t ddoonnee
              A wwhhiillee is a prechecked loop.  Its body is executed
              as  often  as  the exit status of the first _l_i_s_t is
              zero.  The exit status of a wwhhiillee statement is  the
              last  exit  status  of  the _l_i_s_t in the body of the
              loop; if the body is not executed, the exit  status
              is zero.

       ffuunnccttiioonn _n_a_m_e {{ _l_i_s_t }}
              Defines  the  function  _n_a_m_e.  See Functions below.
              Note that redirections specified after  a  function
              definition  are  performed whenever the function is
              executed, not when the function definition is  exe-
              cuted.

       _n_a_m_e (()) _c_o_m_m_a_n_d
              Mostly  the same as ffuunnccttiioonn.  See Functions below.

       (((( _e_x_p_r_e_s_s_i_o_n ))))
              The arithmetic expression _e_x_p_r_e_s_s_i_o_n is  evaluated;
              equivalent  to  lleett  ""_e_x_p_r_e_s_s_i_o_n"".   See Arithmetic
              Expressions and the lleett command below.

       [[[[ _e_x_p_r_e_s_s_i_o_n ]]]]
              Similar to the tteesstt and [[ ... ]] commands (described
              later), with the following exceptions:
                +o    Field splitting and file name generation are
                     not performed on arguments.
                +o    Operators (e.g. --ff,  ==,  !!,  etc.)  must  be
                     unquoted.
                +o    The  second  operand of !!== and == expressions
                     are patterns (e.g.,  the  comparison  in  [[[[
                     ffoooobbaarr == ff**rr ]]]] succeeds)
                +o    There are two additional binary operators: <<
                     and >>  which  return  true  if  their  first
                     string  operand  is  less  than,  or greater
                     than, their second string  operand,  respec-
                     tively.
                +o    The  single  argument  form  of  tteesstt, which
                     tests if the argument has  non-zero  length,
                     is not valid because explicit operators must
                     be always be used.

   QQuuoottiinngg
       Quoting is used to prevent the shell from treating charac-
       ters or words specially.  There are three methods of quot-
       ing: First, \\ quotes the following character, unless it is
       at  the  end  of  a line, in which case both the \\ and the
       newline are stripped.  Second, a single quote  ('')  quotes
       everything  up  to  the  next  single quote (this may span
       lines).  Third, a double quote ("") quotes all  characters,



                        November 28, 1994                       6





KSH(1)                    User commands                    KSH(1)


       except  $$,  `` and \\, up to the next unquoted double quote.
       $$ and `` inside double  quotes  have  their  usual  meaning
       (i.e.,  parameter,  command  or  arithmetic  substitution)
       except no field splitting is carried out on the results of
       double-quoted  substitutions.   If  a  \\  inside a double-
       quoted string is followed by \\, $$, `` or "", it is  replaced
       by  the  second character; if it is followed by a newline,
       both the \\ and the newline are stripped;  otherwise,  both
       the \\ and the character following are unchanged.

       Note:  see  POSIX  Mode below for a special rule regarding
       sequences of the form ""...``...\\""...``.."".

   AAlliiaasseess
       There are two types of aliases: normal command aliases and
       tracked  aliases.   Command aliases are normally used as a
       short hand for a long or often used  command.   The  shell
       expands  command aliases (i.e., substitutes the alias name
       for its value) when it reads the first word of a  command.
       An  expanded  alias  is  re-processed  to  check  for more
       aliases.  If a command alias ends in a space or  tab,  the
       following  word  is also checked for alias expansion.  The
       alias expansion process stops when a word that is  not  an
       alias  is  found,  when  a quoted word is found or when an
       alias word that is currently being expanded is found.

       The following command aliases are defined automatically by
       the shell:
              aauuttoollooaadd==''ttyyppeesseett --uuff''
              ffuunnccttiioonnss==''ttyyppeesseett --ff''
              hhaasshh==''aalliiaass --tt ----''
              hhiissttoorryy==''ffcc --ll''
              iinntteeggeerr==''ttyyppeesseett --ii''
              llooccaall==''ttyyppeesseett''
              llooggiinn==''eexxeecc llooggiinn''
              nneewwggrrpp==''eexxeecc nneewwggrrpp''
              nnoohhuupp==''nnoohhuupp ''
              ppwwdd==''pprriinntt --rr ---- $$PPWWDD''
              rr==''ffcc --ee --''
              ssttoopp==''kkiillll --SSTTOOPP $$$$''
              ssuussppeenndd==''kkiillll --SSTTOOPP $$$$''
              ttyyppee==''wwhheennccee --vv''

       Tracked aliases allow the shell to remember where it found
       a particular command.  The first time  the  shell  does  a
       path  search  for  a  command  that is marked as a tracked
       alias, it saves the full path of the  command.   The  next
       time  the  command is executed, the shell checks the saved
       path to see that it is still  valid,  and  if  so,  avoids
       repeating  the path search.  Tracked aliases can be listed
       and created using aalliiaass --tt.  Note that changing  the  PPAATTHH
       parameter  clears the saved paths for all tracked aliases.
       If the ttrraacckkaallll option is set (i.e., sseett  --oo  ttrraacckkaallll  or
       sseett  --hh),  the  shell tracks all commands.  This option is



                        November 28, 1994                       7





KSH(1)                    User commands                    KSH(1)


       set automatically for non-interactive shells.  For  inter-
       active  shells,  only the following commands are automati-
       cally tracked: ccaatt, cccc, cchhmmoodd, ccpp, ddaattee, eedd, eemmaaccss,  ggrreepp,
       llss, mmaaiill, mmaakkee, mmvv, pprr, rrmm, sseedd, sshh, vvii and wwhhoo.

   SSuubbssttiittuuttiioonn
       The  first  step  the  shell  takes in executing a simple-
       command is to perform substitutions on the  words  of  the
       command.   There  are three kinds of substitution: parame-
       ter, command  and  arithmetic.   Parameter  substitutions,
       which  are  described  in detail in the next section, take
       the form $$nnaammee or $${{...}}; command substitutions  take  the
       form $$((_c_o_m_m_a_n_d)) or ``_c_o_m_m_a_n_d``; and arithmetic substitutions
       take the form $$((((_e_x_p_r_e_s_s_i_o_n)))).

       If a substitution appears outside of  double  quotes,  the
       results  of the substitution are generally subject to word
       or field splitting according to the current value  of  the
       IIFFSS  parameter.   The  IIFFSS  parameter  specifies a list of
       characters which are used to break a string up  into  sev-
       eral  words;  any  characters  from the set space, tab and
       newline that appear in the IFS characters are  called  _I_F_S
       _w_h_i_t_e  _s_p_a_c_e.   Sequences  of  one or more IFS white space
       characters, in combination with zero or one non-IFS  white
       space  characters  delimit  a  field.   As a special case,
       leading and trailing IFS white space is stripped (i.e., no
       leading or trailing empty field is created by it); leading
       or trailing non-IFS  white  space  does  create  an  empty
       field.  Example: if IIFFSS is set to `<space>:', the sequence
       of  characters  `<space>A<space>:<space><space>B::D'  con-
       tains four fields: `A', `B', `' and `D'.  Note that if the
       IIFFSS parameter is set to the null string, no  field  split-
       ting is done; if the parameter is unset, the default value
       of space, tab and newline is used.

       The results of substitution are, unless  otherwise  speci-
       fied, also subject to brace expansion and file name expan-
       sion (see the relevant sections below).

       A command substitution is replaced by the output generated
       by the specified command, which is run in a subshell.  For
       $$((_c_o_m_m_a_n_d)) substitutions, normal quoting  rules  are  used
       when _c_o_m_m_a_n_d is parsed, however, for the ``_c_o_m_m_a_n_d`` form, a
       \\ followed by any of $$, `` or \\ is stripped (a  \\  followed
       by  any  other character is unchanged).  As a special case
       in command substitutions, a command of the form << _f_i_l_e  is
       interpreted  to  mean substitute the contents of _f_i_l_e ($(<
       foo) has the same effect as $(cat foo), but it is  carried
       out more efficiently because no process is started).
       NOTE: $$((_c_o_m_m_a_n_d)) expressions are currently parsed by find-
       ing the matching parenthesis, regardless of quoting.  This
       will hopefully be fixed soon.

       Arithmetic  substitutions are replaced by the value of the



                        November 28, 1994                       8





KSH(1)                    User commands                    KSH(1)


       specified  expression.   For  example,  the  command  eecchhoo
       $$((((22++33**44))))  prints  14.   See Arithmetic Expressions for a
       description of an _e_x_p_r_e_s_s_i_o_n.

   PPaarraammeetteerrss
       Parameters are shell variables; they can be assigned  val-
       ues  and  their  values  can be accessed using a parameter
       substitution.  A parameter name is either one of the  spe-
       cial  single  punctuation  or  digit  character parameters
       described below, or a letter followed by zero or more let-
       ters  or  digits (`_' counts as a letter).  Parameter sub-
       stitutions take the form $$_n_a_m_e or $${{_n_a_m_e}}, where _n_a_m_e is a
       parameter name.  If substitution is performed on a parame-
       ter that is not set, a null string is  substituted  unless
       the  nnoouunnsseett  option (sseett --oo nnoouunnsseett or sseett --uu) is set, in
       which case an error occurs.

       Parameters can be assigned values in  a  number  of  ways.
       First,  the  shell implicitly sets some parameters like ##,
       PPWWDD, etc.; this is the only way the special single charac-
       ter  parameters  are set.  Second, parameters are imported
       from the shell's environment at startup.   Third,  parame-
       ters can be assigned values on the command line, for exam-
       ple, `FFOOOO==bbaarr' sets the parameter  FOO  to  bar;  multiple
       parameter  assignments  can  be  given on a single command
       line and they can be  followed  by  a  simple-command,  in
       which  case  the  assignments  are  in effect only for the
       duration  of  the  command  (such  assignments  are   also
       exported,  see below for implications of this).  Note that
       both the parameter name and the == must be unquoted for the
       shell to recognize a parameter assignment.  The fourth way
       of setting a parameter is with the  eexxppoorrtt,  rreeaaddoonnllyy  and
       ttyyppeesseett  commands;  see  their descriptions in the Command
       Execution section.  Fifth, ffoorr and sseelleecctt loops set param-
       eters  as  well  as the ggeettooppttss, rreeaadd and sseett --AA commands.
       Lastly, parameters can be assigned values using assignment
       operators  inside  arithmetic  expressions (see Arithmetic
       Expressions below) or using the $${{_n_a_m_e[::]==_v_a_l_u_e}}  form  of
       parameter substitution (see below).

       Parameters with the export attribute (set using the eexxppoorrtt
       or ttyyppeesseett --xx commands, or by parameter  assignments  fol-
       lowed  by simple commands) are put in the environment (see
       _e_n_v_i_r_o_n(5)) of commands run by  the  shell  as  _n_a_m_e==_v_a_l_u_e
       pairs.   The order in which parameters appear in the envi-
       ronment of a  command  is  unspecified.   When  the  shell
       starts  up,  it  extracts parameters and their values from
       its  environment  and  automatically   sets   the   export
       attribute for those parameters.

       Modifiers  can be applied to the $${{_n_a_m_e}} form of parameter
       substitution:





                        November 28, 1994                       9





KSH(1)                    User commands                    KSH(1)


       $${{_n_a_m_e::--_w_o_r_d}}
              if _n_a_m_e is set and not  null,  it  is  substituted,
              otherwise _w_o_r_d is substituted.

       $${{_n_a_m_e::++_w_o_r_d}}
              if  _n_a_m_e  is set and not null, _w_o_r_d is substituted,
              otherwise nothing is substituted.

       $${{_n_a_m_e::==_w_o_r_d}}
              if _n_a_m_e is set and not  null,  it  is  substituted,
              otherwise  it  is  assigned  _w_o_r_d and the resulting
              value of _n_a_m_e is substituted.

       $${{_n_a_m_e::??_w_o_r_d}}
              if _n_a_m_e is set and not  null,  it  is  substituted,
              otherwise  _w_o_r_d  is printed on standard error (pre-
              ceded by _n_a_m_e:) and an error occurs (normally caus-
              ing  termination  of  a  shell  script, function or
              .-script).  If word is omitted the string  `parame-
              ter null or not set' is used instead.

       In  the  above  modifiers,  the :: can be omitted, in which
       case the conditions only depend  on  _n_a_m_e  being  set  (as
       opposed  to  set  and not null).  In addition to brace and
       file name expansion, tilde expansion is also performed  on
       _w_o_r_d.   Also,  _w_o_r_d  is evaluated only if the condition is
       true (e.g., eecchhoo $${{vv--$$((sslleeeepp 1100;; eecchhoo  hhii))}}  will  immedi-
       ately  print  the  value  of vv if it is set, otherwise, it
       will sleep for 10 seconds and print hi).

       The following forms of parameter substitution can also  be
       used:

       $${{##_n_a_m_e}}
              The number of positional parameters if _n_a_m_e is ** or
              @@, the number of elements in  the  named  array  if
              _n_a_m_e  is  an  array,  or finally, the length of the
              string value of parameter _n_a_m_e.

       $${{_n_a_m_e##_p_a_t_t_e_r_n}}, $${{_n_a_m_e####_p_a_t_t_e_r_n}}
              If _p_a_t_t_e_r_n matches the beginning of  the  value  of
              parameter  _n_a_m_e,  the  matched text is deleted from
              the result of substitution.  A single ## results  in
              the  shortest match, two ##'s results in the longest
              match.

       $${{_n_a_m_e%%_p_a_t_t_e_r_n}}, $${{_n_a_m_e%%%%_p_a_t_t_e_r_n}}
              Like $${{..##..}} substitution, but it deletes from the
              end of the value.

       The following special parameters are implicitly set by the
       shell and cannot be set directly using assignments:

       !!      Process id of the last background process  started.



                        November 28, 1994                      10





KSH(1)                    User commands                    KSH(1)


              If  no  background processes have been started, the
              parameter is not set.

       ##      The number of positional parameters (i.e., $$11,  $$22,
              etc.).

       $$      The  process  ID  of  the  shell, or the PID of the
              original shell if it is a subshell.

       --      The concatenation  of  the  current  single  letter
              options   (see   sseett  command  below  for  list  of
              options).

       ??      The exit status of the last  non-asynchronous  com-
              mand executed.  If the last command was killed by a
              signal, $$?? is set to 128 plus the signal number.

       00      The  name  the  shell  was  invoked   with   (i.e.,
              aarrggvv[[00]]),  or  the  ccoommmmaanndd--nnaammee  if it was invoked
              with the --cc option and the  ccoommmmaanndd--nnaammee  was  sup-
              plied,  or  the  _f_i_l_e argument, if it was supplied.
              In functions and ..-scripts, $$00 is the name  of  the
              function or script, respectively.

       11 ... 99
              The first nine positional parameters that were sup-
              plied to the shell, function or ..-script.   Further
              positional  parameters may be accessed using $${{_n_u_m_-
              _b_e_r}}.

       **      All positional parameters (except parameter 0) con-
              catenated to one string.

       @@      Same as $$**, unless it is used inside double quotes,
              in which case a separate word is generated for each
              positional  parameter  - if there are no positional
              parameters, no word is generated ("$@" can be  used
              to  access arguments, verbatim, without losing null
              arguments or splitting arguments with spaces).

       The following parameters are set and/or used by the shell:

       __ _(_u_n_d_e_r_s_c_o_r_e_)
              In  interactive  use,  this parameter is set to the
              last word of the previous command.  When a  command
              is executed, this parameter is set to the full path
              of the command and is placed in the command's envi-
              ronment.   When  MMAAIILLPPAATTHH  messages  are evaluated,
              this parameter contains the name of the  file  that
              changed (see MMAAIILLPPAATTHH parameter below).

       CCDDPPAATTHH Search path for the ccdd built-in command.  Works the
              same way as PPAATTHH for those directories  not  begin-
              ning with // in ccdd commands.



                        November 28, 1994                      11





KSH(1)                    User commands                    KSH(1)


       CCOOLLUUMMNNSS
              Set  to  the  number  of columns on the terminal or
              window.   Currently  set  to  the  ccoollss  value   as
              reported  by  _s_t_t_y(1)  if  that  value is non-zero.
              This parameter is  used  by  the  interactive  line
              editing  modes,  and  by sseelleecctt, sseett --oo and kkiillll --ll
              commands to format information in columns.

       EEDDIITTOORR If the VVIISSUUAALL parameter is not set, this  parameter
              controls the command line editing mode for interac-
              tive shells.  See VVIISSUUAALL parameter  below  for  how
              this works.

       EENNVV    If this parameter is found to be set after any pro-
              file files are executed, the expanded value is used
              as  a  shell  start-up file.  It typically contains
              function and alias definitions.

       EERRRRNNOO  Integer value of the shell's errno variable - indi-
              cates the reason the last system call failed.

              Not implemented yet.

       EEXXEECCSSHHEELLLL
              If  set,  this  parameter is assumed to contain the
              shell that is to be used to execute  commands  that
              _e_x_e_c_v_e(2)  fails  to execute and which do not start
              with a `##!! _s_h_e_l_l' sequence.

       FFCCEEDDIITT The editor used by the ffcc command.

       FFPPAATTHH  Like PPAATTHH, but used when an undefined  function  is
              executed  to locate the file defining the function.
              It is also searched when a command can't  be  found
              using  PPAATTHH.  See Functions below for more informa-
              tion.

       HHIISSTTFFIILLEE
              The name of the file used to store  history.   When
              assigned  to,  history is loaded from the specified
              file.  Also, several invocations of the shell  run-
              ning  on  the  same  machine  will share history if
              their HHIISSTTFFIILLEE parameters all  point  at  the  same
              file.

       HHIISSTTSSIIZZEE
              The number of commands normally stored for history,
              default 128.

       HHOOMMEE   The default directory for the ccdd  command  and  the
              value  substituted  for an unqualified ~~ (see Tilde
              Expansion below).

       IIFFSS    Internal field separator, used during  substitution



                        November 28, 1994                      12





KSH(1)                    User commands                    KSH(1)


              and  by the rreeaadd command, to split values into dis-
              tinct arguments; normally set  to  space,  tab  and
              newline.  See Substitution above for details.
              NNoottee:: this parameter is not imported from the envi-
              ronment when the shell is started.

       KKSSHH__VVEERRSSIIOONN
              The version of shell and the date the  version  was
              created (readonly).

       LLIINNEENNOO The  line  number  of  the function or shell script
              that is currently being executed.

              Not implemented yet.

       LLIINNEESS  Set to the number of lines on the terminal or  win-
              dow.

              Not implemented yet.

       MMAAIILL   If set, the user will be informed of the arrival of
              mail in the named file.  This parameter is  ignored
              if the MMAAIILLPPAATTHH parameter is set.

       MMAAIILLCCHHEECCKK
              How  often,  in  seconds,  the shell will check for
              mail in the file(s) specified by MMAAIILL or  MMAAIILLPPAATTHH.
              If  0,  the  shell  checks before each prompt.  The
              default is 600 (5 minutes).

       MMAAIILLPPAATTHH
              A list of files to be checked for mail.   The  list
              is  colon  separated, and each file may be followed
              by a ?? and a message to be printed if new mail  has
              arrived.   Command  and  parameter  substitution is
              performed on the message, and, during substitution,
              the  parameter  $$__  contains  the name of the file.
              The default message is yyoouu hhaavvee mmaaiill iinn $$__.

       OOLLDDPPWWDD The previous working directory.  Unset  if  ccdd  has
              not  successfully  changed  directories  since  the
              shell started (readonly).

       OOPPTTAARRGG When using ggeettooppttss, it contains the argument for  a
              parsed option, if it requires one.

       OOPPTTIINNDD The index of the last argument processed when using
              ggeettooppttss.  Assigning  1  to  this  parameter  causes
              ggeettooppttss to process arguments from the beginning the
              next time it is invoked.

       PPAATTHH   A colon separated  list  of  directories  that  are
              searched  when  looking for commands and ..'d files.
              An  empty  string  resulting  from  a  leading   or



                        November 28, 1994                      13





KSH(1)                    User commands                    KSH(1)


              trailing  colon,  or two adjacent colons is treated
              as a `.', the current directory.

       PPOOSSIIXXLLYY__CCOORRRREECCTT
              If set, this parameter causes the ppoossiixx  option  to
              be enabled.  See POSIX Mode below.

       PPPPIIDD   The process ID of the shell's parent (readonly).

       PPSS11    PPSS11  is  the primary prompt for interactive shells.
              Parameter, command and arithmetic substitutions are
              performed,  and !! is replaced with the current com-
              mand number (see ffcc  command  below).   Default  is
              `$$ '.

       PPSS22    Secondary prompt string, by default `>> ', used when
              more input is needed to complete a command.

       PPSS33    Prompt used by sseelleecctt statement when reading a menu
              selection.  Default is `##?? '.

       PPSS44    Used  to  prefix  commands  that are printed during
              execution  tracing  (see  sseett  --xx  command  below).
              Parameter, command and arithmetic substitutions are
              performed before it is printed.

       PPWWDD    The current working directory (readonly).

       RRAANNDDOOMM A simple random number generator.  Every time  RRAANN--
              DDOOMM  is  referenced, it is assigned the next number
              in a random number series.  The point in the series
              can  be  set  by  assigning a number to RRAANNDDOOMM (see
              _r_a_n_d(3)).

       RREEPPLLYY  Default parameter for the rreeaadd command if no  names
              are  given.  Also used in sseelleecctt loops to store the
              value that is read from standard input.

       SSEECCOONNDDSS
              The number of seconds since the shell  started  or,
              if  the  parameter  has  been  assigned  an integer
              value, the number of seconds since  the  assignment
              plus the value that was assigned.

       TTMMOOUUTT  If  set  to  a  positive  integer in an interactive
              shell, it specifies the maximum number  of  seconds
              the  shell  will  wait for input after printing the
              primary prompt (PPSS11).  If the time is exceeded, the
              shell exits.

       TTMMPPDDIIRR The directory shell temporary files are created in.
              If this parameter is not set, or does  not  contain
              the  absolute  path of a writable directory, tempo-
              rary files are created in //ttmmpp.



                        November 28, 1994                      14





KSH(1)                    User commands                    KSH(1)


       VVIISSUUAALL If set, this parameter controls  the  command  line
              editing  mode  for interactive shells.  If the last
              component of the path specified in  this  parameter
              contains  the  string  vvii,  eemmaaccss or ggmmaaccss, the vi,
              emacs or gmacs  (Gosling  emacs)  editing  mode  is
              enabled, respectively.

   TTiillddee EExxppaannssiioonn
       Tilde  expansion, which is done in parallel with parameter
       substitution, is done on words starting with  an  unquoted
       ~~.  The characters following the tilde, up to the first //,
       if any, are assumed to be a login name.  If the login name
       is  empty,  ++  or --, the value of the HHOOMMEE, PPWWDD, or OOLLDDPPWWDD
       parameter is substituted,  respectively.   Otherwise,  the
       password  file  is  searched  for  the login name, and the
       tilde expression  is  substituted  with  the  user's  home
       directory.  If the login name is not found in the password
       file or if any quoting or parameter substitution occurs in
       the login name, no substitution is performed.

       In parameter assignments (those preceding a simple-command
       or those occurring in the arguments of aalliiaass, eexxppoorrtt rreeaadd--
       oonnllyy,  and  ttyyppeesseett),  tilde  expansion  is done after any
       unquoted colon (::), and login names are also delimited  by
       colons.

       The  home directory of previously expanded login names are
       cached and re-used.  The aalliiaass --dd command may be  used  to
       list,  change  and  add  to  this  cache  (e.g., `alias -d
       fac=/usr/local/facilities; cd ~fac/bin').

   BBrraaccee EExxppaannssiioonn ((aalltteerrnnaattiioonn))
       Brace expressions, which take the form
                      _p_r_e_f_i_x {{_s_t_r1,,...,,_s_t_rN}}_s_u_f_f_i_x
       are expanded to N words, each of which is  the  concatena-
       tion  of  _p_r_e_f_i_x,  _s_t_ri and _s_u_f_f_i_x (e.g., `a{c,b{X,Y},d}e'
       expands to four word: ace, abXe, abYe, and ade).  As noted
       in  the  example,  brace expressions can be nested and the
       resulting words are not sorted.   Brace  expressions  must
       contain  an  unquoted  comma  (,,)  for  expansion to occur
       (i.e., {{}} and {{ffoooo}} are not expanded).  Brace expansion is
       carried  out  after parameter substitution and before file
       name generation.

   FFiillee NNaammee PPaatttteerrnnss
       A file name pattern is  a  word  containing  one  or  more
       unquoted  ?? or ** characters or [[..]] sequences.  Once brace
       expansion has been performed, the shell replaces file name
       patterns with the sorted names of all the files that match
       the  pattern  (if  no  files  match,  the  word  is   left
       unchanged).  The pattern elements have the following mean-
       ing:

       ??      matches any single character.



                        November 28, 1994                      15





KSH(1)                    User commands                    KSH(1)


       **      matches any sequence of characters.

       [[..]]   matches any of the characters inside the  brackets.
              Ranges of characters can be specified by separating
              two characters by a --,  e.g.,  [[aa00--99]]  matches  the
              letter  aa  or  any  digit.   In  order to represent
              itself, a -- must either be quoted or the  first  or
              last character in the character list.  Similarly, a
              ]] must be quoted or the first character in the list
              if it is represent itself instead of the end of the
              list.  Also, a !!  appearing at  the  start  of  the
              list  has special meaning (see below), so to repre-
              sent itself it must be quoted or  appear  later  in
              the list.

       [[!!..]]  like  [[..]],  except  it  matches  any character not
              inside the brackets.

       Note that pdksh currently never matches .. and ...., but  the
       original  ksh,  Bourne sh and bash do, so this may have to
       change (too bad).

       Note that none of the above pattern elements match  either
       a  period (..)  at the start of a file name or a slash (//),
       even if they are explicitly used in a [[..]] sequence; also,
       the names .. and ....  are never matched, even by the pattern
       ..**.

       If the mmaarrkkddiirrss option is set, any directories that result
       from file name generation are marked with a trailing //.

       The  ??((_p_a_t_t_e_r_n_-_l_i_s_t)),  **((_p_-_l)),  ++((_p_-_l)),  @@((_p_-_l)) and !!((_p_-_l))
       elements found in the original  Korn  shell  are  not  yet
       implemented;  the  same  is  true  for the POSIX character
       classes (i.e., [[::_c_l_a_s_s_-_n_a_m_e::]] inside a [[..]] expression).

   IInnppuutt//OOuuttppuutt RReeddiirreeccttiioonn
       When a command is executed, its standard  input,  standard
       output  and  standard  error (file descriptors 0, 1 and 2,
       respectively)  are  normally  inherited  from  the  shell.
       Three  exceptions  to  this are commands in pipelines, for
       which standard input and/or standard output are those  set
       up by the pipeline, asynchronous commands created when job
       control is disabled, for which standard input is initially
       set  to  be  from //ddeevv//nnuullll, and commands for which any of
       the following redirections have been specified:

       >> _f_i_l_e standard output is redirected  to  _f_i_l_e.   If  _f_i_l_e
              does not exist, it is created; if it does exist and
              the nnoocclloobbbbeerr option is set, an error occurs,  oth-
              erwise the file is truncated.  Note that this means
              the command _c_m_d _< _f_o_o _> _f_o_o will open _f_o_o for read-
              ing and then truncate it when it opens it for writ-
              ing, before _c_m_d gets a chance to actually read _f_o_o.



                        November 28, 1994                      16





KSH(1)                    User commands                    KSH(1)


       >>|| _f_i_l_e
              same  as  >>,  except the file is truncated, even if
              the nnoocclloobbbbeerr option is set.

       >>>> _f_i_l_e
              same as >>, except the  file  an  existing  file  is
              appended  to instead of being truncated.  Also, the
              file is opened in append mode, so writes always  go
              to the end of the file (see _o_p_e_n(2)).

       << _f_i_l_e standard  input  is  redirected from _f_i_l_e, which is
              opened for reading.

       <<>> _f_i_l_e
              same as <<, except the file is  opened  for  reading
              and writing.

       <<<< _m_a_r_k_e_r
              after reading the command line containing this kind
              of redirection (called a here document), the  shell
              copies  lines from the command source into a tempo-
              rary file until a line  matching  _m_a_r_k_e_r  is  read.
              When  the  command  is  executed, standard input is
              redirected from the temporary file.  If _m_a_r_k_e_r con-
              tains  no  quoted  characters,  the contents of the
              temporary file are processed as if enclosed in dou-
              ble  quotes  each  time the command is executed, so
              parameter, command and arithmetic substitutions are
              performed,  along with backslash (\\) escapes for $$,
              ``, \\ and \\nneewwlliinnee.  If multiple here documents  are
              used  on  the  same command line, they are saved in
              order.

       <<<<-- _m_a_r_k_e_r
              same as <<<<, except leading tabs are  stripped  from
              lines in the here document.

       <<&& _f_d  standard  input  is duplicated from file descriptor
              _f_d.  _f_d can be a single digit, indicating the  num-
              ber  of  an existing file descriptor, the letter pp,
              indicating the file descriptor associated with  the
              output  of the current co-process, or the character
              --, indicating standard input is to be closed.

       >>&& _f_d  same as <<&&, except the operation is done  on  stan-
              dard output.

       In any of the above redirections, the file descriptor that
       is redirected (i.e., standard input  or  standard  output)
       can  be explicitly given by preceding the redirection with
       a single digit.  Parameter, command and arithmetic substi-
       tutions,  tilde substitutions and file name generation are
       all performed on the _f_i_l_e,  _m_a_r_k_e_r  and  _f_d  arguments  of
       redirections.   Note however, that the results of any file



                        November 28, 1994                      17





KSH(1)                    User commands                    KSH(1)


       name generation are only used if a single file is matched;
       if multiple files match, the word with the unexpanded file
       name  generation  characters  is  used.   Note   that   in
       restricted  shells,  redirections  which  can create files
       cannot be used.

       For simple-commands, redirections may appear  anywhere  in
       the  command, for compound-commands (iiff statements, etc.),
       redirections must appear at  the  end.   Redirections  are
       processed  after  pipelines  are  created and in the order
       they are given, so
                 ccaatt //ffoooo//bbaarr 22>>&&11 >> //ddeevv//nnuullll || ccaatt --nn
       will print an error with a line number prepended to it.

   AArriitthhmmeettiicc EExxpprreessssiioonnss
       Integer arithmetic expressions can be used  with  the  lleett
       command, inside $$((..)) expressions, inside array references
       (e.g., _n_a_m_e[[_e_x_p_r]]), as numeric arguments to the tteesstt  com-
       mand,  and  as  the  value  of an assignment to an integer
       parameter.

       Expression may  contain  alpha-numeric  parameter  identi-
       fiers,  array references, and integer constants and may be
       combined with the following operators (listed and  grouped
       in increasing order of precedence).

       Unary operators:
              ++ -- !! ~~

       Binary operators:
              == **== //== %%== ++== --== <<<<== >>>>== &&== ^^== ||==, ||||, &&&&, ||, ^^, &&,
              ==== !!==, << <<== >>== >>, <<<< >>>>, ++ --, ** // %%

       Ternary operators:
              ?? :: (precedence is between that of  binary  assign-
              ment and |||| operators)

       Grouping operators:
              (( ))

       Integer  constants  may  be specified with arbitrary bases
       using the notation _b_a_s_e##_n_u_m_b_e_r, where _b_a_s_e  is  a  decimal
       integer specifying the base, and _n_u_m_b_e_r is a number in the
       specified base.

   CCoo--PPrroocceesssseess
       A Co-process, which is a  pipeline  created  with  the  ||&&
       operator,  is  an  asynchronous process that the shell can
       both write to (using pprriinntt --pp) and read from  (using  rreeaadd
       --pp).  Only one co-process may be active at any given time,
       unless the input of an existing co-process has been dupli-
       cated  using  a  >>&&pp redirection.  In this case, the shell
       closes its copy of the co-process input (note that  a  <<&&pp
       redirection  does not cause the shell to close its copy of



                        November 28, 1994                      18





KSH(1)                    User commands                    KSH(1)


       the co-process output).  Once rreeaadd --pp has read the end-of-
       file, the co-process input is closed, and further attempts
       to read will produce diagnostics.  Similarly,  once  pprriinntt
       --pp fails due to an EPIPE, the co-process output is closed.
       Note also, that pprriinntt --pp will ignore SIGPIPE signals  dur-
       ing  writes if the signal is not being trapped or ignored;
       the same is not true if  the  co-process  input  has  been
       duplicated  to  another  file  descriptor and pprriinntt --uu_n is
       used.

       If another co-process is started before doing  a  read  or
       <<&&pp  redirection from existing co-processes, the output of
       the co-processes will be shared (e.g.,  eecchhoo  hhii  ||&&  eecchhoo
       tthheerree||&&  ccaatt  <<&&pp will print both "hi" and "there").  This
       is slightly different from  the  original  Korn  shell  in
       which  output is shared as long as the existing co-process
       job has not exited.  As a side affect, end-of-file can not
       be  read reliably in the original Korn shell (e.g., if the
       co-process closes its output but does not exit, the end of
       file will not be read).

   FFuunnccttiioonnss
       Functions  are  defined  using  either Korn shell ffuunnccttiioonn
       _n_a_m_e syntax or the Bourne/POSIX shell _n_a_m_e(())  syntax.   At
       the  moment,  there  is no difference between the two, but
       see below.  Functions are like ..-scripts in that they  are
       executed  in  the  current  environment,  however,  unlike
       ..-scripts, shell arguments (i.e.,  positional  parameters,
       $$11,  etc.)  are never visible inside them.  When the shell
       is determining the location of as command,  functions  are
       searched after special built-in commands, and before regu-
       lar and non-regular built-ins,  and  before  the  PPAATTHH  is
       searched.

       An  existing  function may be deleted using uunnsseett --ff _f_u_n_c_-
       _t_i_o_n_-_n_a_m_e.  A list of  functions  can  be  obtained  using
       ttyyppeesseett  ++ff  and  the  function  definitions can be listed
       using ttyyppeesseett --ff.  aauuttoollooaadd (which is an alias for ttyyppeesseett
       --ffuu)  may  be  used to create undefined functions; when an
       undefined function is executed,  the  shell  searches  the
       path  specified in the FFPPAATTHH parameter for a file with the
       same name as the function, which, if  found  is  read  and
       executed.  If after executing the file, the named function
       is found to be defined, the function is  executed,  other-
       wise,  the  normal  command search is continued (i.e., the
       shell searches the builtin-command table and PPAATTHH).   Note
       that  if  a command is not found using PPAATTHH, an attempt is
       made to autoload a function using FFPPAATTHH (this is an undoc-
       umented feature of the original Korn shell).

       Functions can have two attributes, trace and export, which
       can be set with ttyyppeesseett --fftt and ttyyppeesseett --ffxx, respectively.
       When  a  traced  function  is executed, the shell's xxttrraaccee
       option is turned on for the functions duration,  otherwise



                        November 28, 1994                      19





KSH(1)                    User commands                    KSH(1)


       the  xxttrraaccee option is turned off.  The export attribute of
       functions is currently not used.   In  the  original  Korn
       shell,  exported  functions  are  visible to shell scripts
       that are executed.

       Since functions are executed in the current shell environ-
       ment, parameter assignments made inside functions are vis-
       ible after the function completes.  If  this  is  not  the
       desired  effect,  the ttyyppeesseett command can be used inside a
       function to create a local parameter.  Note  that  special
       parameters (e.g., $$$$, $$!!) can't be scoped in this way.

       The  exit status of a function is that of the last command
       executed in the function.  A function can be made to  fin-
       ish immediately using the rreettuurrnn command; this may also be
       used to explicitly specify the exit status.

       In future, functions defined  with  the  ffuunnccttiioonn  keyword
       will  be  treated  differently than functions defined with
       the (()) notation:
         +o    A separate trap/signal environment is  used  during
              the  execution  of functions.  This means traps set
              inside a function do not affect the  shell's  traps
              and  signals that are not ignored in the shell (but
              may be trapped) have  their  default  effect  in  a
              function.
         +o    The  EXIT  trap,  if set in a function, is executed
              after the function returns.
         +o    the $$00 parameter will be set to  the  name  of  the
              function  (this  is  currently  the  case  for both
              styles of function).

   PPOOSSIIXX MMooddee
       pdksh is intended to be POSIX compliant, however, in  some
       cases,  POSIX behaviour is contrary either to the original
       Korn shell behaviour or  to  user  convenience.   How  the
       shell behaves in these cases is determined by the state of
       the posix option (sseett --oo ppoossiixx) -- if it is on, the  POSIX
       behaviour  is  followed,  otherwise  it  isn't.  The ppoossiixx
       option is set automatically when the shell  starts  up  if
       the  environment  contains  the PPOOSSIIXXLLYY__CCOORRRREECCTT parameter.
       (pdksh can also be compiled so that it is in POSIX mode by
       default, however this is usually not desirable).

       The following is a list of things that are affected by the
       state of the ppoossiixx option:
         +o    \\"" inside double quoted ``..`` command substitutions:
              in  posix mode, the \\"" is interpreted when the com-
              mand is interpreted; in non-posix mode,  the  back-
              slash  is  stripped before the command substitution
              is interpreted.  For example, eecchhoo ""``eecchhoo  \\""hhii\\""``""
              produces  `"hi"'  in  posix mode, `hi' in non-posix
              mode.  To avoid problems, use the $$((......)   form  of
              command substitution.



                        November 28, 1994                      20





KSH(1)                    User commands                    KSH(1)


         +o    kkiillll  --ll  output:  in  posix mode, signal names are
              listed one a single line; in non-posix mode, signal
              numbers,  names  and  descriptions  are  printed in
              columns.  In future, a new option (--vv perhaps) will
              be added to distinguish the two behaviours.
         +o    ffgg exit status: in posix mode, the exit status is 0
              if no errors occur; in  non-posix  mode,  the  exit
              status is that of the last foregrounded job.
         +o    ggeettooppttss:  in  posix mode, options must start with a
              --; in non-posix mode, options can start with either
              -- or ++.
         +o    brace  expansion  (also  known  as alternation): in
              posix mode, brace expansion is  disabled;  in  non-
              posix mode, brace expansion enabled.  Note that sseett
              --oo ppoossiixx (or setting the PPOOSSIIXXLLYY__CCOORRRREECCTT parameter)
              automatically  turns  the  bbrraacceeeexxppaanndd  option off,
              however it can be explicitly turned on later.
         +o    sseett --: in posix mode, this does not clear the  vveerr--
              bboossee or xxttrraaccee options; in non-posix mode, it does.
         +o    sseett exit status: in posix mode, the exit status  of
              set is 0 if there are no errors; in non-posix mode,
              the exit status is that of  any  command  substitu-
              tions performed in generating the set command.  For
              example, `sseett ---- ``ffaallssee``;;  eecchhoo  $$??'  prints  0  in
              posix mode, 1 in non-posix mode.  This construct is
              used  in  most  shell  scripts  that  use  the  old
              _g_e_t_o_p_t(1) command.
         +o    argument  expansion of aalliiaass, eexxppoorrtt, rreeaaddoonnllyy, and
              ttyyppeesseett commands: in posix  mode,  normal  argument
              expansion done; in non-posix mode, field splitting,
              file globing, (normal) tilde expansion  are  turned
              off, and assignment tilde expansion is turned on.
         +o    signal specification: in posix mode, signals can be
              specified as digits only if  signal  numbers  match
              POSIX  values  (i.e., HUP=1, INT=2, QUIT=3, ABRT=6,
              KILL=9, ALRM=14, and TERM=15); in  non-posix  mode,
              signals can be always digits.
         +o    alias  expansion: in posix mode, alias expansion is
              only carried out when  reading  command  words;  in
              non-posix  mode,  alias expansion is carried out on
              any word following an alias that ended in a  space.
              For example, the following for loop
              aalliiaass aa==''ffoorr '' ii==''jj''
              aa ii iinn 11 22;; ddoo eecchhoo ii==$$ii jj==$$jj;; ddoonnee
       uses parameter ii in posix mode, jj in non-posix mode.

   CCoommmmaanndd EExxeeccuuttiioonn
       After evaluation of keyword assignments and arguments, the
       type of command is determined.  A command  may  execute  a
       special  shell built-in, a shell function, a regular shell
       built-in, or an executable file.

       Any keyword assignments are then performed (and  exported)
       for the duration of the command.



                        November 28, 1994                      21





KSH(1)                    User commands                    KSH(1)


       Even  on systems where the _e_x_e_c(2) family does not support
       ##!!  notation for scripts, ksh can be  configured  to  fake
       it.

       There are several built-in commands.

       :: [ ... ]
              The null command.  Exit status is set to zero.

       .. _f_i_l_e [_a_r_g_1 ...]
              Execute  the  commands in _f_i_l_e in the current envi-
              ronment.  The file is searched for in the  directo-
              ries  of  PPAATTHH.   If arguments are given, the posi-
              tional parameters may be used to access them  while
              _f_i_l_e is being executed.  If no arguments are given,
              the positional parameters are those of the environ-
              ment the command is used in.

       aalliiaass [ --dd | --tt [--rr] ] [--xx] [_n_a_m_e_1[==_v_a_l_u_e_1] ...]
              Without  arguments,  aalliiaass  lists  all  aliases and
              their values.  For any name without  a  value,  its
              value  is listed.  Any name with a value defines an
              alias (see Aliases above).

              The --xx option  sets  the  export  attribute  of  an
              alias, or, if no names are given, lists the aliases
              with the export attribute (exporting an alias  cur-
              rently has no affect).

              The --tt option indicates that tracked aliases are to
              be listed/set (values specified on the command line
              are  ignored  for  tracked aliases).  The --rr option
              indicates that all tracked aliases are to be reset.

              The  --dd causes directory aliases, which are used in
              tilde expansion, to be listed  or  set  (see  Tilde
              Expansion above).

       bbgg [_j_o_b ...]
              Resume  the  specified  stopped job(s) in the back-
              ground.  If no jobs are specified, %%++  is  assumed.
              This  command  is  only  available on systems which
              support job control.  See  Job  Control  below  for
              more information.

       bbiinndd [--mm] [_k_e_y[==_e_d_i_t_i_n_g_-_c_o_m_m_a_n_d] ...]
              Set  or  view the current emacs command editing key
              bindings/macros.  See Emacs Interactive Input  Line
              Editing below for a complete description.

       bbrreeaakk [_l_e_v_e_l]
              bbrreeaakk  exits  the  _l_e_v_e_lth  inner most for, select,
              until, or while loop.  _l_e_v_e_l defaults to 1.




                        November 28, 1994                      22





KSH(1)                    User commands                    KSH(1)


       bbuuiillttiinn _c_o_m_m_a_n_d [_a_r_g_1 ...]
              Execute the built-in command _c_o_m_m_a_n_d.

       ccdd [_d_i_r]
              Set the working directory to _d_i_r.  If the parameter
              CCDDPPAATTHH  is  set,  it  lists the search path for the
              directory containing _d_i_r.  A  null  path  mans  the
              current  directory.   If  _d_i_r  is missing, the home
              directory $$HHOOMMEE is used.  If _d_i_r is --, the previous
              working  directory  is  used.  If _d_i_r is determined
              from the value of PPWWDD.  The PPWWDD and OOLLDDPPWWDD  parame-
              ters  are  updated  to  reflect the current and old
              wording directory, respectively.

              Note: the --LL and --PP options available in some  Korn
              shells  are  not implemented yet; the same goes for
              the ppwwdd command.

       ccdd _o_l_d _n_e_w
              The string _n_e_w is substituted for _o_l_d in  the  cur-
              rent directory, and the shell attempts to change to
              the new directory.

       ccoommmmaanndd [--ppvvVV] _c_m_d [_a_r_g_1 ...]
              If neither the --vv nor --VV options are given, _c_m_d  is
              executed  exactly  as  if  the ccoommmmaanndd had not been
              specified, with two exceptions: first,  _c_m_d  cannot
              be  a  shell function, and second, special built-in
              commands lose their specialness (i.e.,  redirection
              and  utility errors do not cause the shell to exit,
              and command assignments are not permanent).  If the
              --pp  option  is given, a default search path is used
              instead of the current value of  PPAATTHH  (the  actual
              value  of  the default path is system dependent: on
              POSIXish systems, it is the value returned by  ggeett--
              ccoonnff CCSS__PPAATTHH).

              If  the  --vv  option  is given, instead of executing
              _c_m_d, information about what would  be  executed  is
              given  (and the same is done for _a_r_g_1 for keywords,
              special and regular  built-in  commands  and  func-
              tions, their names are simply printed, for aliases,
              a command that defines them  is  printed,  and  for
              commands found by searching the PPAATTHH parameter, the
              full path of the command is printed.  If no command
              is be found, (i.e., the path search fails), nothing
              is printed and ccoommmmaanndd exits with a  non-zero  sta-
              tus.   The  --VV option is like the --vv option, except
              it is more verbose.

       ccoonnttiinnuuee [_l_e_v_e_l_s]
              ccoonnttiinnuuee jumps to  the  beginning  of  the  _l_e_v_e_lth
              inner  most  for,  select,  until,  or  while loop.
              _l_e_v_e_l defaults to 1.



                        November 28, 1994                      23





KSH(1)                    User commands                    KSH(1)


       eecchhoo [--nneeEE] [_a_r_g ...]
              Prints its arguments (separated by spaces) followed
              by a newline, to standard out.  The newline is sup-
              pressed if any of the arguments contain  the  back-
              slash  sequence  \\cc.  See pprriinntt command below for a
              list of other backslash sequences that  are  recog-
              nized.

              The options are provided for compatibility with BSD
              shell scripts: --nn suppresses the trailing  newline,
              --ee enables backslash interpretation (a no-op, since
              this is normally done),  and  --EE  which  suppresses
              backslash interpretation.

       eevvaall _c_o_m_m_a_n_d _._._.
              The arguments are concatenated (with spaces between
              them) to form a single string which the shell  then
              parses and executes in the current environment.

       eexxeecc [_c_o_m_m_a_n_d [_a_r_g ...]]
              The  command is executed without forking, replacing
              the shell process.

              If no arguments are given, any  IO  redirection  is
              permanent  and the shell is not replaced.  Any file
              descriptors greater than  2  which  are  opened  or
              _d_u_p(2)-ed  in  this  way  are not made available to
              other executed commands (i.e.,  commands  that  are
              not built-in to the shell).

       eexxiitt [_s_t_a_t_u_s]
              The shell exits with the specified exit status.  If
              _s_t_a_t_u_s is not specified, the  exit  status  is  the
              current value of the ?? parameter.

       eexxppoorrtt [--pp] [_p_a_r_a_m_e_t_e_r[==_v_a_l_u_e]] ...
              Sets  the export attribute of the named parameters.
              Exported parameters are passed in  the  environment
              to executed commands.  If values are specified, the
              named parameters also assigned.

              If no parameters are specified, the  names  of  all
              parameters  with  the  export attribute are printed
              one per line, unless the  --pp  option  is  used,  in
              which  case  eexxppoorrtt  commands defining all exported
              parameters, including their values, are printed.

       ffaallssee  A command that exits with a non-zero status.

       ffcc [--ee _e_d_i_t_o_r | --ll [--nn]] [--rr] [_f_i_r_s_t [_l_a_s_t]]
              _f_i_r_s_t and _l_a_s_t select commands  from  the  history.
              Commands  can  be  selected by history number, or a
              string specifying the most recent command  starting
              with  that string.  The --ll option lists the command



                        November 28, 1994                      24





KSH(1)                    User commands                    KSH(1)


              on stdout, and --nn inhibits the default command num-
              bers.   The  --rr  option  reverses  the order of the
              list.  Without --ll, the selected commands are edited
              by  the  editor specified with the --ee option, or if
              no --ee is specified, the  editor  specified  by  the
              FFCCEEDDIITT  parameter  (if  this  parameter is not set,
              //bbiinn//eedd is used), and then executed by the shell.

       ffcc --ee -- [--gg] [_o_l_d==_n_e_w] [_p_r_e_f_i_x]
              Re-execute the selected command (the previous  com-
              mand by default) after performing the optional sub-
              stitution of _o_l_d with _n_e_w.  If --gg is specified, all
              occurrences  of  _o_l_d  are  replaced with _n_e_w.  This
              command is usually  accessed  with  the  predefined
              alias rr==''ffcc --ee --''.

       ffgg [_j_o_b ...]
              Resume  the specified job(s) in the foreground.  If
              no jobs are specified, %%++ is assumed.  This command
              is only available on systems which support job con-
              trol.  See Job Control below for more  information.

       ggeettooppttss _o_p_t_s_t_r_i_n_g _n_a_m_e [_a_r_g ...]
              ggeettooppttss  is  used  by shell procedures to parse the
              specified arguments (or positional  parameters,  if
              no  arguments  are  given)  and  to check for legal
              options.  _o_p_t_s_t_r_i_n_g  contains  the  option  letters
              that  ggeettooppttss is to recognize.  If a letter is fol-
              lowed by a colon, the option is expected to have an
              argument.   Arguments  containing  options must all
              start with either a -- or a ++, options that  do  not
              take arguments may be grouped in a single argument.
              If an option takes an argument and the option char-
              acter  is not the last character of the argument it
              is found in, the remainder of the argument is taken
              to  be  the  option's argument, otherwise, the next
              argument is the option's argument.

              Each time ggeettooppttss is invoked, it  places  the  next
              option in the shell parameter _n_a_m_e and the index of
              the next argument to  be  processed  in  the  shell
              parameter  OOPPTTIINNDD.   If  the  option was introduced
              with a ++, the option placed  in  _n_a_m_e  is  prefixed
              with  a  ++.   When  an option requires an argument,
              ggeettooppttss places it in the  shell  parameter  OOPPTTAARRGG.
              The  action taken when an illegal option or a miss-
              ing option argument is encountered depends on  _o_p_t_-
              _s_t_r_i_n_g: if it does not begin with a colon, an error
              message is printed on standard error and a question
              mark  is placed in _n_a_m_e; if ooppttssttrriinngg starts with a
              colon, no error message is printed, a question mark
              or  colon  is placed in _n_a_m_e, indicating an illegal
              option  or  missing  argument,  respectively,   and
              OOPPTTAARRGG  is  set to the option character that caused



                        November 28, 1994                      25





KSH(1)                    User commands                    KSH(1)


              the problem.

              When the end of the options is encountered, ggeettooppttss
              exits  with a non-zero exit status.  Options end at
              the first (non-option argument) argument that  does
              not  start  with  a  -,  or  when  a ---- argument is
              encountered.

              Option parsing can be reset by setting OOPPTTIINNDD to  1
              (this is done automatically whenever the shell or a
              shell procedure is invoked).

              Warning: Changing the value of the shell  parameter
              OOPPTTIINNDD  to a value other than 1, or parsing differ-
              ent sets of arguments without resetting OOPPTTIINNDD  may
              lead to unexpected results.

       hhaasshh [--rr] [_n_a_m_e _._._.]
              Without  arguments,  any  hashed executable command
              pathnames are listed.  The  --rr  option  causes  all
              hashed  commands to be removed from the hash table.
              Each _n_a_m_e is searched as if it where a command name
              and  added to the hash table if it is an executable
              command.

       jjoobbss [--llppnn] [_j_o_b ...]
              Display information about the specified jobs; if no
              jobs are specified, all jobs are displayed.  The --nn
              option causes information to be displayed only  for
              jobs that have changed state since the last notifi-
              cation.  If the --ll option is used,  the  process-id
              of  each  process  in a job is also listed.  The --pp
              option causes only the process group of each job to
              be  printed.   See Job Control below for the format
              of _j_o_b and the displayed job.

       kkiillll [--ss _s_i_g_n_a_m_e | --ssiiggnnuumm | --ssiiggnnaammee ] { _j_o_b | _p_i_d |
              --_p_g_r_p } ...
              Send the specified signal to  the  specified  jobs,
              process  ids,  or  process groups.  If no signal is
              specified, the signal TERM is sent.  If  a  job  is
              specified,  the signal is sent to the job's process
              group.  See Job Control below  for  the  format  of
              _j_o_b.

       kkiillll --ll [_e_x_i_t_-_s_t_a_t_u_s ...]
              Print  the name of the signal that killed a process
              which exited with the specified _e_x_i_t_-_s_t_a_t_u_ses.   If
              no  arguments are specified, a list of all the sig-
              nals, their numbers and a short description of them
              are printed.

       lleett [_e_x_p_r_e_s_s_i_o_n ...]
              Each   expression   is  evaluated,  see  Arithmetic



                        November 28, 1994                      26





KSH(1)                    User commands                    KSH(1)


              Expressions above.  A zero status  is  returned  if
              the  last expression evaluates to a non-zero value,
              otherwise a non-zero  status  is  returned.   Since
              expressions  may  need  to be quoted, (((( _e_x_p_r )))) is
              syntactic sugar for lleett ""_e_x_p_r"".

       pprriinntt [--nnpprrssuu_n || --RR [[--eenn]]]] [[_a_r_g_u_m_e_n_t _._._.]]
              PPrriinntt prints its arguments on the standard  output,
              separated by spaces, and terminated with a newline.
              The --nn option suppresses the newline.  By  default,
              certain  C  escapes  are translated.  These include
              \b, \f, \n, \r, \t, \v, and \###  (#  is  an  octal
              digit).   \c  is equivalent to using the --nn option.
              \ expansion may be inhibited with  the  --rr  option.
              The --ss option prints to the history file instead of
              standard output,  the  --uu  option  prints  to  file
              descriptor  _n (_n defaults to 1 if omitted), and the
              --pp  option  prints  to  the  co-process  (see   Co-
              Processes above).

              The  --RR  option is used to emulate, to some degree,
              the BSD echo command,  which  does  not  process  \
              sequences unless the --ee option is given.  As above,
              the --nn option suppresses the trailing newline.

       rreeaadd [--pprrssuu_n] [_p_a_r_a_m_e_t_e_r _._._.]
              Reads a line of input from standard input, separate
              the  line  into fields using the IIFFSS parameter (see
              Substitution above), and assign each field  to  the
              specified parameters.  If there are more parameters
              than fields, the extra parameters are set to  null,
              or  alternatively,  if  there  are more fields than
              parameters, the  last  parameter  is  assigned  the
              remaining   fields  (inclusive  of  any  separating
              spaces).  If no parameters are specified, the RREEPPLLYY
              parameter  is  used.   If  the input line ends in a
              backslash and the --rr option was not used, the back-
              slash  and  newline  are stripped and more input is
              read.  If no input is read, rreeaadd exits with a  non-
              zero status.

              A prompt, which is printed to standard error before
              any input is read, may be  specified  by  appending
              and  question  mark  and  the  prompt  to the first
              parameter (e.g., rreeaadd nnffoooo??''nnuummbbeerr ooff ffooooss:: '').

              The --uu_n and --pp options cause input to be read  from
              file   descriptor  _n  or  the  current  co-process,
              respectively.  If the --ss option is used,  input  is
              saved to the history file.

       rreeaaddoonnllyy [--pp] [_p_a_r_a_m_e_t_e_r[==_v_a_l_u_e]] ...
              Sets  the  readonly  attribute of the named parame-
              ters.  If values are given, parameters are  set  to



                        November 28, 1994                      27





KSH(1)                    User commands                    KSH(1)


              them  before setting the attribute.  Once a parame-
              ter is made readonly, it cannot be  unset  and  its
              value cannot be changed.

              If  no  parameters  are specified, the names of all
              parameters with the readonly attribute are  printed
              one  per  line,  unless  the  --pp option is used, in
              which case rreeaaddoonnllyy commands defining all  readonly
              parameters, including their values, are printed.

       rreettuurrnn [_s_t_a_t_u_s]
              Returns from a function or .. script, with exit sta-
              tus _s_t_a_t_u_s.  If no _s_t_a_t_u_s is given, the exit status
              of the last executed command is used.  If used out-
              side of a function or .. script,  it  has  the  same
              effect  as  eexxiitt.  Note that pdksh treats both pro-
              file and $$EENNVV files as

       sseett [++--aabbCCeeffhhkkmmnnppssuuvvxxXX] [++--oo [_o_p_t_i_o_n]] [++--AA _n_a_m_e] [----]
              [_a_r_g  ...]
              Set (--) or clear (++) a shell option:

               --AA                  Sets the elements of the array
                                   parameter  _n_a_m_e to _a_r_g ...; If
                                   --AA is used, the array is reset
                                   (i.e., emptied) first.
               --aa  aalllleexxppoorrtt       all new parameters are created
                                   with the export attribute
               --bb  nnoottiiffyy          Print  job  notification  mes-
                                   sages  asynchronously, instead
                                   of  just  before  the  prompt.
                                   Only  used  if  job control is
                                   enabled (--mm).
               --CC  nnoocclloobbbbeerr       Prevent  >>  redirection   from
                                   overwriting existing files (>>!!
                                   must be used to force an over-
                                   write).
               --ee  eerrrreexxiitt         Exit   as  soon  as  an  error
                                   occurs  or  a  command   fails
                                   (i.e.,  exits  with a non-zero
                                   status).  This does not  apply
                                   to  commands whose exit status
                                   is  explicitly  tested  by   a
                                   shell  construct  such  as iiff,
                                   uunnttiill, wwhhiillee, &&&& or ||||  state-
                                   ments.
               --ff  nnoogglloobb          Do  not  expand file name pat-
                                   terns.
               --hh  ttrraacckkaallll        Create tracked aliases for all
                                   executed commands (see Aliases
                                   above).   On  by  default  for
                                   non-interactive shells.





                        November 28, 1994                      28





KSH(1)                    User commands                    KSH(1)


               --ii  iinntteerraaccttiivvee     Enable interactive mode - this
                                   can only be set/unset when the
                                   shell is invoked.
               --kk  kkeeyywwoorrdd         Parameter assignments are rec-
                                   ognized anywhere in a command.
               --mm  mmoonniittoorr         Enable  job  control  (default
                                   for interactive shells).
               --nn  nnooeexxeecc          Do not execute any commands  -
                                   useful for checking the syntax
                                   of scripts (ignored if  inter-
                                   active).
               --pp  pprriivviilleeggeedd      Set automatically if, when the
                                   shell starts, the read uid  or
                                   gid  does not match the effec-
                                   tive uid or gid, respectively.
                                   See  Shell Startup above for a
                                   description   of   what   this
                                   means.
               --rr  rreessttrriicctteedd      Enable restricted mode -- this
                                   option can only be  used  when
                                   the  shell  is  invoked.   See
                                   Shell  Startup  above  for   a
                                   description   of   what   this
                                   means.
               --ss
               --ss  ssttddiinn           If  used  when  the  shell  is
                                   invoked,   commands  are  read
                                   from  standard   input.    Set
                                   automatically  if the shell is
                                   invoked with no arguments.

                                   When --ss is  used  in  the  sseett
                                   command,  it  causes the argu-
                                   ments  to  be  sorted   before
                                   assigning  them  to  the posi-
                                   tional parameters (or to array
                                   _n_a_m_e, if --AA is used).
               --uu  nnoouunnsseett         Referencing of an unset param-
                                   eter is treated as  an  error,
                                   unless  one  of  the --, ++ or ==
                                   modifiers is used.
               --vv  vveerrbboossee         Write shell input to  standard
                                   error as it is read.
               --xx  xxttrraaccee          Print  commands  and parameter
                                   assignments when they are exe-
                                   cuted,  preceded  by the value
                                   of PPSS44.
               --XX  mmaarrkkddiirrss        Mark directories with a trail-
                                   ing // during file name genera-
                                   tion.
                   bbggnniiccee          Background jobs are  run  with
                                   lower priority.





                        November 28, 1994                      29





KSH(1)                    User commands                    KSH(1)


                   bbrraacceeeexxppaanndd     Enable  brace  expansion (aka,
                                   alternation).
                   eemmaaccss           Enable BRL emacs-like  command
                                   line    editing   (interactive
                                   shells only); see Emacs Inter-
                                   active Input Line Editing.
                   ggmmaaccss           Enable   gmacs-like   (Gosling
                                   emacs)  command  line  editing
                                   (interactive   shells   only);
                                   currently identical  to  emacs
                                   editing  except that transpose
                                   (^T)  acts  slightly   differ-
                                   ently.
                   iiggnnoorreeeeooff       The  shell  will  not  exit on
                                   when end-of-file is read, eexxiitt
                                   must be used.
                   nnoolloogg           No  effect  -  in the original
                                   Korn  shell,   this   prevents
                                   function    definitions   from
                                   being stored  in  the  history
                                   file.
                   ppoossiixx           Enable  posix mode.  See POSIX
                                   Mode above.
                   vvii              Enable  vi-like  command  line
                                   editing   (interactive  shells
                                   only).
                   vviirraaww           No effect -  in  the  original
                                   Korn  shell,  unless viraw was
                                   set, the vi command line  mode
                                   would  let  the  tty driver do
                                   the work until  ESC  (^[)  was
                                   entered.   pdksh  is always in
                                   viraw mode.
                   vvii--sshhooww88        Prefix  characters  with   the
                                   eighth  bit set with `M-'.  If
                                   this option is not set,  char-
                                   acters  in  the  range 128-160
                                   are printed as is,  which  may
                                   cause problems.
                   vvii--ttaabbccoommpplleettee  In vi command line editing, do
                                   file name completion when  tab
                                   (^I)   is  entered  in  insert
                                   mode.

              These options can also be used upon  invocation  of
              the shell.  The current set of options can be found
              in the parameter --.  Remaining arguments,  if  any,
              are  positional  parameters  and  are  assigned, in
              order, to the positional parameters  (i.e.,  11,  22,
              etc.).   If options are ended with ---- and there are
              no remaining arguments, all  positional  parameters
              are cleared.  If no options or arguments are given,
              then the values of  all  names  are  printed.   For
              unknown  historical  reasons,  a  lone  -- option is



                        November 28, 1994                      30





KSH(1)                    User commands                    KSH(1)


              treated specially: it clears both  the  --xx  and  --vv
              options.

       sshhiifftt [_n_u_m_b_e_r]
              The positional parameters _n_u_m_b_e_r, _n_u_m_b_e_r_+_1 etc. are
              renamed to 11, 22, etc.  _n_u_m_b_e_r defaults to 1.

       tteesstt _e_x_p_r_e_s_s_i_o_n
              tteesstt evaluates the _e_x_p_r_e_s_s_i_o_n and returns zero sta-
              tus  if true, and non-zero status otherwise.  It is
              normally used as the condition command  of  iiff  and
              wwhhiillee  statements.  The following basic expressions
              are available:

               --rr _f_i_l_e              _f_i_l_e exists and is readable
               --ww _f_i_l_e              _f_i_l_e exists and is writable
               --xx _f_i_l_e              _f_i_l_e  exists  and  is   exe-
                                    cutable
               --aa _f_i_l_e              _f_i_l_e exists
               --ee _f_i_l_e              _f_i_l_e exists
               --ff _f_i_l_e              _f_i_l_e is a regular file
               --dd _f_i_l_e              _f_i_l_e is a directory
               --cc _f_i_l_e              _f_i_l_e  is a character special
                                    device
               --bb _f_i_l_e              _f_i_l_e  is  a  block   special
                                    device
               --pp _f_i_l_e              _f_i_l_e is a named pipe
               --uu _f_i_l_e              _f_i_l_e's  mode  has setuid bit
                                    set
               --gg _f_i_l_e              _f_i_l_e's mode has  setgid  bit
                                    set
               --kk _f_i_l_e              _f_i_l_e's  mode  has sticky bit
                                    set
               --ss _f_i_l_e              _f_i_l_e is not empty
               --OO _f_i_l_e              _f_i_l_e's owner is the  shell's
                                    effective user-ID
               --GG _f_i_l_e              _f_i_l_e's  group is the shell's
                                    effective group-ID
               --hh _f_i_l_e              _f_i_l_e is a symbolic link
               --HH _f_i_l_e              _f_i_l_e is a context  dependent
                                    directory  (only  useful  on
                                    HP-UX)
               --LL _f_i_l_e              _f_i_l_e is a symbolic link
               --SS _f_i_l_e              _f_i_l_e is a socket
               --oo _o_p_t_i_o_n            shell _o_p_t_i_o_n is set (see sseett
                                    command  above  for  list of
                                    options)
               _f_i_l_e --nntt _f_i_l_e        first  _f_i_l_e  is  newer  than
                                    second _f_i_l_e
               _f_i_l_e --oott _f_i_l_e        first  _f_i_l_e  is  older  than
                                    second _f_i_l_e
               _f_i_l_e --eeff _f_i_l_e        first _f_i_l_e is the same  file
                                    as second _f_i_l_e




                        November 28, 1994                      31





KSH(1)                    User commands                    KSH(1)


               --tt [[_f_d]]              file  descriptor  is  a  tty
                                    device.  Default value of _f_d
                                    is 1.
               _s_t_r_i_n_g               _s_t_r_i_n_g is not empty
               --zz _s_t_r_i_n_g            _s_t_r_i_n_g is empty
               --nn _s_t_r_i_n_g            _s_t_r_i_n_g is not empty
               _s_t_r_i_n_g == _s_t_r_i_n_g      strings are equal
               _s_t_r_i_n_g !!== _s_t_r_i_n_g     strings are not equal
               _n_u_m_b_e_r --eeqq _n_u_m_b_e_r    numbers compare equal
               _n_u_m_b_e_r --nnee _n_u_m_b_e_r    numbers compare not equal
               _n_u_m_b_e_r --ggee _n_u_m_b_e_r    numbers compare greater than
                                    or equal
               _n_u_m_b_e_r --ggtt _n_u_m_b_e_r    numbers compare greater than
               _n_u_m_b_e_r --llee _n_u_m_b_e_r    numbers compare less than or
                                    equal
               _n_u_m_b_e_r --lltt _n_u_m_b_e_r    numbers compare less than

              The above basic expressions, in which unary  opera-
              tors  have precedence over binary operators, may be
              combined with the following  operators  (listed  in
              increasing order of precedence):

               _e_x_p_r --oo _e_x_p_r    logical or
               _e_x_p_r --aa _e_x_p_r    logical and
               !! _e_x_p_r          logical not
               (( _e_x_p_r ))        grouping

              Note  that some special rules are applied (courtesy
              of POSIX) if the number of arguments to tteesstt  or  [[
              ... ]] is less than five: if leading !! arguments can
              be stripped such that  only  one  argument  remains
              then a string length test is performed (again, even
              if the argument is a unary operator); if leading  !!
              arguments can be stripped such that three arguments
              remain and the second argument is a  binary  opera-
              tor,  then  the binary operation is performed (even
              if first argument is a unary operator, including an
              unstripped !!).

              NNoottee::  A common mistake is to use iiff [[ $$ffoooo == bbaarr ]]
              which fails if parameter ffoooo is null or  unset,  if
              it  has  embedded spaces (i.e., IIFFSS characters), or
              if it is a unary operator like !! or --nn.  Use  tests
              like iiff [[ ""XX$$ffoooo"" == XXbbaarr ]] instead.

       ttiimmeess  Print the accumulated user and system times used by
              the shell and by processes which have  exited  that
              the shell started.

       ttrraapp [_h_a_n_d_l_e_r _s_i_g_n_a_l _._._.]
              Sets  trap  handler that is to be executed when any
              of the specified signals are received.  HHaannddlleerr  is
              either a null string, indicating the signals are to
              be  ignored,  a  minus  (--),  indicating  that  the



                        November 28, 1994                      32





KSH(1)                    User commands                    KSH(1)


              default  action is to be taken for the signals (see
              signal(2 or 3)), or a string containing shell  com-
              mands  to  be  evaluated  and executed at the first
              opportunity (i.e., when the  current  command  com-
              pletes,  or  before  printing  the next PPSS11 prompt)
              after receipt of one of the signals.  SSiiggnnaall is the
              name of a signal (e.g., PIPE or ALRM) or the number
              of the signal (see kkiillll --ll command  above).   There
              are  two  special  signals: EEXXIITT (also known as 00),
              which is executed when the shell is about to  exit,
              and EERRRR which is executed after an error occurs (an
              error is something that would cause  the  shell  to
              exit if the --ee or eerrrreexxiitt option were set - see sseett
              command above).  EEXXIITT handlers are executed in  the
              environment  of  the  last  executed command.  Note
              that for non-interactive shells, the  trap  handler
              cannot  be  changed  for  signals that were ignored
              when the shell started.

              With no arguments, ttrraapp lists, as a series of  ttrraapp
              commands,  the current state of the traps that have
              been set since the shell started.

              The original Korn shell's DDEEBBUUGG trap and  the  han-
              dling  of  EERRRR  and EEXXIITT traps in functions are not
              yet implemented.

       ttrruuee   A command that exits with a zero value.

       ttyyppeesseett [[+-Ulrtux] [--LL[_n]] [--RR[_n]] [--ZZ[_n]] [--ii[_n]] | --ff
              [--ttuuxx]] [_n_a_m_e[==_v_a_l_u_e] ...]
              Display or set parameter attributes.  With no  _n_a_m_e
              arguments,  parameter  attributes are displayed: if
              no options arg used, the current attributes of  all
              parameters  are  printed as typeset commands; if an
              option is given (or -- with no  option  letter)  all
              parameters  and  their  values  with  the specified
              attributes are printed; if options  are  introduced
              with ++, parameter values are not printed.

              If  _n_a_m_e arguments are given, the attributes of the
              named parameters are set (--) or cleared (++).   Val-
              ues for parameters may optionally be specified.  If
              typeset is used inside a function, any  newly  cre-
              ated parameters are local to the function.

              When --ff is used, typeset operates on the attributes
              of functions.  As with parameters, if no _n_a_m_es  are
              given,  functions  are  listed  with  their  values
              (i.e., definitions) unless options  are  introduced
              with  ++,  in which case only the function names are
              reported.





                        November 28, 1994                      33





KSH(1)                    User commands                    KSH(1)


               --LL_n  Left justify attribute: _n specifies the field
                    width.   If  _n  is not specified, the current
                    width of a parameter (or  the  width  of  its
                    first assigned value) is used.  Leading white
                    space (and zeros, if used with the --ZZ option)
                    is stripped.  If necessary, values are either
                    truncated or space padded to  fit  the  field
                    width.
               --RR_n  Right  justify  attribute:  _n  specifies  the
                    field width.  If _n is not specified, the cur-
                    rent  width  of  a parameter (or the width of
                    its first assigned value) is used.   Trailing
                    white space are stripped.  If necessary, val-
                    ues are either stripped of leading characters
                    or  space  padded  to make them fit the field
                    width.
               --ZZ_n  Zero fill attribute: if not combined with --LL,
                    this  is  the same as --RR, except zero padding
                    is used instead of space padding.
               --ii_n  integer attribute: _n specifies  the  base  to
                    use when displaying the integer (if not spec-
                    ified, the base given in the first assignment
                    is used).  Parameters with this attribute may
                    be  assigned  values  containing   arithmetic
                    expressions.
               --UU   unsigned   integer  attribute:  integers  are
                    printed as unsigned values (only useful  when
                    combined with the --ii option).  This option is
                    not in the original Korn shell.
               --ff   Function mode: display or set  functions  and
                    their attributes, instead of parameters.
               --ll   Lower case attribute: all  upper case charac-
                    ters in values are converted to  lower  case.
                    (In  the  original Korn shell, this parameter
                    meant `long integer' when used  with  the  --ii
                    option).
               --rr   Readonly  attribute: parameters with the this
                    attribute may not be assigned  to  or  unset.
                    Once  this  attribute  is  set, it can not be
                    turned off.
               --tt   Tag attribute: has no meaning to  the  shell;
                    provided for application use.

                    For  functions,  --tt  is  the trace attribute.
                    When functions with the trace  attribute  are
                    executed,  the  xxttrraaccee  (--xx)  shell option is
                    temporarily turned on.










                        November 28, 1994                      34





KSH(1)                    User commands                    KSH(1)


               --uu   Upper case attribute: all lower case  charac-
                    ters  in  values are converted to upper case.
                    (In the original Korn shell,  this  parameter
                    meant  `unsigned  integer' when used with the
                    --ii option, which  meant  upper  case  letters
                    would  never  be  used for bases greater than
                    10.  See the --UU option).

                    For functions, --uu is the undefined attribute.
                    See  Functions  above for the implications of
                    this.
               --xx   Export attribute: parameters  (or  functions)
                    are placed in the environment of any executed
                    commands.  Exported functions are not  imple-
                    mented yet.

       uulliimmiitt [--aaccddffHHmmnnssSSttvvww] [_v_a_l_u_e]
              Display  or  set process limits.  If no options are
              used, the file size limit (--ff) is assumed.   vvaalluuee,
              if  specified,  may  be  either  be  an  arithmetic
              expression  or  the  word  uunnlliimmiitteedd.   The  limits
              affect  the  shell and any processes created by the
              shell after a limit is  imposed.   Note  that  some
              systems  may  not allow limits to be increased once
              they are set.  Also note that the types  of  limits
              available  are system dependent - some systems have
              only the --ff limit.

              --aa     Displays all limits.

              --HH     Set the hard limit only (default is  to  set
                     both hard and soft limits).

              --SS     Set  the  soft limit only (default is to set
                     both hard and soft limits).

              --cc     Impose a size limit of _n blocks on the  size
                     of core dumps.

              --dd     Impose  a size limit of _n kbytes on the size
                     of the data area.

              --ff     Impose a size limit of  _n  blocks  on  files
                     written by the shell and its child processes
                     (files of any size may be read).

              --mm     Impose a limit of _n kbytes on the amount  of
                     physical memory used.

              --nn     Impose  a  limit  of _n file descriptors that
                     can be open at once.

              --ss     Impose a size limit of _n kbytes on the  size
                     of the stack area.



                        November 28, 1994                      35





KSH(1)                    User commands                    KSH(1)


              --tt     Impose  a time limit of _n seconds to be used
                     by each process.

              --vv     Impose a limit of _n kbytes on the amount  of
                     virtual memory used; on some systems this is
                     the maximum allowable  virtual  address  (in
                     bytes, not kbytes).

              --ww     Impose  a limit of _n kbytes on the amount of
                     swap space used.

              As far as uulliimmiitt  is  concerned,  a  block  is  512
              bytes.

       uummaasskk [--SS] [_m_a_s_k]
              Display  or  set the file permission creation mask,
              or umask (see _u_m_a_s_k(2)).  If the --SS option is used,
              the mask displayed or set is symbolic, otherwise it
              is an octal number.

              Symbolic masks are like those used by _c_h_m_o_d(1):
                          [uuggooaa]{{==++--}{rrwwxx}*}+[,,...]
              in which the first group of characters is  the  _w_h_o
              part, the second group is the _o_p part, and the last
              group is the _p_e_r_m part.   The  _w_h_o  part  specifies
              which  part  of  the  umask is to be modified.  The
              letters mean:

                      uu      the user permissions

                      gg      the group permissions

                      oo      the  other  permissions   (non-user,
                             non-group)

                      aa      all  permissions  (user,  group  and
                             other)

              The _o_p part indicates how the _w_h_o  permissions  are
              to be modified:

                      ==      set

                      ++      added to

                      --      removed from

              The _p_e_r_m part specifies which permissions are to be
              set, added or removed:

                      rr      read permission

                      ww      write permission




                        November 28, 1994                      36





KSH(1)                    User commands                    KSH(1)


                      xx      execute permission

              When symbolic masks are used,  they  describe  what
              permissions  may  be  made available (as opposed to
              octal masks in which a set  bit  means  the  corre-
              sponding   bit   is   to   be  cleared).   Example:
              `ug=rwx,o=' sets the mask  so  files  will  not  be
              readable,  writable  or executable by `others', and
              is equivalent (on most systems) to the  octal  mask
              `07'.

       uunnaalliiaass [--aaddtt] [_n_a_m_e_1 ...]
              The  aliases  for  the given names are removed.  If
              the --aa option is used, all aliases are removed.  If
              the --tt or --dd options are used, the indicated opera-
              tions are  carried  out  on  tracked  or  directory
              aliases, respectively.

       uunnsseett [--ffvv] _p_a_r_a_m_e_t_e_r ...
              Unset  the  named  parameters  (--vv, the default) or
              functions (--ff).

       wwaaiitt [_j_o_b]
              Wait for the specified job(s) to finish.  The  exit
              status  of  wait is that of the last specified job:
              if the last job is killed by  a  signal,  the  exit
              status  is 128 + the number of the signal (see kkiillll
              --ll _e_x_i_t_-_s_t_a_t_u_s above); if the  last  specified  job
              can't  be  found  (because it never existed, or had
              already finished), the exit status of wait is  127.
              See  Job Control below for the format of _j_o_b.  WWaaiitt
              will return if a signal for which a trap  has  been
              set is received, or if a HUP, INT or QUIT signal is
              received.

              If no jobs are specified, wwaaiitt waits for  all  cur-
              rently  running  jobs  (if any) to finish and exits
              with a zero status.  If job monitoring is  enabled,
              the  completion  status of jobs is printed (this is
              not the case when jobs are explicitly specified).

       wwhheennccee [--ppvv] [name ...]
              For each name, the type of command is listed  (key-
              word,  built-in,  alias, function, tracked alias or
              executable).  If the --pp  option  is  used,  a  path
              search  done even if _n_a_m_e is a keyword, alias, etc.
              Without the --vv option, wwhheennccee is the same  as  ccoomm--
              mmaanndd --vv; with the --VV option, it is the same as ccoomm--
              mmaanndd --VV.  Note that for wwhheennccee, the --pp option  does
              not  affect  the  search  path used, as it does for
              ccoommmmaanndd.  If the type of one or more of  the  names
              could  not  be  determined, the exit status is non-
              zero.




                        November 28, 1994                      37





KSH(1)                    User commands                    KSH(1)


   JJoobb CCoonnttrrooll
       Job control refers to the shell's ability to  monitor  and
       control  jjoobbss,  which are processes or groups of processes
       created for commands or  pipelines.   At  a  minimum,  the
       shell  keeps  track of the status of the background (i.e.,
       asynchronous) jobs that currently exist; this  information
       can  be  displayed using the jjoobbss command.  If job control
       is fully enabled (using sseett --mm or sseett --oo mmoonniittoorr),  as  it
       is  for  interactive  shells,  the  processes of a job are
       placed in their own process group, foreground jobs can  be
       stopped  by typing the suspend character from the terminal
       (normally ^Z), jobs can be restarted in either  the  fore-
       ground  or  background,  using  the  ffgg  and  bbgg commands,
       respectively, and the state of the terminal  is  saved  or
       restored  when  a  foreground job is stopped or restarted,
       respectively.

       Note that only commands that create processes (e.g., asyn-
       chronous  commands,  subshell  commands,  and non-builtin,
       non-function commands) can be stopped; commands like  rreeaadd
       cannot be.

       When  a  job is created, it is assigned a job-number.  For
       interactive shells, this number is  printed  inside  [[..]],
       followed  by  the  process-ids of the processes in the job
       when an  asynchronous  command  is  run.   A  job  may  be
       referred to in bbgg, ffgg, jjoobbss, kkiillll and wwaaiitt commands either
       by the process id of  the  last  process  in  the  command
       pipeline  (as  stored in the $$!! parameter) or by prefixing
       the job-number with a percent  sign  (%%).   Other  percent
       sequences can also be used to refer to jobs:

        %%++          The  most  recently stopped job, or, if there
                    are no stopped jobs, the oldest running  job.
        %%%%, %%       Same as %%++.
        %%--          The  job  that  would  be  the %%++ job, if the
                    later did not exist.
        %%_n          The job with job-number _n.
        %%??_s_t_r_i_n_g    The job  containing  the  string  _s_t_r_i_n_g  (an
                    error occurs if multiple jobs are matched).
        %%_s_t_r_i_n_g     The job starting with string _s_t_r_i_n_g (an error
                    occurs if multiple jobs are matched).

       When a job changes state (e.g., a background job  finishes
       or  foreground  job is stopped), the shell prints the fol-
       lowing status information:
                      [[_n_u_m_b_e_r]] _f_l_a_g _s_t_a_t_u_s _c_o_m_m_a_n_d
       where

        _n_u_m_b_e_r
              is the job-number of the job.

        _f_l_a_g  is ++ or -- if the job is the %%++ or %%--  job,  respec-
              tively, or space if it is neither.



                        November 28, 1994                      38





KSH(1)                    User commands                    KSH(1)


        _s_t_a_t_u_s
              indicates the current state of the job and can be

              RRuunnnniinngg
                     the  job has neither stopped or exited (note
                     that running does not necessarily mean  con-
                     suming  CPU  time  --  the  process could be
                     blocked waiting for some event).

              DDoonnee [((_n_u_m_b_e_r))]
                     the job exited. _n_u_m_b_e_r is the exit status of
                     the  job,  which is omitted if the status is
                     zero.

              SSttooppppeedd [((_s_i_g_n_a_l))]
                     the job was stopped by the indicated  _s_i_g_n_a_l
                     (if  no signal is given, the job was stopped
                     by SIGTSTP).

              _s_i_g_n_a_l_-_d_e_s_c_r_i_p_t_i_o_n [((ccoorree dduummppeedd))]
                     the  job  was  killed  by  a  signal  (e.g.,
                     Memory fault,  Hangup,  etc.  -- use kkiillll --ll
                     for a list  of  signal  descriptions).   The
                     ((ccoorree dduummppeedd))  message indicates the process
                     created a core file.

        _c_o_m_m_a_n_d
              is the command that created the process.  If  there
              are  multiple  processes in the job, then each pro-
              cess will have a line showing its _c_o_m_m_a_n_d and  pos-
              sibly  its _s_t_a_t_u_s, if it is different from the sta-
              tus of the previous process.

   EEmmaaccss IInntteerraaccttiivvee IInnppuutt LLiinnee EEddiittiinngg
       When the eemmaaccss option is set, interactive input line edit-
       ing  is enabled.  WWaarrnniinngg: This mode is slightly different
       from the emacs mode in the original Korn shell and the 8th
       bit is stripped in emacs mode.  In this mode various edit-
       ing commands (typically bound to one or more control char-
       acters) cause immediate actions without waiting for a new-
       line.  Several editing commands are  bound  to  particular
       control  characters when the shell is invoked; these bind-
       ings can be changed using the following commands:

       bbiinndd   The current bindings are listed.

       bbiinndd _s_t_r_i_n_g==[_e_d_i_t_i_n_g_-_c_o_m_m_a_n_d]
              The specified editing command is bound to the given
              ssttrriinngg, which should consist of a control character
              (which may be written  using  caret  notation  ^^_X),
              optionally  preceded by one of the two prefix char-
              acters.  Future input of the _s_t_r_i_n_g will cause  the
              editing  command  to  be immediately invoked.  Note
              that although only two prefix  characters  (usually



                        November 28, 1994                      39





KSH(1)                    User commands                    KSH(1)


              ESC  and  ^X)  are  supported, some multi-character
              sequences can be supported.   The  following  binds
              the arrow keys on an ANSI terminal, or xterm (these
              are in  the  default  bindings).   Of  course  some
              escape sequences won't work out quite this nicely:

              bbiinndd ''^^[[[[''==pprreeffiixx--22
              bbiinndd ''^^XXAA''==uupp--hhiissttoorryy
              bbiinndd ''^^XXBB''==ddoowwnn--hhiissttoorryy
              bbiinndd ''^^XXCC''==ffoorrwwaarrdd--cchhaarr
              bbiinndd ''^^XXDD''==bbaacckkwwaarrdd--cchhaarr

       bbiinndd --mm _s_t_r_i_n_g==[_s_u_b_s_t_i_t_u_t_e]
              The specified input _s_t_r_i_n_g will afterwards be imme-
              diately replaced by the  given  _s_u_b_s_t_i_t_u_t_e  string,
              which may contain editing commands.

       The  following  editing  commands are available; first the
       command name is given followed by its default binding  (if
       any) using caret notation (note that the ASCII ESC charac-
       ter is written as ^[), then the editing function performed
       is  described.   Note  that editing command names are used
       only with the bbiinndd  command.   Furthermore,  many  editing
       commands  are useful only on terminals with a visible cur-
       sor.  The default bindings were chosen to resemble  corre-
       sponding  EMACS  key  bindings.   The users tty characters
       (e.g., ERASE) are bound to reasonable substitutes.

       aabboorrtt ^^GG
              Useful as a response to a  request  for  a  sseeaarrcchh--
              hhiissttoorryy pattern in order to abort the search.

       aauuttoo--iinnsseerrtt
              Simply  causes  the  character to appear as literal
              input.  Most ordinary characters are bound to this.

       bbaacckkwwaarrdd--cchhaarr ^^bb
              Moves the cursor backward one character.

       bbaacckkwwaarrdd--wwoorrdd ^^[[bb
              Moves  the  cursor  backward  to the beginning of a
              word; words are delimited by the current setting of
              IIFFSS.

       bbeeggiinnnniinngg--ooff--lliinnee ^^AA
              Moves  the  cursor  to  the beginning of the edited
              input line.

       ccoommpplleettee ^^[[^^[[
              Automatically completes as much as is unique of the
              hashed command name or the file name containing the
              cursor.  If the entire remaining  command  or  file
              name is unique a space is printed after its comple-
              tion, unless it is a directory name in which case //



                        November 28, 1994                      40





KSH(1)                    User commands                    KSH(1)


              is appended.  If there is no hashed command or file
              name with the current partial word as its prefix, a
              bell  character  is output (usually causing a audio
              beep).

       ccoommpplleettee--ccoommmmaanndd ^^XX^^[[
              Automatically completes as much as is unique of the
              hashed  command  name having the partial word up to
              the cursor as its prefix, as in the  ccoommpplleettee  com-
              mand  described  above.   Only command and function
              names seen since  the  last  hhaasshh  --rr  command  are
              available  for  completion; the hhaasshh command may be
              used to register additional names.

       ccoommpplleettee--ffiillee ^^XX^^XX
              Automatically completes as much as is unique of the
              file  name having the partial word up to the cursor
              as its prefix, as in the ccoommpplleettee command described
              above.

       ccooppyy--llaasstt--aarrgg ^^[[__
              The  last  word of the previous command is inserted
              at the cursor.  Note I/O redirections do not  count
              as words of the command.

       ddeelleettee--cchhaarr--bbaacckkwwaarrdd EERRAASSEE
              Deletes the character before the cursor.

       ddeelleettee--cchhaarr--ffoorrwwaarrdd
              Deletes the character after the cursor.

       ddeelleettee--wwoorrdd--bbaacckkwwaarrdd ^^[[EERRAASSEE
              Deletes  characters  before  the cursor back to the
              beginning of a word.

       ddeelleettee--wwoorrdd--ffoorrwwaarrdd ^^[[dd
              Deletes characters after the cursor up to  the  end
              of a word.

       ddoowwnn--hhiissttoorryy ^^NN
              Scrolls   the   history  buffer  forward  one  line
              (later).  Each input line  originally  starts  just
              after  the  last  entry  in  the history buffer, so
              ddoowwnn--hhiissttoorryy is not  useful  until  either  sseeaarrcchh--
              hhiissttoorryy or uupp--hhiissttoorryy has been performed.

       eenndd--ooff--lliinnee ^^EE
              Moves the cursor to the end of the input line.

       eeoott ^^__ Acts  as  an  end-of-file;  this  is useful because
              edit-mode  input  disables  normal  terminal  input
              canonicalization.





                        November 28, 1994                      41





KSH(1)                    User commands                    KSH(1)


       eeoott--oorr--ddeelleettee ^^dd
              Acts  as  eot if alone on a line; otherwise acts as
              delete-char-forward.

       eexxcchhaannggee--ppooiinntt--aanndd--mmaarrkk ^^XX^^XX
              Places the cursor where the mark is, and  sets  the
              mark to where the cursor was.

       ffoorrwwaarrdd--cchhaarr ^^FF
              Moves the cursor forward one position.

       ffoorrwwaarrdd--wwoorrdd ^^[[ff
              Moves the cursor forward to the end of a word.

       kkiillll--lliinnee KKIILLLL
              Deletes the entire input line.

       kkiillll--ttoo--eeooll ^^KK
              Deletes the input from the cursor to the end of the
              line.

       kkiillll--rreeggiioonn ^^WW
              Deletes the input between the cursor and the  mark.

       lliisstt ^^[[??
              Prints  a sorted, columnated list of hashed command
              names or file names (if any) that can complete  the
              partial  word  containing  the  cursor.   Directory
              names have // appended to them, and executable  file
              names are followed by a **.

       lliisstt--ccoommmmaanndd ^^XX??
              Prints  a sorted, columnated list of hashed command
              names (if any) that can complete the  partial  word
              containing the cursor.

       lliisstt--ffiillee ^^XX^^YY
              Prints  a sorted, columnated list of file names (if
              any) that can complete the partial word  containing
              the  cursor.   File type indicators are appended as
              described under lliisstt above.

       nneewwlliinnee ^^JJ

       nneewwlliinnee ^^MM
              Causes the current input line to  be  processed  by
              the shell.  The current cursor position may be any-
              where on the line.

       nneewwlliinnee--aanndd--nneexxtt ^^OO
              Causes the current input line to  be  processed  by
              the  shell,  and the next line from history becomes
              the current line.  This is only useful after an up-
              history or search-history.



                        November 28, 1994                      42





KSH(1)                    User commands                    KSH(1)


       nnoo--oopp QQUUIITT
              This does nothing.

       pprreeffiixx--11 ^^[[
              Introduces a 2-character command sequence.

       pprreeffiixx--22 ^^XX

       pprreeffiixx--22 ^^[[[[
              Introduces a 2-character command sequence.

       qquuoottee ^^^^
              The  following  character is taken literally rather
              than as an editing command.

       rreeddrraaww ^^LL
              Reprints the prompt string and  the  current  input
              line.

       sseeaarrcchh--cchhaarraacctteerr ^^]]
              Search  forward  in  the  current line for the next
              keyboard character.

       sseeaarrcchh--hhiissttoorryy ^^RR
              Enter incremental search mode.  The  internal  his-
              tory list is searched backwards for commands match-
              ing the input.  An initial ^^ in the  search  string
              anchors  the  search.   The  abort  key  will leave
              search mode.  Other commands will be executed after
              leaving  search  mode.   Successive  sseeaarrcchh--hhiissttoorryy
              commands continue searching backward  to  the  next
              previous  occurrence  of  the pattern.  The history
              buffer retains only a finite number of  lines;  the
              oldest are discarded as necessary.

       sseett--mmaarrkk--ccoommmmaanndd ^^[[<space>
              Set the mark at the cursor position.

       ssttuuffff  On  systems supporting it, pushes the bound charac-
              ter back onto  the  terminal  input  where  it  may
              receive special processing by the terminal handler.
              This is useful for the BRL ^^TT mini-systat  feature,
              for example.

       ssttuuffff--rreesseett
              Acts  like  ssttuuffff, then aborts input the same as an
              interrupt.

       ttrraannssppoossee--cchhaarrss ^^TT
              If at the end of line, or if the  ggmmaaccss  option  is
              set,  this  exchanges  the two previous characters;
              otherwise, it exchanges the  previous  and  current
              characters  and  moves  the cursor one character to
              the right.



                        November 28, 1994                      43





KSH(1)                    User commands                    KSH(1)


       uupp--hhiissttoorryy ^^PP
              Scrolls the history buffer backward one line  (ear-
              lier).

       yyaannkk ^^YY
              Inserts the most recently killed text string at the
              current cursor position.

       yyaannkk--ppoopp ^^[[yy
              Immediately after a  yyaannkk,  replaces  the  inserted
              text  string  with  the  next  previous killed text
              string.

       vveerrssiioonn ^^VV
              Display the  version  of  ksh.   The  current  edit
              buffer  is  restored  as soon as any key is pressed
              (the key is then processed).

   VVii IInntteerraaccttiivvee IInnppuutt LLiinnee EEddiittiinngg
       The vi command line editor in ksh has basically  the  same
       commands  as the vi editor (see _v_i(1)), with the following
       exceptions:

         +o    you start out in insert mode,

         +o    there are file name completion commands (==,  \\,  **,
              ^^XX, ^^EE, ^^FF and, optionally, ^^II),

         +o    the  __  command is different (in ksh it is the last
              argument command, in vi it goes to the start of the
              current line),

         +o    the // and GG commands move in the opposite direction
              as the jj command

         +o    and commands which don't make  sense  in  a  single
              line editor aren't available (e.g., screen movement
              commands, ex :: commands, etc.).

       Note that the ^^XX stands for control-X; also <<eesscc>>, <<ssppaaccee>>
       and <<ttaabb>> are used for escape, space and tab, respectively
       (no kidding).

       Like vi, there are two  modes:  insert  mode  and  command
       mode.   In  insert mode, most characters are simply put in
       the buffer at the current  cursor  position  as  they  are
       typed, however, some characters are treated specially.  In
       particular, the following characters are taken  from  cur-
       rent tty settings (see _s_t_t_y(1)) and have their usual mean-
       ing (normal values are in parentheses): kill  (^^UU),  erase
       (^^??),  werase (^^WW), eof (^^DD), intr (^^CC) and quit (^^\\).  In
       addition to the above, the following characters  are  also
       treated specially in insert mode:




                        November 28, 1994                      44





KSH(1)                    User commands                    KSH(1)


        ^^HH          erases previous character
        ^^VV          literal next: the next character typed is not
                    treated specially (can be used to insert  the
                    characters being described here)
        ^^JJ ^^MM       end of line: the current line is read, parsed
                    and executed by the shell
        <<eesscc>>       puts the editor in command mode (see below)
        ^^EE          file name enumeration (see below)
        ^^FF          file name completion (see below)
        ^^XX          file name expansion (see below)
        <<ttaabb>>       optional file name  completion  (see  below),
                    enabled with sseett --oo vvii--ttaabbccoommpplleettee

       If  a  line  is  longer that the screen width (see CCOOLLUUMMNNSS
       parameter), a >>, ++ or << character is displayed in the last
       column  indicating  that  there are more characters after,
       before and after, or before the current position,  respec-
       tively.  The line is scrolled horizontally as necessary.

       In  command  mode, each character is interpreted as a com-
       mand.  Characters that don't correspond to  commands,  are
       illegal  combinations  of  commands  or  are commands that
       can't be carried out all cause beeps.   In  the  following
       command  descriptions,  a  _n  indicates the command may be
       prefixed by a number (e.g., 1100ll  moves  right  10  charac-
       ters);  if  no number prefix is used, _n is assumed to be 1
       unless otherwise specified.  The term  `current  position'
       refers  to the position between the cursor and the charac-
       ter preceding the cursor.  A `word' is a sequence of  let-
       ters,  digits  and  underscore characters or a sequence of
       non-letter,  non-digit,  non-underscore,   non-white-space
       characters  (e.g.,  ab2*&^ contains two words) and a `big-
       word' is a sequence of non-white-space characters.

       Special ksh vi commands
              The following commands are not in, or are different
              from, the normal vi file editor:

              _n__     insert  a space followed by the _nth big-word
                     from the last command in the history at  the
                     current position and enter insert mode; if _n
                     is not specified, the last word is inserted.

              ##      insert  the  comment  character  (##)  at the
                     start of the current  line  and  return  the
                     line to the shell (equivalent to II##^^JJ).

              _ngg     like  GG,  except  if  _n is not specified, it
                     goes to the most recent remembered line.

              _nvv     edit line _n using the vi editor; if _n is not
                     specified,  the current line is edited.  The
                     actual   command   executed   is   `ffcc    --ee
                     $${{VVIISSUUAALL::--$${{EEDDIITTOORR::--vvii}}}} _n'.



                        November 28, 1994                      45





KSH(1)                    User commands                    KSH(1)


              ** and ^^XX
                     file  name  expansion:  replace  the current
                     big-word with the words obtained by  append-
                     ing a * to it and doing file name expansion.
                     After expansion, the cursor is  placed  just
                     past  the  last  word  and  the editor is in
                     insert mode.

              \\ and ^^FF
                     file name completion:  replace  the  current
                     big-word   with  the  longest  unique  match
                     obtained after performing file  name  expan-
                     sion.

              == and ^^EE
                     file  name  enumeration:  list all the files
                     that match the current big-word.

       Intra-line movement commands

              _nhh and _n^^HH
                     move left _n characters.

              _nll and _n<<ssppaaccee>>
                     move right _n characters.

              00      move to column 0.

              ^^      move to the first non-space character.

              _n||     move to column _n.

              $$      move to the last character.

              _nbb     move back _n words.

              _nBB     move back _n big-words.

              _nff     move forward _n words.

              _nFF     move forward _n big-words.

              _nee     move forward to the end the word, _n times.

              _nEE     move forward to  the  end  the  big-word,  _n
                     times.

              %%      find match: the editor looks forward for the
                     nearest parenthesis, bracket  or  brace  and
                     then  moves the to the matching parenthesis,
                     bracket or brace.

              _nff_c    move forward to the _nth  occurrence  of  the
                     character _c.



                        November 28, 1994                      46





KSH(1)                    User commands                    KSH(1)


              _nFF_c    move  backward  to the _nth occurrence of the
                     character _c.

              _ntt_c    move forward to just before the  _nth  occur-
                     rence of the character _c.

              _nTT_c    move  backward to just before the _nth occur-
                     rence of the character _c.

              _n;;     repeats the last ff, FF, tt or TT command.

              _n,,     repeats the last ff, FF, tt or TT  command,  but
                     moves in the opposite direction.

       Inter-line movement commands

              _njj and _n++ and _n^^NN
                     move to the _nth next line in the history.

              _nkk and _n-- and _n^^PP
                     move  to  the  _nth previous line in the his-
                     tory.

              _nGG     move to line _n in the history; if _n  is  not
                     specified,  the number first remembered line
                     is used.

              _ngg     like GG, except if _n  is  not  specified,  it
                     goes to the most recent remembered line.

              _n//_s_t_r_i_n_g
                     search  backward through the history for the
                     _nth line containing _s_t_r_i_n_g; if _s_t_r_i_n_g starts
                     with  ^^,  the  remainder  of the string must
                     appear at the start of the history line  for
                     it to match.

              _n??_s_t_r_i_n_g
                     same   as  //,  except  it  searches  forward
                     through the history.

              _nnn     search for the _nth occurrence  of  the  last
                     search  string;  the direction of the search
                     is the same as the last search.

              _nNN     search for the _nth occurrence  of  the  last
                     search  string;  the direction of the search
                     is the opposite of the last search.

       Edit commands

              _naa     append text _n times: goes into  insert  mode
                     just after the current position.  The append
                     is only replicated if command  mode  is  re-



                        November 28, 1994                      47





KSH(1)                    User commands                    KSH(1)


                     entered (i.e., <esc> is used).

              _nAA     same  as  aa, except it appends at the end of
                     the line.

              _nii     insert text _n times: goes into  insert  mode
                     at  the  current position.  The insertion is
                     only  replicated  if  command  mode  is  re-
                     entered (i.e., <esc> is used).

              _nII     same as ii, except the insertion is done just
                     before the first non-blank character.

              _nss     substitute  the  next  _n  characters  (i.e.,
                     delete  the  characters  and  go into insert
                     mode).

              SS      substitute whole line: all  characters  from
                     the  first non-blank character to the end of
                     line are deleted and insert mode is entered.

              _ncc_m_o_v_e_-_c_m_d
                     change  from  the  current  position  to the
                     position resulting from _n  _m_o_v_e_-_c_m_ds  (i.e.,
                     delete  the  indicated  region  and  go into
                     insert mode); if _m_o_v_e_-_c_m_d  is  cc,  the  line
                     starting  from the first non-blank character
                     is changed.

              CC      change from the current position to the  end
                     of  the line (i.e., delete to the end of the
                     line and go into insert mode).

              _nxx     delete the next _n characters.

              _nXX     delete the previous _n characters.

              _nDD     delete to the end of the line.

              _ndd_m_o_v_e_-_c_m_d
                     delete from  the  current  position  to  the
                     position  resulting  from _m_o_v_e_-_c_m_d; _m_o_v_e_-_c_m_d
                     is a movement command (see above) or  dd,  in
                     which case the current line is deleted.

              _nrr_c    replace the next _n characters with the char-
                     acter _c.

              _nRR     replace: enter  insert  mode  but  overwrite
                     existing  characters  instead  of  inserting
                     before existing characters.  The replacement
                     is repeated _n times.

              _n~~     change the case of the next _n characters.



                        November 28, 1994                      48





KSH(1)                    User commands                    KSH(1)


              _nyy_m_o_v_e_-_c_m_d
                     yank  from the current position to the posi-
                     tion resulting from  _n  _m_o_v_e_-_c_m_ds  into  the
                     yank  buffer;  if  _m_o_v_e_-_c_m_d  is yy, the whole
                     line is yanked.

              YY      yank from the current position to the end of
                     the line.

              _npp     paste  the  contents of the yank buffer just
                     after the current position, _n times.

              _nPP     same as pp, except the buffer  is  pasted  at
                     the current position.

       Miscellaneous vi commands

              ^^JJ and ^^MM
                     the  current  line  is read, parsed and exe-
                     cuted by the shell.

              ^^LL and ^^RR
                     redraw the current line.

              _n..     redo the last edit command _n times.

              uu      undo the last edit command.

              _i_n_t_r and _q_u_i_t
                     the interrupt and quit  terminal  characters
                     cause  the  current line to be deleted and a
                     new prompt to be printed.

       Missing vi commands
              The following vi commands are in the original  Korn
              shell, but are not yet in pdksh:

              UU      undo  all changes that have been made to the
                     current line.

              @@_c     macro expansion: execute the commands  found
                     in the alias __c.

FFIILLEESS
       ~/.profile
       /etc/profile
       /etc/suid_profile

BBUUGGSS
       Any  bugs  in pdksh should be reported to pdksh@cs.mun.ca.
       Please include the version  of  pdksh  (echo  $KSH_VERSION
       shows  it), the machine, operating system and compiler you
       are using and a description of how to repeat  the  bug  (a
       small  shell  script  that  demonstrates the bug is best).



                        November 28, 1994                      49





KSH(1)                    User commands                    KSH(1)


       The following, if relevant (if you  aren't  sure,  include
       them),  are  also  helpful:  options  you  are using (both
       options.h options and set -o options) and a copy  of  your
       config.h  (the  file  generated  by the configure script).
       New   versions   of   pdksh   can   be    obtained    from
       ftp.cs.mun.ca:pub/pdksh/.

AAUUTTHHOORRSS
       pdksh  is  based  on  the public domain 7th edition Bourne
       shell by Charles Forsyth and parts of  the  BRL  shell  by
       Doug  A. Gwyn, Doug Kingston, Ron Natalie, Arnold Robbins,
       Lou Salkind and others.  The first release  of  pdksh  was
       created  by Eric Gisin, and it was subsequently maintained
       by John R. MacMillan (chance!john@sq.sq.com), and Simon J.
       Gerraty  (sjg@zen.void.oz.au).   The current maintainer is
       Michael  Rendell  (michael@cs.mun.ca).   The  CONTRIBUTORS
       file  in  the source distribution contains a more complete
       list of people and their part in pdksh.

SSEEEE AALLSSOO
       awk(1),  sh(1),  csh(1),  ed(1),  getconf(1),   getopt(1),
       sed(1),  stty(1),  vi(1),  dup(2),  execve(2),  getgid(2),
       getuid(2), open(2), pipe(2), wait(2), getopt(3),  rand(3),
       signal(3), system(3), environ(5)

       _U_N_I_X  _S_h_e_l_l  _P_r_o_g_r_a_m_m_i_n_g_,  Stephen  G.  Kochan, Patrick H.
       Wood, Hayden.

       _T_h_e _K_o_r_n_S_h_e_l_l _C_o_m_m_a_n_d  _a_n_d  _P_r_o_g_r_a_m_m_i_n_g  _L_a_n_g_u_a_g_e_,  Morris
       Bolsky and David Korn, 1989, ISBN 0-13-516972-0.



























                        November 28, 1994                      50


