/* $Id: reply.c 1.1 1995/01/01 07:11:14 cthuang Exp $
 *
 * Send reply packet.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "souper.h"

#define INEWS_PATH    (getenv("POSTER") ? getenv("POSTER") : "inews")
#define SENDMAIL_PATH (getenv("MAILER") ? getenv("MAILER") : "sendmail -t")

/* Find given header line */

static char *
getHeader (FILE *fd, const char *header)
{
    char buf[BUFSIZ], *result;
    long offset;
    int headerLen, n;

    /* Remember file position */
    offset = ftell(fd);

    headerLen = strlen(header);

    /* Look through header */
    while (fgets(buf, sizeof(buf), fd)) {
	if (buf[0] == '\n')
	    break;

	if (strnicmp(buf, header, headerLen) == 0 && buf[headerLen] == ':'
	 && (buf[headerLen+1] == ' ' || buf[headerLen+1] == '\t')) {
	    fseek(fd, offset, SEEK_SET);
	    n = strlen(buf + headerLen + 2);
	    result = (char *)xmalloc(n + 1);
	    strcpy(result, buf + headerLen + 2);
	    if (result[n-1] == '\n')
		result[n-1] = '\0';
	    return result;
	}
    }       

    /* Reposition file */
    fseek(fd, offset, SEEK_SET);
    return NULL;
}

/* Pipe a SLNP reply to the specified delivery agent */

static void
SLPipe (FILE *fd, int bytes, const char *agent)
{
    FILE *pfd;
    unsigned char c;

    /* Open pipe to agent */
    if ((pfd = popen(agent, "w")) == NULL) {
	fprintf(stderr, "%s: can't open reply pipe\n", progname);
	while (bytes--)
	    fgetc (fd);
	return;
    }

    /* Send message to pipe */
    while (bytes--) {
	c = fgetc(fd);
	fputc(c, pfd);
    }

    pclose(pfd);
}

/* Process a SLNP mail reply file, usenet type */

static void
SLuMail (const char *fn)
{
    char buf[BUFSIZ];
    FILE *fd;
    int bytes;
    char *to, *addr;

    /* Open the reply file */
    if ((fd = fopen (fn, "rb")) == NULL) {
	fprintf(stderr, "%s: can't open %s\n", progname, fn);
	return;
    }

    /* Read through it */
    while (fgets(buf, sizeof(buf), fd)) {
	if (strncmp (buf, "#! rnews ", 9)) {
	    fprintf(stderr, "%s: malformed reply file\n", progname);
	    fclose(fd);
	    return;
	}

	/* Get byte count */
	sscanf(buf+9, "%d", &bytes);

	/* Look for To: */
	to = getHeader(fd, "To");
	printf("%s: Mailing to %s\n", progname, to);
	free(to);

	/* Pipe message to delivery agent */
	SLPipe(fd, bytes, SENDMAIL_PATH);
    }

    fclose(fd);
}

/* Process a SLNP news reply file, usenet type */

static void
SLuNews (const char *fn)
{
    char buf[BUFSIZ];
    FILE *fd;
    int bytes;
    char *grp;

    /* Open the reply file */
    if ((fd = fopen (fn, "rb")) == NULL) {
	fprintf (stderr, "%s: can't open %s\n", progname, fn);
	return;
    }

    /* Read through it */
    while (fgets(buf, sizeof(buf), fd)) {
	if (strncmp (buf, "#! rnews ", 9)) {
	    fprintf(stderr, "%s: mailformed reply file\n", progname);
	    fclose(fd);
	    return;
	}

	/* Get byte count */
	sscanf(buf+9, "%d", &bytes);

	grp = getHeader(fd, "Newsgroups");
	printf("%s: Posting article to %s\n", progname, grp);
	free (grp);

	/* Pipe message to delivery agent */
	SLPipe(fd, bytes, INEWS_PATH);
    }
    fclose(fd);
}

/* Process a SLNP mail reply file, binary type */
static void
SLbMail (const char *fn)
{
    char buf[BUFSIZ];
    unsigned char count[4];
    FILE *fd;
    int bytes;
    char *to, *addr;

    /* Open the reply file */
    if ((fd = fopen(fn, "rb")) == NULL) {
	fprintf(stderr, "%s: can't open %s\n", progname, fn);
	return;
    }

    /* Read through it */
    while (fread(count, sizeof(char), 4, fd) == 4) {
	/* Get byte count */
	bytes = ((count[0]*256 + count[1])*256 + count[2])*256 + count[3];

	/* Look for To: */
	to = getHeader(fd, "To");
	printf("%s: Mailing to %s\n", progname, to);
	free(to);

	/* Pipe message to delivery agent */
	SLPipe(fd, bytes, SENDMAIL_PATH);
    }

    fclose(fd);
}

/* Process a SLNP news reply file, binary type */

static void
SLbNews (const char *fn)
{
    char buf[BUFSIZ];
    unsigned char count[4];
    FILE *fd;
    int bytes;
    char *grp;

    /* Open the reply file */
    if ((fd = fopen (fn, "rb")) == NULL) {
	fprintf(stderr, "%s: can't open %s\n", progname, fn);
	return;
    }

    /* Read through it */
    while (fread(count, sizeof(char), 4, fd) == 4) {
	/* Get byte count */
	bytes = ((count[0]*256 + count[1])*256 + count[2])*256 + count[3];

	grp = getHeader(fd, "Newsgroups");
	printf("%s: Posting article to %s\n", progname, grp);
	free (grp);

	/* Pipe message to delivery agent */
	SLPipe(fd, bytes, INEWS_PATH);
    }
    fclose(fd);
}

/* Process a reply packet. */

void
sendReply (void)
{
    FILE *rep_fd;
    char buf[BUFSIZ], repFile[FILENAME_MAX];
    char fname[FILENAME_MAX], kind[FILENAME_MAX], type[FILENAME_MAX];

    /* Open the packet */
    strcpy(repFile, "REPLIES");
    if ((rep_fd = fopen(repFile, "rb")) == NULL) {
	fprintf(stderr, "%s: can't open %s\n", progname, repFile);
	return;
    }

    /* Look through lines in REPLIES file */
    while (fgets(buf, sizeof(buf), rep_fd)) {
	if (sscanf(buf, "%s %s %s", fname, kind, type) != 3) {
	    fprintf(stderr, "%s: malformed REPLIES line\n", progname);
	    return;
	}

	/* Look for mail or news */
	if (strcmp(kind, "mail") != 0 && strcmp(kind, "news") != 0) {
	    fprintf (stderr, "%s: bad reply kind: %s\n", progname, kind);
	    continue;
	}

	/* Check reply type */
	if (type[0] != 'u' && type[0] != 'b' && type[0] != 'B') {
	    fprintf(stderr, "%s: reply type %c not supported\n", progname,
		type[0]);
	    continue;
	}

	/* Make file name */
	strcat(fname, ".MSG");

	/* Process it */
	switch (type[0]) {
	case 'u':
	    if (strcmp(kind, "mail") == 0) SLuMail(fname);
	    if (strcmp(kind, "news") == 0) SLuNews(fname);
	    break;
	case 'b':
	case 'B':
	    if (strcmp(kind, "mail") == 0) SLbMail(fname);
	    if (strcmp(kind, "news") == 0) SLbNews(fname);
	    break;
	}

	/* Delete it */
	if (!readOnly)
	    remove(fname);
    }

    fclose(rep_fd);

    if (!readOnly)
	remove(repFile);
}

