/***********************************************************************\
 *                                 PC2.c                               *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 *  Copyright (C) by Pflanz Ingo, 1993 for enhancements for use via    *
 *  commandline parameters or filetype association (use for *.cmd,     *
 *  *.bat, *.com, *.exe). For distribution, see above.                 *
 *                                                                     *
 * MakeObj.cmd  Installation batch file.                               *
 *                                                                     *
 *              MakeObj <InstallationPathDirectory>                    *
 *              F.e. MakeObj C:\PMAPPS\PC2                             *
 *                                                                     *
\***********************************************************************/

                                        /* Register REXX APIs */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Halt Name SignalHandler       /* Exception handler */

Parse Arg ObjectFileName                /* Get the path and filename of a file to be
                                           installed as a WPS Object with a defined
                                           Object ID, that can directly be installed
                                           to PC/2 */
                                        /* Search if this file exists once */
If ObjectFileName\=" " Then Do
    Rc=SysFileTree(ObjectFileName, FileExistFlag, 'FO')
    If Rc\=0 Then Do                    /* Any error is a fatal memory problem */
        Say
        Say " A fatal memory error occured, exiting..."
        Exit
    End
                                        /* If 1 file existed get it otherwise reinput */
    If FileExistFlag.0\=1 Then
        ObjectFileName=" "
    else
        NewObjectFileName=FileExistFlag.1
End
Do While ObjectFileName=" "
    Call SysCls
    Say "                   Empty WPS Objects Installer"
    Say
    Say " To install any empty Object with an registered Object ID (Idendity) onto the"
    Say " WPS, you must provide a symbolic name for this registered Object. You may"
    Say " then use PC/2 to launch this object, after you have configured this empty"
    Say " Object with the application you want to install as an object. F.e. you may"
    Say " want to create an empty Object and then configure it as an seamless WIN-OS2"
    Say " session, allowing you to launch this seamless WIN-OS2 session from PC/2."
    Say " Please supply a file with path and filename, which will be installed as a"
    Say " WPS object with brackets, WP extension and an Object ID of the filename"
    Say " without the extension. F.e. C:\PMAPPS\PC2\PC2.EXE will become and WPS Object"
    Say " of <WP_PC2>."
    Say
    Say " Syntax:       MAKEOBJ ObjecFileName"
    Say
    Say " Example:      MAKEOBJ C:\PMAPPS\PC2\PC2.EXE"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please input: "
    Col=Col+15
    Call SysCurPos Row, Col
    Pull ObjectFileName                 /* Get a complete filename */
                                        /* Search if this file exists once */
    Rc=SysFileTree(ObjectFileName, FileExistFlag, 'FO')
    If Rc\=0 Then Do                    /* Any error is a fatal memory problem */
        Say
        Say " A fatal memory error occured, exiting..."
        Exit
    End
                                        /* If 1 file existed get it otherwise reinput */
    If FileExistFlag.0\=1 Then
        ObjectFileName=" "
    else
        NewObjectFileName=FileExistFlag.1
End
Say
                                        /* Extract filename from path & filename */
NewObjectName=FILESPEC("Name", NewObjectFileName)
                                        /* Extract path from path & filename */
NewObjectPath=LEFT(NewObjectFileName, LASTPOS('\', NewObjectFileName)-1)
                                        /* Dismiss extension from filename */
NewObject=LEFT(NewObjectName, LASTPOS('.', NewObjectName)-1)
                                        /* Assign filename without extension between <WP_ and > */
NewObjectID="<WP_"NewObject">"
                                        /* Setup the WPS Object configuration */
SetupString="OBJECTID="NewObjectID";STARTUPDIR="NewObjectPath";EXENAME="NewObjectFileName";"
                                        /*'PROGTYPE='exetype';'||,'OPEN=DEFAULT;'||,*/
                                        /* could be added or not */
                                        /* Now create the WPS Object on the Desktop */
rc=SysCreateObject("WPProgram",,
                   NewObjectID,,        /* It should be NewObject, if I knew how to add the Object
                                           rendering mechanism to the filename rendering mechanism
                                           to PC/2's Drag & Drop support */
                   "<WP_DESKTOP>",,
                   SetupString)
If rc=0 Then Do
    Say " Sorry, WPS Object couldn't be created..."
    Say
    Say " Press Enter to continue!..."
    Pull IgnoreInput
End
Else Do
    Say " WPS Object sucessfully created..."
    Say
    Say " You may now want to open the Settings of the newly created empty WP Object to"
    Say " configure it to an application, f.e. an PM, DOS or seamless WIN-OS2 session."
End
Call SysCls
Exit

/*--------------------------------------------------------------------------------------*\
 * The signal handler to exit after an exception                                        *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
SignalHandler:
Call SysCls
Say "PC/2 abnormal error - exiting..."
Exit

