:h1. XSpO - External SpHyDir Rexx Code
:p.

It is nice to have code that understands Web Explorer, but other
people use Netscape, Mosaic, or other browsers. SpHyDir can't
handle every type of hotlist file. The solution to this and
other problems is an External SpHyDir Object. These are called
XSpO's (pronounced "expo") but given that they are written in
Rexx, it is acceptable to roll an "R" in front of the name and
call it a "Rexx-spo".
:p.

An XSpO is an external Rexx program that resides as a CMD file
on disk. If you click on the file with the second mouse button,
open its Settings, and change the icon, you can give it some
meaninful icon. Then you put a shadow of the file in a desktop
folder, probably along with your program object for SpHyDir.
:p.

An XSpO acts something like a Tool. You drag it from its
workplace folder and drop it somewhere in the SpHyDir program.
The nature of the XSpO decides where it can be dropped. Unlike
the Tools, an XSpO could be dropped on an entry area or list.
:p.

The XSpO interface will be extended whenever an idea comes to
mind. Currently, the two supported uses of an XSpO are to fill
the New Links list box in the Link Manager window and to add a
URL Link to an object in the work area. Sample XSpO files are
supplied with SpHyDir for both purposes and will be discussed
here.
:p.

SpHyDir assumes that it has an XSpO whenever the user drops a
CMD file on an object. When the object accepts XSpO, it
generates a Rexx Call to the file as an external procedure.
Since the caller is running in the VX-Rexx environment, all of
the VX-Rexx functions are available to the XSpO. However, it
will be difficult to make use of them without 1) a copy of the
VX-Rexx manual and 2) some hints from me about the environment.
An XSpO that uses VX-Rexx function calls to manipulate objects
is said to be "dirty." The internal implimentation of SpHyDir
may change in the future, and such files may need to be changed.
An object that supports XSpO will generally provide a convention
using only arguments, the return value, and the stack. Details
may differ from object to object. An XSpO that does not directly
call VX-Rexx functions is said to be "clean." The terms are
relative, and it may be convenient to use "quick and dirty"
techniques from time to time.
:p.

When an XSpO is called, it is always passed as an argument the
name of the object on which it was dropped. There is no good way
(currently) for XSpO's to declare a type, so the XSpO itself has
to make sure it has been dropped in the right place and return
without doing anything if it is called by the wrong object.
Objects that call XSpO's should ignore any null return.
:p.

When an XSpO is dropped on the New Links listbox of the Link
Manager window, it is passed no arguments other than the
"New_Links" object name. The XSpO puts new list entries on the
Rexx stack. Each entry begins with a URL (no blanks are allowed
by SpHyDir in a URL) and then a Title (blanks are OK in the
tile). Each line in the Rexx queue is one list entry. Only the
title will show up in the list box, the URL is kept as user data
and is presented later on when the title is dragged to create a
link. If the XSpO returns the word "CLEAR" from the function
call, then the list box is cleared and the new list becomes its
only contents. Otherwise, the new links are added in front of
the existing links.
:p.

The following is the complete text of an XSpO that duplicates
the existing Web Explorer Link Manager function. This file is
distributed with SpHyDir and may be adapted to support other
quicklist formats.
:fig.
/* XSpO version of Web Explorer Links */
arg object
if object<>"NEW_LINKS" then return

exploreini=Value("ETC",,"OS2ENVIRONMENT")"\EXPLORE.INI"
strm_status = Stream( exploreini, "Command", "Open Read" )
if strm_status="READY&colon." then
    do while lines(exploreini)>0
    line=linein(exploreini)
    if line="[quicklist]" then leave
    end
    do while lines(exploreini)>0
    line=linein(exploreini)
    parse var line "quicklist=" title
    if title="" then return
    url=linein(exploreini)
    queue url title
    end
return "CLEAR"
:efig.
:p.

The Workarea also supports XSpO's, but the only function
currently supported is to add a Link to an object. Dropping this
type of XSpO on a Workarea object is simpler than adding the
link to the Link Manager list and then dragging the list item
over and dropping it on the object. A supplied XSpO uses some
rather "dirty" logic to find the current URL in Web Explorer
(you have to enable the WE option that displays the URL in a box
at the top of the window). Dropping this XSpO on a paragraph,
point, or image puts a link to whatever page is currently being
displayed in WE (without requiring that the page be added to the
Quicklist).
:fig.
arg object
    if wordpos(object, "NEW_LINKS WORKAREA")=0 then return

    desktop = "?HWND1"
    app = VRGet( desktop, "FirstChild" )
        do while app<>""
        title=VRGet(app,"Caption")
        if substr(title,1,16 )="IBM WebExplorer " then
            do
            title=strip(substr(title,19),"B")
            kid= VRGet(app,"FirstChild")
            url=Searcher(kid)
            if url<>"" then queue url title
	 if object="WORKAREA" then return "LINK"
            return "ADD"
            end
        app = VRGet( app, "Sibling" )
        end
return ""

Searcher&colon. procedure
    parse arg w
    do while w <> ""
        if VRGet( w, "Visible" ) = 1 then do          
            class = VRGet( w, "ClassName" )
            caption = VRGet( w, "Caption" )
            if class="WC_ENTRYFIELD" then return caption
            subkid = VRGet( w, "FirstChild" )
            url= searcher(subkid)
            if url<>"" then return url
            end
        w = VRGet( w, "Sibling" )
    end

return ""
:efig.
