;
;
; Filename     : Irq.asm
; Included from: Main Assembley Module
; Description  : Irq handler for timing/tracking vertical retrace
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; John Mccarthy would really love to work for a company programming Robots
; or doing some high intensive CPU work.  Hint. Hint.
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
; This uses irq 8 set to the same speed as the vertical retrace so that
; an animation will remain at a smooth/constant speed regardless of the
; machine speed: eg, a 386SX33 will run an animation at the same  speed
; as a 486DX66, only the 386 will skip frames to compensate.All the irq
; really does is "inc traces_past" and this information is used to skip
; frames. If traces_past =1 is 486DX66, =4 is 386 or whatever.  You get
; the idea right?
;
; The irq can operate in real mode or pmode.  Just call the appropiate
; routine.  I did this in case you want to add to  the  irq  your  own
; functions for sound or music or whatever.
;
; Protected mode IRQ controled  subroutines  are  not  available  when
; using the real mode IRQ (obviosly)
;
;

        .386p
        jumps

        public set_pmirq
        public reset_pmirq

        public set_rmirq
        public reset_rmirq

        public reset_raster_count
        public time_raster

        public frametime

        public traces_past
        public frame_number

        public _irqcontrol0
        public _irqcontrol1
        public _irqcontrol2
        public _irqcontrol3
        public _irqcontrol4
        public _irqcontrol5
        public _irqcontrol6
        public _irqcontrol7

        include 3d.ext
        include equ.inc

        pmodeirq equ 0  ; you could also use irq 8 for either of these.
        rmodeirq equ 8  ; both can run at the same time even if both=0.

;
; Real mode IRQ handler
;

code16  segment para public use16
        assume cs:code16, ds:code16

rmirq0:                             ; real mode IRQ0 handler
        push ax ds

; put your real mode irq code here!!!!!
;--------------------------------------



;--------------------------------------

; now my code, this is where i inc that variable
; real mode irq increments protected mode memory location

        mov ax,cs:rfs
        mov ds,ax
        mov si,cs:rfo

        inc dword ptr [si]          ; inc traces_past
        inc dword ptr [si+4]        ; inc frame_number

        pop ds
        mov al,20h
        out 20h,al
        pop ax

        iret

rfs     dw ?                        ; data segment for traces_past
rfo     dw ?                        ; di offset for traces_past

transfer_location:
        mov cs:rfs,cx               ; set protected mode location of
        mov cs:rfo,dx               ; traces_past in terms of real mode
        ret

code16  ends

;

code32  segment para public use32
        assume cs:code32, ds:code32

        include pmode.ext

ormirq0 dd ?                        ; old real mode IRQ handler seg:off
opmirq0 dd ?                        ; old protected mode IRQ handler off

traces_past   dd 0                  ; contains frame speed (irq driven)
frame_number  dd 0                  ; number of frames total,eg 23400 = 13 mins

;
; Protected mode IRQ handler
;

pmirq0:                             ; protected mode IRQ0 handler
        pushad

; put your protected mode irq code here!!!!!
;-------------------------------------------



;-------------------------------------------

; now my code, this is where i inc that variable
; protected mode version is easy!

        inc traces_past
        inc frame_number

        call [d _irqcontrol0]       ; call selected IRQ subroutines
        call [d _irqcontrol1]
        call [d _irqcontrol2]
        call [d _irqcontrol3]
        call [d _irqcontrol4]
        call [d _irqcontrol5]
        call [d _irqcontrol6]
        call [d _irqcontrol7]
        popad

        jmp cs:opmirq0              ; chain to old IRQ0 redirector

;
; Set_rmirq: Get real mode IRQ going
; In=Out=Null
;

set_rmirq:
        mov eax,gs:[rmodeirq*4]     ; save real mode IRQ0 vector
        mov ormirq0,eax

        cli                         ; set IRQ0 to inc variable

        mov word ptr gs:[rmodeirq*4],offset rmirq0  ; set real mode irq
        mov word ptr gs:[(rmodeirq*4)+2],code16

        mov edx,offset traces_past  ; tell real mode irq where traces_past
        add edx,_code32a            ; is in memory (pmode location)
        mov al,dl
        and ax,0fh
        shr edx,4
        mov v86r_cx,dx
        mov v86r_dx,ax

        mov cx,seg transfer_location
        mov dx,offset transfer_location
        int 32h

        sti

        jmp new_timer

;
; Reset_rmirq: Unhook real mode IRQ and reset original timer
; In=Out=Null
;

reset_rmirq:
        cli

        mov eax,ormirq0             ; restore old real mode IRQ0 vector
        mov gs:[rmodeirq*4],eax

        sti

        jmp old_timer

;
; Set_pmirq: Get protected mode IRQ going
; In=Out=Null
;

set_pmirq:
        xor bl,bl                   ; get protected mode IRQ0 redirector
        call _getirqvect
        mov opmirq0,edx

        cli                         ; set IRQ0 to inc variable

        mov bl,pmodeirq
        mov edx,offset pmirq0
        call _setirqvect            ; set protected mode irq

        sti

        jmp new_timer

;
; Reset_pmirq: Unhook protected mode IRQ and reset original timer
; In=Out=Null
;

reset_pmirq:
        cli

        mov bl,pmodeirq
        mov edx,opmirq0
        call _setirqvect

        sti

        jmp old_timer

;
; Set Irq speed to match retrace time
;

new_timer:
        call time_raster

        cli
        mov al,36h
        out 43h,al
        mov ax,frametime
        out 40h,al
        mov al,ah
        out 40h,al
        sti

        ret

;
; Reset Irq speed to default speed
;

old_timer:                         ; reset timer for exit
        cli
        mov al,36h
        out 43h,al

        mov ax,0
        out 40h,al
        out 40h,al

        sti

        ret

;
; Reset_raster_count: reset counters (done before anmation loop)
; In=Out=Null
;

reset_raster_count:                ; reset count before any animation loop
        cli
        mov traces_past,1
        mov frame_number,0
        sti
        ret

;
; Time_raster: Guess what this does?
; In=Null
; Out:
;   AX=time for raster to occure
;

frametime dw 4276h

time_raster:
        cli
        mov dx, input_1        ; input# 1 reg
loop1:
        in al,dx               ; wait for vsync
        test al,8
        jnz loop1
loop2:
        in al,dx
        test al,8
        jz loop2

        mov al,36h             ; reset timer
        out 43h,al
        mov al,0
        out 40h,al
        mov al,0
        out 40h,al
loop3:
        in al,dx               ; wait for vsync
        test al,8
        jnz loop3
loop4:
        in al,dx
        test al,8
        jz loop4

        xor al,al              ; this calculation code courtesy future_crew
        out 43h,al             ; from mental.exe
        in al,40h
        mov ah,al
        in al,40h
        xchg al,ah
        neg ax
        shr ax,1
        mov frametime,ax

        sti
        ret

;
; These are the user difinable IRQ controlled jump vectors:
;
; You can have a certine function performed every  vertical retrace just
; by setting these to point to the code you wish to  be   called.   When
; you want to disable the subroutine, just reset these vectors to offset
; _ret.
;

_irqcontrol0 dd offset _ret
_irqcontrol1 dd offset _ret
_irqcontrol2 dd offset _ret
_irqcontrol3 dd offset _ret
_irqcontrol4 dd offset _ret
_irqcontrol5 dd offset _ret
_irqcontrol6 dd offset _ret
_irqcontrol7 dd offset _ret

code32  ends
        end
