; GOTO.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	goto
extrn	dwordtohex:near, hextodword:near
extrn	tprint:near, tprintce:near
extrn	getkey:near
extrn	ucursoron:near, locate:near
extrn	i4tostr:near, strtoi4:near
extrn	isdigit:near
extrn	up:near, down:near

include	dataseg.inc
extrn	rows:byte, inverse:byte
extrn	cursor:dword
extrn	display_mode:byte
extrn	first_row:byte
extrn	file_row:dword
goto_msg	db ' Go to: ',0
goto_msg_len	equ	$-goto_msg-1
row_msg		db ' row ',0
row_msg_len	equ	$-row_msg-1
col_msg		db ' column ',0
col_msg_len	equ	$-col_msg-1
@curseg	ends

string_limit	equ	byte ptr [ebp-1]

include	codeseg.inc
goto:
	mov	dh,rows
	inc	dh
	xor	dl,dl
	mov	ah,inverse
	lea	esi,goto_msg
	call	tprintce
	mov	dl,goto_msg_len

	cmp	display_mode,4
	je	_hex

; ASCII display mode

asciistring	equ	[ebp-13]

	enter	13,0
	mov	string_limit,11
	lea	esi,row_msg
	call	tprint
	add	dl,row_msg_len+12
	lea	esi,col_msg
	call	tprint

_ascii_row:
	mov	eax,file_row
	lea	esi,asciistring
	call	i4tostr
	movzx	ebx,string_limit
	dec	ebx

_next_row:
	lea	esi,asciistring
	mov	dl,row_msg_len+goto_msg_len
	mov	ah,inverse
	call	tprint
	push	edx
	add	dl,bl
	call	ucursoron
	pop	edx
	call	getkey
	shr	ah,1
	jnc	_ascii0
	call	_extended
	jmp	_next_row

_ascii0:
	cmp	al,27			; ESC?
	je	short _ascii_exit
	cmp	al,0Dh			; Enter?
	je	short _ascii_enter
	cmp	al,' '
	je	short _ascii1
	call	isdigit
	jc	_next_row

_ascii1:
	mov	[esi+ebx],al	; add key to string
	call	_right		; move cursor right
	jmp	_next_row	; get next key

_ascii_enter:
	call	strtoi4
	mov	ebx,offset @curseg:down
	sub	eax,file_row
	jnc	short _ascii3
	mov	ebx,offset @curseg:up
	neg	eax
_ascii3:
	mov	ecx,eax
	push	ebp
_ascii4:
	push	ecx
	push	ebx
	call	ebx
	pop	ebx
	pop	ecx
	loop	_ascii4
	pop	ebp

_ascii_exit:
	leave
	clc
	ret

hexstring	equ	[ebp-11]

_hex:
	enter	11,0
	mov	string_limit,8
	mov	eax,cursor
	lea	esi,hexstring
	call	dwordtohex
	mov	ah,inverse
	xor	ebx,ebx

_hex_getkey:
	mov	ah,inverse
	lea	esi,hexstring
	call	tprintce
	push	edx
	add	dl,bl
	call	ucursoron
	pop	edx
	call	getkey
	shr	ah,1		; extended keycode?
	jnc	_hex0
	call	_extended
	jmp	_hex_getkey

_hex0:
	cmp	al,27		; ESC?
	je	short _hex_exit
	cmp	al,0Dh
	je	short _hex_enter

	cmp	al,'0'
	jb	_hex_getkey
	cmp	al,'9'
	jbe	short _hex_addkey
	and	al,(0FFh-32)	; upper case
	cmp	al,'A'
	jb	_hex_getkey
	cmp	al,'F'
	ja	_hex_getkey

_hex_addkey:
	mov	[esi+ebx],al
	call	_right
	jmp	_hex_getkey


_hex_enter:
	call	hextodword
	mov	esi,eax
	mov	cursor,esi
	mov	dh,rows
	sub	dh,first_row
	shr	dh,1
	add	dh,first_row
	call	locate

_hex_exit:
	leave
	ret

_extended:
	cmp	al,4Dh
	jne	short _ex0
	call	_right
	ret
_ex0:
	cmp	al,4Bh
	jne	_hex_getkey
	call	_left
	ret


_left:
	sub	ebx,1
	adc	ebx,0
	ret

_right:
	inc	ebx
	cmp	bl,string_limit
	cmc
	sbb	ebx,0
	ret


@curseg	ends
	end
