; INSKEY.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

;
; This routine adds a character to the file.  In insert mode, remaining
; characters are pushed forward.  If a CR is inserted, LF is also added.
;

include	model.inc

public	insert_key, advance
extrn	right:near
extrn	open_space:near
extrn	save_char:near
extrn	display_bottom:near
extrn	home:near
extrn	down:near

CR	equ	0Dh
LF	equ	0Ah
TAB	equ	09h

include	dataseg.inc
extrn	cursor:dword, dirty_bits:byte
extrn	insert_mode:byte, undo_length:dword
extrn	display_mode:byte
@curseg	ends

include	codeseg.inc
insert_key	proc	near
	push	es
	push	fs
	pop	es
	assume	es:nothing
	mov	esi,cursor

;
; check for HEX display mode
; and skip insert stuff if so
;
	cmp	display_mode,4
	je	short not_tab

;
; ASCII display mode
;
	cmp	al,CR			; is the char a CR?
	je	short new_line
	cmp	insert_mode,0		; insert mode?
	jne	short insert_char
	cmp	byte ptr es:[esi],CR	; at end of line?
	je	short insert_char
	cmp	al,tab			; new char a TAB?
	jne	short not_tab			; no special handling if not
	cmp	es:[esi],al		; at a TAB?
	jne	short insert_char	; insert tab if old char <> TAB
not_tab:
	mov	edi,esi
	xchg	es:[esi],al		; swap new char for old
	call	save_char		; store the old one
	jmp	short adv0
insert_char:
	push	eax		; save the new character
	mov	eax,1
	call	open_space	; ret: ESI = cursor
	pop	eax
	mov	edi,esi
	jc	short file_full	; CF if file full
	stosb
adv0:
	or	dirty_bits,4	; current line is dirty
	push	undo_length
	call	right		; move cursor to next letter
	pop	undo_length
	or	dirty_bits,11000000b
file_full:
	clc
	pop	es
	ret

advance:
	push	es
	jmp	adv0

new_line:
	push	esi
	mov	eax,2
	call	open_space	; make room for CR+LF
	pop	edi
	jc	file_full
	mov	ax,LF*256+CR
	stosw
	call	display_bottom
	call	home
	call	down
	or	dirty_bits,11000001b
	pop	es
	ret
insert_key	endp

@curseg	ends
	end
