;------------------
; multi.asm - Multi-boot the partition table. James Vahn, public domain.
; Data on the disk is destroyed by the normal use of this program.
;
;            <<---]* BEWARE!! Use at your own risk. *[--->>
;
; The key is to reboot after changing the system indicator (offset 4)
; before you format the disk. Fdisk will then happily change your
; boot partition for you. Interestingly, it's safe to use a system
; type 6 (32bit FAT) on even small partitions.
;
; To use this program, run fdisk and make a PRI-DOS partition and
; an extended partition. This program converts the extended partition
; to another primary. Owners of larger drives will probably want at
; least one extended partition for logical drives.
;
cseg segment
assume cs:cseg
org 100h                        ;COM -> CS=DS=ES=SS
Begin:
        mov     ah,9            ;Print a warning.
        mov     dx,offset msg
        int     21h
        mov     ah,0            ;Get keyboard input.
        int     16h
        cmp     al,'y'          ;Was a 'y' pressed?
        je      l1              ; yes: continue.
        int     20h             ; no: abort.
   l1:  mov     ax,0201h        ;int 31/2, Read 1 sector.
        mov     bx,offset buf   ;Point to buffer.
        mov     cx,1            ;Read track 0, sector 1.
        mov     dx,80h          ;Head 0, drive C.
        int     13h
        mov     cx,4
        mov     si,offset buf+1BEh        ;Start of partition table.
   l2:  cmp     byte ptr[si+4],5  ;Is it a DOS extended partition?
        jne     l3                ; no, check next one.
        mov     byte ptr[si+4],6  ;Make it a 32bit DOS FAT regardless.
   l3:  add     si,16           ;Point to next partition entry.
        loop    l2              ;Check all four entries.
        mov     cx,1
        mov     ax,0301h
        mov     bx,offset buf
;        int     13h             ;Write new partition table (MBR).
        mov     ah,9
        mov     dx,offset txt
        int     21h
        mov     ah,0            ;Wait for keypress.
        int     16h
        mov     ax,40h          ;Prepare for warm reboot.
        mov     es,ax
        mov     bx,72h
        mov     word ptr es:[bx],1234h
        db 0EAh,00,00,0FFh,0FFh        ;JMP FFFF:0000

msg db 'Are you sure?  Write new partition table? [y/N] ',36

txt db 13,'At this point you can either run Fdisk again to make',13,10
    db 'another extended partition, or format what you have.',13,10
    db 'Once all the drives have been formatted you can use',13,10
    db 'fdisk to safely select one to boot from.',13,10,10
    db 'Press any key to reboot...',36

buf db ?

cseg ends
end Begin
