
        page 64,132
        title NOBOOT - disables <Ctrl><Alt><Del> reset sequence
        subttl Steve Harrison Systems n Software
        ;
        ;
comment *

        Documentation for NOBOOT:
        --------------------------

        This program disables the <Ctrl><Alt><Del> keyboard reset
        sequence. Once this program is installed, the only way to
        reboot the system is to turn the power off and then back
        on.

        This program is adapted from Personal Computer Age
        magazine Volume 2.4, pp 17-21.  The original version
        referenced absolute addresses in ROM, which limits
        portability to other machines or even to an XT.
        This version overcomes these restrictions, but adds
        the requirement that DOS 2.0 or greater be used.
        This program will not work with DOS 1.0 or 1.1.
        By necessity, one reference to an absolute memory
        address is made -- to KB_FLAG at 0040:0017h.  If your
        machine uses a different address, change the one line
        noted below to suit your machine.

        This program need be run only once. Although running it
        multiple times will cause no real harm, it could slow
        things down a bit.  In the interest of simplicity, no
        attempt is made to determine whether or not the "filter"
        is already installed -- it blindly installs itself as
        many times as you tell it to.  It is suggested that you
        execute this program from your AUTOEXEC.BAT file.

        Every time a key is pressed or released, the resident
        portion of this program checks to see if the <Ctrl> and
        <Alt> keys are both depressed.  If they are, it tells BIOS
        that they are not.  In effect, it "filters out" this
        key sequence.  This means that any program that
        requires you to make a keyboard entry like
                <Ctrl><Alt><anything else>
        will no longer function because the system will be fooled
        into thinking that the <Ctrl> and <Alt> keys are not
        depressed.

        There is one known analomy [that's a nice way of saying "bug"]
        in this program.  Consider the case where the user depresses
        both the <Ctrl> and the <Alt> keys and then releases the
        <Ctrl> key, leaving only the <Alt> key depressed.  Normally,
        the ALT_SHIFT bit in KB_FLAG would be on.  With this program
        installed, it will be off.  This means that the user must
        release the <Alt> key and depress it AGAIN before it will
        be recognized by the system.  A similar situation occurs
        for releasing the <Alt> key while leaving the <Ctrl> key
        depressed.  This analomy can be corrected with a bit of
        creative programming but is not dealt with here in the
        interest of simplicity.

        Feel free to modify, mutilate, or adulterate this program.
        If you come up with an bug or improvement, please let me
        know by writing me at this address:
                Steve Harrison
                3203 McKinley St.
                San Diego,   Ca     92104

        *
        subttl Equates
        page
        ;
        ;
        ;  Equates
        ;
        ;
cr      equ     0dh             ;ASCII carriage return
lf      equ     0ah             ;ASCII line feed
dollar  equ     '$'             ;ASCII dollar sign - string terminator
alt_shift equ   08h             ;bit of kb_flag that means <Alt>  key pressed
ctl_shift equ   04h             ;bit of kb_flag that means <Ctrl> key pressed
alloff  equ     0ffh-alt_shift-ctl_shift ;kb_flag with <Ctrl> and <Alt> bits off
        subttl Segment declarations
        page
        ;
        ;
        ; Segment declarations
        ;
        ;
biosseg segment at 40h
        org     $+17h           ;KB_FLAG is at 0040:0017 for the PC
kb_flag label   byte            ;*** change as appropriate for your machine ***
biosseg ends
        ;
        ;
cseg    segment para public 'code'
        assume  cs:cseg, ds:cseg, ss:nothing, es:cseg
        org     100h            ;for .COM file
entry   label   far
        jmp     short start     ;jump to install routine
oldoff  dw      ?               ;offset  of old INT 9h handler
oldseg  dw      ?               ;segment of old INT 9h handler
        subttl Int 9h resident filter routine
        page
        ;
        ;
        ; Int 9h resident <Ctrl><Alt> filter
        ;
        ;
filter  proc    far             ;
        push    ax              ;save regs
        push    ds              ;
        mov     ax,0040h        ;point to BIOS data area
        mov     ds,ax           ;with our DS reg
        assume  ds:biosseg
        test    kb_flag,ctl_shift ;is <Ctrl> bit on?
        jz      done            ;if not, nothing to do
        test    kb_flag,alt_shift ;else <Ctrl> bit is on -- is <Alt>?
        jz      done            ;if not, nothing to do
        and     kb_flag,alloff  ;else turn off <Ctrl><Alt> bits
done    label   near
        pop     ds              ;restore regs
        pop     ax              ;
        jmp     dword ptr cs:oldoff ;and jump to old INT 9h handler
filter  endp
last    equ     $+1             ;first byte available for next program
        ;
        ;
        ; Messages
        ;
        ;
errmsg  db      'NOBOOT: Incorrect DOS version.', cr, lf, dollar
okmsg   db      'NOBOOT: <Ctrl><Alt><Del> reset disabled.', cr, lf, dollar
        subttl Installation routine
        page
        ;
        ;
        ; Installation routine
        ;
        ;
install proc    far
start   label   near
        assume  ds:cseg
        mov     ah,30h          ;set code = get DOS version number
        int     21h             ;on to DOS
        cmp     al,0            ;is it pre-DOS 2.0?
        jne     dosok           ;if not, continue
        lea     dx,errmsg       ;else tell user
        mov     ah,9h           ;set code = print string
        int     21h             ;we gotta have DOS 2.x
        int     20h             ;and die gracefully
dosok   label   near
        mov     ax,3509h        ;get seg:off of old
        int     21h             ;INT 9h handler into ES:BX
        mov     oldseg,es       ;and store
        mov     oldoff,bx       ;for later use
        mov     dx,offset filter ;point to our INT 9h filter routine
        mov     ax,2509h        ;set vector for INT 9h
        int     21h             ;on to DOS
        lea     dx,okmsg        ;tell user that we're here
        mov     ah,9h           ;set code = print string
        int     21h             ;on to DOS
        lea     dx,last         ;point after last of resident code
        int     27h             ;terminate and stay resident
install endp
;
;
cseg    ends
        end     entry
