;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Various Support Stuff.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;

H_SUPPORT       equ 1                           ; skip extrn funcs in header

                .286p
                .model medium, pascal
                jumps

include         support.inc

                .code

;
;   clrborder() - clear borders from buffer (useful for cellular automata)
;   pass:       dest - buffer to clear borders from
;               bufw - buffer width
;               bufd - buffer depth
;   returns:    nothing
;

                public clrborder

clrborder       proc pascal dest:far ptr byte, bufw:word, bufd:word
                uses es, di
                cld

                les di,dest
                mov cx,bufw
                mov al,0
           rep  stosb                           ; clear top border

                mov dx,bufd
                sub dx,2
clrbloop1:
                mov byte ptr es:[di],0          ; clear left border
                add di,bufw
                mov byte ptr es:[di-1],0        ; clear right border
                dec dx
                jnz clrbloop1

                mov cx,bufw
                mov al,0
           rep  stosb                           ; clear bottom border

                ret
clrborder       endp


;
;   contrast() - search for entry in greatest contrast to entry 0
;   pass:       pal - palette to search
;   returns:    ax - palette index of greatest contrasting entry
;

                public contrast

contrast        proc pascal pal:far ptr byte
                uses ds, si, di

                lds si,pal

                mov bx,0                        ; initialize best entry

                mov dx,0
                mov ah,0
                mov al,byte ptr [si]
                add dx,ax
                mov al,byte ptr [si+1]
                add dx,ax
                mov al,byte ptr [si+2]
                add dx,ax                       ; dx = total of entry 0
                mov di,0                        ; di = diff. of best contrast
                add si,3

                mov cx,1                        ; current index
align 2
contrast1:
                mov ah,0
                mov al,byte ptr [si]
                add al,byte ptr [si+1]
                adc ah,0
                add al,byte ptr [si+2]
                adc ah,0                        ; ax = total of this entry
                add si,3

                sub ax,dx
                jnc contrast2
                not ax
                inc ax
contrast2:
                                                ; ax = absolute value of diff.
                cmp ax,di                       ; greater than existing diff?
                jle contrast3                   ; no, skip
                mov di,ax                       ; else save best diff.
                mov bx,cx                       ; save best index

contrast3:
                inc cx
                cmp cx,256
                jl contrast1                    ; repeat till done

                mov ax,bx                       ; ax = best contrasting entry
                ret
contrast        endp


;
;   cyclebck() - cycle palette backward
;   pass:       pal  - palette to cycle
;               begr - beginning palette index to cycle
;               endr - ending palette register to cycle
;   returns:    nothing
;

                public cyclebck

cyclebck        proc pascal pal:far ptr byte, begr:word, endr:word
                uses ds, si

                lds si,pal

                mov dx,endr                     ; dx = ending index
                cmp dx,255
                jg cyclebckd

                mov cx,begr
                cmp cx,dx                       ; cx = starting index
                jge cyclebckd

                mov ax,cx
                shl cx,1
                add cx,ax
                add cx,si                       ; cx = first palette position

                add si,dx
                shl dx,1
                add si,dx
                sub si,3                        ; si = last palette position

                push si
                mov al,byte ptr [si]
                mov ah,byte ptr [si+1]
                mov bl,byte ptr [si+2]
align 2
cyclebckl:
                sub si,3
                cmp si,cx                       ; exceeding palette range?
                jl cyclebckld                   ; yes, quit
                xchg al,byte ptr [si]
                xchg ah,byte ptr [si+1]
                xchg bl,byte ptr [si+2]
                jmp cyclebckl
cyclebckld:
                pop si
                mov byte ptr [si],al
                mov byte ptr [si+1],ah
                mov byte ptr [si+2],bl
cyclebckd:
                ret
cyclebck        endp


;
;   cyclefwd() - cycle palette forward
;   pass:       pal  - palette to cycle
;               begr - beginning palette index to cycle
;               endr - ending palette register to cycle
;   returns:    nothing
;

                public cyclefwd

cyclefwd        proc pascal pal:far ptr byte, begr:word, endr:word
                uses ds, si

                lds si,pal

                mov dx,endr                     ; dx = ending index
                cmp dx,255
                jg cyclefwdd

                mov cx,begr
                cmp cx,dx                       ; cx = starting index
                jge cyclefwdd

                mov ax,dx
                shl dx,1
                add dx,ax
                add dx,si                       ; dx = last palette position

                add si,cx
                shl cx,1
                add si,cx                       ; si = first palette position

                push si
                mov al,byte ptr [si]
                mov ah,byte ptr [si+1]
                mov bl,byte ptr [si+2]
align 2
cyclefwdl:
                add si,3
                cmp si,dx                       ; exceeding palette range?
                jge cyclefwdld                  ; yes, quit
                xchg al,byte ptr [si]
                xchg ah,byte ptr [si+1]
                xchg bl,byte ptr [si+2]
                jmp cyclefwdl
cyclefwdld:
                pop si
                mov byte ptr [si],al
                mov byte ptr [si+1],ah
                mov byte ptr [si+2],bl
cyclefwdd:
                ret
cyclefwd        endp


;
;   fileuname() - get unique filename with numeric variation
;   pass:       fname - filename to alter
;   returns:    nothing
;

funext          db 0,0,0,0,0
funodo          db 0,0,0,0

                public fileuname

fileuname       proc pascal fname:far ptr byte
                uses ds, si, di

                mov cs:funext[0],0              ; kill extension buffer
                mov word ptr cs:[funodo],0
                mov word ptr cs:[funodo+2],0    ; reset odometer

                mov cx,0
                lds si,fname
fileuname1:
                cmp byte ptr [si],0             ; end of string?
                je fileuname3                   ; yes, quit
                cmp byte ptr [si],'.'           ; found extension?
                je fileuname2                   ; yes, quit
                inc si
                inc cx
                jmp fileuname1

fileuname2:
                mov di,offset funext
fileuname2a:
                mov al,byte ptr [si]
                mov byte ptr cs:[di],al         ; copy extension
                cmp al,0
                je fileuname3
                inc si
                inc di
                cmp di,(offset funext)+4
                jl fileuname2a

fileuname3:
                cmp cx,5                        ; 5 or less chars?
                jle fileuname4                  ; yes, skip
                mov cx,5                        ; else truncate for digits
fileuname4:
                lds si,fname
                add si,cx
fileuname5:
                mov al,cs:funodo[0]
                add al,'0'
                mov byte ptr [si],al
                mov al,cs:funodo[1]
                add al,'0'
                mov byte ptr [si+1],al
                mov al,cs:funodo[2]
                add al,'0'
                mov byte ptr [si+2],al
                mov al,cs:funext[0]
                mov byte ptr [si+3],al
                mov al,cs:funext[1]
                mov byte ptr [si+4],al
                mov al,cs:funext[2]
                mov byte ptr [si+5],al
                mov al,cs:funext[3]
                mov byte ptr [si+6],al
                mov al,cs:funext[4]
                mov byte ptr [si+7],al
                mov byte ptr [si+8],'$'

                mov ax,4300h
                lds dx,fname
                int 21h
                jc fileuname6

                mov al,cs:funodo[2]
                inc al
                mov cs:funodo[2],al
                cmp al,10
                jl fileuname5

                mov cs:funodo[2],0
                mov al,cs:funodo[1]
                inc al
                mov cs:funodo[1],al
                cmp al,10
                jl fileuname5

                mov cs:funodo[1],0
                mov al,cs:funodo[0]
                inc al
                mov cs:funodo[0],al
                cmp al,10
                jl fileuname5

                stc                             ; else signal error
                jmp fileunamed                  ; quit

fileuname6:
                clc                             ; signal all ok!

fileunamed:
                ret
fileuname       endp


;
;   fillrandom() - fill buffer with random data
;   pass:       dest - buffer to fill
;               bufw - buffer width
;               bufd - buffer depth
;   returns:    nothing
;

                public fillrandom

fillrandom      proc pascal dest:far ptr byte, bufw:word, bufd:word
                uses es, di
                cld

                les di,dest

                mov dx,bufd
align 2
fillrandom1:
                mov cx,bufw
align 2
fillrandom2:
                ;mov ax,randexist
                ;call random
                @rand
                and ax,7
                mov ah,0
                ;cmp al,randexist-1
                cmp al,7
                jne fillrandom3
                mov ah,128
fillrandom3:
                mov byte ptr es:[di],ah
                inc di

                ; loop for remaining cols
                dec cx
                jnz fillrandom2

                ; loop for remaining rows
                dec dx
                jnz fillrandom1

                ret
fillrandom      endp


;
;   ITOA.ASM --- Convert 16-bit integer to ASCII string
;
;   Copyright (C) 1989 Ray Duncan
;
;   Call with:  AX    = 16-bit integer
;               DS:SI = buffer to receive string,
;                       must be at least 6 bytes long
;               CX    = radix
;
;   Returns:    DS:SI = address of converted string
;               AX    = length of string
;
;   Destroy:  Nothing
;

                public itoa

itoa            proc pascal

                add     si,6                    ; advance to end of buffer
                mov     byte ptr [si],'$'
                push    si                      ; and save that address.
                or      ax,ax                   ; test sign of 16-bit value,
                pushf                           ; and save sign on stack.
                jns     itoa1                   ; jump if value was positive.
                neg     ax                      ; find absolute value.

itoa1:          cwd                             ; divide value by radix to extract
                div     cx                      ; next digit for forming string
                add     dl,'0'                  ; convert remainder to ASCII digit
                cmp     dl,'9'                  ; in case converting to hex ASCII,
                jle     itoa2                   ; jump if in range 0-9,
                add     dl,'A'-'9'-1            ; correct digit if in range A-F

itoa2:          dec     si                      ; back up through buffer
                mov     [si],dl                 ; store this character into string
                or      ax,ax
                jnz     itoa1                   ; no, convert another digit

                popf                            ; was original value negative?
                jns     itoa3                   ; no, jump
                dec     si                      ; yes, store sign into output
                mov     byte ptr [si],'-'

itoa3:          pop     ax                      ; calculate length of string
                sub     ax,si
                ret                             ; back to caller

itoa            endp


;
;   LTOA.ASM --- Convert long (32-bit) integer to ASCII string
;
;   Copyright (C) 1989 Ray Duncan
;
;   Call with:  DX:AX = 32-bit integer
;               DS:SI = buffer to receive string,
;                       must be at least 11 bytes long
;               CX    = radix
;
;   Returns:    DS:SI = address of converted string
;               AX    = length of string
;
;   Destroys:   BX, DX
;
;   Since test for value = zero is made after a digit
;   has been stored, the resulting string will always
;   contain at least one significant digit.
;

                public ltoa

ltoa            proc pascal

                add si,11                       ; advance to end of buffer
                mov byte ptr [si],0
                mov byte ptr [si+1],'$'
                push si                         ; and save that address.
                or  dx,dx                       ; test sign of 32 bit value,
                pushf                           ; and save sign on stack.
                jns ltoa1                       ; jump if value was positive.
                not dx                          ; it was negative, take 2's
                not ax                          ; complement of the value.
                add ax,1
                adc dx,0

ltoa1:
                call divide                     ; divide value by radix
                add bl,'0'                      ; convert remainder to ASCII digit
                cmp bl,'9'                      ; in case converting to hex ASCII,
                jle ltoa2                       ; jump if in range 0-9,
                add bl,'A'-'9'-1                ; correct digit if in range A-F.

ltoa2:
                dec si                          ; back up through buffer
                mov [si],bl                     ; store this character into string.
                mov bx,ax                       ; is value = zero yet?
                or  bx,dx
                jnz ltoa1                       ; no, convert another digit.

                popf                            ; was original value negative?
                jns ltoa3                       ; no, jump
                dec si                          ; yes, store - sign into output
                mov byte ptr [si],'-'

ltoa3:
                pop ax                          ; calculate length of string
                sub ax,si
                ret                             ; back to caller.
ltoa            endp

;
; General purpose 32 bit by 16 bit unsigned divide.  This routine must
; be used instead of the machine's usual unsigned divide for cases
; where the quotient may overflow 16 bits (for example, 100,000 / 2 ).
; If called with a zero divisor, this routine returns the dividend
; unchanged and gives no warning.
;
; Call with:    DX:AX = 32 bit dividend
;       CX    = divisor
;
; Returns:  DX:AX = quotient
;       BX    = remainder
;       CX    = divisor (unchanged)
;
; Destroys: Nothing
;
divide          proc near

                jcxz div1                       ; exit if divide by zero
                push ax                         ; 0:dividend_hi/divisor
                mov ax,dx
                xor dx,dx
                div cx
                mov bx,ax                       ; BX = quotient1
                pop ax                          ; remainder1:dividend_lo/divisor
                div cx
                xchg bx,dx                      ; DX:AX = quotient1:quotient2
div1:
                ret                             ; BX = remainder2
divide          endp


;
;   loadfile() - load a file into memory (less than 64K only)
;   pass:       ds:dx - asciiz filename
;               ds:si - buffer to read to
;   returns:    carry clear if ok, carry set on error
;

                public loadfile

loadfile        proc pascal

                mov ax,3d00h
                int 21h                         ; open the file
                jc loadfiled
                mov bx,ax

                mov ax,4202h
                mov cx,0
                mov dx,0
                int 21h                         ; seek to end of file
                jc loadfiled

                push ax                         ; save file length

                mov ax,4200h
                mov cx,0
                mov dx,0
                int 21h                         ; seek to file start

                pop cx                          ; restore bytes to read

                mov ah,3fh
                mov dx,si
                int 21h                         ; read the file

                pushf
                mov ah,3eh
                int 21h                         ; close the file
                popf

loadfiled:
                ret
loadfile        endp


;
;   pattfill() - 8x8 mono -> 256c pattern filler (uses Jouni's Patterns)
;   pass:       dest - buffer to fill
;               bufw,bufd - buffer dimensions
;               pptr - pointer to 8 byte pattern
;               color1,color2 - palette indices for off/on colors
;   returns:    nothing
;

                public pattfill

pattfill        proc pascal dest:far ptr byte, bufw:word, bufd:word, \
                            pptr:far ptr byte, color1:byte, color2:byte
                uses ds, es, di, si

                lds si,pptr                     ; get pattern pointer
                les di,dest                     ; get buffer pointer

                mov bx,0
                mov dx,0
align 2
dopattern_1:

                lodsb                           ; grab pattern byte

                push dx si
                mov dl,al                       ; store in dl

                mov cx,0

align 2
dopattern_2:

                mov al,color1
                rol dl,1                        ; get byte in position
                test dl,1
                jz dopatternw
                mov al,color2
dopatternw:
                stosb

                ; loop for remaining cols
                inc cx
                cmp cx,bufw
                jl dopattern_2                  ; loop for buffer cols

                ; loop for remaining rows
                pop si dx

                inc bx                          ; pattern row counter
                cmp bx,8                        ; wrapped around?
                jl dopatternu                   ; no, skip
                mov bx,0                        ; else reset row counter
                lds si,pptr                     ; go back to pattern start
dopatternu:
                inc dx
                cmp dx,bufd
                jl dopattern_1                  ; loop for buffer rows

                ret
pattfill        endp


;
;   soundit() - funky beep option
;   author:     Ray Duncan (I think, can't remember from where)
;   pass:       freq:word  - frequency in hz
;               durat:word - duration (clock ticks, 18 = 1 sec)
;   returns:    nothing
;

soundit         proc pascal freq:word, durat:word
                public soundit
                uses es, di

                mov cx,freq                     ; get frequency
                mov bx,durat                    ; get duration
                cmp bx,0                        ; duration passed?
                jne lvsound1                    ; yes, skip
                mov bx,3                        ; no, set to 1/6 second

lvsound1:       mov al,0b6h                     ; init channel 2 of
                out 43h,al                      ; timer chip
                mov dx,12h                      ; divide 1,193,180 hertz
                mov ax,34dch                    ; (clock freq) by desired freq
                div cx                          ; result is timer clock count
                out 42h,al                      ; low byte of count to timer
                mov al,ah
                out 42h,al                      ; high byte of count to timer
                in al,61h                       ; read value from port 61h
                or al,3                         ; set first two bits
                out 61h,al                      ; turn speaker on

                mov ah,00h
                int 1ah                         ; get clock counter
                add bx,dx                       ; low word + duration
lvsound2:       int 1ah                         ; poll time
                cmp dx,bx                       ; delay done?
                jl lvsound2                     ; no, loop

                in al,61h                       ; when time lapses, get port
                xor al,3                        ; kill bits 0-1 to turn
                out 61h,al                      ; speaker off
                ret
soundit         endp


;
;
;   DATA
;
;

                .data

                public seed1, seed2, seed3, seed4

seed1           dw irseed1
seed2           dw irseed2
seed3           dw irseed3
seed4           dw irseed4

                end

