;****************************************************************************
; Filename: MEMAVAIL.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.12.25
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: ULONG memavail(VOID);
;    Input: nothing
;   Output: total free memory available
;  Comment: PALmemavail returns the total amount of free memory in bytes on the
;           heap. The free memory size might be a bit smaller than expected as
;           each allocation adds some overhead. Observe: This function checks
;           ONLY available memory from what you have added with PALaddalloc and
;           PALaddmem. This has nothing to do with how much memory your system
;           has available.
;****************************************************************************

        Include STDDEF.INC
        Include "MEMORY.INC"

        Codeseg

Proc    memavail
                Mov     Edx,Offset BlockTable                                   ; Get pointer to the free pointer list
                Clear   Eax                                                     ; Clear the total amount of memory variable
                Push    Ebx
        Align   4
@@Loop01:       Mov     Ebx,[Edx+FreeBlock.NextFree]                            ; Get the first available FreeBlock
        Align   4
@@Loop02:       Mov     Ecx,[Ebx+FreeBlock.BlockSize]                           ; Get the FreeBlock's block size
                Jecxz   @@Next01                                                ; If it's zero then exit
                Lea     Eax,[Eax+Ecx-Size AllocBlock]                           ; Add the block size
                Mov     Ebx,[Ebx+FreeBlock.NextFree]                            ; Move to the next FreeBlock
                Jmp     @@Loop02
        Align   4
@@Next01:       Add     Edx,Size FreeBlock                                      ; Go to the next free pointer list
                Cmp     Edx,Offset BlockTableEnd                                ; Do another lap if it hasn't reached the end
                Jb      @@Loop01
                Pop     Ebx
                Ret                                                             ; Return with total amount of free memory
Endp

        End
