; Mini Game Of Life   (C) Kim Enkovaara 1994
;
; Dataformat :
;   * Data is directly from video memory and consists of two identical pages.
;     And 480 bytes of any kind of data, whick ensures, that loding is
;     succesfull.The colour has to be green (I think so ;)). The character 
;     has to be 03h, that will say that it must be a heart. Otherwise the 
;     coding will not work. The first and last row of each page has to be 
;     empty, colorinformation doesn't matter. The first column has to be 
;     empty too. This has eased up the optimation.
; Other : 
;   * There are not any error checks, so the there has to be redirection to
;     file lifeio < ???.???. And the filesize ought to be right. If the file 
;     doesn't exist, is wrong sized or is in wrong format it's loaded anyhow 
;     and that process might stone the computer.
;   * I don't take any responsibilty about the program. Everyone uses it on
;     his own risk

CODE    SEGMENT PUBLIC  'CODE'
        ORG     100H
        ASSUME  CS:CODE,DS:CODE,SS:CODE,ES:CODE

Start:
IFDEF Maxopt ; Assume AX=0, BX=0
        mov     ah,0b8h                 ; Videoaddress
ELSE
        xor     bx,bx                   ; BX=Handle 0=STDIN
        mov     ax,0b800h               ; Videoaddress
ENDIF

        mov     ds,ax                   ; to DS=VP1
        mov     al,0FAh                 ; AX=adress of videopage 2
        mov     es,ax                   ; ES=VP2
                
        mov     ah,3fh                  ; AH=3fh, AL=no matter
        mov     ch,20h                  ; Read 8192-8477 bytes (>80*25*2)
        xor     dx,dx                   ; Start From ds:dx = ds:0
        int     21h                     ; Read from file with handle

        mov     bl,0A0h                 ; For modulo

        jmp SHORT vali                  ; Init some values and copy scr1->2
        
alku:
;Pelaa peli
        mov     cx,2000d-161d           ; Code 1839 blocks in Videomemory
        
koodausluuppi:
  ;Don't decode empty block = (col 1), Si Mod 160
        mov     ax,si                   ; AX=place in Videobuffer
        div     bl                      ; AX/BL
        or      ah,ah                   ; ZF if 0h or 0h
        jz      loppu                   ; IF rem=0, then don't decode
       
       ;Add the blocks to bh
       ; optimize the coding... addressing DS:[] smaller than ES:[]
        
        push    ds
        push    es
        pop     ds

        mov     bh,ds:[si-1*2]          ; Left
        add     bh,ds:[si+1*2]          ; Right
        add     bh,ds:[si-81*2]         ; Upper-Right
        add     bh,ds:[si-80*2]         ; Upper
        add     bh,ds:[si-79*2]         ; Upper-Left
        add     bh,ds:[si+79*2]         ; Lower-Left
        add     bh,ds:[si+80*2]         ; Lower
        add     bh,ds:[si+81*2]         ; Lower-Right
        
        mov     ax,0003h
        cmp     ds:[si],al              ; Check if in current place is block
        jne     eipalikka

        ;Block Already
        cmp     bh,6d                   ; If 2 blocks surrounding
        je      elaa

eipalikka:
        cmp     bh,9d                   ; If 3 blocks surrounging
        je      elaa
        xchg    ah,al                   ; Swap... 03,00

elaa:

        xchg    ah,al                   ; Set right block for setting
        pop     ds
        mov     ds:[si],ah              ; Set block to videopage 2

loppu:
        sub     si,2                    ; Set the index
        loop    koodausluuppi           ; Loop until done

vali:
;coding ready copy screen 1->2
        mov     di,162d                 ; Startadresses to si/di
        mov     si,162d
        mov     cx,2000d-81d-81d        ; Copy 1838 words
        rep     movsw                   ; Perform the copy

;Check the keyboard
        mov     ah,01
        int     16h                     ; Check keyboard buffer
        jz      alku                    ; If empty go to beginning
        
        ret                             ; Get rid of the program

CODE    ENDS
        END     Start
        