; -----------------------------------------------------------------------------
; IMPORTANT NOTES: This definition file has been read with a scanner from
;                  Soft-ICE Addendum, so some errors may be found although I've
;                  tried to rectify them.
;                   Also, to clarify file structure, I have modified it a bit.
;                  Values which must be filled in are in <>'s.
; -----------------------------------------------------------------------------

; Error codes returned in AX register

 OK             EQU  0  ; No errors
 BP_TABLE_FULL  EQU  3  ; Breakpoint table is full
 MEM_LlM_ERR    EQU  6  ; Limit on memory access breakpoints reached
 IO_LlM_ERR     EQU  7  ; Limit on I/O port access breakpoints reached
 RANGE_LlM_ERR  EQU  9  ; Limit on memory access range breakpoints reached
 DUP_ERR        EQU 16  ; Duplicate breakpoint

; -----------------------------------------------------------------------------

; Breakpoint structure (18 bytes)

 bp_entry       struc
                bp_type         db ?    ; Type
                bp_addr1        dd ?    ; Address #1
                bp_addr2        dd ?    ; Address #2
                bp_addr3        dd ?    ; Address #3
                bp_mode         db ?    ; Mode #1
                bp_mode2        db ?    ; Mode #2
                bp_size         db ?    ; Size
                bp_cnt          db ?    ; Count until triggered
                bp_state        db ?    ; State
 bp_entry       ends

; Breakpoint types (bp_type)

 MEM_LOC        equ 0   ; Memory Iocation breakpoint (BPM)
 MEM_RANGE      equ 1   ; Memory range breakpoint (BPR)
 IO             equ 3   ; I/O breakpoint (BPIO)
 INT_BP         equ 4   ; Interrupt breakpoint (BPINT)
 X_BP           equ 5   ; Execution breakpoint (BPX)

; Breakpoint modes (bp_mode)

 READ_MODE      equ 01  ; Read
 WRITE_MODE     equ 02  ; Write
 EX_MODE        equ 04  ; Execute

; Breakpoint sizes (bp_size)

 BYT            equ 0   ; Byte
 WRD            equ 1   ; Word
 DBL            equ 3   ; Dword

; -----------------------------------------------------------------------------

; Information on how to fill the breakpoint structure for each breakpoint type
; (all unused fields should be 0)

; -----------------------------------------------------------------------------

; Setting memory location breakpoints

 bp_type = MEM_LOC
 bp_addr1 = <address of breakpoint>
 bp_mode = <access mode>
            (READ_MODE / WRITE_MODE / EX_MODE or WRITE_MODE / EX_MODE (exec.))
 bp_size = <size of breakpoint>
 bp_cnt = <number of instances before breakpoint occurs>

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Setting memory range breakpoints

 bp_type = MEM_RANGE
 bp_addr1 = <lower address range limit>
 bp_addr2 = <upper address range limit>
 bp_mode = <access mode>
            (READ_MODE / WRITE_MODE / READ_MODE or WRITE_MODE)
 bp_cnt = <number of instances before breakpoint occurs>

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Setting I/O breakpoints

 bp_type = IO
 word ptr bp_addr1 = <I/O port address>
 bp_mode = <access mode>
            (READ_MODE / WRITE_MODE / READ_MODE or WRITE_MODE)
 bp_cnt = <number of instances before breakpoint occurs>

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Setting interrupt breakpoints

 bp_type = INT_BP
 bp_addr1 = <interrupt number>
 bp_addr2 = <register value to check (optional)>
 bp_mode = <register to check>
            (0 = no value checking / 1 = AL / 2 = AH / 3 = AX)

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

; Setting execution breakpoints

 bp_type = X_BP
 bp_addr1 = <address of breakpoint>
 bp_addr2 = <overlay number (0 = root)>

; -----------------------------------------------------------------------------
