/*
 QFM (Quick Flat Memory) Manajer
 (C)opyright 1995 by Render of ACC TEAM
 UNREGISTERED VERION
*/

#ifndef __QFML_H
#define __QFML_H


/* ==================================================
 Start 32-bit plane mode
 Parameters: None
 Returns: 0 if success
          1 ERROR getting himmem address
          2 ERROR enabling A20
          3 ERROR CPU already under prottected mode
          4 ERROR CPU running under DPMI, cannot intialize.
===================================================== */
extern "C" unsigned int  StartPL   (void);



/* ==================================================
 Leave 32-bit plane mode
 Parameters: None
 Returns: 0 if success
	  1 ERROR Himem was used to start plane mode
		  but it can not be found now.
	  2 ERROR Himem was used to start plane mode
		  but cannot find it's address now.
	  3 ERROR Trying to disable a20
===================================================== */
extern "C" unsigned int  LeavePL   (void);



/* ==================================================
 Open all memory available past the first Mg
 Parameters: None
 Returns: 0 if success
	  1 ERROR Getting max. block size
	  2 ERROR Getting max. block.
	  3 ERROR Locking max. block to get its address
===================================================== */
extern "C" unsigned int  OpenMem   (void);



/* ==================================================
 Close all memory reserved by OpenMem
 Parameters: None
 Returns: 0 if success
	  1 ERROR Trying to unlock block of memory.
	  2 ERROR Deallocking block of memory.
===================================================== */
extern "C" unsigned int  CloseMem  (void);



/* ==================================================
 Moves blocks of memory in plane mode. Size can be
 anything from 0 bytes to 2^32 bytes.

 Parameters: 1 Source offset. A 32 bit offset
		pointing to the block of memory
		defining source.
	     2 Destination offset. A 32 bit
		offset pointing to the block
		of memory to be used as destination.
	     3 Number of bytes to be moved.
		A 32-bit number ranging from 0 to 2^32.

 Returns: A long integer representing a 32-bit offset
	  which is the last address used as destination+1.
===================================================== */
extern "C" unsigned long Pl2Pl     (unsigned long ,unsigned long ,unsigned long);



/* =====================================================================
 Moves blocks of memory in plane mode. Size can be
 anything from 0 bytes to 2^32 bytes. This one is
 for asm coding (parameters passed by registers).

 Parameters: ESI a 32-bit pointer offset pointing the source.
	     EDI a 32-bit pointer offset pointing the destination.
	     EBX a 32-bit integer containing the number of bytes to move

 Returns: EDI Last destination used + 1.
======================================================================== */

extern "C" unsigned long Pl2Pla    (void); // ## ensamblador



/* ==================================================
 Translates a memory address in the form of seg:off
 to an offset of 32 bits.

 Parameters: 1 SEGMENT
	     2 OFFSET

 Returns: OFFSET as a 32-bit number.
===================================================== */
extern "C" unsigned long VirToPL   (unsigned int, unsigned int);



/* ==================================================
 Translates a memory address in the form of seg:off
 to an offset of 32 bits. This one is for asm coders.
 Parameters passed by registers.

 Parameters: AX=SEGMENT
	     BX=OFFSET

 Returns: EAX= OFFSET as a 32-bit number.
===================================================== */

extern "C" unsigned long VirToPLa  (void); // ## ensamblador



/* ==================================================
 Gives the start address of the memory block reserved
 by OpenMem.

 Parameters: None
 Returns: OFFSET to the start of the memory block allocated
	  by OpenMem.
===================================================== */
extern "C" unsigned long GiveSta   (void);



/* ==================================================
 Get the amount of memory reserved by OpenMem()
 Parameters: None
 Returns: Number of Kilobytes allocated by OpenMem.
===================================================== */
extern "C" unsigned int  GiveAmo   (void);



/* ==================================================
 These are the usual poke functions, ranging from
 byte to dword.

 Parameters: 1 OFFSET of memory to poke
	     2 DATA to poke.

 Returns: DATA poked.
===================================================== */
extern "C" unsigned int  Pokeb     (unsigned long , unsigned char);
extern "C" unsigned int  Pokew     (unsigned long , unsigned word);
extern "C" unsigned int  Pokedw    (unsigned long , unsigned dword);



/* ==================================================
 These are the usual peek functions, ranging from
 byte to dword.

 Parameters: 1 OFFSET of memory to poke

 Returns: DATA peeked.
===================================================== */
extern "C" unsigned char Peekb     (unsigned long );
extern "C" unsigned int  Peekw     (unsigned long );
extern "C" unsigned long Peekdw    (unsigned long );

#endif