;
; Sound output routines
;
; K. Krogstad 871208
;


codeseg segment public 'CODE'

assume cs:codeseg, ds:codeseg, es:codeseg, ss:codeseg

CLK_H  equ  0012h        ; Timer input clock, converted to hex.
CLK_L  equ  3540h

;
; Routine to start sound output at frequency f
;
; Callable from C as follows:
;
;
; sound_on (f);
;  
; unsigned f;
;

so_in struc
   so_bp   dw ?
   so_ip   dw ?
   so_f    dw ?
so_in ends

      public sound_on_
sound_on_ proc near

    push bp
    mov  bp, sp

    mov  dx, 043h
    mov  al, 0b6h
    out  dx, al         ; Get timer ready
    
    mov  dx, CLK_H
    mov  ax, CLK_L
    div  [bp].so_f      ; Calculate frequency

    mov  dx, 042h
    out  dx, al         ; Output low byte of count

    mov  al, ah
    out  dx, al         ; Output high byte of count

    mov  dx, 61h
    in   al, dx         ; Get value of speaker ctrl port

    or   al, 03h        ; Set bit 0 & 1 to 1
    out  dx, al         ; Output new value

    pop  bp
    ret

sound_on_ endp


;
; Turn sound off.
;

    public sound_off_
sound_off_ proc near

    mov  dx, 61h
    in   al, dx         ; Get value of speaker ctrl port

    and  al, 0fch       ; Set bit 0 & 1 to 0
    out  dx, al         ; Output new value

    ret

sound_off_ endp

codeseg ends
        end
