/*****************************************************************************
 BLITDEMO.C

 Quick'n'dirty program to show how to use some of the VGL routines.  Just
 bounces some balls around behind three "windows".  Also, a brick wall glides
 back and forth in front of the balls (brick wall from Wolfenstein).  You
 can change the background color in the windows with the LEFT and RIGHT
 arrow keys.  The UP and DOWN arrow keys will increase or decrease the number
 of balls bouncing around.  F1-F3 toggle the display of the three windows
 on and off. Everything is drawn into a virtual screen, then copied to the
 real screen.  The sprites and the demo screen were drawn rather hastily
 in Deluxe Paint.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#include <stdlib.h>
#include "keys.h"
#include "vgl.h"

#define MAXSPRITES   128                /* Max # of sprites in this demo    */

char far MyBuffer[64000];               /* Our virtual screen               */
char far Palette[768];                  /* Buffer for the palette           */

char far RedBall[1000];                 /* Some sprite buffers              */
char far GrnBall[1000];
char far BluBall[1000];
char far OraBall[1000];
char far PurBall[1000];
char far MagBall[1000];
char far CyaBall[1000];
char far YelBall[1000];

char far Wall[4096];                    /* Buffer for the wall bitmap       */

char far* BitMap[MAXSPRITES];           /* Pointers to bitmaps for each     */
                                        /* sprite                           */
int       BallX[MAXSPRITES];            /* Sprite X positions               */
int       BallY[MAXSPRITES];            /* Sprite Y positions               */
int       BallDX[MAXSPRITES];           /* Sprite X delta                   */
int       BallDY[MAXSPRITES];           /* Sprite Y delta                   */


Intro()
{
  /* Black the palette */
   vglBlack();

   /* Load in a font */
   vglLoadFont( "fonts\\opus.fon" );

   /* Turn on bolding */
   vglBoldOn();

   /* Set text color to bright green */
   vglTextColor( 10 );

   /* Position the "cursor" */
   vglGotoXY( 20, 110 );

   /* Display a string */
   vglPuts( "VGL Blitting Demo" );

   /* Fade in */
   vglFadeIn( Palette );

   /* Delay a bit */
   sleep( 1 );

   /* Fade out */
   vglFadeOut( Palette );

   /* Clear the screen */
   vglClear( 0 );

   /* Set text color to bright yellow */
   vglTextColor( 14 );

   /* Position the "cursor" */
   vglGotoXY( 45, 110 );

   /* Display some text */
   vglPuts( "By Mark Morley" );

   /* Fade in */
   vglFadeIn( Palette );

   /* Delay a bit */
   sleep( 1 );

   /* Fade out */
   vglFadeOut( Palette );
}

main()
{
   int i, x, y, ok = 1, key, wx = 0, wd = 1;
   int win1 = 1, win2 = 1, win3 = 1, back = 0;
   int numsprites = 16;

   randomize();

   /* Enter mode 13h */
   vglInit();

   /* Load the wall image and get the palette as well */
   vglGif( "wall.gif", Wall, Palette, 0, 0 );

   /* Load the images for the sprites */
   vglGif( "redball.gif", RedBall, 0, 0, 0 );
   vglGif( "grnball.gif", GrnBall, 0, 0, 0 );
   vglGif( "bluball.gif", BluBall, 0, 0, 0 );
   vglGif( "yelball.gif", YelBall, 0, 0, 0 );
   vglGif( "purball.gif", PurBall, 0, 0, 0 );
   vglGif( "magball.gif", MagBall, 0, 0, 0 );
   vglGif( "oraball.gif", OraBall, 0, 0, 0 );
   vglGif( "cyaball.gif", CyaBall, 0, 0, 0 );

   /* Display a little intro */
   Intro();

   /* Tell the VGL routines to draw in our virtual screen */
   vglBuffer( MyBuffer );

   /* Load the screen image (title, etc) directly into video memory */
   vglGif( "blitdemo.gif", VIDMEM, 0, 0, 0 );

   /* Set up some random sprites */
   for( i = 0; i < MAXSPRITES; i++ )
   {
      BallX[i] = random( 320 - 31 );
      BallY[i] = random( 200 - 31 );
      BallDX[i] = 5 - random( 10 );
      BallDY[i] = 5 - random( 10 );
      if( BallDX[i] == 0 )
         BallDX[i] = 1;
      if( BallDY[i] == 0 )
         BallDY[i] = 1;
      switch( i % 8 )
      {
         case 0 : BitMap[i] = RedBall;
                  break;
         case 1 : BitMap[i] = GrnBall;
                  break;
         case 2 : BitMap[i] = BluBall;
                  break;
         case 3 : BitMap[i] = YelBall;
                  break;
         case 4 : BitMap[i] = OraBall;
                  break;
         case 5 : BitMap[i] = CyaBall;
                  break;
         case 6 : BitMap[i] = MagBall;
                  break;
         case 7 : BitMap[i] = PurBall;
                  break;
      }
   }

   /* Fade in the palette */
   vglFadeIn( Palette );

   /* Loop until ESC is pressed */
   while( ok )
   {
      /* Copy the three windows from our virtual screen into video memory,
         but only if the windows are "active" */
      if( win1 )
         vglCopyW( 12, 32, 45, 136 );    /* Left window */
      if( win2 )
         vglCopyW( 81, 32, 157, 136 );   /* Middle window */
      if( win3 )
         vglCopyW( 262, 32, 45, 136 );   /* Right window */

      /* Clear the virtual screen to the background color */
      vglClear( back );

      /* Loop through the active sprites... */
      for( i = 0; i < numsprites; i++ )
      {
         /* Draw the sprite into our virtual screen */
         vglPutSprite( BallX[i], BallY[i], 31, 31, BitMap[i] );

         /* Update the sprite's position */
         x = BallX[i] + BallDX[i];
         y = BallY[i] + BallDY[i];
         if( x < 0 || x > 320 - 31 )
            BallDX[i] = -BallDX[i];
         else
            BallX[i] = x;
         if( y < 0 || y > 200 - 31 )
            BallDY[i] = -BallDY[i];
         else
            BallY[i] = y;
      }

      /* Draw the wall image (not a sprite) */
      vglPut( wx, 68, 64, 64, Wall );

      /* Update the wall's position */
      wx += wd;
      if( wx == 256 )
      {
         wd = -1;
         wx--;
      }
      else if( wx == 0 )
      {
         wd = 1;
         wx++;
      }

      /* Check for a keypress */
      if( kbhit() )
      {
         if( (key = getch()) == 0 )
            key = 256 * getch();
         switch( key )
         {
            case Escape         : ok = 0;               /* Done! */
                                  break;
            case F1             : win1 = 1 - win1;      /* Toggle window 1 status */
                                  if( !win1 )
                                  {
                                     /* Temporarily draw in video memory */
                                     vglBuffer( VIDMEM );

                                     /* Black out the window */
                                     vglBox( 12, 32, 45, 136, 0 );

                                     /* Back to the virtual screen */
                                     vglBuffer( MyBuffer );
                                  }
                                  break;
            case F2             : win2 = 1 - win2;
                                  if( !win2 )
                                  {
                                     /* Temporarily draw in video memory */
                                     vglBuffer( VIDMEM );

                                     /* Black out the window */
                                     vglBox( 81, 32, 157, 136, 0 );

                                     /* Back to the virtual screen */
                                     vglBuffer( MyBuffer );
                                  }
                                  break;
            case F3             : win3 = 1 - win3;
                                  if( !win3 )
                                  {
                                     /* Temporarily draw in video memory */
                                     vglBuffer( VIDMEM );

                                     /* Black out the window */
                                     vglBox( 262, 32, 45, 136, 0 );

                                     /* Back to the virtual screen */
                                     vglBuffer( MyBuffer );
                                  }
                                  break;
            case Right          : back++;               /* Increase background color */
                                  if( back == 16 )
                                     back = 0;
                                  break;
            case Left           : back--;               /* Decrease background color */
                                  if( back < 0 )
                                     back = 15;
                                  break;
            case Up             : if( numsprites < MAXSPRITES )  /* Increase sprite count */
                                     numsprites++;
                                  break;
            case Down           : if( numsprites > 1 )           /* Decrease sprite count */
                                     numsprites--;
                                  break;
         }
      }
   }

   /* Fade out */
   vglFadeOut( Palette );

   /* Exit mode 13h */
   vglTerm();
   return;
}
