;
; *** Listing 11-13 ***
;
; Finds the first occurrence of the letter 'z' in
; a zero-terminated string, using non-string instructions.
;
	jmp	Skip
;
TestString	label	byte
	db	'This is a test string that is '
	db	'z'
	db	'terminated with a zero byte...',0
;
; Finds the first occurrence of the specified byte in the
; specified zero-terminated string.
;
; Input:
;	AL = byte to find
;	DS:SI = zero-terminated string to search
;
; Output:
;	SI = pointer to first occurrence of byte in string,
;		or 0 if the byte wasn't found
;
; Registers altered: AH, SI
;
; Note: Do not pass a string that starts at offset 0 (SI=0),
;	since a match on the first byte and failure to find
;	the byte would be indistinguishable.
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
FindCharInString:
FindCharInStringLoop:
	mov	ah,[si]	;get the next string byte
	cmp	ah,al	;is this the byte we're
			; looking for?
	jz	FindCharInStringDone
			;yes, so we're done
	inc	si	;point to the following byte
	and	ah,ah	;is this the terminating zero?
	jnz	FindCharInStringLoop
			;no, so check the next byte
	sub	si,si	;we didn't find a match, so return
			; 0 in SI
FindCharInStringDone:
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'z'		;byte value to find
	mov	si,offset TestString
				;string to search
	call	FindCharInString ;search for the byte
	call	ZTimerOff
