/* ***********************************************************************
   *									 *
   *			Histogram VGA Color Processor			 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *				Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "alloc.h"
#include "mem.h"
#include "math.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"
#include "graphb.h"

Byte Frequency[8192];
Word Hues[8192];

void Sort(Word First, Word Last)
{
  Word i, j, k;
  Word Pivot, Temp2;
  Byte Temp;

  if(First<Last-1)
  {
    i=First;
    j=Last;
    k=(First+Last)>>1;
    Pivot=(Frequency[i]+Frequency[j]+Frequency[k])/3;
    while(i<j)
    {
      while(Frequency[i]>Pivot)
	++i;
      while(Frequency[j]<Pivot)
       --j;
      if(i<j)
      {
	Temp=Frequency[i];
	Frequency[i]=Frequency[j];
	Frequency[j]=Temp;
	Temp2=Hues[i];
	Hues[i]=Hues[j];
	Hues[j]=Temp2;
	++i;
	--j;
      }
    }
    if(j<Last)
    {
      Sort(First,j);
      Sort(j+1,Last);
    }
  }
  if(Frequency[Last]>Frequency[First])
  {
    Temp=Frequency[First];
    Frequency[First]=Frequency[Last];
    Frequency[Last]=Temp;
    Temp2=Hues[First];
    Hues[First]=Hues[Last];
    Hues[Last]=Temp2;
  }
}

typedef char Name[32];

Name FileName;

void GetFileName()
{
  Byte x, y;

  printf("\nEnter File Name => ");
  x=wherex();
  y=wherey();
  gets(FileName);
  if(strlen(FileName)==0)
  {
    strcpy(FileName,"TEST");
    gotoxy(x, y);
    puts(FileName);
  }
  strcat(FileName, ".RGB");
  puts("");
  puts("");
}

Palette_Register PalArray;
Word i, j, x, y;
int LastColor;
Word ColorNum;
Byte  far *ColorHistogram;
Word rc, gc, bc;
FILE *TextDiskFile;

void ClearMem()
{

  for(i=0; i<=32767; i++)
    ColorHistogram[i]=0;
  for(i=0; i<=8191; i++)
    Frequency[i]=0;
  for(i=0; i<=8191; i++)
    Hues[i]=0;
}

void CollectColorData()
{
  TextDiskFile=fopen(FileName, "rb");
  if(TextDiskFile==NULL)
    exit(1);
  XRes=getw(TextDiskFile);
  YRes=getw(TextDiskFile);
  printf("Image Resolution is %d by %d pixels.\n\n\n", XRes, YRes);
  printf("Collecting color data....\n\n");
  for(y=0; y<YRes; y++)
  {
    for(x=0; x<XRes; x++)
    {
      rc=(getc(TextDiskFile))&62;
      gc=(getc(TextDiskFile))&62;
      bc=(getc(TextDiskFile))&62;
      ColorNum=(rc>>1)|(gc<<4)|(bc<<9);
      if(ColorHistogram[ColorNum]<255)
	ColorHistogram[ColorNum]=ColorHistogram[ColorNum]+1;
    }
  }
  fclose(TextDiskFile);
  LastColor=-1;
  for(j=0; j<32768; j++)
  {
    if(ColorHistogram[j]>0)
    {
      ++LastColor;
      Hues[LastColor]=j;
      Frequency[LastColor]=ColorHistogram[j];
    }
  }
}

void SortColorData()
{
  Word d1, Tempd, d2;
  Byte r1, g1, b1;
  Byte r2, g2, b2;

  printf("There are %d colors.\n\n",LastColor);
  puts("Starting sort.");
  Sort(0, LastColor);
  puts("Sort completed.");
  printf("\nModifying extra colors....\n");
  for(i=0; i<=255; i++)
    Frequency[i]=i;
  for(i=256; i<=LastColor; i++)
  {
    d1=32768;
    for(j=0; j<=255; j++)
    {
      r1=(Hues[i]<<1)&62;
      g1=(Hues[i]>>4)&62;
      b1=(Hues[i]>>9)&62;
      r2=(Hues[j]<<1)&62;
      g2=(Hues[j]>>4)&62;
      b2=(Hues[j]>>9)&62;
      Tempd=Sqr(r1-r2)+Sqr(g1-g2)+Sqr(b1-b2);
      if(Tempd<d1)
      {
	d1=Tempd;
	d2=j;
      }
    }
    Frequency[i]=d2;
  }
}

void MakePalette(Palette_Register PalArray)
{
  for(j=0; j<=255; j++)
  {
    PalArray[j].Red=(Hues[j]<<1)&62;
    PalArray[j].Grn=(Hues[j]>>4)&62;
    PalArray[j].Blu=(Hues[j]>>9)&62;
  }
}

void GetColorHistogramFromFrequency()
{
  for(j=0; j<=LastColor; j++)
    ColorHistogram[Hues[j]]=Frequency[j];
}

void Display()
{
  TextDiskFile=fopen(FileName, "rb");
  if(TextDiskFile==NULL)
    exit(1);
  XRes=getw(TextDiskFile);
  YRes=getw(TextDiskFile);
  for(y=0; y<YRes; y++)
  {
    for(x=0; x<XRes; x++)
    {
      rc=(getc(TextDiskFile))&62;
      gc=(getc(TextDiskFile))&62;
      bc=(getc(TextDiskFile))&62;
      ColorNum=(rc>>1)|(gc<<4)|(bc<<9);
      Plot(x, y, ColorHistogram[ColorNum]);
    }
  }
  fclose(TextDiskFile);
}

void main()
{
  ColorHistogram=farmalloc(32768);
  if(ColorHistogram==0)
  {
    printf("Not enough memory!\n");
    printf("Only %u bytes left to allocate.\n Hit any key to exit.\n",farcoreleft());
    getch();
    exit(1);
  }
  Title();
  ClearMem();
  clrscr();
  printf("\t    Histogram Color Image Processor using Least Squares Fit\n");
  printf("\t       for VGA 256 Color Modes by Christopher D. Watkins\n\n");
  GetFileName();
  CollectColorData();
  SortColorData();
  Set_Graphics_Mode(XRes, YRes);
  MakePalette(PalArray);
  Set_Palette(PalArray);
  GetColorHistogramFromFrequency();
  Display();
  Exit_Graphics();
  farfree(ColorHistogram);
}