/*
  ͻ
                                                                          
              36 State Finite Closed Linear Cellular Automation           
                                                                          
                        Sierpinski Rule File Maker                        
                                                                          
                     (c) 1991 Christopher D. Watkins                      
                                                                          
  ͼ
*/

#include "stdio.h"
#include "dos.h"
#include "alloc.h"
#include "string.h"
#include "defs.h"
#include "globals.h"
#include "mathb.h"

#define States 36
#define MaxState States-1
#define density 1    /*  1 - most dense  Or  2 - least dense  */

typedef Byte State[36];
typedef State Rulei;
typedef Rulei Rule[36];
typedef char name[33];

name RuleFileName;
FILE *RuleFile;
Rule far *Rules;
Word i, j, k;
int x;
Byte o;
Byte r;

void WriteRuleFile()
{
  fwrite(Rules, sizeof(Rule), 36, RuleFile);
  fclose(RuleFile);
}

void main()
{
  strcpy(RuleFileName, "RULE1D.CA");
  if((RuleFile=fopen(RuleFileName, "wb"))==NULL)
  {
    printf("can't open file.\n");
    exit(1);
  }
  Rules=farcalloc(36, sizeof(Rule));
  if(Rules==NULL)
  {
    printf("can't get the mem!\n");
    exit(1);
  }
  clrscr();
  printf("Generating Rule\n");
  strcpy(RuleFileName,"RULE.CA");
  InitRand(0.4231966);
  for(i=0; i<=MaxState; i++)
  {
    for(j=0; j<=MaxState; j++)
    {
      for(k=0; k<=MaxState; k++)
      {
	if(i == 0)
	  x = k;
	else
	{
	  if(j < k)
	  {
	    if(k == 0)
	      x = i;
	    else
	      x = 0;
	  }
	  else
	  {
	    if(i == k)
	      x = RandInt(States);
	    else
	    {
	      r=j%density;
	      switch(r)
	      {
		case 0: x=i;
			break;
		case 1: x=k;
			break;
	      }
	    }
	  }
	}
/*
	x=i+j+k;
*/
/*
	x=i+j;
*/
	o=(x%States)&0xFF;
	Rules[i][j][k]=o;
      }
    }
  }
  WriteRuleFile();
  farfree(Rules);
}